/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.support;

import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.support.AsyncCompletionQuery;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.system.RequestProcessor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public final class AsyncCompletionTask
implements CompletionTask,
Runnable {
    private final AsyncCompletionQuery query;
    private final JTextComponent component;
    private Document doc;
    private int queryCaretOffset;
    private CompletionResultSet queryResultSet;
    private CompletionResultSet refreshResultSet;
    private ProgressMonitor rpTask;
    private boolean cancelled;
    private boolean queryInvoked;

    public AsyncCompletionTask(AsyncCompletionQuery query, JTextComponent component) {
        assert (query != null) : "Query must be non-null";
        this.query = query;
        this.component = component;
        query.initTask(this);
    }

    public AsyncCompletionTask(AsyncCompletionQuery query) {
        this(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(CompletionResultSet resultSet) {
        assert (resultSet != null);
        assert (SwingUtilities.isEventDispatchThread());
        this.doc = this.component != null ? this.component.getDocument() : null;
        this.queryInvoked = true;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            this.performQuery(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(CompletionResultSet resultSet) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.cancelled) : "refresh() called on canceled task";
        if (this.queryInvoked) {
            assert (resultSet != null);
            AsyncCompletionTask asyncCompletionTask = this;
            synchronized (asyncCompletionTask) {
                this.refreshResultSet = resultSet;
            }
            this.refreshImpl();
        } else {
            this.query.preQueryUpdate(this.component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancelled = true;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            if (this.rpTask != null) {
                this.rpTask.cancel();
                this.rpTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(CompletionResultSet resultSet) {
        this.queryCaretOffset = this.component != null ? this.component.getSelectionStart() : -1;
        this.query.prepareQuery(this.component);
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            this.queryResultSet = resultSet;
            this.rpTask = new NullProgressMonitor();
            RequestProcessor.invokeLater((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshImpl() {
        CompletionResultSet resultSet;
        boolean rpTaskFinished;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            rpTaskFinished = this.rpTask == null;
            resultSet = this.refreshResultSet;
        }
        if (resultSet != null) {
            if (rpTaskFinished) {
                asyncCompletionTask = this;
                synchronized (asyncCompletionTask) {
                    this.refreshResultSet = null;
                }
                if (this.query.canFilter(this.component)) {
                    this.query.filter(resultSet);
                    assert (resultSet.isFinished()) : this.toString() + ": query.filter(): Result set not finished by resultSet.finish()";
                } else {
                    this.performQuery(resultSet);
                }
            } else if (!this.query.canFilter(this.component)) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CompletionResultSet resultSet;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            resultSet = this.queryResultSet;
        }
        if (resultSet != null) {
            this.query.query(resultSet, this.doc, this.queryCaretOffset);
            assert (resultSet.isFinished()) : this.toString() + ": query.query(): Result set not finished by resultSet.finish()";
        }
        asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            this.rpTask = null;
            this.queryResultSet = null;
            if (this.refreshResultSet != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AsyncCompletionTask.this.refreshImpl();
                    }
                });
            }
        }
    }

    synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public String toString() {
        return "AsyncCompletionTask: query=" + this.query;
    }
}

