/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.das2.jythoncompletion.nbadapt.Utilities;
import org.das2.jythoncompletion.support.CompletionDocumentation;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.jythoncompletion.ui.CompletionSettings;
import org.das2.jythoncompletion.ui.HTMLDocView;

public class DocumentationScrollPane
extends JScrollPane {
    private static final String BACK = "org/netbeans/modules/editor/completion/resources/back.png";
    private static final String FORWARD = "org/netbeans/modules/editor/completion/resources/forward.png";
    private static final String GOTO_SOURCE = "org/netbeans/modules/editor/completion/resources/open_source_in_editor.png";
    private static final String SHOW_WEB = "org/netbeans/modules/editor/completion/resources/open_in_external_browser.png";
    private static final String JAVADOC_ESCAPE = "javadoc-escape";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    private static final int ACTION_JAVADOC_ESCAPE = 0;
    private static final int ACTION_JAVADOC_BACK = 1;
    private static final int ACTION_JAVADOC_FORWARD = 2;
    private static final int ACTION_JAVADOC_OPEN_IN_BROWSER = 3;
    private static final int ACTION_JAVADOC_OPEN_SOURCE = 4;
    private JButton bBack;
    private JButton bForward;
    private JButton bGoToSource;
    private JButton bShowWeb;
    private HTMLDocView view;
    private List<CompletionDocumentation> history = new ArrayList<CompletionDocumentation>(5);
    private int currentHistoryIndex = -1;
    protected CompletionDocumentation currentDocumentation = null;
    private Dimension documentationPreferredSize = CompletionSettings.INSTANCE.documentationPopupPreferredSize();

    public DocumentationScrollPane(JTextComponent editorComponent) {
        this.setPreferredSize(null);
        Color bgColor = CompletionSettings.INSTANCE.documentationBackgroundColor();
        this.view = new HTMLDocView(bgColor);
        this.view.addHyperlinkListener(new HyperlinkAction());
        this.setViewportView(this.view);
        this.installTitleComponent();
        this.installKeybindings(editorComponent);
        this.setFocusable(false);
    }

    public void setPreferredSize(Dimension preferredSize) {
        if (preferredSize == null) {
            preferredSize = this.documentationPreferredSize;
        }
        super.setPreferredSize(preferredSize);
    }

    public void setData(CompletionDocumentation doc) {
        this.setDocumentation(doc);
        this.addToHistory(doc);
    }

    private ImageIcon resolveIcon(String res) {
        return new ImageIcon(DocumentationScrollPane.class.getResource("/" + res));
    }

    private void installTitleComponent() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlDkShadow")));
        toolbar.setLayout(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.gridx = 0;
        gdc.gridy = 0;
        gdc.anchor = 17;
        ImageIcon icon = this.resolveIcon(BACK);
        if (icon != null) {
            this.bBack = new BrowserButton((Icon)icon);
            this.bBack.addMouseListener(new MouseEventListener(this.bBack));
            this.bBack.setEnabled(false);
            this.bBack.setFocusable(false);
            this.bBack.setContentAreaFilled(false);
            this.bBack.setMargin(new Insets(0, 0, 0, 0));
            this.bBack.setToolTipText("HINT_doc_browser_back_button");
            toolbar.add((Component)this.bBack, gdc);
        }
        gdc.gridx = 1;
        gdc.gridy = 0;
        gdc.anchor = 17;
        icon = this.resolveIcon(FORWARD);
        if (icon != null) {
            this.bForward = new BrowserButton((Icon)icon);
            this.bForward.addMouseListener(new MouseEventListener(this.bForward));
            this.bForward.setEnabled(false);
            this.bForward.setFocusable(false);
            this.bForward.setContentAreaFilled(false);
            this.bForward.setToolTipText("HINT_doc_browser_forward_button");
            this.bForward.setMargin(new Insets(0, 0, 0, 0));
            toolbar.add((Component)this.bForward, gdc);
        }
        gdc.gridx = 2;
        gdc.gridy = 0;
        gdc.anchor = 17;
        icon = this.resolveIcon(SHOW_WEB);
        if (icon != null) {
            this.bShowWeb = new BrowserButton((Icon)icon);
            this.bShowWeb.addMouseListener(new MouseEventListener(this.bShowWeb));
            this.bShowWeb.setEnabled(false);
            this.bShowWeb.setFocusable(false);
            this.bShowWeb.setContentAreaFilled(false);
            this.bShowWeb.setMargin(new Insets(0, 0, 0, 0));
            this.bShowWeb.setToolTipText("HINT_doc_browser_show_web_button");
            toolbar.add((Component)this.bShowWeb, gdc);
        }
        gdc.gridx = 3;
        gdc.gridy = 0;
        gdc.weightx = 1.0;
        gdc.anchor = 17;
        icon = this.resolveIcon(GOTO_SOURCE);
        if (icon != null) {
            this.bGoToSource = new BrowserButton((Icon)icon);
            this.bGoToSource.addMouseListener(new MouseEventListener(this.bGoToSource));
            this.bGoToSource.setEnabled(false);
            this.bGoToSource.setFocusable(false);
            this.bGoToSource.setContentAreaFilled(false);
            this.bGoToSource.setMargin(new Insets(0, 0, 0, 0));
            this.bGoToSource.setToolTipText("HINT_doc_browser_goto_source_button");
            toolbar.add((Component)this.bGoToSource, gdc);
        }
        this.setColumnHeaderView(toolbar);
    }

    private synchronized void setDocumentation(CompletionDocumentation doc) {
        this.currentDocumentation = doc;
        String text = this.currentDocumentation.getText();
        URL url = this.currentDocumentation.getURL();
        if (text != null) {
            Document document;
            if (url != null && (document = this.view.getDocument()) instanceof HTMLDocument) {
                ((HTMLDocument)document).setBase(url);
            }
            this.view.setContent(text, null);
        } else if (url != null) {
            try {
                this.view.setPage(url);
            }
            catch (UnknownHostException ioe) {
                this.view.setContent(ioe.toString(), null);
            }
            catch (FileNotFoundException ex) {
                this.view.setContent(ex.toString(), null);
            }
            catch (IOException ioe) {
                this.view.setContent(ioe.toString(), null);
            }
        }
        if (this.bShowWeb != null) {
            this.bShowWeb.setEnabled(url != null);
        }
        if (this.bGoToSource != null) {
            this.bGoToSource.setEnabled(this.currentDocumentation.getGotoSourceAction() != null);
        }
    }

    private void myScrollToRef(String reference) {
        Document d = this.view.getDocument();
        if (d instanceof HTMLDocument) {
            HTMLDocument doc = (HTMLDocument)d;
            HTMLDocument.Iterator iter = doc.getIterator(HTML.Tag.A);
            while (iter.isValid()) {
                AttributeSet a = iter.getAttributes();
                String nm = (String)a.getAttribute(HTML.Attribute.NAME);
                System.err.println("ref: " + nm);
                if (nm != null && nm.equals(reference)) {
                    try {
                        Rectangle r = this.view.modelToView(iter.getStartOffset());
                        if (r != null) {
                            Rectangle vis = this.getVisibleRect();
                            r.height = vis.height;
                            this.scrollRectToVisible(r);
                        }
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                iter.next();
            }
        }
    }

    private synchronized void addToHistory(CompletionDocumentation doc) {
        int histSize = this.history.size();
        for (int i = this.currentHistoryIndex + 1; i < histSize; ++i) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(doc);
        this.currentHistoryIndex = this.history.size() - 1;
        if (this.currentHistoryIndex > 0 && this.bBack != null) {
            this.bBack.setEnabled(true);
        }
        if (this.bForward != null) {
            this.bForward.setEnabled(false);
        }
    }

    private synchronized void backHistory() {
        if (this.currentHistoryIndex > 0) {
            --this.currentHistoryIndex;
            this.setDocumentation(this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == 0 && this.bBack != null) {
                this.bBack.setEnabled(false);
            }
            if (this.bForward != null) {
                this.bForward.setEnabled(true);
            }
        }
    }

    private synchronized void forwardHistory() {
        if (this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            this.setDocumentation(this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == this.history.size() - 1 && this.bForward != null) {
                this.bForward.setEnabled(false);
            }
            if (this.bBack != null) {
                this.bBack.setEnabled(true);
            }
        }
    }

    synchronized void clearHistory() {
        this.currentHistoryIndex = -1;
        this.history.clear();
        if (this.bBack != null) {
            this.bBack.setEnabled(false);
        }
        if (this.bForward != null) {
            this.bForward.setEnabled(false);
        }
    }

    private void openInExternalBrowser() {
        URL url = this.currentDocumentation.getURL();
        if (url != null) {
            Utilities.openBrowser(url.toString());
        }
    }

    private void goToSource() {
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey, JTextComponent component) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        if (component != null) {
            TextUI ui = component.getUI();
            Keymap km = component.getKeymap();
            if (ui != null && km != null) {
                EditorKit kit = ui.getEditorKit(component);
            }
        }
        return ret;
    }

    private void registerKeybinding(int action, String actionName, KeyStroke stroke, String editorActionName, JTextComponent component) {
        KeyStroke[] keys = this.findEditorKeys(editorActionName, stroke, component);
        for (int i = 0; i < keys.length; ++i) {
            this.getInputMap().put(keys[i], actionName);
        }
        this.getActionMap().put(actionName, new DocPaneAction(action));
    }

    private void installKeybindings(JTextComponent component) {
        this.registerKeybinding(0, JAVADOC_ESCAPE, KeyStroke.getKeyStroke(27, 0), "escape", component);
        this.registerKeybinding(1, JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null, component);
        this.registerKeybinding(2, JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null, component);
        this.registerKeybinding(3, JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null, component);
        this.registerKeybinding(4, JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null, component);
        this.mapWithShift(KeyStroke.getKeyStroke(38, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(40, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(33, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(34, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(36, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(35, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(39, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(37, 0));
    }

    private void mapWithShift(KeyStroke key) {
        InputMap inputMap = this.getInputMap(1);
        Object actionKey = inputMap.get(key);
        if (actionKey != null) {
            key = KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers() | 1);
            this.getInputMap().put(key, actionKey);
        }
    }

    private class DocPaneAction
    extends AbstractAction {
        private int action;

        private DocPaneAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    CompletionImpl.get().hideDocumentation(false);
                    break;
                }
                case 1: {
                    DocumentationScrollPane.this.backHistory();
                    break;
                }
                case 2: {
                    DocumentationScrollPane.this.forwardHistory();
                    break;
                }
                case 3: {
                    DocumentationScrollPane.this.openInExternalBrowser();
                    break;
                }
                case 4: {
                    DocumentationScrollPane.this.goToSource();
                }
            }
        }
    }

    private class DefaultDoc
    implements CompletionDocumentation {
        private URL url = null;

        private DefaultDoc(URL url) {
            this.url = url;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        private HyperlinkAction() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            String desc;
            if (e != null && HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && (desc = e.getDescription()) != null) {
                CompletionDocumentation doc = DocumentationScrollPane.this.currentDocumentation.resolveLink(desc);
                if (doc == null) {
                    try {
                        URL url = DocumentationScrollPane.this.currentDocumentation.getURL();
                        url = url != null ? new URL(url, desc) : new URL(desc);
                        doc = new DefaultDoc(url);
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                }
                if (doc != null) {
                    DocumentationScrollPane.this.setData(doc);
                }
            }
        }
    }

    private class MouseEventListener
    extends MouseAdapter {
        private JButton button;

        MouseEventListener(JButton button) {
            this.button = button;
        }

        public void mouseEntered(MouseEvent ev) {
            if (this.button.isEnabled()) {
                this.button.setContentAreaFilled(true);
                this.button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent ev) {
            this.button.setContentAreaFilled(false);
            this.button.setBorderPainted(false);
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.button.equals(DocumentationScrollPane.this.bBack)) {
                DocumentationScrollPane.this.backHistory();
            } else if (this.button.equals(DocumentationScrollPane.this.bForward)) {
                DocumentationScrollPane.this.forwardHistory();
            } else if (this.button.equals(DocumentationScrollPane.this.bGoToSource)) {
                DocumentationScrollPane.this.goToSource();
            } else if (this.button.equals(DocumentationScrollPane.this.bShowWeb)) {
                DocumentationScrollPane.this.openInExternalBrowser();
            }
        }
    }

    private class BrowserButton
    extends JButton {
        public BrowserButton() {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(String text) {
            super(text);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
        }
    }
}

