/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.TimeUtil;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyIterator;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexListDataSetIterator;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.TrimStrideWrapper;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.BinaryInfixOps;
import org.virbo.jythonsupport.PyQDataSetAdapter;

public class PyQDataSet
extends PyJavaInstance {
    WritableDataSet ds;
    QDataSet rods;
    private static Map<String, PyReflectedFunction> binaryInfixMethods = new HashMap<String, PyReflectedFunction>();

    PyQDataSet(QDataSet ds) {
        super((Object)ds);
        this.ds = ds instanceof WritableDataSet ? (WritableDataSet)ds : (ds.rank() == 0 ? null : (DataSetUtil.isQube((QDataSet)ds) ? DDataSet.copy((QDataSet)ds) : null));
        this.rods = ds;
    }

    public QDataSet getQDataSet() {
        return this.rods;
    }

    public PyQDataSet __add__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.add((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __radd__(PyObject arg0) {
        return this.__add__(arg0);
    }

    public PyObject __sub__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.subtract((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __rsub__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.subtract((QDataSet)that, (QDataSet)this.rods));
    }

    public PyObject __mul__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.multiply((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __rmul__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.multiply((QDataSet)that, (QDataSet)this.rods));
    }

    public PyObject __div__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.divide((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __rdiv__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.divide((QDataSet)that, (QDataSet)this.rods));
    }

    public PyObject __floordiv__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.div((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __mod__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.mod((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __rfloordiv__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.div((QDataSet)that, (QDataSet)this.rods));
    }

    public PyObject __rmod__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.mod((QDataSet)that, (QDataSet)this.rods));
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __neg__() {
        return new PyQDataSet(Ops.negate((QDataSet)this.rods));
    }

    public PyObject __abs__() {
        return new PyQDataSet(Ops.abs((QDataSet)this.rods));
    }

    public PyObject __pow__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.pow((QDataSet)this.rods, (QDataSet)that));
    }

    public PyObject __rpow__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.pow((QDataSet)that, (QDataSet)this.rods));
    }

    public PyObject __findattr__(String name) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func;
        }
        return super.__findattr__(name);
    }

    public void __delattr__(String attr) {
        if (binaryInfixMethods.remove(attr) == null) {
            super.__delattr__(attr);
        }
    }

    public void __setattr__(String name, PyObject value) {
        if (binaryInfixMethods.containsKey(name)) {
            binaryInfixMethods.remove(name);
        }
        super.__setattr__(name, value);
    }

    public PyObject invoke(String name) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this);
        }
        return super.invoke(name);
    }

    public PyObject invoke(String name, PyObject arg1) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this, arg1);
        }
        return super.invoke(name, arg1);
    }

    public PyObject invoke(String name, PyObject arg1, PyObject arg2) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this, arg1, arg2);
        }
        return super.invoke(name, arg1, arg2);
    }

    public PyObject invoke(String name, PyObject[] args, String[] keywords) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this, args, keywords);
        }
        return super.invoke(name, args, keywords);
    }

    public PyObject invoke(String name, PyObject[] args) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this);
        }
        return super.invoke(name);
    }

    protected static Number getNumber(Object po) {
        if (po instanceof QDataSet) {
            QDataSet qpo = (QDataSet)po;
            if (qpo.rank() == 0) {
                return qpo.value();
            }
            throw Py.TypeError((String)"QDataSet with rank>0 found where number was expected");
        }
        if (po instanceof PyQDataSet) {
            PyQDataSet pqd = (PyQDataSet)((Object)po);
            QDataSet qpo = pqd.rods;
            if (qpo.rank() == 0) {
                return qpo.value();
            }
            throw Py.TypeError((String)"PyQDataSet with rank>0 found where number was expected");
        }
        if (po instanceof PyObject) {
            Object result = ((PyObject)po).__tojava__(Number.class);
            if (result == Py.NoConversion) {
                throw Py.TypeError((String)("can't convert to number: " + ((PyObject)po).__repr__()));
            }
            return (Number)result;
        }
        if (po instanceof Number) {
            return (Number)po;
        }
        throw Py.TypeError((String)("can't convert to number: " + po));
    }

    public int __len__() {
        return this.rods.length();
    }

    public PyObject __getitem__(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            if (arg0 instanceof PySlice) {
                PySlice slice = (PySlice)arg0;
                Number start = PyQDataSet.getNumber(slice.start);
                Number stop = PyQDataSet.getNumber(slice.stop);
                Number step = PyQDataSet.getNumber(slice.step);
                if (step == null || step.equals(1)) {
                    if (start == null) {
                        start = 0;
                    }
                    if (stop == null) {
                        stop = this.rods.length();
                    }
                    if (start.intValue() < 0) {
                        start = this.rods.length() + start.intValue();
                    }
                    if (stop.intValue() < 0) {
                        stop = this.rods.length() + stop.intValue();
                    }
                    return new PyQDataSet(this.rods.trim(start.intValue(), stop.intValue()));
                }
                TrimStrideWrapper wds = new TrimStrideWrapper(this.rods);
                wds.setTrim(0, start, stop, step);
                return new PyQDataSet((QDataSet)wds);
            }
            if (arg0.isNumberType()) {
                int idx = ((Number)arg0.__tojava__(Number.class)).intValue();
                if (idx < 0) {
                    idx = this.rods.length() + idx;
                }
                if (this.rods.rank() > 1) {
                    QDataSet sds = this.rods.slice(idx);
                    return new PyQDataSet(sds);
                }
                return Py.java2py((Object)this.rods.value(idx));
            }
            if (arg0.isSequenceType()) {
                QubeDataSetIterator iter = new QubeDataSetIterator(this.rods);
                PySequence slices = (PySequence)arg0;
                for (int i = 0; i < slices.__len__(); ++i) {
                    QubeDataSetIterator.IndexListIteratorFactory fit;
                    PyObject a = slices.__getitem__(i);
                    if (a instanceof PySlice) {
                        PySlice slice = (PySlice)a;
                        Number start = PyQDataSet.getNumber(slice.start);
                        Number stop = PyQDataSet.getNumber(slice.stop);
                        Number step = PyQDataSet.getNumber(slice.step);
                        fit = new QubeDataSetIterator.StartStopStepIteratorFactory(start, stop, step);
                    } else if (a instanceof PyQDataSet) {
                        Object o2 = a.__tojava__(QDataSet.class);
                        QDataSet that = (QDataSet)o2;
                        fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                    } else if (a.isNumberType()) {
                        int idx = PyQDataSet.getNumber(a).intValue();
                        fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
                    } else {
                        QDataSet that = this.coerce_ds(a);
                        fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                    }
                    iter.setIndexIteratorFactory(i, (QubeDataSetIterator.DimensionIteratorFactory)fit);
                }
                DDataSet result = iter.createEmptyDs();
                QubeDataSetIterator resultIter = new QubeDataSetIterator((QDataSet)result);
                while (iter.hasNext()) {
                    iter.next();
                    double d = iter.getValue(this.rods);
                    resultIter.next();
                    resultIter.putValue((WritableDataSet)result, d);
                }
                result.putProperty("UNITS", this.ds.property("UNITS"));
                result.putProperty("LABEL", this.ds.property("LABEL"));
                result.putProperty("NAME", this.ds.property("NAME"));
                result.putProperty("VALID_MAX", this.ds.property("VALID_MAX"));
                result.putProperty("VALID_MIN", this.ds.property("VALID_MIN"));
                result.putProperty("FILL_VALUE", this.ds.property("FILL_VALUE"));
                return new PyQDataSet((QDataSet)result);
            }
            throw Py.TypeError((String)("invalid index type: " + arg0));
        }
        QDataSet that = (QDataSet)o;
        QubeDataSetIterator iter = new QubeDataSetIterator((QDataSet)this.ds);
        QDataSet dep0 = null;
        if (this.ds.rank() > 1) {
            iter = new IndexListDataSetIterator(that);
        } else {
            QubeDataSetIterator.IndexListIteratorFactory fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
            iter.setIndexIteratorFactory(0, (QubeDataSetIterator.DimensionIteratorFactory)fit);
            dep0 = (QDataSet)this.ds.property("DEPEND_0");
            if (dep0 != null) {
                dep0 = DataSetOps.applyIndex((QDataSet)dep0, (int)0, (QDataSet)that, (boolean)false);
            }
        }
        DDataSet result = iter.createEmptyDs();
        QubeDataSetIterator resultIter = new QubeDataSetIterator((QDataSet)result);
        while (iter.hasNext()) {
            iter.next();
            double d = iter.getValue(this.rods);
            resultIter.next();
            resultIter.putValue((WritableDataSet)result, d);
        }
        if (dep0 != null && dep0.length() == result.length()) {
            result.putProperty("DEPEND_0", (Object)dep0);
        }
        result.putProperty("UNITS", this.ds.property("UNITS"));
        result.putProperty("LABEL", this.ds.property("LABEL"));
        result.putProperty("NAME", this.ds.property("NAME"));
        result.putProperty("VALID_MAX", this.ds.property("VALID_MAX"));
        result.putProperty("VALID_MIN", this.ds.property("VALID_MIN"));
        result.putProperty("FILL_VALUE", this.ds.property("FILL_VALUE"));
        return new PyQDataSet((QDataSet)result);
    }

    public void __setitem__(PyObject arg0, PyObject arg1) {
        if (this.ds == null) {
            throw new RuntimeException("__setitem__ on dataset that could not be made into mutable.");
        }
        QubeDataSetIterator iter = new QubeDataSetIterator((QDataSet)this.ds);
        if (!arg0.isSequenceType()) {
            QubeDataSetIterator.SingletonIteratorFactory fit;
            PyObject a = arg0;
            if (a instanceof PySlice) {
                PySlice slice = (PySlice)a;
                Integer start = slice.start == Py.None ? null : Integer.valueOf(((Number)slice.start.__tojava__(Number.class)).intValue());
                Integer stop = slice.stop == Py.None ? null : Integer.valueOf(((Number)slice.stop.__tojava__(Number.class)).intValue());
                Integer step = slice.step == Py.None ? null : Integer.valueOf(((Number)slice.step.__tojava__(Number.class)).intValue());
                fit = new QubeDataSetIterator.StartStopStepIteratorFactory((Number)start, (Number)stop, (Number)step);
            } else if (a.isNumberType()) {
                int idx = ((Number)a.__tojava__(Number.class)).intValue();
                fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
            } else {
                Object o = a.__tojava__(QDataSet.class);
                QDataSet that = (QDataSet)o;
                fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
            }
            iter.setIndexIteratorFactory(0, (QubeDataSetIterator.DimensionIteratorFactory)fit);
        } else if (arg0 instanceof PyQDataSet) {
            Object o = arg0.__tojava__(QDataSet.class);
            QDataSet that = (QDataSet)o;
            if (this.ds.rank() > 1) {
                iter = new IndexListDataSetIterator(that);
            } else {
                QubeDataSetIterator.IndexListIteratorFactory fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                iter.setIndexIteratorFactory(0, (QubeDataSetIterator.DimensionIteratorFactory)fit);
            }
        } else {
            PyObject a;
            int i;
            PySequence slices = (PySequence)arg0;
            QDataSet[] lists = new QDataSet[slices.__len__()];
            boolean allLists = true;
            for (i = 0; i < slices.__len__(); ++i) {
                a = slices.__getitem__(i);
                if (!(a instanceof PyQDataSet)) {
                    allLists = false;
                    continue;
                }
                lists[i] = ((PyQDataSet)a).rods;
            }
            if (allLists) {
                int n = lists[0].length();
                QDataSet val = this.coerceDsInternal(arg1);
                QubeDataSetIterator it = new QubeDataSetIterator(val);
                if (this.ds.rank() == 1) {
                    for (int i2 = 0; i2 < n; ++i2) {
                        it.next();
                        this.ds.putValue((int)lists[0].value(i2), it.getValue(val));
                    }
                } else if (this.ds.rank() == 2) {
                    for (int i3 = 0; i3 < n; ++i3) {
                        it.next();
                        this.ds.putValue((int)lists[0].value(i3), (int)lists[1].value(i3), it.getValue(val));
                    }
                } else if (this.ds.rank() == 3) {
                    for (int i4 = 0; i4 < n; ++i4) {
                        it.next();
                        this.ds.putValue((int)lists[0].value(i4), (int)lists[1].value(i4), (int)lists[2].value(i4), it.getValue(val));
                    }
                } else if (this.ds.rank() == 4) {
                    for (int i5 = 0; i5 < n; ++i5) {
                        it.next();
                        this.ds.putValue((int)lists[0].value(i5), (int)lists[1].value(i5), (int)lists[2].value(i5), (int)lists[2].value(i5), it.getValue(val));
                    }
                }
                return;
            }
            for (i = 0; i < slices.__len__(); ++i) {
                QubeDataSetIterator.IndexListIteratorFactory fit;
                a = slices.__getitem__(i);
                if (a instanceof PySlice) {
                    PySlice slice = (PySlice)a;
                    Integer start = (Integer)slice.start.__tojava__(Integer.class);
                    Integer stop = (Integer)slice.stop.__tojava__(Integer.class);
                    Integer step = (Integer)slice.step.__tojava__(Integer.class);
                    fit = new QubeDataSetIterator.StartStopStepIteratorFactory((Number)start, (Number)stop, (Number)step);
                } else if (a.isNumberType() && !(a instanceof PyQDataSet)) {
                    int idx = (Integer)a.__tojava__(Integer.class);
                    fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
                } else {
                    Object o = a.__tojava__(QDataSet.class);
                    QDataSet that = (QDataSet)o;
                    fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                }
                iter.setIndexIteratorFactory(i, (QubeDataSetIterator.DimensionIteratorFactory)fit);
            }
        }
        int[] qube = new int[iter.rank()];
        for (int i = 0; i < iter.rank(); ++i) {
            qube[i] = iter.length(i);
        }
        QDataSet val = this.coerceDsInternal(arg1);
        if (val.rank() == 0) {
            double d = val.value();
            while (iter.hasNext()) {
                iter.next();
                iter.putValue(this.ds, d);
            }
        } else {
            if (val.rank() != iter.rank()) {
                throw new IllegalArgumentException("not supported, couldn't reconcile ranks: arg=" + val.rank() + " and ds=" + iter.rank());
            }
            QubeDataSetIterator it = new QubeDataSetIterator(val);
            while (it.hasNext()) {
                it.next();
                double d = it.getValue(val);
                iter.next();
                iter.putValue(this.ds, d);
            }
        }
    }

    private QDataSet coerceDsInternal(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            if (arg0.isNumberType()) {
                try {
                    double d = (Double)arg0.__tojava__(Double.class);
                    return DataSetUtil.asDataSet((double)d);
                }
                catch (RuntimeException ex) {
                    DRank0DataSet do2;
                    Object o2 = arg0.__tojava__(Object.class);
                    if (o2 instanceof TimeUtil.TimeStruct) {
                        do2 = DataSetUtil.asDataSet((Datum)TimeUtil.toDatum((TimeUtil.TimeStruct)((TimeUtil.TimeStruct)o2)));
                    } else if (o2 instanceof Datum) {
                        do2 = DataSetUtil.asDataSet((Datum)((Datum)o2));
                    } else {
                        throw ex;
                    }
                    return do2;
                }
            }
            if (arg0 instanceof PyString) {
                try {
                    return DataSetUtil.asDataSet((Datum)DatumUtil.parse((String)arg0.toString()));
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            if (arg0.isSequenceType()) {
                return PyQDataSetAdapter.adaptList((PyList)arg0);
            }
            throw Py.TypeError((String)("unable to coerce: " + arg0));
        }
        QDataSet ds = (QDataSet)o;
        if (ds.rank() == 0) {
            return ds;
        }
        return ds;
    }

    public QDataSet gt(Object o) {
        System.err.println(o);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PyQDataSet append(PyObject arg0) {
        DDataSet result;
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            if (arg0.isNumberType()) {
                double d = (Double)arg0.__tojava__(Double.class);
                result = (DDataSet)ArrayDataSet.copy(Double.TYPE, (QDataSet)this.rods);
                result = (DDataSet)ArrayDataSet.append((ArrayDataSet)result, (ArrayDataSet)DDataSet.wrap((double[])new double[]{d}));
                return new PyQDataSet((QDataSet)result);
            } else {
                if (!arg0.isSequenceType()) throw Py.TypeError((String)("unable to coerce: " + arg0));
                result = (DDataSet)ArrayDataSet.copy(Double.TYPE, (QDataSet)this.rods);
                result = (DDataSet)ArrayDataSet.append((ArrayDataSet)result, (ArrayDataSet)DDataSet.copy((QDataSet)PyQDataSetAdapter.adaptList((PyList)arg0)));
            }
            return new PyQDataSet((QDataSet)result);
        } else {
            QDataSet ds = (QDataSet)o;
            result = (DDataSet)ArrayDataSet.copy(Double.TYPE, (QDataSet)this.rods);
            result = (DDataSet)ArrayDataSet.append((ArrayDataSet)result, (ArrayDataSet)DDataSet.copy((QDataSet)ds));
        }
        return new PyQDataSet((QDataSet)result);
    }

    private QDataSet coerce_ds(PyObject arg0) {
        return this.coerceDsInternal(arg0);
    }

    public Object __coerce_ex__(PyObject arg0) {
        return this.coerceDsInternal(arg0);
    }

    public PyObject __iter__() {
        return new PyIterator(){
            int i = 0;

            public PyObject __iternext__() {
                if (this.i < PyQDataSet.this.rods.length()) {
                    Object result = PyQDataSet.this.rods.rank() == 1 ? new PyFloat(PyQDataSet.this.rods.value(this.i)) : new PyQDataSet(PyQDataSet.this.rods.slice(this.i));
                    ++this.i;
                    return result;
                }
                return null;
            }
        };
    }

    public Object __tojava__(Class c) {
        if (c.isArray() && c.getComponentType() == Double.TYPE && this.rods.rank() == 1) {
            double[] result = new double[this.rods.length()];
            for (int i = 0; i < this.rods.length(); ++i) {
                result[i] = this.rods.value(i);
            }
            return result;
        }
        return super.__tojava__(c);
    }

    public String toString() {
        return "PyQDataSet wrapping " + this.rods.toString();
    }

    static {
        binaryInfixMethods.put("gt", new PyReflectedFunction("gt"));
        for (Method m : BinaryInfixOps.class.getMethods()) {
            PyReflectedFunction func = binaryInfixMethods.get(m.getName());
            if (func == null) {
                func = new PyReflectedFunction(m.getName());
                binaryInfixMethods.put(m.getName(), func);
            }
            if (func == null) continue;
            func.addMethod(m);
        }
    }
}

