/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.Glob;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.capability.TimeSeriesBrowse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger logger = Logger.getLogger("virbo.jython");
    private static Map<String, Object> metadata;
    private static String metadataSurl;

    public static QDataSet getDataSet(String surl, String stimeRange, ProgressMonitor mon) throws Exception {
        TimeSeriesBrowse tsb;
        logger.log(Level.FINE, "getDataSet({0},{1})", new Object[]{surl, stimeRange});
        URI uri = DataSetURI.getURI((String)surl);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        DataSource result = factory.getDataSource(uri);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if ((tsb = (TimeSeriesBrowse)result.getCapability(TimeSeriesBrowse.class)) != null) {
            DatumRange timeRange = DatumRangeUtil.parseTimeRange((String)stimeRange);
            tsb.setTimeRange(timeRange);
        } else {
            System.err.println("Warning: TimeSeriesBrowse capability not found, simply returning dataset.");
        }
        QDataSet rds = result.getDataSet(mon);
        try {
            metadata = result.getMetadata((ProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            // empty catch block
        }
        metadataSurl = surl;
        if (rds == null) {
            return null;
        }
        if (rds instanceof WritableDataSet && DataSetUtil.isQube((QDataSet)rds)) {
            return rds;
        }
        if (DataSetUtil.isQube((QDataSet)rds)) {
            return DDataSet.copy((QDataSet)rds);
        }
        System.err.println("unable to copy read-only dataset, which may cause problems elsewhere.");
        return rds;
    }

    public static QDataSet getDataSet(String surl, ProgressMonitor mon) throws Exception {
        logger.log(Level.FINE, "getDataSet({0})", surl);
        URI uri = DataSetURI.getURIValid((String)surl);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        DataSource result = factory.getDataSource(uri);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        QDataSet rds = result.getDataSet(mon);
        try {
            metadata = result.getMetadata((ProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            // empty catch block
        }
        metadataSurl = surl;
        if (rds == null) {
            return null;
        }
        if (rds instanceof WritableDataSet && DataSetUtil.isQube((QDataSet)rds)) {
            return rds;
        }
        if (DataSetUtil.isQube((QDataSet)rds)) {
            return DDataSet.copy((QDataSet)rds);
        }
        System.err.println("unable to copy read-only dataset, which may cause problems elsewhere.");
        return rds;
    }

    public static Map<String, Object> getMetaData(String surl, ProgressMonitor mon) throws Exception {
        logger.log(Level.FINE, "getMetaData({0})", surl);
        if (surl.equals(metadataSurl)) {
            return metadata;
        }
        URI url = DataSetURI.getURIValid((String)surl);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)url, (ProgressMonitor)new NullProgressMonitor());
        DataSource result = factory.getDataSource(DataSetURI.getResourceURI((URI)url));
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        return result.getMetadata(mon);
    }

    public static QDataSet getDataSet(String surl) throws Exception {
        return Util.getDataSet(surl, null);
    }

    public static QDataSet getDataSet(String spec, InputStream in, ProgressMonitor mon) throws Exception {
        logger.log(Level.FINE, "getDataSet({0},InputStream)", new Object[]{spec});
        String[] ss = spec.split(":", -2);
        int i = ss[0].indexOf("+");
        String ext = i == -1 ? ss[0] : ss[0].substring(i + 1);
        File f = File.createTempFile("autoplot", "." + ext);
        ReadableByteChannel chin = Channels.newChannel(in);
        FileChannel chout = new FileOutputStream(f).getChannel();
        DataSourceUtil.transfer((ReadableByteChannel)chin, (WritableByteChannel)chout);
        String virtUrl = ss[0] + ":" + f.toURI().toString() + ss[1];
        QDataSet ds = Util.getDataSet(virtUrl, mon);
        return ds;
    }

    public static String[] listDirectory(String surl) throws IOException, URISyntaxException {
        logger.log(Level.FINE, "listDirectory({0})", surl);
        String[] ss = FileSystem.splitUrl((String)surl);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri((String)ss[2]));
        String glob = ss[3].substring(ss[2].length());
        Object[] result = glob.length() == 0 ? fs.listDirectory("/") : fs.listDirectory("/", Glob.getRegex((String)glob));
        Arrays.sort(result);
        return result;
    }
}

