/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.jythoncompletion.CompletionSettings;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.virbo.datasource.DataSetSelector;
import org.virbo.jythonsupport.ui.EditorTextPane;

public class EditorContextMenu {
    private EditorTextPane editor;
    private JPopupMenu menu;
    private DataSetSelector dataSetSelector;
    private JMenu examplesMenu;

    public EditorContextMenu(EditorTextPane edit) {
        this.editor = edit;
        this.maybeCreateMenu();
        this.editor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && EditorContextMenu.this.menu != null) {
                    EditorContextMenu.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && EditorContextMenu.this.menu != null) {
                    EditorContextMenu.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setDataSetSelector(DataSetSelector sel) {
        this.dataSetSelector = sel;
    }

    private JMenuItem createInsertMenuItem(String label, final String text) {
        JMenuItem result = new JMenuItem(new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                EditorContextMenu.this.insertCode(text);
            }
        });
        String htmlText = text;
        htmlText = htmlText.replaceAll("<", "&lt;");
        htmlText = htmlText.replaceAll(">", "&gt;");
        htmlText = htmlText.replaceAll("\n", "<br>");
        htmlText = htmlText.replaceAll(" ", "&nbsp;");
        result.setToolTipText("<html><tt>" + htmlText + "</tt></html>");
        return result;
    }

    private synchronized void maybeCreateMenu() {
        if (this.menu == null) {
            JMenu submenu;
            this.menu = new JPopupMenu();
            JMenu insertCodeMenu = new JMenu("Insert Code");
            insertCodeMenu.add(new AbstractAction("getDataSet()"){

                public void actionPerformed(ActionEvent e) {
                    String surl = EditorContextMenu.this.dataSetSelector.getValue();
                    EditorContextMenu.this.insertCode("getDataSet('" + surl + "')\n");
                }
            });
            insertCodeMenu.add(new AbstractAction("getParam()"){

                public void actionPerformed(ActionEvent e) {
                    String var = EditorContextMenu.this.editor.getSelectedText();
                    if (var == null || var.length() == 0) {
                        EditorContextMenu.this.insertCode("p1= getParam( 'p1', 0.0 , 'parameter p1 (default=0.0)' )\n");
                    } else {
                        EditorContextMenu.this.insertCode(var + "= getParam( '" + var + "', 0.0, 'parameter " + var + " (default=0.0)' )\n");
                    }
                }
            });
            JMenu fragmentsMenu = new JMenu("Code Fragments");
            fragmentsMenu.add(this.createInsertMenuItem("procedure", "def myproc(x,y):\n  z=x+y\n  return z\n"));
            fragmentsMenu.add(this.createInsertMenuItem("if block", "x=0\nif (x<0):\n  print 'x<0'\nelif (x==0):\n  print 'x==0'\nelse:\n  print 'x>0'\n"));
            fragmentsMenu.add(this.createInsertMenuItem("for loop with index", "a= sin( linspace(0,PI,100) )\nfor i in xrange(len(a)):\n  print i, a[i]\n"));
            fragmentsMenu.add(this.createInsertMenuItem("for loop over dataset", "a= sin( linspace(0,PI,100) )\nfor i in a:\n  print i\n"));
            insertCodeMenu.add(fragmentsMenu);
            this.menu.add(insertCodeMenu);
            this.examplesMenu = submenu = new JMenu("Example Scripts");
            this.menu.add(submenu);
            JMenu actionsMenu = new JMenu("Actions");
            JMenuItem mi = new JMenuItem(new AbstractAction("plot"){

                public void actionPerformed(ActionEvent e) {
                    String doThis = EditorContextMenu.this.editor.getSelectedText();
                    if (doThis == null) {
                        return;
                    }
                    EditorContextMenu.this.editor.plot(doThis);
                }
            });
            mi.setToolTipText("Plot dataset reference in a second Autoplot with server port open");
            actionsMenu.add(mi);
            this.menu.add(actionsMenu);
            JMenu settingsMenu = new JMenu("Settings");
            mi = new JMenuItem(new AbstractAction("Edit Settings"){

                public void actionPerformed(ActionEvent e) {
                    CompletionSettings settings = JythonCompletionProvider.getInstance().settings();
                    PropertyEditor p = new PropertyEditor((Object)settings);
                    p.showModalDialog((Component)EditorContextMenu.this.editor);
                }
            });
            mi.setToolTipText("Settings for the editor");
            settingsMenu.add(mi);
            this.menu.add(settingsMenu);
            this.menu.addSeparator();
            JMenuItem cutItem = this.menu.add(new DefaultEditorKit.CutAction());
            cutItem.setText("Cut");
            JMenuItem copyItem = this.menu.add(new DefaultEditorKit.CopyAction());
            copyItem.setText("Copy");
            JMenuItem pasteItem = this.menu.add(new DefaultEditorKit.PasteAction());
            pasteItem.setText("Paste");
        }
    }

    private void insertCode(String code) {
        try {
            this.editor.getDocument().insertString(this.editor.getCaretPosition(), code, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(EditorContextMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addExampleAction(Action a) {
        this.examplesMenu.add(a);
    }
}

