/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.WebFileSystem;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PySyntaxError;
import org.virbo.jythonsupport.ui.EditorAnnotationsSupport;
import org.virbo.jythonsupport.ui.EditorTextPane;

public class ScriptPanelSupport {
    EditorTextPane editor;
    final EditorAnnotationsSupport annotationsSupport;
    JLabel fileNameLabel;
    protected boolean dirty = false;
    public static final String PROP_DIRTY = "dirty";
    protected File file = null;
    public static final String PROP_FILE = "file";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ScriptPanelSupport(EditorTextPane editor) {
        this.editor = editor;
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ScriptPanelSupport.this.setDirty(true);
            }

            public void removeUpdate(DocumentEvent e) {
                ScriptPanelSupport.this.setDirty(true);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.annotationsSupport = editor.getEditorAnnotationsSupport();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        this.updateFileNameLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_DIRTY, oldDirty, dirty);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        this.updateFileNameLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_FILE, oldFile, file);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            this.saveAs();
            return;
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(file);
            String text = this.editor.getText();
            out.write(text.getBytes());
            this.setDirty(false);
        }
        finally {
            out.close();
        }
    }

    public void loadFile(File file) throws IOException, FileNotFoundException {
        FileInputStream r = new FileInputStream(file);
        this.loadInputStream(r);
        this.setFile(file);
        this.setDirty(false);
    }

    protected void loadInputStream(InputStream in) throws IOException {
        BufferedReader r = null;
        try {
            StringBuffer buf = new StringBuffer();
            r = new BufferedReader(new InputStreamReader(in));
            String s = r.readLine();
            while (s != null) {
                buf.append(s + "\n");
                s = r.readLine();
            }
            Document d = this.editor.getDocument();
            d.remove(0, d.getLength());
            d.insertString(0, buf.toString(), null);
            this.setDirty(false);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private void annotateError(PyException ex, int offset) throws BadLocationException {
        if (ex instanceof PySyntaxError) {
            Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            int lineno = offset + ((PyInteger)ex.value.__getitem__(1).__getitem__(1)).getValue();
            this.annotationsSupport.annotateLine(lineno, "error", ex.toString());
        } else {
            Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            this.annotationsSupport.annotateLine(offset + ex.traceback.tb_lineno, "error", ex.toString());
        }
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.toString().endsWith(".jy") || f.toString().endsWith(".py") || f.toString().endsWith(".jyds");
            }

            public String getDescription() {
                return "python and jython scripts";
            }
        };
    }

    public int getSaveFile() throws IOException {
        int r;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(this.getFileFilter());
        if (this.file != null && !this.file.getCanonicalPath().startsWith(WebFileSystem.getDownloadDirectory().toString())) {
            chooser.setSelectedFile(this.file);
        }
        if ((r = chooser.showSaveDialog(this.editor)) == 0) {
            this.file = chooser.getSelectedFile();
            if (!(this.file.toString().endsWith(".jy") || this.file.toString().endsWith(".py") || this.file.toString().endsWith(".jyds"))) {
                this.file = new File(this.file.toString() + ".jy");
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAs() {
        OutputStream out = null;
        try {
            if (this.getSaveFile() == 0) {
                out = new FileOutputStream(this.file);
                String text = this.editor.getText();
                out.write(text.getBytes());
                this.setDirty(false);
                this.setFile(this.file);
            }
        }
        catch (IOException iOException) {
            DasExceptionHandler.handle((Throwable)iOException);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addCaretLabel(final JLabel caretPositionLabel) {
        this.editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int pos = ScriptPanelSupport.this.editor.getCaretPosition();
                Element root = ScriptPanelSupport.this.editor.getDocument().getDefaultRootElement();
                int irow = root.getElementIndex(pos);
                int icol = pos - root.getElement(irow).getStartOffset();
                String text = "" + (1 + irow) + "," + (1 + icol);
                int isel = ScriptPanelSupport.this.editor.getSelectionEnd() - ScriptPanelSupport.this.editor.getSelectionStart();
                int iselRow0 = root.getElementIndex(ScriptPanelSupport.this.editor.getSelectionStart());
                int iselRow1 = root.getElementIndex(ScriptPanelSupport.this.editor.getSelectionEnd());
                if (isel > 0) {
                    text = iselRow1 > iselRow0 ? "[" + isel + "ch," + (1 + iselRow1 - iselRow0) + "lines]" : "[" + isel + "ch]";
                }
                caretPositionLabel.setText(text);
            }
        });
    }

    public void addFileLabel(JLabel fileNameLabel) {
        this.fileNameLabel = fileNameLabel;
        this.updateFileNameLabel();
    }

    private void updateFileNameLabel() {
        if (this.fileNameLabel != null) {
            this.fileNameLabel.setText(String.valueOf(this.getFile()) + " " + (this.isDirty() ? "*" : ""));
        }
    }
}

