/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.imagedatasource;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.imagedatasource.ImageDataSet;
import org.virbo.metatree.MetadataUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageDataSource
extends AbstractDataSource {
    public static final int CHANNEL_HUE = 1;
    public static final int CHANNEL_SATURATION = 2;
    public static final int CHANNEL_VALUE = 3;

    public ImageDataSource(URI uri) {
        super(uri);
    }

    private double toHSV(int rgb, int channel) {
        double sat;
        double r = (rgb & 0xFF0000) >> 16;
        double g = (rgb & 0xFF00) >> 8;
        double b = rgb & 0xFF;
        double minVal = Math.min(Math.min(r /= 255.0, g /= 255.0), b /= 255.0);
        double maxVal = Math.max(Math.max(r, g), b);
        double delta = maxVal - minVal;
        double value = maxVal;
        if (channel == 3) {
            return value * 100.0;
        }
        double hue = 0.0;
        if (delta == 0.0) {
            hue = 0.0;
            sat = 0.0;
        } else {
            sat = delta / maxVal;
            double del_R = ((maxVal - r) / 6.0 + delta / 2.0) / delta;
            double del_G = ((maxVal - g) / 6.0 + delta / 2.0) / delta;
            double del_B = ((maxVal - b) / 6.0 + delta / 2.0) / delta;
            if (r == maxVal) {
                hue = del_B - del_G;
            } else if (g == maxVal) {
                hue = 0.0 + del_R - del_B;
            } else if (b == maxVal) {
                hue = 0.0 + del_G - del_R;
            }
            if (hue < 0.0) {
                hue += 1.0;
            }
            if (hue > 1.0) {
                hue -= 1.0;
            }
            hue *= 360.0;
            sat *= 100.0;
        }
        if (channel == 1) {
            return hue;
        }
        return sat;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        mon.started();
        BufferedImage image = ImageIO.read(DataSetURI.getInputStream((URI)this.uri, (ProgressMonitor)mon));
        String channel = (String)this.params.get("channel");
        Color c = null;
        ImageDataSet.ColorOp op = null;
        if (channel != null) {
            if (channel.equals("red")) {
                c = Color.red;
            } else if (channel.equals("green")) {
                c = Color.green;
            } else if (channel.equals("blue")) {
                c = Color.blue;
            } else {
                if (channel.equals("alpha")) {
                    if (image.getSampleModel().getNumBands() < 4) {
                        throw new IllegalArgumentException("this image has less than three bands, which is interpretted to mean no alpha");
                    }
                    DDataSet ds = DDataSet.createRank2((int)image.getWidth(), (int)image.getHeight());
                    for (int i = 0; i < ds.length(); ++i) {
                        for (int j = 0; j < ds.length(0); ++j) {
                            ds.putValue(i, j, (double)image.getAlphaRaster().getSample(i, j, 0));
                        }
                    }
                    ds.putProperty("LABEL", (Object)"alpha");
                    return ds;
                }
                if (channel.equals("greyscale")) {
                    op = new ImageDataSet.ColorOp(){

                        public double value(int rgb) {
                            int r = rgb & 0xFF;
                            int g = rgb & 0xFF;
                            int b = rgb & 0xFF;
                            return 0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b;
                        }
                    };
                } else if (channel.equals("hue")) {
                    op = new ImageDataSet.ColorOp(){

                        public double value(int rgb) {
                            return ImageDataSource.this.toHSV(rgb, 1);
                        }
                    };
                } else if (channel.equals("saturation")) {
                    op = new ImageDataSet.ColorOp(){

                        public double value(int rgb) {
                            return ImageDataSource.this.toHSV(rgb, 2);
                        }
                    };
                } else if (channel.equals("value")) {
                    op = new ImageDataSet.ColorOp(){

                        public double value(int rgb) {
                            return ImageDataSource.this.toHSV(rgb, 3);
                        }
                    };
                } else {
                    throw new IllegalArgumentException("unsupported channel: " + channel);
                }
            }
        }
        ImageDataSet result = new ImageDataSet(image, c, op);
        if (channel == null) {
            result.putProperty("RENDER_TYPE", "image");
        }
        mon.finished();
        return result;
    }

    public Map<String, Object> getJpegExifMetaData(ProgressMonitor mon) throws Exception {
        InputStream in = DataSetURI.getInputStream((URI)this.uri, (ProgressMonitor)mon);
        Metadata metadata = JpegMetadataReader.readMetadata((InputStream)in);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Directory exifDirectory = metadata.getDirectory(ExifDirectory.class);
        Iterator i = exifDirectory.getTagIterator();
        while (i.hasNext()) {
            Tag t = (Tag)i.next();
            map.put(t.getTagName(), t.getDescription());
        }
        return map;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String ext = this.getExt(this.resourceURI).toLowerCase();
        if (ext.equals(".jpg")) {
            return this.getJpegExifMetaData(mon);
        }
        File f = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)new NullProgressMonitor());
        HashMap<String, Object> map = new HashMap();
        ImageReader jpegImageReader = ImageIO.getImageReadersByFormatName(ext.substring(1)).next();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(f);
        boolean seekForwardOnly = true;
        boolean ignoreMetadata = false;
        jpegImageReader.setInput(imageInputStream, seekForwardOnly, ignoreMetadata);
        IIOMetadata imageMetadata = jpegImageReader.getImageMetadata(0);
        Node metaDataRoot = imageMetadata.getAsTree(imageMetadata.getNativeMetadataFormatName());
        map = MetadataUtil.toMetaTree((Node)metaDataRoot);
        return map;
    }
}

