/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.imagedatasource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.URISplit;

public class ImageDataSourceFormat
implements DataSourceFormat {
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        String ext;
        int j;
        int i;
        int h;
        int w;
        QDataSet b;
        QDataSet g;
        QDataSet r;
        BufferedImage im;
        MutablePropertyDataSet alpha = null;
        if (data.length() == 3) {
            im = new BufferedImage(data.length(0), data.length(0, 0), 1);
            r = data.slice(0);
            g = data.slice(1);
            b = data.slice(2);
            w = data.length(0);
            h = data.length(0, 0);
        } else if (data.length(0, 0) == 4) {
            im = new BufferedImage(data.length(), data.length(0), 2);
            r = DataSetOps.slice2((QDataSet)data, (int)0);
            g = DataSetOps.slice2((QDataSet)data, (int)1);
            b = DataSetOps.slice2((QDataSet)data, (int)2);
            alpha = DataSetOps.slice2((QDataSet)data, (int)3);
            w = data.length();
            h = data.length(0);
        } else {
            im = new BufferedImage(data.length(), data.length(0), 1);
            r = DataSetOps.slice2((QDataSet)data, (int)0);
            g = DataSetOps.slice2((QDataSet)data, (int)1);
            b = DataSetOps.slice2((QDataSet)data, (int)2);
            w = data.length();
            h = data.length(0);
        }
        URISplit split = URISplit.parse((String)uri);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        boolean warn = true;
        while (it.hasNext()) {
            it.next();
            double v = it.getValue(data);
            if (!warn || !(v < 0.0) && !(v >= 256.0)) continue;
            System.err.println("element out of range 0-255: " + v);
            warn = false;
        }
        if (alpha == null) {
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    im.setRGB(i, h - j - 1, (int)(r.value(i, j) * 256.0 * 256.0 + g.value(i, j) * 256.0 + b.value(i, j)));
                }
            }
        } else {
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    im.setRGB(i, h - j - 1, (int)(alpha.value(i, j) * 256.0 * 256.0 * 256.0 + r.value(i, j) * 256.0 * 256.0 + g.value(i, j) * 256.0 + b.value(i, j)));
                }
            }
        }
        if (!ImageIO.write((RenderedImage)im, ext = split.file.substring((i = split.file.lastIndexOf(".")) + 1), new File(split.resourceUri))) {
            throw new IOException("unable to find writer for " + ext);
        }
    }
}

