/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

public class MessageBox
extends Dialog {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 4;
    public static final int NO = 8;
    public static final int YES_NO = 12;
    public static final int YES_NO_CANCEL = 14;
    public static final int OK_CANCEL = 3;
    public static final int DEFAULT = 3;
    private int result;
    private int type;
    private Button yes;
    private Button no;
    private Button ok;
    private Button cancel;

    private MessageBox(Frame owner) {
        super(owner);
    }

    private MessageBoxListener createListener() {
        return new MessageBoxListener();
    }

    public static int showModalMessage(Frame owner, int type, String title, String message) {
        return MessageBox.showModalMessage(owner, type, title, MessageBox.breakLines(message));
    }

    public static int showModalMessage(Frame owner, int type, String title, String[] message) {
        MessageBox mb = new MessageBox(owner);
        MessageBoxListener mbl = mb.createListener();
        if (type == 0) {
            type = 3;
        }
        mb.type = type;
        mb.setTitle(title);
        mb.setModal(true);
        mb.setLayout(new BorderLayout());
        mb.addWindowListener(mbl);
        Panel messagePanel = new Panel(new GridLayout(0, 1));
        for (int i = 0; i < message.length; ++i) {
            messagePanel.add(new Label(message[i]));
        }
        mb.add((Component)messagePanel, "Center");
        Panel buttonPanel = new Panel(new FlowLayout(2));
        if ((type & 1) == 1) {
            mb.ok = new Button("Ok");
            mb.ok.addActionListener(mbl);
            buttonPanel.add(mb.ok);
        }
        if ((type & 4) == 4) {
            mb.yes = new Button("Yes");
            mb.yes.addActionListener(mbl);
            buttonPanel.add(mb.yes);
        }
        if ((type & 8) == 8) {
            mb.no = new Button("No");
            mb.no.addActionListener(mbl);
            buttonPanel.add(mb.no);
        }
        if ((type & 2) == 2) {
            mb.cancel = new Button("Cancel");
            mb.cancel.addActionListener(mbl);
            buttonPanel.add(mb.cancel);
        }
        mb.add((Component)messagePanel, "Center");
        mb.add((Component)buttonPanel, "South");
        mb.pack();
        Dimension od = owner.getSize();
        Point op = owner.getLocation();
        Dimension md = mb.getSize();
        mb.setLocation(op.x + (od.width - md.width) / 2, op.y + (od.height - md.height) / 2);
        mb.setVisible(true);
        return mb.result;
    }

    private static String[] breakLines(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        int lines = st.countTokens();
        String[] list = new String[lines];
        for (int i = 0; i < lines; ++i) {
            list[i] = st.nextToken();
        }
        return list;
    }

    private class MessageBoxListener
    extends WindowAdapter
    implements ActionListener {
        private MessageBoxListener() {
        }

        public void windowClosing(WindowEvent e) {
            MessageBox.this.result = 2;
            MessageBox.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MessageBox.this.ok) {
                MessageBox.this.result = 1;
            } else if (e.getSource() == MessageBox.this.cancel) {
                MessageBox.this.result = 2;
            } else if (e.getSource() == MessageBox.this.yes) {
                MessageBox.this.result = 4;
            } else if (e.getSource() == MessageBox.this.no) {
                MessageBox.this.result = 8;
            }
            MessageBox.this.setVisible(true);
        }
    }
}

