/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.das2.util.Base64;
import org.das2.util.FileUtil;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFileSystem
extends WebFileSystem {
    public static final int LISTING_TIMEOUT_MS = 200000;

    private HttpFileSystem(URI root, File localRoot) {
        super(root, localRoot);
    }

    public static synchronized HttpFileSystem createHttpFileSystem(URI rooturi) throws FileSystem.FileSystemOfflineException, UnknownHostException {
        try {
            File local;
            String auth = rooturi.getAuthority();
            String[] ss = auth.split("@");
            if (ss.length > 3) {
                throw new IllegalArgumentException("user info section can contain at most two at (@) symbols");
            }
            if (ss.length == 3) {
                String userInfo = ss[0];
                for (int i = 1; i < 2; ++i) {
                    userInfo = userInfo + "%40" + ss[i];
                }
                auth = ss[2];
                try {
                    URI rooturi2;
                    rooturi = rooturi2 = new URI(rooturi.getScheme() + "://" + userInfo + "@" + auth + rooturi.getPath());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("unable to handle: " + rooturi);
                }
            }
            URL root = rooturi.toURL();
            HttpURLConnection urlc = (HttpURLConnection)root.openConnection();
            urlc.setConnectTimeout(3000);
            urlc.setRequestMethod("HEAD");
            String userInfo = null;
            try {
                userInfo = KeyChain.getDefault().getUserInfo(root);
            }
            catch (CancelledOperationException ex) {
                throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
            }
            if (userInfo != null) {
                String encode = Base64.encodeBytes(userInfo.getBytes());
                urlc.setRequestProperty("Authorization", "Basic " + encode);
            }
            boolean offline = true;
            boolean connectFail = true;
            try {
                urlc.connect();
                connectFail = false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                if (FileSystem.settings().isAllowOffline()) {
                    logger.info("remote filesystem is offline, allowing access to local cache.");
                }
                throw new FileSystem.FileSystemOfflineException("" + urlc.getResponseCode() + ": " + urlc.getResponseMessage());
            }
            if (!connectFail) {
                if (urlc.getResponseCode() != 200 && urlc.getResponseCode() != 403) {
                    if (urlc.getResponseCode() == 401) {
                        KeyChain.getDefault().clearUserPassword(root);
                        if (userInfo == null) {
                            String port = root.getPort() == -1 ? "" : ":" + root.getPort();
                            URL rootAuth = new URL(root.getProtocol() + "://" + "user@" + root.getHost() + port + root.getFile());
                            try {
                                URI rootAuthUri = rootAuth.toURI();
                                return HttpFileSystem.createHttpFileSystem(rootAuthUri);
                            }
                            catch (URISyntaxException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    } else {
                        offline = false;
                    }
                } else {
                    offline = false;
                }
            }
            if (FileSystemSettings.hasAllPermission()) {
                local = HttpFileSystem.localRoot(rooturi);
                logger.log(Level.FINER, "initializing httpfs {0} at {1}", new Object[]{root, local});
            } else {
                local = null;
                logger.log(Level.FINER, "initializing httpfs {0} in applet mode", root);
            }
            HttpFileSystem result = new HttpFileSystem(rooturi, local);
            result.offline = offline;
            return result;
        }
        catch (FileSystem.FileSystemOfflineException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileSystem.FileSystemOfflineException(e, rooturi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void downloadFile(String filename, File f, File partFile, ProgressMonitor monitor) throws IOException {
        block23: {
            Lock lock = this.getDownloadLock(filename, f, monitor);
            if (lock == null) {
                return;
            }
            logger.log(Level.FINE, "downloadFile({0})", filename);
            try {
                HttpURLConnection hurlc;
                String userInfo;
                URL remoteURL = new URL(this.root.toString() + filename);
                URLConnection urlc = remoteURL.openConnection();
                try {
                    userInfo = KeyChain.getDefault().getUserInfo(this.root);
                }
                catch (CancelledOperationException ex) {
                    throw new IOException("user cancelled at credentials entry");
                }
                if (userInfo != null) {
                    String encode = Base64.encodeBytes(userInfo.getBytes());
                    urlc.setRequestProperty("Authorization", "Basic " + encode);
                }
                if ((hurlc = (HttpURLConnection)urlc).getResponseCode() == 404) {
                    logger.log(Level.INFO, "{0} URL: {1}", new Object[]{hurlc.getResponseCode(), remoteURL});
                    throw new FileNotFoundException("not found: " + remoteURL);
                }
                if (hurlc.getResponseCode() != 200) {
                    logger.log(Level.INFO, "{0} URL: {1}", new Object[]{hurlc.getResponseCode(), remoteURL});
                    throw new IOException(hurlc.getResponseCode() + ": " + hurlc.getResponseMessage() + "\n" + remoteURL);
                }
                Date d = null;
                List<String> sd = urlc.getHeaderFields().get("Last-Modified");
                if (sd != null && sd.size() > 0) {
                    d = new Date(sd.get(sd.size() - 1));
                }
                monitor.setTaskSize(urlc.getContentLength());
                if (!f.getParentFile().exists()) {
                    logger.log(Level.FINE, "make dirs {0}", f.getParentFile());
                    FileSystemUtil.maybeMkdirs(f.getParentFile());
                }
                if (partFile.exists()) {
                    logger.log(Level.FINE, "clobber file {0}", f);
                    if (!partFile.delete()) {
                        logger.log(Level.INFO, "Unable to clobber file {0}, better use it for now.", f);
                        return;
                    }
                }
                if (partFile.createNewFile()) {
                    InputStream in = urlc.getInputStream();
                    logger.log(Level.FINE, "transferring bytes of {0}", filename);
                    FileOutputStream out = new FileOutputStream(partFile);
                    monitor.setLabel("downloading file");
                    monitor.started();
                    try {
                        this.copyStream(in, out, monitor);
                        monitor.finished();
                        out.close();
                        in.close();
                        if (d != null) {
                            try {
                                partFile.setLastModified(d.getTime() + 10L);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (f.exists()) {
                            logger.log(Level.FINE, "deleting old file {0}", f);
                            if (!f.delete()) {
                                throw new IllegalArgumentException("unable to delete " + f);
                            }
                        }
                        if (!partFile.renameTo(f)) {
                            throw new IllegalArgumentException("rename failed " + partFile + " to " + f);
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        out.close();
                        in.close();
                        partFile.delete();
                        throw e;
                    }
                }
                throw new IOException("couldn't create local file: " + f);
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected Map<String, Object> getHeadMeta(String f) throws IOException, CancelledOperationException {
        String realName = f;
        try {
            URL ur = new URL(this.root.toURL(), f);
            HttpURLConnection connect = (HttpURLConnection)ur.openConnection();
            String userInfo = KeyChain.getDefault().getUserInfo(ur);
            if (userInfo != null) {
                String encode = Base64.encodeBytes(userInfo.getBytes());
                connect.setRequestProperty("Authorization", "Basic " + encode);
            }
            connect.setRequestMethod("HEAD");
            HttpURLConnection.setFollowRedirects(false);
            connect.connect();
            HttpURLConnection.setFollowRedirects(true);
            if (connect.getResponseCode() == 303) {
                String surl = connect.getHeaderField("Location");
                if (surl.startsWith(this.root.toString())) {
                    realName = surl.substring(this.root.toString().length());
                }
                connect.disconnect();
                ur = new URL(this.root.toURL(), realName);
                connect = (HttpURLConnection)ur.openConnection();
                connect.setRequestMethod("HEAD");
                connect.connect();
            }
            boolean exists = connect.getResponseCode() != 404;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.putAll(connect.getHeaderFields());
            connect.disconnect();
            return result;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        if (this.localRoot == null) {
            return filename.endsWith("/");
        }
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        File parentFile = f.getParentFile();
        String parent = this.getLocalName(parentFile);
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String[] list = this.listDirectory(parent);
        String lookFor = filename.startsWith("/") ? filename.substring(1) + "/" : filename + "/";
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(lookFor)) continue;
            return true;
        }
        return false;
    }

    public void resetListingCache() {
        if (!FileUtil.deleteWithinFileTree(this.localRoot, ".listing")) {
            throw new IllegalArgumentException("unable to delete all .listing files");
        }
    }

    private File listingFile(String directory) {
        File f = new File(this.localRoot, directory);
        try {
            FileSystemUtil.maybeMkdirs(f);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("unable to mkdir " + f);
        }
        File listing = new File(this.localRoot, directory + ".listing");
        return listing;
    }

    public boolean isListingCached(String directory) {
        File listing = this.listingFile(directory);
        if (listing.exists() && System.currentTimeMillis() - listing.lastModified() < 200000L) {
            logger.fine(String.format("listing date is %f5.2 seconds old", (double)(System.currentTimeMillis() - listing.lastModified()) / 1000.0));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listDirectory(String directory) throws IOException {
        if (this.isListingCached(directory = HttpFileSystem.toCanonicalFolderName(directory))) {
            logger.log(Level.FINE, "using cached listing for {0}", directory);
            File listing = this.listingFile(directory);
            URL[] list = null;
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(listing);
                list = HtmlUtil.getDirectoryListing(this.getURL(directory), fin);
            }
            catch (CancelledOperationException ex) {
                throw new IllegalArgumentException(ex);
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
            }
            String[] result = new String[list.length];
            int n = directory.length();
            for (int i = 0; i < list.length; ++i) {
                URL url = list[i];
                result[i] = this.getLocalName(url).substring(n);
            }
            return result;
        }
        boolean successOrCancel = false;
        if (this.isOffline()) {
            File f = new File(this.localRoot, directory);
            if (!f.exists()) {
                throw new FileSystem.FileSystemOfflineException("unable to list " + f + " when offline");
            }
            String[] listing = f.list();
            return listing;
        }
        if (!successOrCancel) {
            logger.log(Level.FINE, "list {0}", directory);
            try {
                URL[] list;
                URL listUrl = this.getURL(directory);
                String file = listUrl.getFile();
                if (file.charAt(file.length() - 1) != '/') {
                    listUrl = new URL(listUrl.toString() + '/');
                }
                File listing = this.listingFile(directory);
                this.downloadFile(directory, listing, new File(listing.toString() + ".part"), new NullProgressMonitor());
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(listing);
                    list = HtmlUtil.getDirectoryListing(this.getURL(directory), fin);
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                }
                String[] result = new String[list.length];
                int n = directory.length();
                for (int i = 0; i < list.length; ++i) {
                    URL url = list[i];
                    result[i] = this.getLocalName(url).substring(n);
                }
                return result;
            }
            catch (CancelledOperationException ex) {
                throw new IOException("user cancelled at credentials");
            }
            catch (IOException ex) {
                if (this.isOffline()) {
                    System.err.println("** using local listing because remote is not available");
                    System.err.println("or some other error occurred. **");
                    File localFile = new File(this.localRoot, directory);
                    return localFile.list();
                }
                throw ex;
            }
        }
        return new String[]{"should not get here"};
    }

    @Override
    public String[] listDirectory(String directory, String regex) throws IOException {
        if (!this.isDirectory(directory = HttpFileSystem.toCanonicalFilename(directory))) {
            throw new IllegalArgumentException("is not a directory: " + directory);
        }
        String[] listing = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex + "/?");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < listing.length; ++i) {
            if (!pattern.matcher(listing[i]).matches()) continue;
            result.add(listing[i]);
        }
        return result.toArray(new String[result.size()]);
    }
}

