/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.das2.util.filesystem.AppletHttpProtocol;
import org.das2.util.filesystem.DefaultHttpProtocol;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

public abstract class WebFileSystem
extends FileSystem {
    Map<String, Long> lastAccessed = new HashMap<String, Long>();
    protected final File localRoot;
    private boolean applet;
    protected WebProtocol protocol;
    protected boolean offline = false;
    public static final String PROP_OFFLINE = "offline";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map downloads = new HashMap();

    public static File getDownloadDirectory() {
        File local = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        local = new File(local, ".das2/fsCache/wfs/");
        return local;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        boolean oldOffline = offline;
        this.offline = offline;
        this.propertyChangeSupport.firePropertyChange(PROP_OFFLINE, oldOffline, offline);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected WebFileSystem(URI root, File localRoot) {
        super(root);
        this.localRoot = localRoot;
        if (localRoot == null) {
            if (root.getScheme().equals("http") || root.getScheme().equals("https")) {
                this.protocol = new AppletHttpProtocol();
            }
        } else if (root.getScheme().equals("http") || root.getScheme().equals("https")) {
            this.protocol = new DefaultHttpProtocol();
        }
    }

    protected static File localRoot(URI root) {
        File local = FileSystem.settings().getLocalCacheDir();
        logger.log(Level.FINE, "WFS localRoot={0}", local);
        String s = root.getScheme() + "/" + root.getHost() + "/" + root.getPath();
        local = new File(local, s);
        try {
            FileSystemUtil.maybeMkdirs(local);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return local;
    }

    private void waitForDownload(ProgressMonitor monitor, String filename) {
        monitor.setProgressMessage("waiting for file to download");
        ProgressMonitor downloadMonitor = (ProgressMonitor)this.downloads.get(filename);
        monitor.started();
        while (downloadMonitor != null) {
            monitor.setTaskSize(downloadMonitor.getTaskSize());
            if (monitor.isCancelled()) {
                downloadMonitor.cancel();
            }
            if (!monitor.isCancelled()) {
                monitor.setTaskProgress(downloadMonitor.getTaskProgress());
            }
            try {
                this.downloads.wait(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            downloadMonitor = (ProgressMonitor)this.downloads.get(filename);
        }
        monitor.finished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getDownloadLock(final String filename, File f, ProgressMonitor monitor) throws IOException {
        logger.log(Level.FINER, "{0} wants download lock for {1} wfs impl {2}", new Object[]{Thread.currentThread().getName(), filename, this.hashCode()});
        Map map = this.downloads;
        synchronized (map) {
            ProgressMonitor mon = (ProgressMonitor)this.downloads.get(filename);
            if (mon != null) {
                logger.log(Level.FINE, "another thread is downloading {0}, waiting...", filename);
                this.waitForDownload(monitor, filename);
                if (f.exists()) {
                    return null;
                }
                if (monitor.isCancelled()) {
                    throw new InterruptedIOException("request was cancelled");
                }
                throw new FileNotFoundException("expected to find " + f);
            }
            logger.log(Level.FINE, "this thread will download {0}.", filename);
            this.downloads.put(filename, monitor);
            monitor.started();
            return new ReentrantLock(){

                public void lock() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void unlock() {
                    Map map = WebFileSystem.this.downloads;
                    synchronized (map) {
                        WebFileSystem.this.downloads.remove(filename);
                        WebFileSystem.this.downloads.notifyAll();
                    }
                }
            };
        }
    }

    protected abstract void downloadFile(String var1, File var2, File var3, ProgressMonitor var4) throws IOException;

    public String getLocalRootAbsPath() {
        return this.localRoot.getAbsolutePath();
    }

    public File getLocalRoot() {
        return this.localRoot;
    }

    public abstract boolean isDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1) throws IOException;

    public String[] listDirectory(String directory, String regex) throws IOException {
        String[] names = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].endsWith("/")) {
                names[i] = names[i].substring(0, names[i].length() - 1);
            }
            if (!pattern.matcher(names[i]).matches()) continue;
            result.add(names[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public URL getURL(String filename) {
        try {
            filename = FileSystem.toCanonicalFilename(filename);
            return new URL(this.root + filename.substring(1));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getURI(String filename) {
        try {
            filename = FileSystem.toCanonicalFilename(filename);
            return new URI(this.root + filename.substring(1));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getRootURL() {
        try {
            return this.root.toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    public String getLocalName(URL url) {
        if (!url.toString().startsWith(this.root.toString())) {
            throw new IllegalArgumentException("url \"" + url + "\"is not of this web file system");
        }
        String filename = FileSystem.toCanonicalFilename(url.toString().substring(this.root.toString().length()));
        return filename;
    }

    public FileObject getFileObject(String filename) {
        WebFileObject f = new WebFileObject(this, filename, new Date(System.currentTimeMillis()));
        return f;
    }

    protected synchronized long getLastAccessed(String filename) {
        Long lastAccess = this.lastAccessed.get(filename);
        if (lastAccess == null) {
            return 0L;
        }
        return lastAccess;
    }

    protected synchronized void markAccess(String filename) {
        this.lastAccessed.put(filename, System.currentTimeMillis());
    }

    protected void copyStream(InputStream is, OutputStream out, ProgressMonitor monitor) throws IOException {
        byte[] buffer = new byte[2048];
        int bytesRead = is.read(buffer, 0, 2048);
        long totalBytesRead = bytesRead;
        while (bytesRead > -1) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            monitor.setTaskProgress(totalBytesRead);
            out.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer, 0, 2048);
            totalBytesRead += (long)bytesRead;
            logger.finest("transferring data");
        }
    }

    public String toString() {
        return "wfs " + this.root;
    }

    public boolean isAppletMode() {
        return this.applet;
    }

    public void setAppletMode(boolean applet) {
        this.applet = applet;
    }
}

