/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CombinedTreeModel
implements TreeModel {
    List treeModels;
    List treeModelRoots;
    List<Float> treeModelSortIndexes;
    Object root = null;
    WeakHashMap sourceMap;
    List listeners;
    private final boolean checkEvent = false;
    SubTreeModelListener myListener = new SubTreeModelListener();

    public CombinedTreeModel(Object root) {
        this.root = root;
        this.treeModels = new ArrayList();
        this.treeModelRoots = new ArrayList();
        this.treeModelSortIndexes = new ArrayList<Float>();
        this.sourceMap = new WeakHashMap();
        this.listeners = new ArrayList();
    }

    public Object getRoot() {
        return this.root;
    }

    public void mountTree(TreeModel treeModel) {
        this.mountTree(treeModel, -1);
    }

    public void mountTree(TreeModel treeModel, int sortIndex) {
        if (this.treeModelRoots.contains(treeModel.getRoot())) {
            int index = this.treeModelRoots.indexOf(treeModel.getRoot());
            this.treeModels.set(index, treeModel);
            this.treeModelRoots.set(index, treeModel.getRoot());
            this.treeModelSortIndexes.set(index, Float.valueOf(sortIndex));
            TreePath path = new TreePath(this.root);
            treeModel.addTreeModelListener(this.myListener);
            this.fireTreeNodesChanged(path, new int[]{index}, new Object[]{treeModel.getRoot()});
        } else {
            int index = Collections.binarySearch(this.treeModelSortIndexes, Float.valueOf((float)sortIndex + 0.5f));
            index = -1 - index;
            this.treeModels.add(index, treeModel);
            this.treeModelRoots.add(index, treeModel.getRoot());
            this.treeModelSortIndexes.add(index, Float.valueOf(sortIndex));
            TreePath path = new TreePath(this.root);
            treeModel.addTreeModelListener(this.myListener);
            this.fireTreeNodesInserted(path, new int[]{index}, new Object[]{treeModel.getRoot()});
        }
    }

    public void unmountTree(TreeModel treeModel) {
        int index = this.treeModelRoots.indexOf(treeModel.getRoot());
        if (index != -1) {
            this.treeModels.remove(index);
            this.treeModelRoots.remove(index);
            this.treeModelSortIndexes.remove(index);
            TreePath path = new TreePath(this.root);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{treeModel.getRoot()}));
        }
    }

    public synchronized Object getChild(Object parent, int index) {
        Object result;
        TreeModel mt;
        if (parent == this.root) {
            mt = (TreeModel)this.treeModels.get(index);
            result = mt.getRoot();
        } else {
            mt = (TreeModel)this.sourceMap.get(parent);
            result = mt.getChild(parent, index);
        }
        this.sourceMap.put(result, mt);
        return result;
    }

    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.treeModels.size();
        }
        TreeModel mt = (TreeModel)this.sourceMap.get(parent);
        return mt.getChildCount(parent);
    }

    public boolean isLeaf(Object node) {
        if (node == this.root) {
            return this.treeModels.size() == 0;
        }
        TreeModel mt = (TreeModel)this.sourceMap.get(node);
        if (mt == null) {
            System.err.println("null on " + node);
            return true;
        }
        return mt.isLeaf(node);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        Object parent = path.getPathComponent(path.getPathCount() - 2);
        Object child = path.getPathComponent(path.getPathCount() - 1);
        int index = this.getIndexOfChild(parent, child);
        this.fireTreeNodesChanged(path, new int[]{index}, new Object[]{newValue});
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            for (int i = 0; i < this.treeModels.size(); ++i) {
                if (child != ((TreeModel)this.treeModels.get(i)).getRoot()) continue;
                return i;
            }
            return -1;
        }
        TreeModel mt = (TreeModel)this.sourceMap.get(parent);
        return mt.getIndexOfChild(parent, child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeNodesInserted(TreePath path, int[] insertedIndeces, Object[] children) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path, insertedIndeces, children);
        this.fireTreeNodesInserted(e);
    }

    private void fireTreeNodesChanged(TreePath path, int[] changedIndeces, Object[] children) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path, changedIndeces, children);
        this.fireTreeNodesChanged(e);
    }

    private void fireTreeNodesChanged(TreeModelEvent e) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesChanged(e);
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent e) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeStructureChanged(e);
        }
    }

    class SubTreeModelListener
    implements TreeModelListener {
        SubTreeModelListener() {
        }

        private TreeModelEvent prependTreeModelEvent(TreeModelEvent e) {
            Object[] path = e.getPath();
            Object[] path2 = new Object[path.length + 1];
            path2[0] = CombinedTreeModel.this.root;
            System.arraycopy(path, 0, path2, 1, path.length);
            TreeModelEvent result = new TreeModelEvent((Object)this, path2, e.getChildIndices(), e.getChildren());
            return result;
        }

        public void treeNodesChanged(TreeModelEvent e) {
            CombinedTreeModel.this.fireTreeNodesChanged(this.prependTreeModelEvent(e));
        }

        public void treeNodesInserted(TreeModelEvent e) {
            CombinedTreeModel.this.fireTreeNodesInserted(this.prependTreeModelEvent(e));
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            CombinedTreeModel.this.fireTreeNodesRemoved(this.prependTreeModelEvent(e));
        }

        public void treeStructureChanged(TreeModelEvent e) {
            CombinedTreeModel.this.fireTreeStructureChanged(this.prependTreeModelEvent(e));
        }
    }
}

