/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.Arrays;
import org.das2.util.DasDie;

public class DasMath {
    private static final double log10 = Math.log(10.0);

    public static double log10(double x) {
        return Math.log(x) / log10;
    }

    public static double exp10(double x) {
        double result = Math.pow(10.0, x);
        return result;
    }

    public static double exp10(int x) {
        double result = Math.pow(10.0, x);
        return result;
    }

    public static double roundNFractionalDigits(double x, int n) {
        double tenToN = Math.pow(10.0, n - 1);
        return (double)Math.round(x * tenToN) / tenToN;
    }

    public static double roundNSignificantDigits(double x, int n) {
        double sign = x < 0.0 ? -1.0 : 1.0;
        double exp = Math.pow(10.0, Math.floor(Math.log10(sign * x)));
        double mant = x / exp;
        double tenToN = Math.pow(10.0, n - 1);
        mant = (double)Math.round(mant * tenToN) / tenToN;
        return mant * exp;
    }

    public static double tanh(double x) {
        double sinh = (Math.exp(x) - Math.exp(-x)) / 2.0;
        double cosh = (Math.exp(x) + Math.exp(-x)) / 2.0;
        double tanh = sinh / cosh;
        return tanh;
    }

    public static double interpolate(double[] datay, double findex) {
        int index = (int)findex;
        double alpha = findex - (double)index;
        if (findex < 0.0) {
            return datay[0];
        }
        if (findex > (double)datay.length - 1.0) {
            return datay[datay.length - 1];
        }
        double result = alpha == 0.0 ? datay[index] : datay[index] * (1.0 - alpha) + datay[index + 1] * alpha;
        return result;
    }

    public static double[] interpolate(double[] datay, double[] findex) {
        double[] result = new double[findex.length];
        for (int i = 0; i < findex.length; ++i) {
            result[i] = DasMath.interpolate(datay, findex[i]);
        }
        return result;
    }

    public static double[] findex(double[] datax, double[] x) {
        double[] result = new double[x.length];
        int index = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = DasMath.findex(datax, x[i], index);
            index = (int)result[i];
        }
        return result;
    }

    public static final double findex(double[] datax, double x, int guess) {
        int index;
        for (index = Math.max(Math.min(guess, datax.length - 1), 0); index < datax.length - 1 && datax[index + 1] < x; ++index) {
        }
        while (index > 0 && datax[index] > x) {
            --index;
        }
        if (index == datax.length - 1) {
            --index;
        }
        return (double)index + (x - datax[index]) / (datax[index + 1] - datax[index]);
    }

    public static void main(String[] args) {
        double x = 1.0E-18;
        DasDie.println("x:" + x);
        DasDie.println("roundNDigits:" + DasMath.roundNSignificantDigits(x, 3));
        double[] x1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] y1 = new double[]{4.0, 6.0, 7.0, 3.0, 1.0};
        double[] interpx = new double[]{1.0, 1.5, 4.5, 5.0, 1.5};
        double[] interpy = DasMath.interpolate(y1, DasMath.findex(x1, interpx));
        for (int i = 0; i < interpx.length; ++i) {
            System.out.println("" + interpx[i] + " " + interpy[i]);
        }
    }

    public static double modp(double x, double t) {
        double result = x % t;
        return result >= 0.0 ? result : t + result;
    }

    public static int modp(int x, int t) {
        int result = x % t;
        return result >= 0 ? result : t + result;
    }

    public static double biggerOf(double x1, double x2) {
        return x1 > x2 ? x1 : x2;
    }

    private static double gcd(double a, double d, double error) {
        if (error > 0.0) {
            a = Math.round(a / error);
            d = Math.round(d / error);
        }
        if (a < d) {
            double t = a;
            a = d;
            d = t;
        }
        if (d == 0.0) {
            if (error > 0.0) {
                return a * error;
            }
            return a;
        }
        double r = a % d;
        for (int iterations = 0; r > 0.0 && iterations < 15; ++iterations) {
            d = r;
            r = a % d;
        }
        if (error > 0.0) {
            return d * error;
        }
        return d;
    }

    public static double gcd(double[] A, double error) {
        double guess;
        double result = guess = A[0];
        for (int i = 1; i < A.length; ++i) {
            result = DasMath.gcd(result, A[i], error);
        }
        return result;
    }

    public static double mean(double[] A) {
        double avgGuess = A[0];
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i] - avgGuess;
        }
        return sum / (double)A.length + avgGuess;
    }

    public static double median(double[] A) {
        double[] sorted = DasMath.sort(A);
        return sorted[A.length / 2];
    }

    public static double max(double[] A) {
        double max = A[0];
        for (int i = 0; i < A.length; ++i) {
            max = max > A[i] ? max : A[i];
        }
        return max;
    }

    public static double min(double[] A) {
        double min = A[0];
        for (int i = 0; i < A.length; ++i) {
            min = min < A[i] ? min : A[i];
        }
        return min;
    }

    public static double[] sort(double[] A) {
        double[] copy = new double[A.length];
        for (int i = 0; i < A.length; ++i) {
            copy[i] = A[i];
        }
        Arrays.sort(copy);
        return copy;
    }
}

