/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

public class FixedWidthFormatter {
    private static final String spaces = "                                  ";
    private static final String stars = "**********************************";

    public static String format(String s, int nchars) {
        if (nchars > stars.length()) {
            return FixedWidthFormatter.formatWide(s, nchars);
        }
        int pad = nchars - s.length();
        if (pad > 0) {
            s = spaces.substring(0, pad) + s;
        } else if (s.length() > nchars) {
            s = stars.substring(0, nchars);
        }
        return s;
    }

    public static String formatWide(String s, int nchars) {
        if (s.length() < nchars) {
            StringBuffer sb = new StringBuffer(nchars - s.length());
            for (int i = 0; i < nchars - s.length(); ++i) {
                sb.append(' ');
            }
            s = sb.toString() + s;
        } else if (s.length() > nchars) {
            StringBuffer sb = new StringBuffer(nchars);
            for (int i = 0; i < nchars; ++i) {
                sb.append('*');
            }
            s = sb.toString();
        }
        return s;
    }
}

