/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.DefaultExceptionHandler;
import org.das2.util.ExceptionHandler;
import org.das2.util.ThrowRuntimeExceptionHandler;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystemFactory;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FtpFileSystemFactory;
import org.das2.util.filesystem.HttpFileSystemFactory;
import org.das2.util.filesystem.LocalFileSystemFactory;
import org.das2.util.filesystem.SubFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public abstract class FileSystem {
    URI root;
    protected static final Logger logger = Logger.getLogger("das2.filesystem");
    private static final Map<URI, FileSystem> instances = new HashMap<URI, FileSystem>();
    private static FileSystemSettings settings = new FileSystemSettings();
    private static final HashMap registry = new HashMap();
    public static final String PROP_CASE_INSENSITIVE = "caseInsensitive";
    protected HashMap properties = new HashMap(5);
    private static ExceptionHandler exceptionHandler;

    public static FileSystem create(URL root) throws FileSystemOfflineException, UnknownHostException {
        try {
            return FileSystem.create(root.toURI(), (ProgressMonitor)new NullProgressMonitor());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FileSystem create(String s) throws FileSystemOfflineException, UnknownHostException {
        try {
            return FileSystem.create(new URI(s), (ProgressMonitor)new NullProgressMonitor());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static synchronized FileSystem create(URL root, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException {
        try {
            return FileSystem.create(root.toURI(), mon);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static synchronized FileSystem recreate(URI root) throws FileSystemOfflineException, UnknownHostException {
        return FileSystem.recreate(root, new NullProgressMonitor());
    }

    public static FileSystem create(URI root) throws FileSystemOfflineException, UnknownHostException {
        return FileSystem.create(root, (ProgressMonitor)new NullProgressMonitor());
    }

    public static synchronized FileSystem recreate(URI root, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException {
        FileSystem result = instances.get(root);
        if (result != null) {
            return instances.remove(root);
        }
        return FileSystem.create(root, mon);
    }

    public static synchronized void reset() {
        instances.clear();
    }

    public static synchronized FileSystem create(URI root, ProgressMonitor mon) throws FileSystemOfflineException, UnknownHostException {
        FileSystemFactory factory;
        logger.log(Level.FINE, "create filesystem {0}", root);
        FileSystem result = instances.get(root);
        if (result != null) {
            return result;
        }
        if (root.getPath() != null && (root.getPath().contains(".zip") || root.getPath().contains(".ZIP")) && registry.containsKey("zip")) {
            try {
                String surl = root.toString();
                int i = surl.indexOf(".zip");
                if (i == -1) {
                    i = surl.indexOf(".ZIP");
                }
                String[] ss = FileSystem.splitUrl(surl.substring(0, i + 4));
                URI parent = new URI(ss[2]);
                String zipname = ss[3].substring(ss[2].length());
                String subdir = surl.substring(i + 4);
                FileSystem remote = FileSystem.create(parent);
                File localZipFile = remote.getFileObject(zipname).getFile(mon);
                factory = (FileSystemFactory)registry.get("zip");
                FileSystem zipfs = factory.createFileSystem(localZipFile.toURI());
                if (subdir.equals("") || subdir.equals("/")) {
                    result = zipfs;
                }
                result = new SubFileSystem(zipfs, subdir);
            }
            catch (UnknownHostException ex) {
                throw ex;
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new FileSystemOfflineException(ex);
            }
        } else {
            factory = (FileSystemFactory)registry.get(root.getScheme());
        }
        if (factory == null) {
            throw new IllegalArgumentException("unsupported protocol: " + root);
        }
        if (result == null) {
            try {
                result = factory.createFileSystem(root);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        instances.put(root, result);
        return result;
    }

    public static FileSystemSettings settings() {
        return settings;
    }

    public static void registerFileSystemFactory(String proto, FileSystemFactory factory) {
        registry.put(proto, factory);
    }

    protected FileSystem(URI root) {
        if (!root.toString().endsWith("/")) {
            String s = root.toString();
            try {
                root = new URI(s + "/");
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(FileSystem.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        this.root = root;
    }

    public URI getRootURI() {
        return this.root;
    }

    private static String getRegexFromGlob(String glob) {
        String regex = glob.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        return regex;
    }

    protected static String toCanonicalFilename(String filename) {
        if ((filename = filename.replaceAll("\\\\", "/")).length() == 0 || filename.charAt(0) != '/') {
            filename = "/" + filename;
        }
        filename = filename.replaceAll("//", "/");
        return filename;
    }

    protected static String toCanonicalFolderName(String name) {
        if (!(name = FileSystem.toCanonicalFilename(name)).endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    public abstract FileObject getFileObject(String var1);

    public abstract boolean isDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1, String var2) throws IOException;

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public abstract File getLocalRoot();

    public FileSystem createFileSystem(String directory) throws URISyntaxException {
        try {
            return new SubFileSystem(this, FileSystem.toCanonicalFolderName(directory));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String[] splitUrl(String surl) {
        int i3;
        int fileEnd;
        if (!(surl.startsWith("file:/") || surl.startsWith("ftp://") || surl.startsWith("http://") || surl.startsWith("https://"))) {
            surl = "file://" + (surl.charAt(0) == '/' ? surl : '/' + surl);
        }
        String params = null;
        int i = surl.indexOf("?");
        if (i != -1) {
            fileEnd = i;
            params = surl.substring(i + 1);
            if ((i = surl.indexOf("?", i + 1)) != -1) {
                throw new IllegalArgumentException("too many ??'s!");
            }
        } else {
            fileEnd = surl.length();
        }
        i = surl.lastIndexOf("/");
        String surlDir = surl.substring(0, i);
        String file = surl.substring(i, fileEnd);
        String ext = (i = file.lastIndexOf(46)) != -1 ? file.substring(i + 1) : "";
        int i2 = surl.indexOf("://") + 3;
        if (surl.indexOf("://") == -1 && surl.startsWith("file:/")) {
            i2 = 5;
        }
        if ((i3 = surl.indexOf("/", i2 + 1)) == -1) {
            i3 = i2;
        }
        String[] result = new String[]{surl.substring(0, i2), surl.substring(0, i3), surlDir + "/", surl.substring(0, fileEnd), ext, params};
        return result;
    }

    public static synchronized ExceptionHandler getExceptionHandler() {
        if (exceptionHandler == null) {
            String val;
            String name = "java.awt.headless";
            String deft = "false";
            try {
                val = System.getProperty(name, deft);
            }
            catch (SecurityException ex) {
                val = deft;
            }
            boolean headless = "true".equals(val);
            exceptionHandler = headless ? new ThrowRuntimeExceptionHandler() : new DefaultExceptionHandler();
        }
        return exceptionHandler;
    }

    public static synchronized void setExceptionHandler(ExceptionHandler eh) {
        exceptionHandler = eh;
    }

    static {
        registry.put("file", new LocalFileSystemFactory());
        registry.put("http", new HttpFileSystemFactory());
        registry.put("https", new HttpFileSystemFactory());
        registry.put("ftp", new FtpFileSystemFactory());
        exceptionHandler = null;
    }

    public static class DirectoryEntry {
        public String name;
        public char type;
        public long size;
        public long modified;
    }

    public static class FileSystemOfflineException
    extends IOException {
        public FileSystemOfflineException() {
        }

        public FileSystemOfflineException(String message) {
            super(message);
        }

        public FileSystemOfflineException(IOException e) {
            super(e.getMessage());
            this.initCause(e);
        }

        public FileSystemOfflineException(IOException e, URI root) {
            super(e.getMessage() + ": " + root);
            this.initCause(e);
        }
    }
}

