/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.binarydatasource;

import java.nio.ByteBuffer;
import org.virbo.binarydatasource.Byte;
import org.virbo.binarydatasource.Double;
import org.virbo.binarydatasource.Float;
import org.virbo.binarydatasource.Int;
import org.virbo.binarydatasource.Long;
import org.virbo.binarydatasource.Short;
import org.virbo.binarydatasource.TruncatedFloat;
import org.virbo.binarydatasource.UByte;
import org.virbo.binarydatasource.UInt;
import org.virbo.binarydatasource.UShort;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

public abstract class BufferDataSet
extends AbstractDataSet
implements WritableDataSet {
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    int reclen;
    int recoffset;
    int fieldLen;
    Object type;
    protected ByteBuffer back;
    private static final boolean RANGE_CHECK = true;
    public static final Object DOUBLE = "double";
    public static final Object FLOAT = "float";
    public static final Object TRUNCATEDFLOAT = "truncatedfloat";
    public static final Object LONG = "long";
    public static final Object INT = "int";
    public static final Object UINT = "uint";
    public static final Object SHORT = "short";
    public static final Object USHORT = "ushort";
    public static final Object BYTE = "byte";
    public static final Object UBYTE = "ubyte";

    public static int byteCount(Object type) {
        if (type.equals(DOUBLE)) {
            return 8;
        }
        if (type.equals(FLOAT)) {
            return 4;
        }
        if (type.equals(LONG)) {
            return 8;
        }
        if (type.equals(INT)) {
            return 4;
        }
        if (type.equals(UINT)) {
            return 4;
        }
        if (type.equals(TRUNCATEDFLOAT)) {
            return 2;
        }
        if (type.equals(SHORT)) {
            return 2;
        }
        if (type.equals(USHORT)) {
            return 2;
        }
        if (type.equals(BYTE)) {
            return 1;
        }
        if (type.equals(UBYTE)) {
            return 1;
        }
        throw new IllegalArgumentException("bad type: " + type);
    }

    public static BufferDataSet makeDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer buf, Object type) {
        BufferDataSet result;
        if (rank == 1 && len1 > 1) {
            throw new IllegalArgumentException("rank is 1, but len1 is not 1");
        }
        if (reclen < BufferDataSet.byteCount(type)) {
            throw new IllegalArgumentException("reclen " + reclen + " is smaller that length of type " + type);
        }
        if (reclen * len0 > buf.limit()) {
            throw new IllegalArgumentException(String.format("buffer length (%d bytes) is too small to contain data (%d %d-byte records)", buf.limit(), len0, reclen));
        }
        if (type.equals(DOUBLE)) {
            result = new Double(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(FLOAT)) {
            result = new Float(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(LONG)) {
            result = new Long(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(INT)) {
            result = new Int(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(UINT)) {
            result = new UInt(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(SHORT)) {
            result = new Short(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(USHORT)) {
            result = new UShort(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(TRUNCATEDFLOAT)) {
            result = new TruncatedFloat(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(BYTE)) {
            result = new Byte(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else if (type.equals(UBYTE)) {
            result = new UByte(rank, reclen, recoffs, len0, len1, len2, len3, buf);
        } else {
            throw new IllegalArgumentException("bad data type: " + type);
        }
        return result;
    }

    public BufferDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, Object type, ByteBuffer back) {
        this(rank, reclen, recoffs, len0, len1, len2, 11, type, back);
    }

    public BufferDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, Object type, ByteBuffer back) {
        if (rank == 1 && len1 > 1) {
            throw new IllegalArgumentException("rank is 1, but len1 is not 1");
        }
        if (reclen < BufferDataSet.byteCount(type)) {
            throw new IllegalArgumentException("reclen " + reclen + " is smaller that length of type " + type);
        }
        this.back = back;
        this.rank = rank;
        this.reclen = reclen;
        this.recoffset = recoffs;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        this.type = type;
        this.fieldLen = BufferDataSet.byteCount(type);
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
        if (reclen > 0 && this.fieldLen > reclen) {
            System.err.println(String.format("field length (%d) is greater than record length (%d) for len0=%d.", this.fieldLen, reclen, len0));
        }
        if (reclen > 0 && back.remaining() < reclen * len0) {
            System.err.println(String.format("back buffer is too short (len=%d) for len0=%d.", back.remaining(), len0));
        }
    }

    public Object getType() {
        return this.type;
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.len0;
    }

    public int length(int i) {
        return this.len1;
    }

    public int length(int i0, int i1) {
        return this.len2;
    }

    public int length(int i0, int i1, int i2) {
        return this.len3;
    }

    protected void rangeCheck(int i0, int i1, int i2, int i3) {
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this.toString());
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this.toString());
        }
        if (i2 < 0 || i2 >= this.len2) {
            throw new IndexOutOfBoundsException("i2=" + i2 + " " + this.toString());
        }
        if (i3 < 0 || i3 >= this.len3) {
            throw new IndexOutOfBoundsException("i3=" + i3 + " " + this.toString());
        }
    }

    protected int offset() {
        if (this.rank != 0) {
            throw new IllegalArgumentException("rank error");
        }
        return this.recoffset;
    }

    protected int offset(int i0) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, 0, 0, 0);
        return this.recoffset + this.reclen * i0;
    }

    protected int offset(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, i1, 0, 0);
        return this.recoffset + this.reclen * i0 + i1 * this.fieldLen;
    }

    protected int offset(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, i1, i2, 0);
        return this.recoffset + this.reclen * i0 + i1 * this.fieldLen * this.len2 + i2 * this.fieldLen;
    }

    protected int offset(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank error");
        }
        this.rangeCheck(i0, i1, i2, i3);
        return this.recoffset + this.reclen * i0 + i1 * this.fieldLen * this.len2 + i2 * this.fieldLen;
    }

    public abstract double value();

    public abstract double value(int var1);

    public abstract double value(int var1, int var2);

    public abstract double value(int var1, int var2, int var3);

    public abstract double value(int var1, int var2, int var3, int var4);

    public QDataSet trim(int ist, int ien) {
        return BufferDataSet.makeDataSet(this.rank, this.reclen, this.offset(ist), ien - ist, this.len1, this.len2, this.len3, this.back, this.type);
    }

    public void copyTo(ByteBuffer buf) {
        this.back.position(this.recoffset);
        this.back.mark();
        this.back.limit(this.recoffset + this.reclen * this.len0);
        buf.put(this.back);
        this.back.reset();
    }

    protected synchronized void ensureWritable() {
        if (this.back.isReadOnly()) {
            ByteBuffer wback = ByteBuffer.allocateDirect(this.back.capacity());
            wback.put(this.back);
            this.back = wback;
        }
    }
}

