/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.wav;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.BDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SDataSet;
import org.virbo.datasource.AbstractDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WavDataSource
extends AbstractDataSource {
    public WavDataSource(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        BDataSet result;
        File wavFile = this.getFile(mon);
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(wavFile);
        AudioFormat audioFormat = fileFormat.getFormat();
        int headerLength = 64;
        int frameSize = audioFormat.getFrameSize();
        int frameCount = (int)((wavFile.length() - (long)headerLength) / (long)frameSize);
        int bits = audioFormat.getSampleSizeInBits();
        int frameOffset = 0;
        if (this.params.get("offset") != null) {
            double offsetSeconds = Double.parseDouble((String)this.params.get("offset"));
            frameOffset = (int)Math.floor(offsetSeconds * (double)audioFormat.getSampleRate());
            frameCount -= frameOffset;
        }
        if (this.params.get("length") != null) {
            double lengthSeconds = Double.parseDouble((String)this.params.get("length"));
            int frameCountLimit = (int)Math.floor(lengthSeconds * (double)audioFormat.getSampleRate());
            frameCount = Math.min(frameCount, frameCountLimit);
        }
        FileInputStream fin = new FileInputStream(wavFile);
        MappedByteBuffer byteBuffer = fin.getChannel().map(FileChannel.MapMode.READ_ONLY, headerLength + frameOffset * frameSize, frameCount * frameSize);
        boolean unsigned = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (unsigned) {
            throw new IllegalArgumentException("Unsupported wave file format: " + audioFormat + ", need signed.");
        }
        if (audioFormat.getChannels() > 1) {
            throw new IllegalArgumentException("Unsupported wave file format: " + audioFormat + ", need mono.");
        }
        if (bits != 16 && bits != 8) {
            throw new IllegalArgumentException("Unsupported wave file format: " + audioFormat + ", need 8 or 16 bits.");
        }
        if (bits == 16) {
            byteBuffer.order(audioFormat.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            short[] buf = new short[frameCount];
            shortBuffer.get(buf);
            result = SDataSet.wrap((short[])buf);
        } else {
            byte[] buf = new byte[frameCount];
            byteBuffer.get(buf);
            result = BDataSet.wrap((byte[])buf);
        }
        MutablePropertyDataSet timeTags = DataSetUtil.tagGenDataSet((int)frameCount, (double)0.0, (double)(1.0 / (double)audioFormat.getSampleRate()), (Units)Units.seconds);
        result.putProperty("DEPEND_0", (Object)timeTags);
        return result;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(this.resourceURI.toURL());
        AudioFormat audioFormat = fileFormat.getFormat();
        HashMap<String, Object> properties = new HashMap<String, Object>(audioFormat.properties());
        properties.put("encoding", audioFormat.getEncoding());
        properties.put("endianness", audioFormat.isBigEndian() ? "bigEndian" : "littleEndian");
        properties.put("channels", audioFormat.getChannels());
        properties.put("frame rate", Float.valueOf(audioFormat.getFrameRate()));
        properties.put("bits", audioFormat.getSampleSizeInBits());
        return properties;
    }
}

