/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.wav;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import org.das2.datum.Units;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.binarydatasource.BinaryDataSource;
import org.virbo.binarydatasource.BufferDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WavDataSource2
extends AbstractDataSource {
    public WavDataSource2(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File wavFile = DataSetURI.getFile((URI)this.resourceURI, (ProgressMonitor)mon);
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(wavFile);
        AudioFormat audioFormat = fileFormat.getFormat();
        int headerLength = 64;
        int frameSize = audioFormat.getFrameSize();
        int frameCount = (int)((wavFile.length() - (long)headerLength) / (long)frameSize);
        int bits = audioFormat.getSampleSizeInBits();
        int frameOffset = 0;
        if (this.params.get("offset") != null) {
            double offsetSeconds = Double.parseDouble((String)this.params.get("offset"));
            frameOffset = (int)Math.floor(offsetSeconds * (double)audioFormat.getSampleRate());
            frameCount -= frameOffset;
        }
        if (this.params.get("length") != null) {
            double lengthSeconds = Double.parseDouble((String)this.params.get("length"));
            int frameCountLimit = (int)Math.floor(lengthSeconds * (double)audioFormat.getSampleRate());
            frameCount = Math.min(frameCount, frameCountLimit);
        }
        int channel = this.params.get("channel") != null ? Integer.parseInt((String)this.params.get("channel")) : 0;
        int byteOffset = headerLength + frameOffset * frameSize;
        int byteLength = frameCount * frameSize;
        String byteOrder = audioFormat.isBigEndian() ? "big" : "little";
        String type = null;
        if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            if (bits == 32) {
                type = "int";
            } else if (bits == 16) {
                type = "short";
            } else if (bits == 8) {
                type = "byte";
            }
        } else if (bits == 32) {
            type = "uint";
        } else if (bits == 16) {
            type = "ushort";
        } else if (bits == 8) {
            type = "ubyte";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("byteOffset", "" + byteOffset);
        params.put("byteLength", "" + byteLength);
        params.put("recLength", "" + frameSize);
        params.put("recOffset", "" + channel * bits / 8);
        params.put("type", type);
        params.put("byteOrder", byteOrder);
        URL lurl = new URL("" + wavFile.toURI().toURL() + "?" + URISplit.formatParams(params));
        BinaryDataSource bds = new BinaryDataSource(lurl.toURI());
        BufferDataSet result = (BufferDataSet)bds.getDataSet((ProgressMonitor)new NullProgressMonitor());
        MutablePropertyDataSet timeTags = DataSetUtil.tagGenDataSet((int)frameCount, (double)0.0, (double)(1.0 / (double)audioFormat.getSampleRate()), (Units)Units.seconds);
        result.putProperty("DEPEND_0", (Object)timeTags);
        return result;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(this.resourceURI.toURL());
        AudioFormat audioFormat = fileFormat.getFormat();
        HashMap<String, Object> properties = new HashMap<String, Object>(audioFormat.properties());
        properties.put("encoding", audioFormat.getEncoding());
        properties.put("endianness", audioFormat.isBigEndian() ? "bigEndian" : "littleEndian");
        properties.put("channels", audioFormat.getChannels());
        properties.put("frame rate", Float.valueOf(audioFormat.getFrameRate()));
        properties.put("bits", audioFormat.getSampleSizeInBits());
        return properties;
    }
}

