/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.client.Authenticator;
import org.das2.client.DasServer;
import org.das2.client.DataSetStreamHandler;
import org.das2.client.Key;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamTool;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.qstream.QDataSetStreamHandler;

class Das2ServerDataSource
extends AbstractDataSource {
    static final Logger logger = Logger.getLogger("das2serverDataSource");
    DatumRange timeRange;
    Datum resolution;
    String dsParams;
    List<String> tcaDesc;
    String key;
    Map dsdfParams = null;

    public Das2ServerDataSource(URI uri) {
        super(uri);
        if (!"no".equals(this.params.get("tsb"))) {
            this.addCability(TimeSeriesBrowse.class, this.getTimeSeriesBrowse());
        }
        HashMap<String, String> params2 = new HashMap<String, String>(this.params);
        params2.put("server", "dataset");
        this.timeRange = DatumRangeUtil.parseTimeRangeValid((String)(params2.get("start_time") + " to " + params2.get("end_time")));
        this.resolution = null;
    }

    public synchronized QDataSet getDataSet(final ProgressMonitor mon) throws Exception {
        AbstractDataSet result;
        QDataSet result1;
        DataSetStreamHandler handler;
        ReadableByteChannel channel;
        String dataset;
        mon.started();
        mon.setProgressMessage("sending request");
        LinkedHashMap<String, String> params2 = new LinkedHashMap<String, String>();
        LinkedHashMap otherParams = new LinkedHashMap(this.params);
        otherParams.remove("start_time");
        otherParams.remove("end_time");
        otherParams.remove("resolution");
        otherParams.remove("dataset");
        otherParams.remove("tsb");
        String item = (String)otherParams.remove("item");
        String interval = (String)otherParams.remove("interval");
        String key1 = (String)otherParams.remove("key");
        this.dsParams = URISplit.formatParams(otherParams);
        params2.put("server", "dataset");
        if (this.timeRange == null) {
            throw new IllegalArgumentException("timeRange is null");
        }
        params2.put("start_time", URLEncoder.encode(this.timeRange.min().toString(), "US-ASCII"));
        params2.put("end_time", URLEncoder.encode(this.timeRange.max().toString(), "US-ASCII"));
        if (this.resolution != null) {
            params2.put("resolution", "" + this.resolution.doubleValue(Units.seconds));
        }
        if ((dataset = (String)this.params.get("dataset")) == null) {
            dataset = (String)this.params.get("arg_0");
        }
        if (interval != null) {
            params2.put("interval", URLEncoder.encode(interval, "US-ASCII"));
            params2.remove("resolution");
        }
        params2.put("dataset", URLEncoder.encode(dataset, "US-ASCII"));
        if (this.dsParams.length() > 0) {
            params2.put("params", this.dsParams);
        }
        URL url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
        if (this.dsdfParams == null) {
            String dsdfURL = this.resourceURI + "?server=dsdf&dataset=" + dataset;
            URL url3 = new URL(dsdfURL);
            logger.log(Level.FINE, "opening {0}", url3);
            InputStream in = url3.openStream();
            channel = Channels.newChannel(in);
            final LinkedHashMap map = new LinkedHashMap();
            handler = new DataSetStreamHandler(new HashMap(), mon){

                public void streamDescriptor(StreamDescriptor sd) throws StreamException {
                    super.streamDescriptor(sd);
                    map.putAll(sd.getProperties());
                }
            };
            StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)handler);
            channel.close();
            this.dsdfParams = map;
        }
        this.tcaDesc = new ArrayList<String>();
        int iplane = 0;
        String label = (String)this.dsdfParams.get("label");
        while (label != null) {
            this.tcaDesc.add(label);
            label = (String)this.dsdfParams.get("plane_" + ++iplane + ".label");
        }
        String groupAccess = (String)this.dsdfParams.get("groupAccess");
        if (groupAccess != null && groupAccess.trim().length() > 0) {
            if (key1 == null) {
                Authenticator authenticator = new Authenticator(DasServer.create((URL)this.resourceURI.toURL()), groupAccess);
                Key key2 = authenticator.authenticate();
                if (key2 != null) {
                    params2.put("key", key2.toString());
                    url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
                }
            } else {
                params2.put("key", key1);
                url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
            }
        }
        logger.fine(String.valueOf(url2));
        boolean qds = "1".equals(this.dsdfParams.get("qstream"));
        logger.log(Level.FINE, "opening {0} {1}", new Object[]{qds ? "as qstream" : "as das2stream", url2});
        InputStream in = url2.openStream();
        final DasProgressMonitorInputStream mpin = new DasProgressMonitorInputStream(in, mon);
        channel = Channels.newChannel((InputStream)mpin);
        if (qds) {
            try {
                QDataSetStreamHandler eh = new QDataSetStreamHandler();
                org.virbo.qstream.StreamTool.readStream((ReadableByteChannel)channel, (org.virbo.qstream.StreamHandler)eh);
                result1 = eh.getDataSet();
            }
            catch (org.virbo.qstream.StreamException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof InterruptedIOException) {
                    ex.printStackTrace();
                    throw (InterruptedIOException)ex.getCause();
                }
                ex.printStackTrace();
                throw ex;
            }
        }
        handler = new DataSetStreamHandler(new HashMap(), mon){

            public void streamDescriptor(StreamDescriptor sd) throws StreamException {
                super.streamDescriptor(sd);
                if (mon.getTaskSize() != -1L) {
                    mpin.setEnableProgressPosition(false);
                }
            }
        };
        try {
            StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)handler);
        }
        catch (StreamException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof InterruptedIOException) {
                ex.printStackTrace();
                throw (InterruptedIOException)ex.getCause();
            }
            ex.printStackTrace();
            throw ex;
        }
        mon.finished();
        DataSet ds = handler.getDataSet();
        if (ds == null) {
            throw new RuntimeException("failed to get dataset, without explanation!  (Possibly no records)");
        }
        if (ds.getXLength() == 0) {
            throw new RuntimeException("empty dataset returned");
        }
        if (item == null || item.equals("") || item.equals("0")) {
            result = DataSetAdapter.create((DataSet)ds);
        } else {
            DataSet das2ds = ds.getPlanarView(item);
            if (das2ds == null) {
                int iitem = Integer.parseInt(item);
                das2ds = ds.getPlanarView("plane_" + iitem);
            }
            if (das2ds == null) {
                throw new IllegalArgumentException("no such plane, looking for " + item);
            }
            result = DataSetAdapter.create((DataSet)das2ds);
        }
        if (this.tcaDesc != null && this.tcaDesc.size() > 0) {
            if (item == null) {
                result.putProperty("LABEL", (Object)this.tcaDesc.get(0));
            } else {
                result.putProperty("LABEL", (Object)this.tcaDesc.get(Integer.parseInt(item)));
            }
        }
        result1 = result;
        if (this.timeRange == null) {
            this.timeRange = DatumRangeUtil.parseTimeRange((String)((String)params2.get("start_time") + " to " + (String)params2.get("end_time")));
        }
        logger.fine("  done. ");
        try {
            Object o;
            String prop = "DEPEND_0";
            QDataSet dep = (QDataSet)result1.property(prop);
            if (dep == null && (o = result1.property(prop = "JOIN_0")) instanceof QDataSet) {
                dep = (QDataSet)o;
            }
            if (dep != null && dep.property("CACHE_TAG") == null) {
                QDataSet bounds = SemanticOps.bounds((QDataSet)result1);
                CacheTag ct = new CacheTag(DataSetUtil.asDatumRange((QDataSet)bounds.slice(0), (boolean)true), this.resolution);
                MutablePropertyDataSet dep2 = DataSetOps.makePropertiesMutable((QDataSet)dep);
                dep2.putProperty("CACHE_TAG", (Object)ct);
                MutablePropertyDataSet result2 = DataSetOps.makePropertiesMutable((QDataSet)result1);
                result2.putProperty(prop, (Object)dep2);
                return result2;
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return result1;
    }

    public TimeSeriesBrowse getTimeSeriesBrowse() {
        return new TimeSeriesBrowse(){

            public void setTimeRange(DatumRange dr) {
                Das2ServerDataSource.this.timeRange = dr;
            }

            public void setTimeResolution(Datum d) {
                Das2ServerDataSource.this.resolution = d;
            }

            public String getURI() {
                String stime = Das2ServerDataSource.this.timeRange.min().toString().replace(" ", "+");
                String etime = Das2ServerDataSource.this.timeRange.max().toString().replace(" ", "+");
                String sparams = "dataset=" + (String)Das2ServerDataSource.this.params.get("dataset") + "&start_time=" + stime + "&end_time=" + etime;
                if (Das2ServerDataSource.this.resolution != null) {
                    sparams = sparams + "&resolution=" + Das2ServerDataSource.this.resolution.doubleValue(Units.seconds);
                } else {
                    logger.fine("no resolution specified");
                }
                if (Das2ServerDataSource.this.dsParams != null) {
                    sparams = sparams + "&" + Das2ServerDataSource.this.dsParams;
                }
                return "vap+das2Server:" + Das2ServerDataSource.this.resourceURI + "?" + sparams;
            }

            public DatumRange getTimeRange() {
                return Das2ServerDataSource.this.timeRange;
            }

            public Datum getTimeResolution() {
                return Das2ServerDataSource.this.resolution;
            }

            public void setURI(String suri) throws ParseException {
                URISplit split = URISplit.parse((URI)Das2ServerDataSource.this.uri);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String startTime = (String)params.remove("start_time");
                String endTime = (String)params.get("end_time");
                String sresolution = (String)params.get("resolution");
                if (startTime != null && endTime != null) {
                    Das2ServerDataSource.this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
                }
                if (sresolution != null) {
                    Das2ServerDataSource.this.resolution = Units.seconds.parse(sresolution);
                }
            }
        };
    }

    public String getURI() {
        return super.getURI();
    }

    public String toString() {
        return this.resourceURI + "?" + (String)this.params.get("dataset");
    }
}

