/*
 * Decompiled with CFR 0.152.
 */
package ftpfs;

import ftpfs.FTPBeanFileSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.filesystem.WriteCapability;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpFileObject
extends WebFileObject {
    FTPBeanFileSystem ftpfs;
    WriteCapability write = new WriteCapability(){

        public OutputStream getOutputStream() throws IOException {
            return FtpFileObject.this.getOutputStream(false);
        }

        public boolean canWrite() {
            return true;
        }

        public synchronized boolean delete() throws IOException {
            File localFile;
            File listingFile = new File(FtpFileObject.this.getLocalFile().getParent(), ".listing");
            if (listingFile.exists()) {
                FtpFileObject.this.ftpfs.resetListCache(FtpFileObject.this.getParent().getNameExt());
            }
            if ((localFile = FtpFileObject.this.getLocalFile()).exists() && !localFile.delete()) {
                throw new IOException("unable to delete local file " + localFile);
            }
            return FtpFileObject.this.ftpfs.delete(FtpFileObject.this);
        }
    };

    protected FtpFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        super(wfs, pathname, modifiedDate);
        this.ftpfs = (FTPBeanFileSystem)wfs;
    }

    public long getSize() {
        boolean tinyGzFib = true;
        File listing = new File(this.getLocalFile().getParent(), ".listing");
        if (listing.exists()) {
            try {
                FileSystem.DirectoryEntry[] list = this.ftpfs.parseLsl(null, listing);
                int ii = this.getNameExt().lastIndexOf("/");
                String lookFor = this.getNameExt().substring(ii + 1);
                String lookForGz = this.getNameExt().substring(ii + 1) + ".gz";
                for (int i = 0; i < list.length; ++i) {
                    if (list[i].name.equals(lookFor)) {
                        return list[i].size;
                    }
                    if (!tinyGzFib || !list[i].name.equals(lookForGz)) continue;
                    System.err.println("approximating size of gzipped file " + list[i].name + "when it is uncompressed");
                    return 2000L * Math.round((double)list[i].size / 2000.0) * 5L;
                }
                return -1L;
            }
            catch (IOException ex) {
                Logger.getLogger(FtpFileObject.class.getName()).log(Level.SEVERE, null, ex);
                return -1L;
            }
        }
        return -1L;
    }

    public boolean exists() {
        if (this.getLocalFile() != null && this.getLocalFile().exists()) {
            return true;
        }
        File listing = new File(this.getLocalFile().getParent(), ".listing");
        if (!listing.exists()) {
            try {
                this.ftpfs.listDirectory(this.getParent().getNameExt());
            }
            catch (IOException ex) {
                Logger.getLogger(FtpFileObject.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        if (listing.exists()) {
            try {
                FileSystem.DirectoryEntry[] list = this.ftpfs.parseLsl(null, listing);
                int ii = this.getNameExt().lastIndexOf("/");
                String lookFor = this.getNameExt().substring(ii + 1);
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].name.equals(lookFor)) continue;
                    return true;
                }
                return false;
            }
            catch (IOException ex) {
                Logger.getLogger(FtpFileObject.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        FileSystem.getExceptionHandler().handleUncaught((Throwable)new IOException("local listing file (.listing) not found"));
        return false;
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == WriteCapability.class) {
            return (T)this.write;
        }
        return (T)super.getCapability(clazz);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        try {
            this.getFile((ProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!append && this.exists()) {
            throw new IllegalArgumentException("file exists in file system already!");
        }
        return new FileOutputStream(this.getLocalFile(), append){

            public void close() {
                try {
                    super.close();
                    System.err.println("closing");
                    FtpFileObject.this.ftpfs.uploadFile(FtpFileObject.this.getNameExt(), FtpFileObject.this.getLocalFile(), (ProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
    }
}

