/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.aggregator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.dataset.CacheTag;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;
import org.virbo.aggregator.AggregationPollUpdating;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingDataSource
extends AbstractDataSource {
    private FileStorageModelNew fsm;
    DataSourceFactory delegateDataSourceFactory;
    AggregationPollUpdating upd;
    Map<String, Object> metadata;
    MetadataModel metadataModel;
    private DatumRange viewRange = DatumRangeUtil.parseTimeRangeValid((String)"2006-07-03 to 2006-07-05");
    private Datum resolution = null;
    private DatumRange cacheRange = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String sparams = "";

    private DatumRange quantize(DatumRange timeRange) {
        try {
            String[] ss = this.fsm.getNamesFor(timeRange);
            if (ss.length == 0) {
                return new DatumRange(TimeUtil.prevMidnight((Datum)timeRange.min()), TimeUtil.nextMidnight((Datum)timeRange.max()));
            }
            DatumRange result = this.fsm.getRangeFor(ss[0]);
            for (int i = 0; i < ss.length; ++i) {
                DatumRange r1 = this.fsm.getRangeFor(ss[i]);
                result = result.include(r1.max()).include(r1.min());
            }
            if (timeRange.contains(result)) {
                return timeRange;
            }
            return result;
        }
        catch (IOException ex) {
            Logger.getLogger(AggregatingDataSource.class.getName()).log(Level.SEVERE, null, ex);
            timeRange = new DatumRange(TimeUtil.prevMidnight((Datum)timeRange.min()), TimeUtil.nextMidnight((Datum)timeRange.max()));
            return timeRange;
        }
    }

    public AggregatingDataSource(URI uri, DataSourceFactory delegateFactory) throws MalformedURLException, FileSystem.FileSystemOfflineException, IOException, ParseException {
        super(uri);
        this.delegateDataSourceFactory = delegateFactory;
        this.addCability(TimeSeriesBrowse.class, this.createTimeSeriesBrowse());
        String stimeRange = this.params.get("timerange");
        if (this.params.get("timeRange") != null && stimeRange == null) {
            stimeRange = this.params.get("timeRange");
        }
        if (stimeRange == null) {
            throw new IllegalArgumentException("timeRange not found");
        }
        stimeRange = stimeRange.replaceAll("\\+", " ");
        this.viewRange = DatumRangeUtil.parseTimeRange((String)stimeRange);
    }

    private TimeSeriesBrowse createTimeSeriesBrowse() {
        return new AggTimeSeriesBrowse();
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        Units dep0units;
        String[] ss = this.getFsm().getBestNamesFor(this.viewRange, (ProgressMonitor)new NullProgressMonitor());
        Logger.getLogger("virbo.datasource.agg").fine("aggregating " + ss.length + " files for " + this.viewRange);
        ArrayDataSet result = null;
        JoinDataSet altResult = null;
        if (ss.length == 0 && null == this.getFsm().getRepresentativeFile((ProgressMonitor)new NullProgressMonitor())) {
            throw new FileNotFoundException("No such file: No files found matching " + this.getFsm().toString());
        }
        if (ss.length > 1) {
            mon.setTaskSize((long)(ss.length * 10));
            mon.started();
        }
        DatumRange cacheRange1 = null;
        for (int i = 0; i < ss.length; ++i) {
            block30: {
                ProgressMonitor mon1;
                URI delegateUri;
                DataSource delegateDataSource;
                String scompUrl = this.getFsm().getFileSystem().getRootURI().toString() + ss[i];
                if (!this.sparams.equals("")) {
                    scompUrl = scompUrl + "?" + this.sparams;
                }
                if ((delegateDataSource = this.delegateDataSourceFactory.getDataSource(delegateUri = DataSetURI.getURIValid(scompUrl))).getCapability(TimeSeriesBrowse.class) != null) {
                    TimeSeriesBrowse delegateTsb = delegateDataSource.getCapability(TimeSeriesBrowse.class);
                    delegateTsb.setTimeRange(this.viewRange);
                    delegateTsb.setTimeResolution(this.resolution);
                    this.setResolution(delegateTsb.getTimeResolution());
                } else {
                    this.resolution = null;
                }
                this.metadataModel = delegateDataSource.getMetadataModel();
                if (ss.length > 1) {
                    mon.setProgressMessage("getting " + ss[i]);
                    mon1 = SubTaskMonitor.create((ProgressMonitor)mon, (long)(i * 10), (long)(10 * (i + 1)));
                    if (mon1.isCancelled()) break;
                    mon1.setTaskProgress(0L);
                } else if (ss.length == 1) {
                    mon1 = mon;
                    mon1.setLabel("loading " + ss[0]);
                    mon1.started();
                    mon1.setTaskProgress(0L);
                } else {
                    mon1 = mon;
                }
                try {
                    QDataSet ds1 = delegateDataSource.getDataSet(mon1);
                    DatumRange dr1 = this.getFsm().getRangeFor(ss[i]);
                    if (result == null && altResult == null) {
                        if (ds1 instanceof JoinDataSet) {
                            altResult = JoinDataSet.copy((JoinDataSet)((JoinDataSet)ds1));
                            DDataSet mpds = DDataSet.create((int[])new int[0]);
                            altResult.putProperty("JOIN_0", (Object)mpds);
                        } else if (ss.length == 1) {
                            result = ArrayDataSet.maybeCopy((QDataSet)ds1);
                        } else {
                            result = ArrayDataSet.maybeCopy((QDataSet)ds1);
                            result.grow(result.length() * ss.length * 11 / 10);
                        }
                        this.metadata = delegateDataSource.getMetadata((ProgressMonitor)new NullProgressMonitor());
                        cacheRange1 = dr1;
                        break block30;
                    }
                    if (ds1 instanceof JoinDataSet) {
                        altResult.joinAll((JoinDataSet)ds1);
                    } else {
                        ArrayDataSet ads1 = ArrayDataSet.maybeCopy((Class)result.getComponentType(), (QDataSet)ds1);
                        try {
                            if (result.canAppend(ads1)) {
                                result.append(ads1);
                            } else {
                                result.grow(result.length() + ads1.length() * (ss.length - i));
                                result.append(ads1);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            throw new IllegalArgumentException("can't append data from " + delegateUri, ex);
                        }
                    }
                    cacheRange1 = new DatumRange(cacheRange1.min(), dr1.max());
                }
                catch (Exception ex) {
                    if (ex instanceof NoDataInIntervalException && ss.length > 1) {
                        System.err.println("no data found in " + delegateUri);
                    }
                    if (ss.length == 1) {
                        throw ex;
                    }
                    throw ex;
                }
            }
            if (ss.length > 1 && mon.isCancelled()) break;
        }
        this.cacheRange = cacheRange1;
        mon.finished();
        if (altResult != null) {
            ArrayDataSet dep0 = (ArrayDataSet)altResult.property("DEPEND_0");
            Units units = dep0units = dep0 == null ? null : SemanticOps.getUnits((QDataSet)dep0);
            if (dep0 == null) {
                dep0 = (ArrayDataSet)altResult.property("JOIN_0");
                QDataSet d = (QDataSet)altResult.property("DEPEND_0", 0);
                if (d != null) {
                    dep0units = SemanticOps.getUnits((QDataSet)d);
                }
                dep0.putProperty("UNITS", (Object)dep0units);
            }
            if (dep0 != null && cacheRange1.getUnits().isConvertableTo(dep0units)) {
                dep0.putProperty("CACHE_TAG", (Object)new CacheTag(cacheRange1, null));
                dep0.putProperty("TYPICAL_MIN", (Object)this.viewRange.min().doubleValue(dep0units));
                dep0.putProperty("TYPICAL_MAX", (Object)this.viewRange.max().doubleValue(dep0units));
            }
            return altResult;
        }
        MutablePropertyDataSet dep0 = result == null ? null : (MutablePropertyDataSet)result.property("DEPEND_0");
        Units units = dep0units = dep0 == null ? null : SemanticOps.getUnits((QDataSet)dep0);
        if (dep0 != null && cacheRange1.getUnits().isConvertableTo(dep0units)) {
            dep0.putProperty("CACHE_TAG", (Object)new CacheTag(cacheRange1, null));
            dep0.putProperty("TYPICAL_MIN", (Object)this.viewRange.min().doubleValue(dep0units));
            dep0.putProperty("TYPICAL_MAX", (Object)this.viewRange.max().doubleValue(dep0units));
        }
        return result;
    }

    @Override
    public MetadataModel getMetadataModel() {
        return this.metadataModel;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if (this.metadata == null) {
            Map<String, Object> retValue = super.getMetadata(mon);
            return retValue;
        }
        return this.metadata;
    }

    public Datum getResolution() {
        return this.resolution;
    }

    public void setResolution(Datum resolution) {
        Datum old = this.resolution;
        this.resolution = resolution;
        this.propertyChangeSupport.firePropertyChange("resolution", old, resolution);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public DatumRange getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(DatumRange viewRange) {
        DatumRange oldViewRange = this.viewRange;
        this.viewRange = viewRange;
        this.propertyChangeSupport.firePropertyChange("viewRange", oldViewRange, viewRange);
    }

    public FileStorageModelNew getFsm() {
        return this.fsm;
    }

    public void setFsm(FileStorageModelNew fsm) {
        this.fsm = fsm;
    }

    public void setParams(String params) {
        String oldParams = this.sparams;
        this.sparams = params;
        this.propertyChangeSupport.firePropertyChange("args", oldParams, params);
    }

    @Override
    public String getURI() {
        return super.getURI();
    }

    public class AggTimeSeriesBrowse
    implements TimeSeriesBrowse {
        public void setTimeRange(DatumRange dr) {
            AggregatingDataSource.this.viewRange = AggregatingDataSource.this.quantize(dr);
            Logger.getLogger("virbo.datasource.agg").fine("set timerange=" + AggregatingDataSource.this.viewRange);
        }

        public void setTimeResolution(Datum d) {
            AggregatingDataSource.this.resolution = d;
            Logger.getLogger("virbo.datasource.agg").fine("set resolution=" + d);
        }

        public String getURI() {
            String surl = DataSetURI.fromUri(AggregatingDataSource.this.resourceURI) + "?";
            if (AggregatingDataSource.this.sparams != null && !AggregatingDataSource.this.sparams.equals("")) {
                surl = surl + AggregatingDataSource.this.sparams + "&";
            }
            surl = surl + "timerange=" + String.valueOf(AggregatingDataSource.this.viewRange);
            URISplit split = URISplit.parse(surl);
            LinkedHashMap<String, String> mparams = URISplit.parseParams(split.params);
            String stimeRange = AggregatingDataSource.this.viewRange.toString();
            mparams.put("timerange", stimeRange);
            split.params = URISplit.formatParams(mparams);
            return URISplit.format(split);
        }

        public DatumRange getTimeRange() {
            return AggregatingDataSource.this.viewRange;
        }

        public Datum getTimeResolution() {
            return AggregatingDataSource.this.resolution;
        }

        public String toString() {
            return "aggtsb: " + AggregatingDataSource.this.viewRange + "@" + (AggregatingDataSource.this.resolution == null ? "intrinsic" : AggregatingDataSource.this.resolution);
        }

        public void setURI(String suri) throws ParseException {
            AggregatingDataSource.this.viewRange = URISplit.parseTimeRange(suri);
        }
    }
}

