/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.prefs.Preferences;
import org.das2.util.filesystem.FileSystem;

public final class AutoplotSettings {
    private static AutoplotSettings instance;
    PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof String) {
                prefs.put(evt.getPropertyName(), (String)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Boolean) {
                prefs.putBoolean(evt.getPropertyName(), (Boolean)evt.getNewValue());
            } else {
                throw new RuntimeException("unsupported property type needs to be implemented: " + evt.getPropertyName() + "  " + evt.getNewValue().getClass());
            }
        }
    };
    static Preferences prefs;
    protected String autoplotData = "";
    public static final String PROP_AUTOPLOTDATA = "autoplotData";
    private String fscache = "";
    public static final String PROP_FSCACHE = "fscache";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static synchronized AutoplotSettings settings() {
        if (instance == null) {
            instance = new AutoplotSettings();
        }
        return instance;
    }

    private AutoplotSettings() {
        try {
            prefs = Preferences.userNodeForPackage(AutoplotSettings.class);
            this.addPropertyChangeListener(this.listener);
            this.loadPreferences();
        }
        catch (Exception ex) {
            System.err.println("Problem encountered when attempting to load user preferences, continuing with autoplot_data in $HOME");
            this.autoplotData = "${HOME}/autoplot_data";
            this.fscache = "${HOME}/autoplot_data/fscache";
        }
    }

    public void loadPreferences() {
        this.autoplotData = prefs.get(PROP_AUTOPLOTDATA, "${HOME}/autoplot_data");
        this.fscache = prefs.get(PROP_FSCACHE, "${HOME}/autoplot_data/fscache");
    }

    public String getAutoplotData() {
        return this.autoplotData;
    }

    public String getFscache() {
        return this.fscache;
    }

    public void setFscache(String val) {
        String old = this.fscache;
        if (old.equals(val)) {
            return;
        }
        String tval = val;
        tval = tval.replaceAll("\\$\\{HOME\\}", System.getProperty("user.home"));
        FileSystem.settings().setLocalCacheDir(new File(tval));
        this.fscache = val;
        String home = System.getProperty("user.home");
        if (val.startsWith(home)) {
            val = "${HOME}" + val.substring(home.length());
        }
        this.propertyChangeSupport.firePropertyChange(PROP_FSCACHE, old, val);
    }

    public String resolveProperty(String name) {
        if (name.equals(PROP_AUTOPLOTDATA)) {
            return this.getAutoplotData().replace("${HOME}", System.getProperty("user.home"));
        }
        if (name.equals(PROP_FSCACHE)) {
            String result = this.getFscache();
            result = result.replace("${autoplotData}", this.getAutoplotData());
            result = result.replace("${HOME}", System.getProperty("user.home"));
            return result;
        }
        throw new IllegalArgumentException("unable to resolve property: " + name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

