/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.filechooser.FileFilter;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceRegistry;

public class DataSetSelectorSupport {
    DataSetSelector ui;
    public static final String PREF_LAST_OPEN_FOLDER = "last_open_folder";
    public static final String PREF_RECENTLY_OPENED_FILES = "recently_opened_files";
    private JMenu recentMenu = null;

    DataSetSelectorSupport(DataSetSelector ui) {
        this.ui = ui;
    }

    private static File userHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String browseLocal(Component parent) {
        Preferences prefs = Preferences.userNodeForPackage(DataSetSelectorSupport.class);
        String currentDirectory = prefs.get(PREF_LAST_OPEN_FOLDER, DataSetSelectorSupport.userHome().toString());
        final HashMap<String, Object> exts = DataSourceRegistry.getInstance().dataSourcesByExt;
        JFileChooser chooser = new JFileChooser(currentDirectory);
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String t = f.toString();
                if (t == null) {
                    System.err.println("here is that bad state on windows.  bug http://sourceforge.net/tracker/?func=detail&aid=3038977&group_id=199733&atid=970682");
                    t = "" + f;
                    return false;
                }
                try {
                    String ext = DataSetURI.getExt(t);
                    if (ext != null) {
                        ext = "." + ext;
                    }
                    return t.endsWith(".vap") || t.endsWith(".zip") || t.endsWith(".ZIP") || ext != null && exts.containsKey(ext);
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }

            public String getDescription() {
                return "supported formats and .vap files";
            }
        };
        chooser.addChoosableFileFilter(ff);
        FileFilter select = ff;
        Iterator<String> i$ = exts.keySet().iterator();
        while (i$.hasNext()) {
            String ext1;
            final String extf = ext1 = i$.next();
            ff = new FileFilter(){

                public boolean accept(File f) {
                    if (f.toString() == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String t = f.toString();
                    String ext = DataSetURI.getExt(t);
                    if (ext != null) {
                        ext = "." + ext;
                    }
                    return ext != null && extf.equals(ext);
                }

                public String getDescription() {
                    return "*" + extf;
                }
            };
            chooser.addChoosableFileFilter(ff);
        }
        chooser.setFileFilter(select);
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            try {
                prefs.put(PREF_LAST_OPEN_FOLDER, chooser.getSelectedFile().getParent().toString());
                return chooser.getSelectedFile().toURI().toURL().toString();
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(DataSetSelectorSupport.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public Action openLocalAction() {
        return new AbstractAction("Open File..."){

            public void actionPerformed(ActionEvent e) {
                String result = DataSetSelectorSupport.browseLocal(DataSetSelectorSupport.this.ui);
                if (result != null) {
                    DataSetSelectorSupport.this.ui.setValue(result);
                    DataSetSelectorSupport.this.ui.maybePlot(false);
                }
            }
        };
    }

    protected void refreshRecentFilesMenu() {
        if (this.recentMenu != null) {
            this.recentMenu.removeAll();
            if (this.ui.getRecent() == null) {
                return;
            }
            ArrayList<String> recent = new ArrayList<String>(this.ui.getRecent());
            Collections.reverse(recent);
            Iterator<String> i$ = recent.iterator();
            while (i$.hasNext()) {
                String s;
                final String f = s = i$.next();
                AbstractAction a = new AbstractAction(String.valueOf(f)){

                    public void actionPerformed(ActionEvent e) {
                        DataSetSelectorSupport.this.ui.setValue(f);
                        DataSetSelectorSupport.this.ui.maybePlot(false);
                    }
                };
                this.recentMenu.add(a);
            }
        }
    }

    public static String getPluginsText() {
        return DataSourceRegistry.getPluginsText();
    }

    JMenu recentMenu() {
        if (this.recentMenu == null) {
            this.recentMenu = new JMenu("Open Recent");
            this.refreshRecentFilesMenu();
        }
        return this.recentMenu;
    }

    protected void browseSourceTypes() {
    }
}

