/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import ftpfs.FTPBeanFileSystemFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemFactory;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.filesystem.URIException;
import org.das2.util.filesystem.VFSFileSystemFactory;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.aggregator.AggregatingDataSourceFactory;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.URISplit;
import org.virbo.dsops.Ops;
import zipfs.ZipFileSystemFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetURI {
    private static final Logger logger = Logger.getLogger("virbo.datasource");
    static WeakHashMap<DataSource, DataSourceFactory> dsToFactory;

    public static String getExt(String surl) {
        if (surl == null) {
            throw new NullPointerException();
        }
        String explicitExt = DataSetURI.getExplicitExt(surl);
        if (explicitExt != null) {
            return explicitExt;
        }
        URISplit split = URISplit.parse(surl);
        if (split.file != null) {
            int i0 = split.file.lastIndexOf(47);
            if (i0 == -1) {
                return null;
            }
            int i1 = split.file.lastIndexOf(46);
            if (i1 != -1 && i1 > i0) {
                return split.file.substring(i1 + 1);
            }
            return null;
        }
        return null;
    }

    public static String getExplicitExt(String surl) {
        URISplit split = URISplit.parse(surl);
        if (split.vapScheme == null) {
            return null;
        }
        int i = split.vapScheme.indexOf("+");
        if (i != -1) {
            return split.vapScheme.substring(i + 1);
        }
        return null;
    }

    public static URISplit parse(String surl) {
        return URISplit.parse(surl);
    }

    public static String format(URISplit split) {
        return URISplit.format(split);
    }

    public static DataSource getDataSource(URI uri) throws Exception {
        DataSourceFactory factory = DataSetURI.getDataSourceFactory(uri, (ProgressMonitor)new NullProgressMonitor());
        if (factory == null) {
            throw new IllegalArgumentException("unable to resolve URI: " + uri);
        }
        DataSource result = factory.getDataSource(uri);
        dsToFactory.put(result, factory);
        return result;
    }

    public static DataSource getDataSource(String surl) throws Exception {
        return DataSetURI.getDataSource(DataSetURI.getURIValid(surl));
    }

    public static String getDataSourceUri(DataSource ds) {
        DataSourceFactory factory = dsToFactory.get(ds);
        if (factory instanceof AggregatingDataSourceFactory) {
            return ds.getURI();
        }
        if (factory == null) {
            return ds.getURI();
        }
        URISplit split = URISplit.parse(ds.getURI());
        String fext = DataSourceRegistry.getInstance().getExtensionFor(factory).substring(1);
        if (DataSourceRegistry.getInstance().hasSourceByExt(split.ext)) {
            DataSourceFactory f2 = DataSourceRegistry.getInstance().getSource(split.ext);
            if (!factory.getClass().isInstance(f2)) {
                split.vapScheme = "vap+" + fext;
            }
        } else {
            split.vapScheme = "vap+" + fext;
        }
        return URISplit.format(split);
    }

    public static boolean isAggregating(String surl) {
        int ipercy;
        int iquest = surl.indexOf("?");
        if (iquest > 0) {
            surl = surl.substring(0, iquest);
        }
        if ((ipercy = (surl = surl.replaceAll("%25", "%")).lastIndexOf("%Y")) == -1) {
            ipercy = surl.lastIndexOf("$Y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("%y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$y");
        }
        return ipercy != -1;
    }

    public static URI getResourceURI(URI uri) {
        URISplit split = URISplit.parse(uri);
        return split.resourceUri;
    }

    public static URI getResourceURI(String surl) {
        if (surl.matches("file\\:[A-Z]\\:\\\\.*")) {
            surl = "file://" + surl.substring(5).replace('\\', '/');
        }
        if (surl.matches("file\\:/[A-Z]\\:\\\\.*")) {
            surl = "file://" + surl.substring(5).replace('\\', '/');
        }
        URISplit split = URISplit.parse(surl);
        return split.resourceUri;
    }

    public static URL getWebURL(URI url) {
        try {
            URL rurl = DataSetURI.getResourceURI(url).toURL();
            String surl = rurl.toString();
            return new URL(surl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static String newUri(String context, String newUri) {
        URISplit scontext = URISplit.parse(context, 0, false);
        URISplit newURLSplit = URISplit.parse(newUri);
        if (newURLSplit.file != null && !newURLSplit.file.equals("")) {
            scontext.file = newURLSplit.file;
        }
        if (newURLSplit.params != null && !newURLSplit.params.equals("")) {
            scontext.params = newURLSplit.params;
        }
        return URISplit.format(scontext);
    }

    public static DataSourceFormat getDataSourceFormat(URI uri) {
        URL url;
        String file;
        int i2;
        int i = uri.getScheme().indexOf(".");
        String ext = i != -1 ? uri.getScheme().substring(0, i) : ((i2 = uri.getScheme().indexOf("+")) != -1 ? uri.getScheme().substring(i2 + 1) : ((i = (file = (url = DataSetURI.getWebURL(uri)).getPath()).lastIndexOf(".")) == -1 ? "" : file.substring(i)));
        return DataSourceRegistry.getInstance().getFormatByExt(ext);
    }

    public static DataSourceFactory getDataSourceFactory(URI uri, ProgressMonitor mon) throws IOException, IllegalArgumentException {
        URI resourceUri;
        String suri = DataSetURI.fromUri(uri);
        if (DataSetURI.isAggregating(suri)) {
            String eext = DataSetURI.getExplicitExt(suri);
            if (eext != null) {
                DataSourceFactory delegateFactory = DataSourceRegistry.getInstance().getSource(eext);
                AggregatingDataSourceFactory factory = new AggregatingDataSourceFactory();
                factory.setDelegateDataSourceFactory(delegateFactory);
                return factory;
            }
            return new AggregatingDataSourceFactory();
        }
        String ext = DataSetURI.getExplicitExt(suri);
        if (ext != null && !suri.startsWith("vap+X:")) {
            return DataSourceRegistry.getInstance().getSource(ext);
        }
        try {
            String resourceSuri = uri.getRawSchemeSpecificPart();
            resourceUri = new URI(resourceSuri);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        ext = DataSetURI.getExt(uri.toASCIIString());
        if (ext == null) {
            ext = "";
        }
        DataSourceFactory factory = null;
        factory = DataSourceRegistry.getInstance().getSource(ext);
        if (factory == null && (resourceUri.getScheme().equals("http") || resourceUri.getScheme().equals("https"))) {
            URL url = resourceUri.toURL();
            mon.setTaskSize(-1L);
            mon.started();
            mon.setProgressMessage("doing HEAD request to find dataset type");
            URLConnection c = url.openConnection();
            String mime = c.getContentType();
            if (mime == null) {
                throw new IOException("failed to connect");
            }
            String cd = c.getHeaderField("Content-Disposition");
            if (cd != null) {
                int i0 = cd.indexOf("filename=\"");
                int i1 = cd.indexOf("\"", i0 += "filename=\"".length());
                String filename = cd.substring(i0, i1);
                i0 = filename.lastIndexOf(".");
                ext = filename.substring(i0);
            }
            mon.finished();
            factory = DataSourceRegistry.getInstance().getSourceByMime(mime);
        }
        if (factory == null) {
            if (ext.equals("") || ext.equals("X")) {
                throw new NonResourceException("resource has no extension or mime type");
            }
            factory = DataSourceRegistry.getInstance().getSource(ext);
        }
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported extension: " + ext);
        }
        return factory;
    }

    public static LinkedHashMap<String, String> parseParams(String params) {
        return URISplit.parseParams(params);
    }

    public static String formatParams(Map parms) {
        return URISplit.formatParams(parms);
    }

    public static InputStream getInputStream(URL url, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(url.toString());
        try {
            FileObject fo;
            URI spath = DataSetURI.getWebURL(DataSetURI.toUri(split.path)).toURI();
            FileSystem fs = FileSystem.create((URI)spath);
            String filename = split.file.substring(split.path.length());
            if (fs instanceof LocalFileSystem) {
                filename = DataSourceUtil.unescape(filename);
            }
            if (!(fo = fs.getFileObject(split.file.substring(split.path.length()))).isLocal()) {
                logger.log(Level.INFO, "downloading file {0}", fo.getNameExt());
            }
            return fo.getInputStream(mon);
        }
        catch (URISyntaxException ex) {
            throw new IOException("URI Syntax Exception: " + ex.getMessage());
        }
    }

    public static InputStream getInputStream(URI uri, ProgressMonitor mon) throws IOException {
        FileObject fo;
        URISplit split = URISplit.parse(uri);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        String filename = split.file.substring(split.path.length());
        if (fs instanceof LocalFileSystem) {
            filename = DataSourceUtil.unescape(filename);
        }
        if (!(fo = fs.getFileObject(filename)).isLocal()) {
            logger.log(Level.INFO, "downloading file {0}", fo.getNameExt());
        }
        return fo.getInputStream(mon);
    }

    public static URL toURL(String surl) throws MalformedURLException {
        surl = surl.replaceAll(" ", "%20");
        return new URL(surl);
    }

    public static URI toUri(String suri) {
        try {
            if (!URISplit.isUriEncoded(suri)) {
                suri = suri.replaceAll("%([^0-9])", "%25$1");
                suri = suri.replaceAll("<", "%3C");
                suri = suri.replaceAll(">", "%3E");
                suri = suri.replaceAll(" ", "%20");
            }
            return new URI(suri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String fromUri(URI uri) {
        String query;
        String surl = uri.toASCIIString();
        int i = surl.indexOf("?");
        String string = query = i == -1 ? "" : surl.substring(i);
        if (i != -1) {
            return URISplit.uriDecode(surl.substring(0, i)) + query;
        }
        return URISplit.uriDecode(surl);
    }

    public static String maybePlusToSpace(String ssheet) {
        if (ssheet.contains(" ")) {
            return ssheet;
        }
        return ssheet.replaceAll("\\+", " ");
    }

    public static File getFile(URL url, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(url.toString());
        try {
            File tfile;
            FileObject fo;
            if (split.path == null || split.path.length() == 0) {
                throw new IllegalArgumentException("expected file but didn't find one, check URI for question mark");
            }
            FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL(DataSetURI.toUri(split.path)).toURI());
            String filename = split.file.substring(split.path.length());
            if (fs instanceof LocalFileSystem) {
                filename = DataSourceUtil.unescape(filename);
            }
            if (!(fo = fs.getFileObject(filename)).isLocal()) {
                logger.log(Level.FINE, "downloading file {0}", fo.getNameExt());
            } else {
                logger.log(Level.FINE, "using local copy of {0}", fo.getNameExt());
            }
            if (fo.exists()) {
                tfile = fo.getFile(mon);
            } else {
                FileObject foz = fs.getFileObject(filename + ".gz");
                if (foz.exists()) {
                    File fz = foz.getFile(mon);
                    File tfile1 = new File(fz.getPath().substring(0, fz.getPath().length() - 3) + ".temp");
                    tfile = new File(fz.getPath().substring(0, fz.getPath().length() - 3));
                    FileSystemUtil.unzip((File)fz, (File)tfile1);
                    if (tfile.exists()) {
                        tfile.delete();
                    }
                    tfile1.renameTo(tfile);
                } else {
                    throw new FileNotFoundException("File not found: " + url);
                }
            }
            return tfile;
        }
        catch (URISyntaxException ex) {
            throw new IOException("URI Syntax Exception: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkNonHtml(File tfile, URL source) throws HtmlResponseIOException, FileNotFoundException {
        FileInputStream fi = null;
        HtmlResponseIOException ex2 = null;
        try {
            String ss;
            fi = new FileInputStream(tfile);
            byte[] magic = new byte[5];
            int bytes = fi.read(magic);
            if (bytes == 5 && DataSourceUtil.isHtmlStream(ss = new String(magic))) {
                ex2 = new HtmlResponseIOException("file appears to be html: " + tfile, source);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DataSetURI.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DataSetURI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (ex2 != null) {
            throw ex2;
        }
    }

    public static File getFile(String suri, boolean allowHtml, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(suri);
        try {
            FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
            String filename = split.file.substring(split.path.length());
            FileObject fo = fs.getFileObject(filename);
            File tfile = fo.getFile(mon);
            if (!allowHtml && tfile.exists()) {
                DataSetURI.checkNonHtml(tfile, new URL(split.file));
            }
            return tfile;
        }
        catch (URIException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            if (ex.getMessage().startsWith("root does not exist")) {
                throw new IOException(ex.getMessage());
            }
            throw new IOException("Unsupported protocol: " + suri);
        }
    }

    public static File getFile(URI uri, ProgressMonitor mon) throws IOException {
        String suri = DataSetURI.fromUri(uri);
        return DataSetURI.getFile(suri, false, mon);
    }

    public static File downloadResourceAsTempFile(URL url, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(url.toString());
        if (split.file.startsWith("file:/")) {
            if (split.params != null && split.params.length() > 0) {
                throw new IllegalArgumentException("local file URLs cannot have arguments");
            }
            try {
                return new File(new URL(split.file).toURI());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        File local = FileSystem.settings().getLocalCacheDir();
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        String id = fs.getLocalRoot().toString().substring(FileSystem.settings().getLocalCacheDir().toString().length());
        File localCache = new File(local, "temp");
        if (!(localCache = new File(localCache, id)).exists() && !localCache.mkdirs()) {
            throw new IOException("unable to make directory: " + localCache);
        }
        String filename = new File(localCache, split.file.substring(split.path.length())).toString();
        if (split.params != null && split.params.length() > 0) {
            String safe = split.params;
            safe = safe.replaceAll("\\+", "_");
            safe = safe.replaceAll("-", ".");
            safe = Ops.safeName((String)safe);
            filename = filename + "__" + safe;
        }
        System.err.println("reading URL " + url);
        URLConnection urlc = url.openConnection();
        urlc.setConnectTimeout(3000);
        DasProgressMonitorInputStream in = new DasProgressMonitorInputStream(urlc.getInputStream(), mon);
        File newf = new File(filename + "__");
        FileOutputStream out = new FileOutputStream(newf);
        DataSourceUtil.transfer(Channels.newChannel((InputStream)in), Channels.newChannel(out));
        File result = new File(filename);
        result.deleteOnExit();
        DataSetURI.checkNonHtml(newf, url);
        newf.renameTo(result);
        return result;
    }

    public static File getFile(String uri, ProgressMonitor mon) throws IOException {
        return DataSetURI.getFile(uri, false, mon);
    }

    public static File getHtmlFile(URL url, ProgressMonitor mon) throws IOException {
        try {
            URI uri = url.toURI();
            return DataSetURI.getFile(url.toString(), true, mon);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URI getURIValid(String surl) throws URISyntaxException {
        URI result = DataSetURI.getURI(surl);
        if (result == null) {
            throw new IllegalArgumentException("URI cannot be formed from \"" + surl + "\"");
        }
        return result;
    }

    public static URI getURI(String surl) throws URISyntaxException {
        URISplit split = URISplit.maybeAddFile(surl, 0);
        if (split == null) {
            return null;
        }
        surl = split.surl;
        if (surl.endsWith("://")) {
            surl = surl + "/";
        }
        surl = surl.replaceAll("%([^0-9])", "%25$1");
        surl = surl.replaceAll("<", "%3C");
        surl = surl.replaceAll(">", "%3E");
        surl = surl.replaceAll(" ", "%20");
        if (split.vapScheme != null) {
            if (split.vapScheme.contains(" ")) {
                split.vapScheme = split.vapScheme.replace(" ", "+");
            }
            surl = split.vapScheme + ":" + surl;
        }
        if (!(surl = URISplit.format(URISplit.parse(surl))).startsWith("vap")) {
            URISplit split2 = URISplit.parse(surl);
            String vapScheme = URISplit.implicitVapScheme(split2);
            if (vapScheme.contains("&")) {
                throw new IllegalArgumentException("Address contains ampersand in what looks like a filename: " + surl);
            }
            if (vapScheme.equals("")) {
                vapScheme = "vap+X";
            }
            surl = vapScheme + ":" + surl;
        }
        URI result = new URI(surl);
        return result;
    }

    public static URL getURL(String surl) throws MalformedURLException {
        try {
            URI uri = DataSetURI.getURIValid(surl);
            return DataSetURI.getWebURL(uri);
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
    }

    public static List<CompletionResult> getCompletions(String surl, int carotpos, ProgressMonitor mon) throws Exception {
        int firstSlashAfterHost;
        if (carotpos == 0 || !surl.substring(0, carotpos).contains(":") && (carotpos < 4 && surl.substring(0, carotpos).equals("vap".substring(0, carotpos)) || surl.length() > 3 && surl.substring(0, 3).equals("vap"))) {
            return DataSetURI.getTypesCompletions(surl, carotpos, mon);
        }
        URISplit split = URISplit.parse(surl, carotpos, true);
        if (split.file == null || split.resourceUriCarotPos > split.file.length() && DataSourceRegistry.getInstance().hasSourceByExt(DataSetURI.getExt(surl))) {
            return DataSetURI.getFactoryCompletions(URISplit.format(split), split.formatCarotPos, mon);
        }
        int n = firstSlashAfterHost = split.authority == null ? 0 : split.authority.length();
        if (split.resourceUriCarotPos <= firstSlashAfterHost) {
            return DataSetURI.getHostCompletions(URISplit.format(split), split.formatCarotPos, mon);
        }
        return DataSetURI.getFileSystemCompletions(URISplit.format(split), split.formatCarotPos, true, true, null, mon);
    }

    public static List<CompletionResult> getHostCompletions(String surl, int carotpos, ProgressMonitor mon) throws IOException {
        String surlDir;
        String prefix;
        URISplit split = URISplit.parse(surl.substring(0, carotpos));
        if (split.path == null) {
            prefix = "";
            surlDir = "";
        } else {
            prefix = split.file.substring(split.path.length());
            surlDir = split.path;
        }
        mon.setLabel("getting list of cache hosts");
        if (split.scheme == null) {
            ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>();
            String[] s = new String[]{"ftp://", "http://", "https://", "file:///", "sftp://"};
            for (int j = 0; j < s.length; ++j) {
                completions.add(new CompletionResult(s[j] + surl + "/", s[j] + surl + "/"));
            }
            return completions;
        }
        File cacheF = new File(FileSystem.settings().getLocalCacheDir(), split.scheme);
        if (!cacheF.exists()) {
            return Collections.emptyList();
        }
        String[] s = cacheF.list();
        boolean foldCase = true;
        if (foldCase) {
            prefix = prefix.toLowerCase();
        }
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(s.length);
        for (int j = 0; j < s.length; ++j) {
            String scomp;
            String string = scomp = foldCase ? s[j].toLowerCase() : s[j];
            if (!scomp.startsWith(prefix)) continue;
            String result1 = s[j] + "/";
            String[] s2 = new File(cacheF, result1).list();
            while (s2.length == 1 && new File(cacheF, result1 + "/" + s2[0]).isDirectory()) {
                result1 = result1 + s2[0] + "/";
                s2 = new File(cacheF, result1).list();
            }
            completions.add(new CompletionResult(surlDir + result1, result1, null, surl.substring(0, carotpos), true));
        }
        if (completions.size() != 1 || ((CompletionResult)completions.get((int)0)).completion.equals(surlDir + prefix + "/")) {
            // empty if block
        }
        return completions;
    }

    public static List<CompletionResult> getFileSystemAggCompletions(String surl, int carotpos, ProgressMonitor mon) throws IOException, URISyntaxException {
        int islash;
        URISplit split = URISplit.parse(surl.substring(0, carotpos), carotpos, false);
        String prefix = URISplit.uriDecode(split.file.substring(split.path.length()));
        String surlDir = URISplit.uriDecode(split.path);
        String params = null;
        int iq = surl.indexOf("?");
        if (iq > -1 && (islash = surl.lastIndexOf("/")) <= carotpos) {
            params = surl.substring(iq + 1);
        }
        mon.setLabel("getting remote listing");
        FileSystem fs = null;
        fs = FileSystem.create((URI)DataSetURI.toUri(surlDir));
        Object[] s = fs.listDirectory("/");
        Arrays.sort(s);
        boolean foldCase = Boolean.TRUE.equals(fs.getProperty("caseInsensitive"));
        if (foldCase) {
            prefix = prefix.toLowerCase();
        }
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(5);
        String[] s2 = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            s2[i] = surlDir + (String)s[i];
        }
        if (s2.length > 0) {
            LinkedList<String> files = new LinkedList<String>(Arrays.asList(s2));
            List<String> saggs = DataSourceUtil.findAggregations(files, true);
            for (String sagg : saggs) {
                sagg = URISplit.removeParam(sagg, "timerange");
                completions.add(new CompletionResult(sagg, "Use aggregation", true));
            }
        }
        return completions;
    }

    public static List<CompletionResult> getFileSystemCompletions(String surl, int carotpos, boolean inclAgg, boolean inclFiles, String acceptPattern, ProgressMonitor mon) throws IOException, URISyntaxException {
        String[] s;
        int islash;
        URISplit split = URISplit.parse(surl.substring(0, carotpos), carotpos, false);
        String prefix = URISplit.uriDecode(split.file.substring(split.path.length()));
        String surlDir = URISplit.uriDecode(split.path);
        String params = null;
        int iq = surl.indexOf("?");
        if (iq > -1 && (islash = surl.lastIndexOf("/")) <= carotpos) {
            params = surl.substring(iq + 1);
        }
        mon.setLabel("getting remote listing");
        FileSystem fs = null;
        if (surlDir.equals("file:") || surlDir.equals("file://")) {
            surlDir = "file:///";
            CompletionResult t0 = split.vapScheme != null ? new CompletionResult(split.vapScheme + ":" + "file:///", "need three slashes") : new CompletionResult("file:///", "need three slashes");
            List<CompletionResult> completions = Collections.singletonList(t0);
            return completions;
        }
        boolean onlyAgg = false;
        if (surlDir.endsWith("/$Y/")) {
            String s1 = surlDir.substring(0, surlDir.length() - 3);
            String s2 = surlDir.substring(surlDir.length() - 3, surlDir.length() - 1);
            FileSystem fsp = FileSystem.create((URI)DataSetURI.toUri(s1), (ProgressMonitor)mon);
            FileStorageModelNew fsm = FileStorageModelNew.create((FileSystem)fsp, (String)s2);
            fs = fsp;
            ArrayList<String> ss = new ArrayList<String>();
            String[] ss2 = fsm.getNamesFor(null);
            int nn = Math.min(1, ss2.length);
            for (int i = 0; i < nn; ++i) {
                FileSystem fsm2 = FileSystem.create((URI)DataSetURI.toUri(s1 + ss2[i]));
                String[] ss3 = fsm2.listDirectory("/");
                for (int ii = 0; ii < ss3.length; ++ii) {
                    ss3[ii] = ss2[i] + '/' + ss3[ii];
                }
                ss.addAll(Arrays.asList(ss3));
            }
            s = ss.toArray(new String[ss.size()]);
            surlDir = s1;
            onlyAgg = true;
        } else {
            if (surlDir.startsWith("file:/") && !surlDir.contains(".zip/") && !surlDir.contains(".ZIP/") && !new File(new URL(split.path).getPath()).exists()) {
                throw new FileNotFoundException("directory does not exist: " + split.path);
            }
            fs = FileSystem.create((URI)DataSetURI.toUri(surlDir), (ProgressMonitor)mon);
            s = fs.listDirectory("/");
        }
        if (acceptPattern != null) {
            Pattern p = Pattern.compile(acceptPattern);
            ArrayList<String> res = new ArrayList<String>(s.length);
            for (int i = 0; i < s.length; ++i) {
                if (s[i].endsWith("/")) {
                    res.add(s[i]);
                    continue;
                }
                if (!p.matcher(s[i]).matches()) continue;
                res.add(s[i]);
            }
            s = res.toArray(new String[res.size()]);
        }
        Arrays.sort(s, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean d2;
                boolean d1 = o1.startsWith(".");
                if (d1 == (d2 = o2.startsWith("."))) {
                    return o1.compareTo(o2);
                }
                if (d1) {
                    return 1;
                }
                return -1;
            }
        });
        boolean foldCase = Boolean.TRUE.equals(fs.getProperty("caseInsensitive"));
        if (foldCase) {
            prefix = prefix.toLowerCase();
        }
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>(s.length);
        String[] s2 = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            s2[i] = surlDir + s[i];
        }
        if (s2.length > 0 && inclAgg) {
            LinkedList<String> files = new LinkedList<String>(Arrays.asList(s2));
            List<String> saggs = DataSourceUtil.findAggregations(files, true);
            if (onlyAgg) {
                completions.removeAll(completions);
            }
            for (String sagg : saggs) {
                URISplit split2 = URISplit.parse(sagg);
                LinkedHashMap<String, String> params2 = URISplit.parseParams(split2.params);
                String tr = (String)params2.remove("timerange");
                split2.params = params2.size() == 0 ? null : URISplit.formatParams(params2);
                if (split2.vapScheme != null && !sagg.startsWith(split2.vapScheme)) {
                    split2.vapScheme = null;
                }
                String scomp = URISplit.format(split2);
                if (split2.vapScheme == null && split.vapScheme != null) {
                    split2.vapScheme = split.vapScheme;
                }
                sagg = URISplit.format(split2);
                if (!(scomp = scomp.substring(surlDir.length())).startsWith(prefix)) continue;
                completions.add(new CompletionResult(sagg, "Use aggregation (" + tr + " available)", true));
            }
        }
        if (!onlyAgg) {
            for (int j = 0; j < s.length; ++j) {
                String scomp;
                String string = scomp = foldCase ? s[j].toLowerCase() : s[j];
                if (!scomp.startsWith(prefix)) continue;
                if (s[j].endsWith("contents.html")) {
                    s[j] = s[j].substring(0, s[j].length() - "contents.html".length());
                }
                if (s[j].endsWith(".zip") || s[j].endsWith(".ZIP")) {
                    s[j] = s[j] + "/";
                }
                if (!inclFiles && !s[j].endsWith("/")) continue;
                String completion = surlDir + s[j];
                completion = DataSetURI.newUri(surl, completion);
                String label = s[j];
                String completable = surl.substring(0, carotpos);
                boolean maybePlot = true;
                if (completion.startsWith("file://" + completable)) {
                    completion = completion.substring(7);
                }
                completions.add(new CompletionResult(completion, label, null, completable, maybePlot));
            }
        }
        if (completions.size() != 1 || ((CompletionResult)completions.get((int)0)).completion.equals(surlDir + prefix + "/")) {
            // empty if block
        }
        return completions;
    }

    public static List<CompletionResult> getTypesCompletions(String surl, int carotpos, ProgressMonitor mon) throws Exception {
        List<CompletionContext> exts = DataSourceRegistry.getPlugins();
        ArrayList<CompletionResult> completions = new ArrayList<CompletionResult>();
        String prefix = surl.substring(0, carotpos);
        String suffix = "";
        if (surl.startsWith("vap:")) {
            suffix = surl.substring(4);
        }
        for (CompletionContext cc : exts) {
            if (!cc.completable.startsWith(prefix)) continue;
            completions.add(new CompletionResult(cc.completable + suffix, cc.completable, null, cc.completable, false));
        }
        String labelPrefix = "";
        return completions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompletionResult> getFactoryCompletions(String surl1, int carotPos, ProgressMonitor mon) throws Exception {
        CompletionContext cc = new CompletionContext();
        URISplit split = URISplit.parse(surl1);
        int qpos = surl1.lastIndexOf(63, carotPos);
        if (qpos == -1 && surl1.contains(":") && (surl1.endsWith(":") || surl1.contains("&"))) {
            qpos = surl1.indexOf(":");
        }
        if (qpos == -1 && surl1.contains(":") && split.file == null) {
            qpos = surl1.indexOf(":");
        }
        cc.surl = surl1;
        cc.surlpos = carotPos;
        ArrayList<CompletionResult> result = new ArrayList();
        if (qpos != -1 && qpos < carotPos) {
            if (qpos == -1) {
                qpos = surl1.length();
            }
            int eqpos = surl1.lastIndexOf(61, carotPos - 1);
            int amppos = surl1.lastIndexOf(38, carotPos - 1);
            if (amppos == -1) {
                amppos = qpos;
            }
            if (eqpos > amppos) {
                cc.context = CompletionContext.CONTEXT_PARAMETER_VALUE;
                cc.completable = surl1.substring(eqpos + 1, carotPos);
                cc.completablepos = carotPos - (eqpos + 1);
            } else {
                cc.context = CompletionContext.CONTEXT_PARAMETER_NAME;
                cc.completable = surl1.substring(amppos + 1, carotPos);
                cc.completablepos = carotPos - (amppos + 1);
                if (surl1.length() > carotPos && surl1.charAt(carotPos) != '&') {
                    surl1 = surl1.substring(0, carotPos) + '&' + surl1.substring(carotPos);
                    split = URISplit.parse(surl1);
                }
            }
        } else {
            cc.context = CompletionContext.CONTEXT_FILE;
            qpos = surl1.indexOf(63, carotPos);
            cc.completable = qpos == -1 ? surl1 : surl1.substring(0, qpos);
            cc.completablepos = carotPos;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            int i;
            DataSourceFactory factory = DataSetURI.getDataSourceFactory(DataSetURI.getURIValid(surl1), (ProgressMonitor)new NullProgressMonitor());
            if (factory == null) {
                throw new IllegalArgumentException("unable to find data source factory");
            }
            String suri = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            if (suri == null) {
                suri = cc.surl;
            }
            URI uri = DataSetURI.getURIValid(suri);
            cc.resourceURI = DataSetURI.getResourceURI(uri);
            cc.params = split.params;
            List<CompletionContext> completions = factory.getCompletions(cc, mon);
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            for (i = 0; i < 3; ++i) {
                params.remove("arg_" + i);
            }
            i = 0;
            for (CompletionContext cc1 : completions) {
                boolean dontYetHave;
                String paramName;
                String string = paramName = cc1.implicitName != null ? cc1.implicitName : cc1.completable;
                if (paramName.indexOf("=") != -1) {
                    paramName = paramName.substring(0, paramName.indexOf("="));
                }
                boolean bl = dontYetHave = !params.containsKey(paramName);
                boolean startsWith = cc1.completable.startsWith(cc.completable);
                if (!startsWith) continue;
                LinkedHashMap<String, String> paramsCopy = new LinkedHashMap<String, String>(params);
                if (cc1.implicitName != null) {
                    paramsCopy.put(cc1.implicitName, cc1.completable);
                } else {
                    paramsCopy.put(cc1.completable, null);
                }
                String ss = (split.vapScheme == null ? "" : split.vapScheme + ":") + split.file + "?" + URISplit.formatParams(paramsCopy);
                if (!dontYetHave) continue;
                result.add(new CompletionResult(ss, cc1.label, cc1.doc, surl1.substring(0, carotPos), cc1.maybePlot));
                ++i;
            }
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String file = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            DataSourceFactory factory = DataSetURI.getDataSourceFactory(DataSetURI.getURIValid(surl1), mon);
            if (file != null) {
                URI uri = DataSetURI.getURIValid(file);
                cc.resourceURI = DataSetURI.getResourceURI(uri);
            }
            cc.params = split.params;
            if (factory == null) {
                throw new IllegalArgumentException("unable to find data source factory");
            }
            List<CompletionContext> completions = factory.getCompletions(cc, mon);
            int i = 0;
            for (CompletionContext cc1 : completions) {
                if (!cc1.completable.startsWith(cc.completable)) continue;
                String ss = CompletionContext.insert(cc, cc1);
                if (split.vapScheme != null && !ss.startsWith(split.vapScheme)) {
                    ss = split.vapScheme + ":" + ss;
                }
                result.add(new CompletionResult(ss, cc1.label, cc1.doc, surl1.substring(0, carotPos), cc1.maybePlot));
                ++i;
            }
            return result;
        }
        try {
            int newCarotPos;
            int i;
            mon.setProgressMessage("listing directory");
            mon.started();
            String surl = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            if (surl == null) {
                throw new MalformedURLException("unable to process");
            }
            int surlPos = cc.surl.indexOf(surl);
            if (surlPos == -1) {
                surlPos = 0;
            }
            String surlDir = (i = surl.lastIndexOf("/", (newCarotPos = carotPos - surlPos) - 1)) <= 0 ? surl : (surl.charAt(i - 1) == '/' ? surl.substring(0, i + 1) : surl.substring(0, i + 1));
            URI url = DataSetURI.getURIValid(surlDir);
            String prefix = surl.substring(i + 1, newCarotPos);
            FileSystem fs = FileSystem.create((URL)DataSetURI.getWebURL(url), (ProgressMonitor)new NullProgressMonitor());
            String[] s = fs.listDirectory("/");
            mon.finished();
            for (int j = 0; j < s.length; ++j) {
                if (!s[j].startsWith(prefix)) continue;
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_FILE, surlDir + s[j]);
                result.add(new CompletionResult(CompletionContext.insert(cc, cc1), cc1.label, cc1.doc, surl1.substring(0, carotPos), true));
            }
        }
        catch (MalformedURLException ex) {
            result = Collections.singletonList(new CompletionResult("Malformed URI", "Something in the URL prevents processing", surl1.substring(0, carotPos), false));
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            result = Collections.singletonList(new CompletionResult("FileSystem offline", "FileSystem is offline.", surl1.substring(0, carotPos), false));
        }
        finally {
            mon.finished();
        }
        return result;
    }

    public static void init() {
    }

    public static void main(String[] args) {
        System.err.println(DataSetURI.getResourceURI("file:C:\\documents and settings\\jbf\\pngwalk"));
    }

    static {
        DataSourceRegistry registry = DataSourceRegistry.getInstance();
        registry.discoverFactories();
        registry.discoverRegistryEntries();
        FileSystem.registerFileSystemFactory((String)"zip", (FileSystemFactory)new ZipFileSystemFactory());
        FileSystem.registerFileSystemFactory((String)"ftp", (FileSystemFactory)new FTPBeanFileSystemFactory());
        FileSystem.registerFileSystemFactory((String)"sftp", (FileSystemFactory)new VFSFileSystemFactory());
        FileSystem.settings().setPersistence(FileSystemSettings.Persistence.EXPIRES);
        if (FileSystemSettings.hasAllPermission()) {
            File apDataHome = new File(AutoplotSettings.settings().resolveProperty("fscache"));
            FileSystem.settings().setLocalCacheDir(apDataHome);
        }
        dsToFactory = new WeakHashMap();
    }

    public static class CompletionResult {
        public String completion;
        public String doc;
        public String completable;
        public String label;
        public boolean maybePlot;

        protected CompletionResult(String completion, String doc) {
            this(completion, doc, null, false);
        }

        protected CompletionResult(String completion, String doc, boolean maybePlot) {
            this(completion, null, doc, null, maybePlot);
        }

        protected CompletionResult(String completion, String doc, String completable, boolean maybePlot) {
            this(completion, null, doc, completable, maybePlot);
        }

        protected CompletionResult(String completion, String label, String doc, String completable, boolean maybePlot) {
            this.completion = completion;
            this.completable = completable;
            this.label = label != null ? label : (completable != null ? completable : completion);
            this.doc = doc;
            this.maybePlot = maybePlot;
        }
    }

    public static class NonResourceException
    extends IllegalArgumentException {
        public NonResourceException(String msg) {
            super(msg);
        }
    }
}

