/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.text.ParseException;
import java.util.LinkedHashMap;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

public class DefaultTimeSeriesBrowse
implements TimeSeriesBrowse {
    public String uri;
    DatumRange timeRange;

    public void setURI(String suri) throws ParseException {
        this.uri = suri;
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String sdr = (String)params.get(URISplit.PARAM_TIME_RANGE);
        if (sdr != null) {
            this.timeRange = DatumRangeUtil.parseTimeRange((String)sdr.replaceAll("\\+", " "));
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void setTimeRange(DatumRange dr) {
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        params.put(URISplit.PARAM_TIME_RANGE, dr.toString().replaceAll(" ", "+"));
        if (split.file != null && split.file.equals("file:///")) {
            split.file = null;
        }
        split.params = URISplit.formatParams(params);
        this.uri = URISplit.format(split);
        this.timeRange = dr;
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeResolution(Datum d) {
    }

    public Datum getTimeResolution() {
        return null;
    }
}

