/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.DiskUsageModel;
import com.cottagesystems.jdiskhog.FSTreeModel;
import com.cottagesystems.jdiskhog.MyMouseListener;
import com.cottagesystems.jdiskhog.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.AutoplotUI;
import org.virbo.datasource.AutoplotSettings;

public class JDiskHogPanel
extends JPanel {
    AutoplotUI app;
    public JButton jButton1;
    public JScrollPane jScrollPane2;
    public JTree jTree1;

    public JDiskHogPanel(AutoplotUI model) {
        this.app = model;
        this.initComponents();
        this.jTree1.addMouseListener(this.createMouseListener(this.jTree1));
    }

    private MouseListener createMouseListener(JTree jtree) {
        return new MyMouseListener(jtree, this);
    }

    Action getDeleteAction(final JTree jtree) {
        return new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                FSTreeModel model = (FSTreeModel)jtree.getModel();
                TreePath[] paths = jtree.getSelectionPaths();
                boolean okay = true;
                Throwable ex = null;
                for (int i = 0; i < paths.length; ++i) {
                    File f = model.getFile(paths[i]);
                    if (f.equals(model.root)) continue;
                    if (f.isFile()) {
                        okay = f.delete();
                        continue;
                    }
                    try {
                        okay = Util.deleteFileTree(f);
                        continue;
                    }
                    catch (IllegalArgumentException ex1) {
                        ex = ex1;
                        okay = false;
                    }
                }
                if (!okay) {
                    JOptionPane.showConfirmDialog(jtree, ex.getLocalizedMessage(), "unable to delete", -1, 2);
                }
                JDiskHogPanel.this.scan(model.root);
            }
        };
    }

    Action getPlotAction(final JTree jtree) {
        return new AbstractAction("Plot"){

            public void actionPerformed(ActionEvent e) {
                FSTreeModel model = (FSTreeModel)jtree.getModel();
                TreePath[] paths = jtree.getSelectionPaths();
                if (paths.length == 0) {
                    return;
                }
                File f = model.getFile(paths[0]);
                String sf = f.toString();
                String cache = AutoplotSettings.settings().resolveProperty("fscache");
                boolean acceptOutside = false;
                String outsideName = sf.substring(cache.length());
                if (sf.startsWith(cache)) {
                    String[] protos = new String[]{"ftp", "http", "https"};
                    for (int i = 0; i < protos.length; ++i) {
                        if (!outsideName.startsWith("/" + protos[i] + "/")) continue;
                        outsideName = protos[i] + "://" + outsideName.substring(protos[i].length() + 2);
                        acceptOutside = true;
                    }
                }
                if (acceptOutside) {
                    JDiskHogPanel.this.app.plotUri(outsideName);
                } else {
                    JDiskHogPanel.this.app.plotUri(f.toString());
                }
                Container p = JDiskHogPanel.this.getTopLevelAncestor();
                if (p instanceof JDialog) {
                    p.setVisible(false);
                }
            }
        };
    }

    Action getCopyToAction(final JTree jtree) {
        return new AbstractAction("Copy To..."){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setCurrentDirectory(new File("foo").getParentFile());
                chooser.setAcceptAllFileFilterUsed(false);
                if (chooser.showSaveDialog(jtree) == 0) {
                    File destdir = chooser.getSelectedFile();
                    FSTreeModel model = (FSTreeModel)jtree.getModel();
                    TreePath[] paths = jtree.getSelectionPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        File f = model.getFile(paths[i]);
                        try {
                            Util.fileCopy(f, destdir);
                            continue;
                        }
                        catch (FileNotFoundException ex1) {
                            Logger.getLogger(JDiskHogPanel.class.getName()).log(Level.SEVERE, null, ex1);
                            JOptionPane.showMessageDialog(jtree, "File Not Found:\n" + ex1.getLocalizedMessage());
                            continue;
                        }
                        catch (IOException ex1) {
                            Logger.getLogger(JDiskHogPanel.class.getName()).log(Level.SEVERE, null, ex1);
                            JOptionPane.showMessageDialog(jtree, "Error Occurred:\n" + ex1.getLocalizedMessage());
                        }
                    }
                }
            }
        };
    }

    public void scan(File root) {
        DiskUsageModel dumodel = new DiskUsageModel();
        dumodel.search(root, 0, (ProgressMonitor)new NullProgressMonitor());
        FSTreeModel model = new FSTreeModel(dumodel, root);
        this.jTree1.setModel(model);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jButton1 = new JButton();
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDiskHogPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 688, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(636, Short.MAX_VALUE).add((Component)this.jButton1, -2, 52, -2)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 293, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        SwingUtilities.getWindowAncestor(this).setVisible(false);
    }
}

