/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.JDiskHogPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MyMouseListener
extends MouseAdapter {
    JTree jtree;
    JDiskHogPanel panel;
    TreePath context;
    JPopupMenu popup;

    MyMouseListener(JTree jtree, JDiskHogPanel panel) {
        this.jtree = jtree;
        this.panel = panel;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.context = this.jtree.getPathForLocation(e.getX(), e.getY());
            this.jtree.getSelectionModel().addSelectionPath(this.context);
            if (this.context != null) {
                this.showPopup(e);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.context = this.jtree.getPathForLocation(e.getX(), e.getY());
            this.jtree.getSelectionModel().addSelectionPath(this.context);
            if (this.context != null) {
                this.showPopup(e);
            }
        }
    }

    private synchronized void showPopup(MouseEvent e) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(new JMenuItem(this.panel.getDeleteAction(this.jtree)));
            this.popup.add(new JMenuItem(this.panel.getPlotAction(this.jtree)));
            this.popup.add(new JMenuItem(this.panel.getCopyToAction(this.jtree)));
        }
        this.popup.show(this.jtree, e.getX(), e.getY());
    }
}

