/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class Util {
    public static boolean deleteFileTree(File root) throws IllegalArgumentException {
        if (!root.exists()) {
            return true;
        }
        File[] children = root.listFiles();
        boolean success = true;
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory()) {
                success = success && Util.deleteFileTree(children[i]);
                continue;
            }
            boolean bl = success = success && children[i].delete();
            if (success) continue;
            throw new IllegalArgumentException("unable to delete file " + children[i]);
        }
        boolean bl = success = success && (!root.exists() || root.delete());
        if (!success) {
            throw new IllegalArgumentException("unable to delete folder " + root);
        }
        return success;
    }

    public static void fileCopy(File src, File dst) throws FileNotFoundException, IOException {
        if (src.isDirectory() && (!dst.exists() || dst.isDirectory())) {
            File[] files;
            if (!dst.exists() && !dst.mkdirs()) {
                throw new IOException("unable to mkdir " + dst);
            }
            File dst1 = new File(dst, src.getName());
            if (!dst1.exists() && !dst1.mkdir()) {
                throw new IOException("unable to mkdir " + dst1);
            }
            dst = dst1;
            for (File f : files = src.listFiles()) {
                if (f.isDirectory()) {
                    dst1 = new File(dst, f.getName());
                    if (!dst1.exists() && !dst1.mkdir()) {
                        throw new IOException("unable to mkdir " + dst1);
                    }
                } else {
                    dst1 = dst;
                }
                Util.fileCopy(f, dst1);
            }
            return;
        }
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        FileChannel ic = new FileInputStream(src).getChannel();
        FileChannel oc = new FileOutputStream(dst).getChannel();
        ic.transferTo(0L, ic.size(), oc);
        ic.close();
        oc.close();
    }
}

