/*
 * Decompiled with CFR 0.152.
 */
package external;

import external.FunctionSupport;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.PlotSymbol;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.ScriptContext;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.CanvasUtil;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.jythonsupport.PyQDataSetAdapter;
import org.virbo.jythonsupport.Util;

public class PlotCommand
extends PyObject {
    private static QDataSet coerceIt(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            if (arg0.isNumberType()) {
                double d = (Double)arg0.__tojava__(Double.class);
                return DataSetUtil.asDataSet((double)d);
            }
            if (arg0 instanceof PyString) {
                try {
                    return Util.getDataSet((String)((String)arg0.__tojava__(String.class)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if (arg0.isSequenceType()) {
                return PyQDataSetAdapter.adaptList((PyList)((PyList)arg0));
            }
            throw Py.TypeError((String)("unable to coerce: " + arg0));
        }
        QDataSet ds = (QDataSet)o;
        if (ds.rank() == 0) {
            return ds;
        }
        return ds;
    }

    private Object getEnumElement(Class c, String ele) {
        int PUBLIC_STATIC_FINAL = 25;
        if (c.isEnum()) {
            T[] vals;
            for (Object o : vals = c.getEnumConstants()) {
                Enum e = (Enum)o;
                if (!e.toString().equals(ele)) continue;
                return e;
            }
        } else {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                try {
                    String name = f.getName();
                    if ((f.getModifiers() & PUBLIC_STATIC_FINAL) != PUBLIC_STATIC_FINAL) continue;
                    Object value = f.get(null);
                    if (!name.equals(ele) || value == null || !c.isInstance(value)) continue;
                    return value;
                }
                catch (IllegalAccessException iae) {
                    IllegalAccessError err = new IllegalAccessError(iae.getMessage());
                    err.initCause(iae);
                    throw err;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __call__(PyObject[] args, String[] keywords) {
        PyInteger False = Py.newBoolean((boolean)false);
        FunctionSupport fs = new FunctionSupport("plotx", new String[]{"x", "y", "z", "xtitle", "xrange", "ytitle", "yrange", "ztitle", "zrange", "xlog", "ylog", "zlog", "title", "renderType", "color", "symsize", "linewidth", "symbol"}, new PyObject[]{Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, False, False, False, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None});
        fs.args(args, keywords);
        int nparm = args.length - keywords.length;
        if (nparm == 0) {
            System.err.println("args.length=0");
            return Py.None;
        }
        int iplot = 0;
        int nargs = nparm;
        PyObject po0 = args[0];
        if (po0 instanceof PyInteger) {
            iplot = ((PyInteger)po0).getValue();
            PyObject[] newArgs = new PyObject[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                newArgs[i] = args[i + 1];
            }
            args = newArgs;
            --nargs;
            nparm = args.length - keywords.length;
        }
        QDataSet[] qargs = new QDataSet[nargs];
        Application dom = ScriptContext.getDocumentModel();
        if (nargs == 1 && po0 instanceof PyString) {
            try {
                ScriptContext.plot(((PyString)po0).toString());
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PlotCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int i = 0; i < nargs; ++i) {
                QDataSet ds;
                qargs[i] = ds = PlotCommand.coerceIt(args[i]);
            }
            try {
                if (nargs == 1) {
                    ScriptContext.plot(iplot, qargs[0]);
                } else if (nargs == 2) {
                    ScriptContext.plot(iplot, qargs[0], qargs[1]);
                } else if (nargs == 3) {
                    ScriptContext.plot(iplot, qargs[0], qargs[1], qargs[2]);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        dom.getController().registerPendingChange((Object)this, (Object)this);
        dom.getController().performingChange((Object)this, (Object)this);
        try {
            int chNum = iplot;
            while (dom.getDataSourceFilters().length <= chNum) {
                Plot p = CanvasUtil.getMostBottomPlot(dom.getController().getCanvas());
                dom.getController().setPlot(p);
                dom.getController().addPlotElement(null, null);
            }
            DataSourceFilter dsf = dom.getDataSourceFilters(chNum);
            List<PlotElement> elements = dom.getController().getPlotElementsFor(dsf);
            Plot plot = dom.getController().getPlotFor(elements.get(0));
            for (int i = nparm; i < args.length; ++i) {
                PyList plval;
                Units u;
                DatumRange dr;
                String kw = keywords[i - nparm];
                PyObject val = args[i];
                String sval = (String)val.__str__().__tojava__(String.class);
                if (kw.equals("ytitle")) {
                    plot.getYaxis().setLabel(sval);
                    continue;
                }
                if (kw.equals("yrange")) {
                    dr = plot.getYaxis().getRange();
                    u = dr.getUnits();
                    plval = (PyList)val;
                    plot.getYaxis().setRange(DatumRange.newDatumRange((double)((Number)plval.get(0)).doubleValue(), (double)((Number)plval.get(1)).doubleValue(), (Units)u));
                    continue;
                }
                if (kw.equals("ylog")) {
                    plot.getYaxis().setLog("1".equals(sval));
                    continue;
                }
                if (kw.equals("xtitle")) {
                    plot.getXaxis().setLabel(sval);
                    continue;
                }
                if (kw.equals("xrange")) {
                    dr = plot.getXaxis().getRange();
                    u = dr.getUnits();
                    plval = (PyList)val;
                    plot.getXaxis().setRange(DatumRange.newDatumRange((double)((Number)plval.get(0)).doubleValue(), (double)((Number)plval.get(1)).doubleValue(), (Units)u));
                    continue;
                }
                if (kw.equals("xlog")) {
                    plot.getXaxis().setLog("1".equals(sval));
                    continue;
                }
                if (kw.equals("ztitle")) {
                    plot.getZaxis().setLabel(sval);
                    continue;
                }
                if (kw.equals("zrange")) {
                    dr = plot.getZaxis().getRange();
                    u = dr.getUnits();
                    plval = (PyList)val;
                    plot.getZaxis().setRange(DatumRange.newDatumRange((double)((Number)plval.get(0)).doubleValue(), (double)((Number)plval.get(1)).doubleValue(), (Units)u));
                    continue;
                }
                if (kw.equals("zlog")) {
                    plot.getZaxis().setLog("1".equals(sval));
                    continue;
                }
                if (kw.equals("color")) {
                    Color c;
                    if (sval == null) continue;
                    try {
                        c = Color.decode(sval);
                    }
                    catch (NumberFormatException ex) {
                        c = (Color)this.getEnumElement(Color.class, sval);
                    }
                    if (c != null) {
                        elements.get(0).getStyle().setColor(c);
                        continue;
                    }
                    throw new IllegalArgumentException("unable to identify color: " + sval);
                }
                if (kw.equals("title")) {
                    plot.setTitle(sval);
                    continue;
                }
                if (kw.equals("symsize")) {
                    elements.get(0).getStyle().setSymbolSize(Double.valueOf(sval));
                    continue;
                }
                if (kw.equals("linewidth")) {
                    elements.get(0).getStyle().setLineWidth(Double.valueOf(sval));
                    continue;
                }
                if (kw.equals("symbol")) {
                    elements.get(0).getStyle().setPlotSymbol((PlotSymbol)this.getEnumElement(DefaultPlotSymbol.class, sval));
                    continue;
                }
                if (!kw.equals("renderType")) continue;
                RenderType rt = RenderType.valueOf(sval);
                elements.get(0).setRenderType(rt);
            }
        }
        finally {
            dom.getController().changePerformed((Object)this, (Object)this);
        }
        return Py.None;
    }
}

