/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class CreatePngWalkDialog
extends JPanel {
    private JCheckBox createThumbsCb;
    private JTextField flnRootTf;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField outputFolderTf;
    private JCheckBox overwriteCB;
    private JButton pickFolderButton;
    private JTextField timeFormatTf;
    private JTextField timeRangeTf;

    public CreatePngWalkDialog() {
        this.initComponents();
        String home = System.getProperty("user.home") + System.getProperty("file.separator");
        home = home.replaceAll("\\\\", "/");
        this.outputFolderTf.setText(home + "pngwalk/");
        this.setDefaults();
        this.checkExists();
    }

    private void setDefaults() {
        Preferences prefs = Preferences.userNodeForPackage(CreatePngWalkDialog.class);
        String file = prefs.get("filenameRoot", this.flnRootTf.getText());
        this.flnRootTf.setText(file);
        String home = prefs.get("outputFolder", this.outputFolderTf.getText());
        this.outputFolderTf.setText(home);
        String timeFormat = prefs.get("timeFormat", this.timeFormatTf.getText());
        this.timeFormatTf.setText(timeFormat);
        String timeRange = prefs.get("timeRange", this.timeRangeTf.getText());
        this.timeRangeTf.setText(timeRange);
        boolean thumbs = prefs.getBoolean("createThumbs", this.createThumbsCb.isSelected());
        this.createThumbsCb.setSelected(thumbs);
    }

    public void writeDefaults() {
        Preferences prefs = Preferences.userNodeForPackage(CreatePngWalkDialog.class);
        prefs.put("filenameRoot", this.flnRootTf.getText());
        prefs.put("outputFolder", this.outputFolderTf.getText());
        prefs.put("timeFormat", this.timeFormatTf.getText());
        prefs.put("timeRange", this.timeRangeTf.getText());
        prefs.putBoolean("createThumbs", this.createThumbsCb.isSelected());
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(CreatePngWalkDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void checkExists() {
        String sf = this.outputFolderTf.getText();
        File f = new File(sf);
        this.overwriteCB.setEnabled(f.exists());
        if (!f.exists()) {
            this.overwriteCB.setSelected(false);
        }
    }

    public JTextField getFlnRootTf() {
        return this.flnRootTf;
    }

    public JTextField getOutputFolderTf() {
        return this.outputFolderTf;
    }

    public JTextField getTimeFormatTf() {
        return this.timeFormatTf;
    }

    public JTextField getTimeRangeTf() {
        return this.timeRangeTf;
    }

    public JCheckBox getCreateThumbsCb() {
        return this.createThumbsCb;
    }

    public JCheckBox getOverwriteCb() {
        return this.overwriteCB;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.flnRootTf = new JTextField();
        this.jLabel2 = new JLabel();
        this.outputFolderTf = new JTextField();
        this.pickFolderButton = new JButton();
        this.jLabel3 = new JLabel();
        this.timeFormatTf = new JTextField();
        this.jLabel4 = new JLabel();
        this.timeRangeTf = new JTextField();
        this.createThumbsCb = new JCheckBox();
        this.overwriteCB = new JCheckBox();
        this.jLabel1.setText("Filename Root:");
        this.flnRootTf.setText("product");
        this.flnRootTf.setToolTipText("Stem used to ensure unique filenames");
        this.jLabel2.setText("Output Folder:");
        this.outputFolderTf.setText("/folder/");
        this.outputFolderTf.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                CreatePngWalkDialog.this.outputFolderTfKeyReleased(evt);
            }

            public void keyTyped(KeyEvent evt) {
                CreatePngWalkDialog.this.outputFolderTfKeyTyped(evt);
            }
        });
        this.pickFolderButton.setText("Pick");
        this.pickFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreatePngWalkDialog.this.pickFolderButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Time Format:");
        this.timeFormatTf.setText("$Y$m$d");
        this.timeFormatTf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreatePngWalkDialog.this.timeFormatTfActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Time Range:");
        this.timeRangeTf.setText("2010");
        this.createThumbsCb.setSelected(true);
        this.createThumbsCb.setText("Create Thumbs");
        this.overwriteCB.setText("Overwrite");
        this.overwriteCB.setToolTipText("overwrite existing pngwalk");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.flnRootTf, -1, 238, Short.MAX_VALUE)).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.overwriteCB).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.outputFolderTf, -1, 195, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pickFolderButton)))))).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)this.timeFormatTf, -1, 238, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.createThumbsCb)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)this.timeRangeTf, -1, 238, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.flnRootTf, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.outputFolderTf, -2, -1, -2).add((Component)this.pickFolderButton)).addPreferredGap(0).add((Component)this.overwriteCB).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.timeFormatTf, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.timeRangeTf, -2, -1, -2).add(12, 12, 12).add((Component)this.createThumbsCb).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void pickFolderButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.getOutputFolderTf().getText());
        chooser.setFileSelectionMode(1);
        int r = chooser.showSaveDialog(this);
        if (r == 0) {
            this.outputFolderTf.setText(chooser.getSelectedFile().toString());
        }
    }

    private void outputFolderTfKeyTyped(KeyEvent evt) {
        this.checkExists();
    }

    private void timeFormatTfActionPerformed(ActionEvent evt) {
    }

    private void outputFolderTfKeyReleased(KeyEvent evt) {
        this.checkExists();
    }
}

