/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.pngwalk.PngWalkTool1;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;

public class GridPngWalkView
extends PngWalkView {
    private int thumbSize = 100;
    private int nCols = 1;
    private static final int MIN_THUMB_SIZE = 20;
    private static final int MAX_THUMB_SIZE = 300;
    private JScrollPane scrollPane;
    private GridViewCanvas canvas;
    private double restoreScrollPct = -1.0;

    public GridPngWalkView(WalkImageSequence sequence) {
        super(sequence);
        this.setShowCaptions(true);
        this.setLayout(new BorderLayout());
        this.canvas = new GridViewCanvas();
        this.scrollPane = new JScrollPane(this.canvas);
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (GridPngWalkView.this.seq == null) {
                    return;
                }
                GridPngWalkView.this.selectCellAt(e.getX(), e.getY());
            }
        });
        this.canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                GridPngWalkView.this.nCols = GridPngWalkView.this.getWidth() / GridPngWalkView.this.thumbSize;
                if (GridPngWalkView.this.nCols == 0) {
                    GridPngWalkView.this.nCols = 1;
                }
                if (GridPngWalkView.this.restoreScrollPct >= 0.0) {
                    JScrollBar sb = GridPngWalkView.this.scrollPane.getVerticalScrollBar();
                    int newScroll = (int)(GridPngWalkView.this.restoreScrollPct * (double)(sb.getMaximum() - sb.getVisibleAmount()));
                    sb.setValue(newScroll);
                    GridPngWalkView.this.restoreScrollPct = -1.0;
                }
                GridPngWalkView.this.updateLayout();
            }
        });
        this.scrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){
            Timer repaintTimer = new Timer("GridViewRepaintDelay", true);
            TimerTask task;

            public void stateChanged(ChangeEvent e) {
                if (this.task != null) {
                    this.task.cancel();
                }
                if (GridPngWalkView.this.seq == null) {
                    return;
                }
                if (!GridPngWalkView.this.canvas.isShowing()) {
                    return;
                }
                this.task = new TimerTask(){

                    public void run() {
                        Rectangle bounds = GridPngWalkView.this.scrollPane.getViewport().getViewRect();
                        int rowMin = bounds.y / GridPngWalkView.this.thumbSize;
                        int rowMax = Math.min((bounds.y + bounds.height) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.seq.size() / GridPngWalkView.this.nCols + 1);
                        int colMin = Math.min(bounds.x / GridPngWalkView.this.thumbSize, GridPngWalkView.this.nCols);
                        int colMax = Math.min((bounds.x + bounds.width) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.nCols);
                        for (int row = rowMin; row < rowMax; ++row) {
                            int n;
                            for (int col = colMin; col < colMax && (n = row * GridPngWalkView.this.nCols + col) < GridPngWalkView.this.seq.size(); ++col) {
                                GridPngWalkView.this.seq.imageAt(n).getThumbnail(true);
                            }
                        }
                    }
                };
                this.repaintTimer.schedule(this.task, 200L);
            }
        });
        this.add(this.scrollPane);
    }

    private void updateLayout() {
        if (this.canvas == null) {
            return;
        }
        if (this.seq != null) {
            this.canvas.setPreferredSize(new Dimension(this.thumbSize * this.nCols, this.thumbSize * (this.seq.size() / this.nCols + 1)));
        } else {
            this.canvas.setPreferredSize(new Dimension(0, 0));
        }
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    protected void sequenceChanged() {
        this.updateLayout();
        if (this.scrollPane != null) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    protected void thumbnailSizeChanged() {
        JScrollBar sb = this.scrollPane.getVerticalScrollBar();
        this.restoreScrollPct = (double)sb.getValue() / (double)(sb.getMaximum() - sb.getVisibleAmount());
        this.thumbSize = this.getThumbnailSize();
        this.nCols = this.getWidth() / this.thumbSize;
        if (this.nCols == 0) {
            this.nCols = 1;
        }
        this.updateLayout();
        super.thumbnailSizeChanged();
    }

    public JComponent getMouseTarget() {
        return this.canvas;
    }

    private void selectCellAt(int x, int y) {
        if (x > this.nCols * this.thumbSize) {
            return;
        }
        int row = y / this.thumbSize;
        int col = x / this.thumbSize;
        int n = row * this.nCols + col;
        if (n >= this.seq.size()) {
            return;
        }
        this.seq.setIndex(n);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("index")) {
            int i = (Integer)e.getOldValue();
            int x = i % this.nCols * this.thumbSize;
            int y = i / this.nCols * this.thumbSize;
            this.canvas.repaint(new Rectangle(x, y, this.thumbSize, this.thumbSize));
            i = (Integer)e.getNewValue();
            x = i % this.nCols * this.thumbSize;
            y = i / this.nCols * this.thumbSize;
            this.canvas.repaint(new Rectangle(x, y, this.thumbSize, this.thumbSize));
            int scrollMin = this.scrollPane.getVerticalScrollBar().getValue();
            int scrollMax = scrollMin + this.scrollPane.getVerticalScrollBar().getVisibleAmount();
            int pos = y - this.getHeight() / 2 - this.thumbSize / 2;
            if (scrollMin > y || scrollMax < y + this.thumbSize) {
                this.scrollPane.getVerticalScrollBar().setValue(pos);
            }
        } else if (e.getPropertyName().equals("thumbLoaded")) {
            int i = (Integer)e.getNewValue();
            int y = i / this.nCols * this.thumbSize;
            int x = i % this.nCols * this.thumbSize;
            this.canvas.repaint(new Rectangle(x, y, this.thumbSize, this.thumbSize));
            this.canvas.repaintSoon();
        } else if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        }
    }

    private class GridViewCanvas
    extends JPanel
    implements Scrollable {
        private Font smallFont = new Font("Dialog", 0, 6);
        private Font normalFont = new Font("Dialog", 0, 12);
        javax.swing.Timer repaintTimer;

        GridViewCanvas() {
            this.repaintTimer = new javax.swing.Timer(300, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GridViewCanvas.this.repaint();
                }
            });
            this.repaintTimer.setRepeats(false);
        }

        private void repaintSoon() {
            this.repaintTimer.restart();
        }

        public void paintComponent(Graphics g1) {
            super.paintComponent(g1);
            Graphics2D g2 = (Graphics2D)g1;
            if (GridPngWalkView.this.thumbSize < 100) {
                g2.setFont(this.smallFont);
            } else {
                g2.setFont(this.normalFont);
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (GridPngWalkView.this.seq == null) {
                return;
            }
            Rectangle bounds = g2.getClipBounds();
            int rowMin = bounds.y / GridPngWalkView.this.thumbSize;
            int rowMax = Math.min((bounds.y + bounds.height) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.seq.size() / GridPngWalkView.this.nCols + 1);
            int colMin = Math.min(bounds.x / GridPngWalkView.this.thumbSize, GridPngWalkView.this.nCols);
            int colMax = Math.min((bounds.x + bounds.width) / GridPngWalkView.this.thumbSize + 1, GridPngWalkView.this.nCols);
            FontMetrics fm = g2.getFontMetrics();
            List<DatumRange> drs = GridPngWalkView.this.seq.getActiveSubrange();
            int npaint = (rowMax - rowMin) * (colMax - colMin);
            for (int row = rowMin; row < rowMax; ++row) {
                int i;
                for (int col = colMin; col < colMax && (i = row * GridPngWalkView.this.nCols + col) < GridPngWalkView.this.seq.size(); ++col) {
                    WalkImage wimage;
                    BufferedImage thumb;
                    if (GridPngWalkView.this.seq.getIndex() == i) {
                        Color oldColor = g2.getColor();
                        g2.setColor(Color.orange);
                        g2.fillRect(col * GridPngWalkView.this.thumbSize, row * GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize);
                        g2.setColor(oldColor);
                    }
                    if ((thumb = (wimage = GridPngWalkView.this.seq.imageAt(i)).getThumbnail(!GridPngWalkView.this.scrollPane.getVerticalScrollBar().getValueIsAdjusting())) != null) {
                        double s = Math.min((double)(GridPngWalkView.this.thumbSize - 4) / (double)thumb.getWidth(), (double)(GridPngWalkView.this.thumbSize - 4 - fm.getHeight()) / (double)thumb.getHeight());
                        if (s < 1.0) {
                            int w = (int)(s * (double)thumb.getWidth());
                            int h = (int)(s * (double)thumb.getHeight());
                            if (npaint < 10) {
                                ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(thumb.getWidth(), thumb.getHeight(), 0, 0, w, h, 0, 1, 1, 0.0, false);
                                thumb = resizeOp.filter(thumb, null);
                            } else {
                                thumb = WalkUtil.resizeImage(thumb, w, h);
                            }
                        }
                    } else {
                        thumb = PngWalkView.loadingImage;
                    }
                    int imgX = col * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize - thumb.getWidth()) / 2;
                    int imgY = row * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize - thumb.getHeight() - fm.getHeight()) / 2;
                    g2.drawImage((Image)thumb, imgX, imgY, null);
                    if (PngWalkTool1.isQualityControlEnabled() && GridPngWalkView.this.seq.getQualityControlSequence() != null) {
                        GridPngWalkView.this.paintQualityControlIcon(i, g2, imgX, imgY, true);
                    }
                    try {
                        Shape oldClip;
                        int cx;
                        int ds = 6;
                        if (drs != null && i < GridPngWalkView.this.seq.size() - 1 && GridPngWalkView.this.seq.imageAt(i + 1).getDatumRange().min().subtract(wimage.getDatumRange().max()).doubleValue(Units.seconds) > 0.0) {
                            g2.setColor(Color.GRAY);
                            cx = col * GridPngWalkView.this.thumbSize + GridPngWalkView.this.thumbSize - ds;
                            int cy = row * GridPngWalkView.this.thumbSize + GridPngWalkView.this.thumbSize - fm.getHeight() - 3;
                            oldClip = g2.getClip();
                            g2.clip(new Rectangle(cx, row * GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize));
                            g2.fillPolygon(new int[]{cx, cx + ds, cx + ds, cx}, new int[]{cy, cy - ds, cy, cy}, 4);
                            g2.setClip(oldClip);
                        }
                        if (drs != null && i > 0 && GridPngWalkView.this.seq.imageAt(i).getDatumRange().min().subtract(GridPngWalkView.this.seq.imageAt(i - 1).getDatumRange().max()).doubleValue(Units.seconds) > 0.0) {
                            g2.setColor(Color.GRAY);
                            cx = col * GridPngWalkView.this.thumbSize;
                            int cy = row * GridPngWalkView.this.thumbSize + GridPngWalkView.this.thumbSize - fm.getHeight() - 3;
                            oldClip = g2.getClip();
                            g2.clip(new Rectangle(cx, row * GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize, GridPngWalkView.this.thumbSize));
                            g2.fillPolygon(new int[]{cx, cx, cx + ds, cx}, new int[]{cy, cy - ds, cy, cy}, 4);
                            g2.setClip(oldClip);
                        }
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                    if (!GridPngWalkView.this.showCaptions || wimage.getCaption() == null) continue;
                    int cx = col * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize - thumb.getWidth()) / 2;
                    int cy = row * GridPngWalkView.this.thumbSize + (GridPngWalkView.this.thumbSize + thumb.getHeight() + fm.getHeight()) / 2;
                    g2.setColor(Color.BLACK);
                    Shape oldClip = g2.getClip();
                    g2.clip(new Rectangle(cx, row * GridPngWalkView.this.thumbSize, (GridPngWalkView.this.thumbSize + thumb.getWidth()) / 2, GridPngWalkView.this.thumbSize));
                    g2.drawString(wimage.getCaption(), cx, cy);
                    g2.setClip(oldClip);
                }
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return GridPngWalkView.this.thumbSize;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            int x = GridPngWalkView.this.scrollPane.getVerticalScrollBar().getVisibleAmount() / GridPngWalkView.this.thumbSize * GridPngWalkView.this.thumbSize;
            return x;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

