/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageResize {
    public static BufferedImage getScaledInstance(BufferedImage img, int thumbSize) {
        int w0 = img.getWidth();
        int h0 = img.getHeight();
        int thumbH = 0;
        int thumbW = 0;
        double aspect = 1.0 * (double)w0 / (double)h0;
        thumbH = (int)Math.sqrt(Math.pow(thumbSize, 2.0) / (aspect * aspect + 1.0));
        thumbW = (int)((double)thumbH * aspect);
        return ImageResize.getScaledInstance(img, thumbW, thumbH, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

