/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.autoplot.pngwalk.PngWalkTool1;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkImageSequence;

public abstract class PngWalkView
extends JPanel
implements PropertyChangeListener {
    protected WalkImageSequence seq;
    protected boolean showCaptions = false;
    protected static final BufferedImage loadingImage = PngWalkView.initLoadingImage();
    protected static final ImageIcon okBadge;
    protected static final ImageIcon problemBadge;
    protected static final ImageIcon ignoreBadge;
    protected int thumbnailSize = 100;
    public static final String PROP_THUMBNAILSIZE = "thumbnailSize";

    protected PngWalkView(WalkImageSequence sequence) {
        this.setSequence(sequence);
    }

    public final void setSequence(WalkImageSequence sequence) {
        if (this.seq != null) {
            this.seq.removePropertyChangeListener(this);
        }
        this.seq = sequence;
        if (this.seq != null) {
            this.seq.addPropertyChangeListener(this);
        }
        this.sequenceChanged();
    }

    public WalkImageSequence getSequence() {
        return this.seq;
    }

    protected void sequenceChanged() {
        this.repaint();
    }

    protected void thumbnailSizeChanged() {
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        } else {
            this.repaint();
        }
    }

    public boolean isShowCaptions() {
        return this.showCaptions;
    }

    public void setShowCaptions(boolean showCaptions) {
        this.showCaptions = showCaptions;
    }

    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(int thumbnailSize) {
        int oldThumbnailSize = this.thumbnailSize;
        this.thumbnailSize = thumbnailSize;
        this.thumbnailSizeChanged();
        this.firePropertyChange(PROP_THUMBNAILSIZE, oldThumbnailSize, thumbnailSize);
    }

    public JComponent getMouseTarget() {
        return this;
    }

    protected void drawCenteredString(Graphics2D g, String msg) {
        if (msg == null) {
            return;
        }
        System.err.println("draw string");
        Rectangle bounds = g.getClipBounds();
        if (bounds != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.drawString(msg, (bounds.width - fm.stringWidth(msg)) / 2, bounds.height / 2);
        } else {
            System.err.println("bad clipping");
        }
    }

    protected void paintImageCentered(BufferedImage i, Graphics2D g2) {
        this.paintImageCentered(i, g2, null);
    }

    protected void paintImageCentered(BufferedImage i, Graphics2D g2, String caption) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        double captionHeight = this.showCaptions && caption != null ? (double)(fm.getHeight() + fm.getDescent()) : 0.0;
        double imageHeight = i.getHeight();
        double xfactor = (double)this.getWidth() / (double)i.getWidth(null);
        double yfactor = ((double)this.getHeight() - captionHeight) / imageHeight;
        double s = Math.min(xfactor, yfactor);
        s = Math.min(1.0, s);
        int xpos = (int)((double)this.getWidth() - (double)i.getWidth(null) * s) / 2;
        int ypos = (int)((double)this.getHeight() - captionHeight - imageHeight * s) / 2;
        int xs = (int)((double)i.getWidth(null) * s);
        int ys = (int)((double)i.getHeight(null) * s);
        ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(i.getWidth(), i.getHeight(), 0, 0, xs, ys, 0, -1, -1, 0.0, false);
        g2.drawImage(i, resizeOp, xpos, ypos);
        if (this.showCaptions && caption != null) {
            int cx = xpos;
            int cy = ypos + ys + fm.getHeight();
            g2.drawString(caption, cx, cy);
        }
        if (PngWalkTool1.isQualityControlEnabled() && this.seq.getQualityControlSequence() != null) {
            this.paintQualityControlIcon(this.seq.getIndex(), g2, xpos, ypos, true);
        }
    }

    private static BufferedImage initLoadingImage() {
        BufferedImage li = new BufferedImage(48, 48, 2);
        Graphics2D g2 = li.createGraphics();
        g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        g2.fillRoundRect(0, 0, 48, 48, 6, 6);
        g2.setColor(Color.WHITE);
        g2.fillOval(12, 32, 4, 4);
        g2.fillOval(24, 32, 4, 4);
        g2.fillOval(36, 32, 4, 4);
        return li;
    }

    protected void paintQualityControlIcon(int i, Graphics2D g2, int imgX, int imgY, boolean icon) {
        block11: {
            QualityControlRecord rec;
            block12: {
                rec = this.seq.getQualityControlSequence().getQualityControlRecord(i);
                if (okBadge == null) {
                    throw new RuntimeException("unable to locate all badges for quality control");
                }
                if (rec == null) break block11;
                if (!icon) break block12;
                switch (rec.getStatus()) {
                    case OK: {
                        okBadge.paintIcon(this, g2, imgX + 5, imgY + 5);
                        break block11;
                    }
                    case PROBLEM: {
                        problemBadge.paintIcon(this, g2, imgX + 5, imgY + 5);
                        break block11;
                    }
                    case IGNORE: {
                        ignoreBadge.paintIcon(this, g2, imgX + 5, imgY + 5);
                    }
                    default: {
                        return;
                    }
                }
            }
            Color color0 = g2.getColor();
            switch (rec.getStatus()) {
                case OK: {
                    System.err.println("imgX=" + imgX);
                    g2.setColor(Color.GREEN);
                    break;
                }
                case PROBLEM: {
                    g2.setColor(Color.RED);
                    break;
                }
                case IGNORE: {
                    g2.setColor(Color.GRAY);
                }
                default: {
                    return;
                }
            }
            g2.fillOval(imgX, imgY, 6, 6);
            g2.setColor(Color.GRAY);
            g2.drawOval(imgX, imgY, 6, 6);
            g2.setColor(color0);
        }
    }

    static {
        URL u = PngWalkView.class.getResource("/resources/badge_problem.png");
        problemBadge = u != null ? new ImageIcon(u) : null;
        u = PngWalkView.class.getResource("/resources/badge_ok.png");
        okBadge = u != null ? new ImageIcon(u) : null;
        u = PngWalkView.class.getResource("/resources/badge_ignore.png");
        ignoreBadge = u != null ? new ImageIcon(u) : null;
    }
}

