/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.pngwalk.PngWalkTool1;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;

public class RowPngWalkView
extends PngWalkView {
    public static final int DEFAULT_CELL_SIZE = 100;
    public static final int MINIMUM_CELL_SIZE = 20;
    private int cellSize = 100;
    protected JScrollPane scrollPane;
    private Canvas canvas;
    private double restoreScrollPct = -1.0;

    public RowPngWalkView(WalkImageSequence sequence) {
        super(sequence);
        this.setShowCaptions(true);
        this.setLayout(new BorderLayout());
        this.canvas = new Canvas();
        this.scrollPane = new JScrollPane(this.canvas, 20, 32);
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (RowPngWalkView.this.seq == null) {
                    return;
                }
                int clickCell = (int)Math.floor((double)e.getX() / (double)RowPngWalkView.this.cellSize);
                RowPngWalkView.this.selectCell(clickCell);
            }
        });
        this.canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (RowPngWalkView.this.restoreScrollPct >= 0.0) {
                    JScrollBar sb = RowPngWalkView.this.scrollPane.getHorizontalScrollBar();
                    int newScroll = (int)(RowPngWalkView.this.restoreScrollPct * (double)(sb.getMaximum() - sb.getVisibleAmount()));
                    if (newScroll < 0) {
                        newScroll = 0;
                    }
                    sb.setValue(newScroll);
                    RowPngWalkView.this.restoreScrollPct = -1.0;
                }
            }
        });
        this.scrollPane.getHorizontalScrollBar().getModel().addChangeListener(new ChangeListener(){
            Timer repaintTimer = new Timer("RowViewRepaintDelay", true);
            TimerTask task;

            public void stateChanged(ChangeEvent e) {
                if (this.task != null) {
                    this.task.cancel();
                }
                if (RowPngWalkView.this.seq == null) {
                    return;
                }
                if (!RowPngWalkView.this.canvas.isShowing()) {
                    return;
                }
                this.task = new TimerTask(){

                    public void run() {
                        Rectangle bounds = RowPngWalkView.this.scrollPane.getViewport().getViewRect();
                        int first = Math.max(0, (bounds.x - bounds.width) / RowPngWalkView.this.cellSize);
                        int last = Math.min(RowPngWalkView.this.seq.size(), (bounds.x + 2 * bounds.width) / RowPngWalkView.this.cellSize + 1);
                        for (int i = first; i < last; ++i) {
                            RowPngWalkView.this.seq.imageAt(i).getThumbnail(true);
                        }
                    }
                };
                this.repaintTimer.schedule(this.task, 200L);
            }
        });
        this.add(this.scrollPane);
    }

    protected void sequenceChanged() {
        this.updateLayout();
        if (this.scrollPane != null) {
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
    }

    protected void thumbnailSizeChanged() {
        JScrollBar sb = this.scrollPane.getHorizontalScrollBar();
        this.restoreScrollPct = (double)sb.getValue() / (double)(sb.getMaximum() - sb.getVisibleAmount());
        this.cellSize = this.getThumbnailSize();
        this.updateLayout();
        super.thumbnailSizeChanged();
    }

    public JComponent getMouseTarget() {
        return this.canvas;
    }

    private void updateLayout() {
        if (this.canvas == null) {
            return;
        }
        if (this.seq != null) {
            this.canvas.setPreferredSize(new Dimension(this.cellSize * this.seq.size(), this.cellSize));
        } else {
            this.canvas.setPreferredSize(new Dimension(0, 0));
        }
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    private void selectCell(int n) {
        this.seq.setIndex(n);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("index")) {
            int i = (Integer)e.getOldValue();
            int x = i * this.cellSize;
            this.canvas.repaint(new Rectangle(x, 0, this.cellSize, this.cellSize));
            i = (Integer)e.getNewValue();
            x = i * this.cellSize;
            this.canvas.repaint(new Rectangle(x, 0, this.cellSize, this.cellSize));
            int scrollMin = this.scrollPane.getHorizontalScrollBar().getValue();
            int scrollMax = scrollMin + this.scrollPane.getHorizontalScrollBar().getVisibleAmount();
            int pos = i * this.cellSize - this.getWidth() / 2 + this.cellSize / 2;
            if (scrollMin > i * this.cellSize || scrollMax < (i + 1) * this.cellSize) {
                this.scrollPane.getHorizontalScrollBar().setValue(pos);
            }
        } else if (e.getPropertyName().equals("thumbLoaded") || e.getPropertyName().equals("imageLoaded") || e.getPropertyName().equals("badgeChange")) {
            int i = (Integer)e.getNewValue();
            int x = i * this.cellSize;
            this.canvas.repaint(new Rectangle(x, 0, this.cellSize, this.cellSize));
        } else if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        }
    }

    private class Canvas
    extends JPanel
    implements Scrollable {
        private Font smallFont = new Font("Dialog", 0, 6);
        private Font normalFont = new Font("Dialog", 0, 12);
        javax.swing.Timer repaintTimer;

        public Canvas() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.repaintTimer = new javax.swing.Timer(300, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Canvas.this.repaint();
                }
            });
            this.repaintTimer.setRepeats(false);
        }

        private void repaintSoon() {
            this.repaintTimer.restart();
        }

        public synchronized void paintComponent(Graphics g1) {
            super.paintComponent(g1);
            Graphics2D g2 = (Graphics2D)g1;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (RowPngWalkView.this.cellSize < 100) {
                g2.setFont(this.smallFont);
            } else {
                g2.setFont(this.normalFont);
            }
            Rectangle bounds = g2.getClipBounds();
            FontMetrics fm = g2.getFontMetrics();
            if (RowPngWalkView.this.seq == null) {
                return;
            }
            int imax = Math.min(RowPngWalkView.this.seq.size() - 1, (bounds.x + bounds.width) / RowPngWalkView.this.cellSize);
            for (int i = bounds.x / RowPngWalkView.this.cellSize; i <= imax; ++i) {
                WalkImage wimage;
                BufferedImage thumb;
                if (i == RowPngWalkView.this.seq.getIndex()) {
                    g2.setColor(Color.orange);
                    g2.fillRect(i * RowPngWalkView.this.cellSize, 0, RowPngWalkView.this.cellSize, RowPngWalkView.this.cellSize);
                }
                if ((thumb = (wimage = RowPngWalkView.this.seq.imageAt(i)).getThumbnail(!RowPngWalkView.this.scrollPane.getHorizontalScrollBar().getValueIsAdjusting())) != null) {
                    double s = Math.min((double)(RowPngWalkView.this.cellSize - 4) / (double)thumb.getWidth(), (double)(RowPngWalkView.this.cellSize - 4 - fm.getHeight()) / (double)thumb.getHeight());
                    if (s < 1.0) {
                        int w = (int)(s * (double)thumb.getWidth());
                        int h = (int)(s * (double)thumb.getHeight());
                        ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(thumb.getWidth(), thumb.getHeight(), 0, 0, w, h, 0, 1, 1, 0.0, false);
                        thumb = resizeOp.filter(thumb, null);
                    }
                } else {
                    thumb = PngWalkView.loadingImage;
                }
                int imgX = i * RowPngWalkView.this.cellSize + (RowPngWalkView.this.cellSize - thumb.getWidth()) / 2;
                int imgY = (RowPngWalkView.this.cellSize - thumb.getHeight() - fm.getHeight()) / 2;
                g2.drawImage((Image)thumb, imgX, imgY, null);
                if (PngWalkTool1.isQualityControlEnabled() && RowPngWalkView.this.seq.getQualityControlSequence() != null) {
                    RowPngWalkView.this.paintQualityControlIcon(i, g2, imgX, imgY, true);
                }
                if (!RowPngWalkView.this.showCaptions || wimage.getCaption() == null) continue;
                int cx = i * RowPngWalkView.this.cellSize + (RowPngWalkView.this.cellSize - thumb.getWidth()) / 2;
                int cy = (RowPngWalkView.this.cellSize + thumb.getHeight() + fm.getHeight()) / 2;
                g2.setColor(Color.BLACK);
                Shape oldClip = g2.getClip();
                g2.clip(new Rectangle(cx, 0, (RowPngWalkView.this.cellSize + thumb.getWidth()) / 2, this.getHeight()));
                g2.drawString(wimage.getCaption(), cx, cy);
                g2.setClip(oldClip);
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
            return RowPngWalkView.this.cellSize;
        }

        public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
            int x = RowPngWalkView.this.scrollPane.getHorizontalScrollBar().getVisibleAmount() / RowPngWalkView.this.cellSize * RowPngWalkView.this.cellSize;
            return x;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

