/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.WalkImageSequence;

public class SinglePngWalkView
extends PngWalkView {
    private BufferedImage cacheImage;

    public SinglePngWalkView(WalkImageSequence s) {
        super(s);
        this.setShowCaptions(true);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (SinglePngWalkView.this.seq != null && SinglePngWalkView.this.seq.size() != 0) {
                    SinglePngWalkView.this.seq.skipBy(e.getWheelRotation());
                }
            }
        });
    }

    protected synchronized void paintComponent(Graphics g1) {
        super.paintComponent(g1);
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.seq == null || this.seq.size() == 0) {
            return;
        }
        BufferedImage i = this.seq.currentImage().getImage();
        if (i != null && i.getWidth(this) > 0 && i.getHeight(this) > 0) {
            this.paintImageCentered(i, g2, this.seq.currentImage().getCaption());
            this.cacheImage = i;
        } else {
            if (this.cacheImage != null) {
                this.paintImageCentered(this.cacheImage, g2, this.seq.currentImage().getCaption());
            }
            this.paintImageCentered(loadingImage, g2);
        }
    }
}

