/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.das2.datum.DatumRange;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubrangeEditorDialog
extends JDialog {
    private int maxIndex;
    private List<DatumRange> dateSpan;
    private boolean okClicked = false;
    private JButton cancelButton;
    private JLabel endLabel;
    private JSlider endSlider;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton okButton;
    private JLabel startLabel;
    private JSlider startSlider;

    public SubrangeEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Time Range Selection");
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        this.initComponents();
    }

    public void setTimeSpan(List<DatumRange> span) {
        this.dateSpan = span;
        this.maxIndex = this.dateSpan.size() - 1;
        this.startSlider.setValue(0);
        this.startSlider.setMaximum(this.maxIndex);
        this.endSlider.setMaximum(this.maxIndex);
        this.endSlider.setValue(this.maxIndex);
        this.startLabel.setText(this.dateSpan.get(this.startSlider.getValue()).toString());
        this.endLabel.setText(this.dateSpan.get(this.endSlider.getValue()).toString());
    }

    public boolean isOkClicked() {
        return this.okClicked;
    }

    public int getStartIndex() {
        return this.startSlider.getValue();
    }

    public void setStartIndex(int in) {
        if (in < 0) {
            in = 0;
        }
        if (in > this.maxIndex) {
            in = this.maxIndex;
        }
        if (in > this.endSlider.getValue()) {
            in = this.endSlider.getValue();
        }
        this.startSlider.setValue(in);
    }

    public int getEndIndex() {
        return this.endSlider.getValue();
    }

    public void setEndIndex(int in) {
        if (in < 0) {
            in = 0;
        }
        if (in > this.maxIndex) {
            in = this.maxIndex;
        }
        if (in < this.startSlider.getValue()) {
            in = this.startSlider.getValue();
        }
        this.endSlider.setValue(in);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.startSlider = new JSlider();
        this.jLabel2 = new JLabel();
        this.endSlider = new JSlider();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.startLabel = new JLabel();
        this.endLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Start:");
        this.startSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SubrangeEditorDialog.this.startSliderStateChanged(evt);
            }
        });
        this.jLabel2.setText("End:");
        this.endSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SubrangeEditorDialog.this.endSliderStateChanged(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubrangeEditorDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubrangeEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.startLabel.setText("(application changes this)");
        this.endLabel.setText("(application changes this)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.startSlider, -1, 441, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.startLabel, -1, 399, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.endLabel, -1, 407, Short.MAX_VALUE)).add((Component)this.endSlider, -1, 441, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(291, 291, 291).add((Component)this.cancelButton, -1, 69, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.okButton, -1, 75, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.startLabel)).addPreferredGap(0).add((Component)this.startSlider, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.endLabel)).addPreferredGap(0).add((Component)this.endSlider, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.okButton).add((Component)this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void startSliderStateChanged(ChangeEvent evt) {
        this.startLabel.setText(this.dateSpan.get(this.startSlider.getValue()).toString());
        if (this.startSlider.getValue() > this.endSlider.getValue()) {
            this.endSlider.setValue(this.startSlider.getValue());
        }
    }

    private void endSliderStateChanged(ChangeEvent evt) {
        this.endLabel.setText(this.dateSpan.get(this.endSlider.getValue()).toString());
        if (this.endSlider.getValue() < this.startSlider.getValue()) {
            this.startSlider.setValue(this.endSlider.getValue());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okClicked = true;
        this.setVisible(false);
    }
}

