/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.datasource.DataSetSelector;
import org.xml.sax.SAXException;

public class AddDataSourcePanel
extends JPanel {
    public static final String PREF_RECENT = "addDataSourceRecent";
    public DataSetSelector dataSetSelector1;
    public JLabel jLabel1;

    public AddDataSourcePanel() {
        this.initComponents();
        this.dataSetSelector1.setBrowseTypeExt("jar");
        this.dataSetSelector1.setEnableDataSource(false);
        this.dataSetSelector1.setHidePlayButton(true);
        Preferences prefs = Preferences.userNodeForPackage(AddDataSourcePanel.class);
        String srecent = prefs.get(PREF_RECENT, "");
        if (!srecent.equals("")) {
            try {
                ArrayList<String> urls = new ArrayList<String>();
                List<Bookmark> recent = Bookmark.parseBookmarks(srecent);
                for (Bookmark b : recent) {
                    urls.add(((Bookmark.Item)b).getUri());
                }
                this.dataSetSelector1.setRecent(urls);
                if (urls.size() > 1) {
                    this.dataSetSelector1.setValue((String)urls.get(urls.size() - 1));
                }
                this.dataSetSelector1.setRecent(urls);
            }
            catch (SAXException ex) {
                Logger.getLogger(AddDataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(AddDataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            String[] recent = new String[]{"(no recent entries)"};
            this.dataSetSelector1.setRecent(new ArrayList<String>(Arrays.asList(recent)));
            this.dataSetSelector1.setValue("");
        }
        this.dataSetSelector1.addPropertyChangeListener("recent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Preferences prefs = Preferences.userNodeForPackage(AddDataSourcePanel.class);
                List srecent = AddDataSourcePanel.this.dataSetSelector1.getRecent();
                ArrayList<Bookmark> recent = new ArrayList<Bookmark>();
                for (String s : srecent) {
                    recent.add(new Bookmark.Item(s));
                }
                prefs.put(AddDataSourcePanel.PREF_RECENT, Bookmark.formatBooks(recent));
            }
        });
    }

    public DataSetSelector getDataSetSelector() {
        return this.dataSetSelector1;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataSetSelector1 = new DataSetSelector();
        this.jLabel1.setText("Add Data Sources Found in Jar File:");
        this.dataSetSelector1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDataSourcePanel.this.dataSetSelector1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.dataSetSelector1, -1, 384, Short.MAX_VALUE)).add((Component)this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.dataSetSelector1, -2, -1, -2).addContainerGap(220, Short.MAX_VALUE)));
    }

    private void dataSetSelector1ActionPerformed(ActionEvent evt) {
    }
}

