/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSetSelector;

public class AddPlotElementDialog
extends JDialog {
    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";
    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";
    private JButton cancelButton;
    private JLabel jLabel1;
    private JButton overplotButton;
    private JButton plotBelowButton;
    private JButton plotButton;
    private DataSetSelector primaryDataSetSelector;
    private JCheckBox secondaryCheckBox;
    private DataSetSelector secondaryDataSetSelector;
    private JCheckBox tertiaryCheckBox;
    private DataSetSelector tertiaryDataSetSelector;

    public AddPlotElementDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.secondaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryCheckBox.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected() && this.tertiaryCheckBox.isSelected());
        this.primaryDataSetSelector.setPlotItButtonVisible(false);
        this.secondaryDataSetSelector.setPlotItButtonVisible(false);
        this.tertiaryDataSetSelector.setPlotItButtonVisible(false);
    }

    private void initComponents() {
        this.primaryDataSetSelector = new DataSetSelector();
        this.secondaryCheckBox = new JCheckBox();
        this.secondaryDataSetSelector = new DataSetSelector();
        this.tertiaryCheckBox = new JCheckBox();
        this.tertiaryDataSetSelector = new DataSetSelector();
        this.overplotButton = new JButton();
        this.plotBelowButton = new JButton();
        this.plotButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.secondaryCheckBox.setText("Plot Against (X):");
        this.secondaryCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.secondaryCheckBoxActionPerformed(evt);
            }
        });
        this.tertiaryCheckBox.setText("And Against (Y):");
        this.tertiaryCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.tertiaryCheckBoxActionPerformed(evt);
            }
        });
        this.overplotButton.setText("Overplot");
        this.overplotButton.setToolTipText("Add this to the current plot as an overplot");
        this.overplotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.overplotButtonActionPerformed(evt);
            }
        });
        this.plotBelowButton.setText("Plot Below");
        this.plotBelowButton.setToolTipText("Plot below the current plot, possibly inserting a plot.");
        this.plotBelowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.plotBelowButtonActionPerformed(evt);
            }
        });
        this.plotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/go.png")));
        this.plotButton.setText("Plot");
        this.plotButton.setToolTipText("Replace the current plot with this");
        this.plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.plotButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Plot the Data Set URI:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.overplotButton).addPreferredGap(0).add((Component)this.plotBelowButton).addPreferredGap(0).add((Component)this.plotButton)).add((Component)this.primaryDataSetSelector, -1, 678, Short.MAX_VALUE).add((Component)this.secondaryCheckBox).add((Component)this.secondaryDataSetSelector, -2, 0, Short.MAX_VALUE).add((Component)this.tertiaryCheckBox).add((Component)this.tertiaryDataSetSelector, -2, 0, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -1, 503, Short.MAX_VALUE).add(175, 175, 175))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.primaryDataSetSelector, -2, -1, -2).addPreferredGap(0).add((Component)this.secondaryCheckBox).addPreferredGap(0).add((Component)this.secondaryDataSetSelector, -2, -1, -2).addPreferredGap(0).add((Component)this.tertiaryCheckBox).addPreferredGap(0).add((Component)this.tertiaryDataSetSelector, -2, -1, -2).addPreferredGap(0, 70, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.plotButton).add((Component)this.plotBelowButton).add((Component)this.overplotButton).add((Component)this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void secondaryCheckBoxActionPerformed(ActionEvent evt) {
        if (this.secondaryCheckBox.isSelected()) {
            this.secondaryDataSetSelector.setValue(this.primaryDataSetSelector.getValue());
        }
        this.secondaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryCheckBox.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected() && this.tertiaryCheckBox.isSelected());
    }

    private void overplotButtonActionPerformed(ActionEvent evt) {
        this.setModifiers(1);
        this.cancelled = false;
        this.setVisible(false);
    }

    private void plotBelowButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(2);
        this.setVisible(false);
    }

    private void plotButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(evt.getModifiers());
        this.setVisible(false);
    }

    private void tertiaryCheckBoxActionPerformed(ActionEvent evt) {
        if (this.tertiaryCheckBox.isSelected()) {
            this.tertiaryDataSetSelector.setValue(this.primaryDataSetSelector.getValue());
        }
        this.tertiaryDataSetSelector.setVisible(this.tertiaryCheckBox.isSelected());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }

    public int getDepCount() {
        if (this.tertiaryCheckBox.isSelected()) {
            return 2;
        }
        if (this.secondaryCheckBox.isSelected()) {
            return 1;
        }
        return 0;
    }

    public void setDepCount(int i) {
        this.primaryDataSetSelector.setVisible(i > -1);
        this.secondaryCheckBox.setVisible(i > -1);
        this.secondaryCheckBox.setSelected(i > 0);
        this.secondaryDataSetSelector.setVisible(i > 0);
        this.tertiaryCheckBox.setVisible(i > 0);
        this.tertiaryCheckBox.setSelected(i > 1);
        this.tertiaryDataSetSelector.setVisible(i > 1);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public DataSetSelector getPrimaryDataSetSelector() {
        return this.primaryDataSetSelector;
    }

    public DataSetSelector getSecondaryDataSetSelector() {
        return this.secondaryDataSetSelector;
    }

    public DataSetSelector getTertiaryDataSetSelector() {
        return this.tertiaryDataSetSelector;
    }
}

