/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.DasApplication;
import org.das2.beans.BeansUtil;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.util.Base64;
import org.das2.util.ExceptionHandler;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.Util;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.CanvasUtil;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.Row;
import org.virbo.autoplot.layout.LayoutUtil;
import org.virbo.autoplot.state.StatePersistence;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.Caching;
import org.virbo.qstream.QDataSetStreamHandler;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;
import org.virbo.qstream.SimpleStreamFormatter;
import org.virbo.qstream.StreamException;
import org.virbo.qstream.StreamHandler;
import org.virbo.qstream.StreamTool;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationModel {
    DasApplication application;
    DasCanvas canvas;
    Timer tickleTimer;
    Application dom;
    private ExceptionHandler exceptionHandler;
    boolean applet = false;
    static final Logger logger = Logger.getLogger("virbo.autoplot");
    public static final String PREF_RECENT = "recent";
    public static final String PROPERTY_RECENT = "recent";
    public static final String PROPERTY_BOOKMARKS = "bookmarks";
    private static final int MAX_RECENT = 20;
    PropertyChangeListener timeSeriesBrowseListener;
    Caching caching = null;
    ProgressMonitor mon = null;
    protected List<Bookmark> recent = null;
    protected List<Bookmark> bookmarks = null;
    protected String vapFile = null;
    public static final String PROP_VAPFILE = "vapFile";
    private boolean autoRangeSuppress;
    private boolean restoringState = false;
    String embedDs = "";
    boolean embedDsDirty = false;
    boolean useEmbeddedDataSet = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setApplet(boolean v) {
        this.applet = v;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler eh) {
        this.exceptionHandler = eh;
        DasApplication.getDefaultApplication().setExceptionHandler(this.exceptionHandler);
        FileSystem.setExceptionHandler((ExceptionHandler)this.exceptionHandler);
        String cl = eh.getClass().getName();
        if (cl.equals("org.virbo.autoplot.scriptconsole.GuiExceptionHandler")) {
            try {
                Method m = eh.getClass().getMethod("setApplicationModel", ApplicationModel.class);
                m.invoke((Object)eh, this);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void showMessage(String message, String title, int messageType) {
        if (!"true".equals(AutoplotUtil.getProperty("java.awt.headless", "false"))) {
            Component p = SwingUtilities.getRoot((Component)this.canvas);
            if (p == null) {
                if (messageType == 2) {
                    System.err.println("WARNING: " + title + ": " + message);
                } else if (messageType == 1) {
                    System.err.println("INFO: " + title + ": " + message);
                } else {
                    System.err.println(title + ": " + message);
                }
            } else {
                JOptionPane.showMessageDialog(p, message, title, messageType);
            }
        } else if (messageType == 2) {
            System.err.println("WARNING: " + title + ": " + message);
        } else if (messageType == 1) {
            System.err.println("INFO: " + title + ": " + message);
        } else {
            System.err.println(title + ": " + message);
        }
    }

    public ApplicationModel() {
        DataSetURI.init();
        this.dom = new Application();
    }

    public void addDasPeersToApp() {
        if (!this.applet) {
            BeansUtil.registerEditor(RenderType.class, EnumerationEditor.class);
        }
        new ApplicationController(this, this.dom);
        this.canvas = this.dom.getController().addCanvas();
        this.application = this.canvas.getApplication();
        this.dom.getController().addPlotElement(null, null);
    }

    public DasCanvas getCanvas() {
        return this.dom.getController().getDasCanvas();
    }

    void setDataSet(QDataSet ds) {
        this.dom.getController().getPlotElement().getController().setResetRanges(true);
        this.dom.getController().getDataSourceFilter().getController().setDataSource(null);
        this.dom.getController().getDataSourceFilter().setUri("vap+internal:");
        this.dom.getController().getDataSourceFilter().getController().setDataSetInternal(null);
        this.dom.getController().getDataSourceFilter().getController().setDataSetInternal(ds);
    }

    public void setDataSet(int chNum, String label, QDataSet ds) {
        while (this.dom.getDataSourceFilters().length <= chNum) {
            Plot p = CanvasUtil.getMostBottomPlot(this.dom.getController().getCanvas());
            this.dom.getController().setPlot(p);
            this.dom.getController().addPlotElement(null, null);
        }
        DataSourceFilter dsf = this.dom.getDataSourceFilters(chNum);
        List<PlotElement> elements = this.dom.getController().getPlotElementsFor(dsf);
        dsf.getController().setDataSource(null);
        dsf.setUri("vap+internal:");
        dsf.getController().setDataSetInternal(null);
        dsf.getController().setDataSetInternal(ds);
        if (label != null) {
            for (PlotElement pe : elements) {
                pe.setLegendLabel(label);
                pe.setDisplayLegend(true);
            }
        }
    }

    public void setDataSet(int chNum, String label, String suri) {
        while (this.dom.getDataSourceFilters().length <= chNum) {
            Plot p = CanvasUtil.getMostBottomPlot(this.dom.getController().getCanvas());
            this.dom.getController().setPlot(p);
            this.dom.getController().addPlotElement(null, null);
        }
        DataSourceFilter dsf = this.dom.getDataSourceFilters(chNum);
        List<PlotElement> elements = this.dom.getController().getPlotElementsFor(dsf);
        for (PlotElement pe : elements) {
            pe.getController().setResetPlotElement(true);
            pe.getController().setResetComponent(true);
        }
        dsf.getController().setDataSource(null);
        dsf.setUri(suri);
        if (label != null) {
            for (PlotElement pe : elements) {
                pe.setLegendLabel(label);
                pe.setDisplayLegend(true);
            }
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dom.getController().getDataSourceFilter().getController().resetDataSource(false, dataSource);
    }

    public DataSource dataSource() {
        return this.dom.getController().getDataSourceFilter().getController().getDataSource();
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void resetDataSetSourceURL(String surl, ProgressMonitor mon) {
        block12: {
            if (surl == null) {
                return;
            }
            URISplit split = URISplit.parse((String)surl);
            surl = URISplit.format((URISplit)split);
            try {
                if (split.file != null && (split.file.endsWith(".vap") || split.file.endsWith(".vapx"))) {
                    try {
                        URI uri = DataSetURI.getURIValid((String)surl);
                        mon.started();
                        mon.setProgressMessage("loading vap file");
                        File openable = DataSetURI.getFile((URI)uri, (ProgressMonitor)this.application.getMonitorFactory().getMonitor(this.canvas, "loading vap", ""));
                        if (split.params != null) {
                            LinkedHashMap params = URISplit.parseParams((String)split.params);
                            if (params.containsKey("timerange") && !params.containsKey("timeRange")) {
                                params.put("timeRange", params.remove("timerange"));
                            }
                            this.doOpen(openable, (LinkedHashMap<String, String>)params);
                        } else {
                            this.doOpen(openable);
                        }
                        mon.setProgressMessage("done loading vap file");
                        mon.finished();
                        this.addRecent(surl);
                        break block12;
                    }
                    catch (HtmlResponseIOException ex) {
                        URL url = ex.getURL();
                        if (url == null) {
                            url = new URL(DataSetURI.getURIValid((String)surl).getSchemeSpecificPart());
                        }
                        HtmlResponseIOException neww = new HtmlResponseIOException(ex.getMessage(), url);
                        throw new RuntimeException(neww);
                    }
                    catch (IOException ex) {
                        mon.finished();
                        throw new RuntimeException(ex);
                    }
                }
                this.dom.getController().setFocusUri(null);
                this.dom.getController().setFocusUri(surl);
                this.getDataSourceFilterController().resetSuri(surl, mon);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setDataSourceURL(String surl) {
        String oldVal = this.dom.getController().getDataSourceFilter().getUri();
        if (surl == null && oldVal == null) {
            return;
        }
        if (surl != null && surl.equals(oldVal)) {
            return;
        }
        this.resetDataSetSourceURL(surl, (ProgressMonitor)new NullProgressMonitor());
    }

    public String getDataSourceURL() {
        return this.dom.getController().getDataSourceFilter().getUri();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Bookmark> getRecent() {
        boolean ok;
        if (this.recent != null) {
            return this.recent;
        }
        String nodeName = "recent";
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        File f = new File(f2, nodeName + ".xml");
        if (f.exists()) {
            try {
                this.recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new FileInputStream(f)).getDocumentElement());
                return this.recent;
            }
            catch (SAXException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                return new ArrayList<Bookmark>();
            }
            catch (IOException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                return new ArrayList<Bookmark>();
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                return new ArrayList<Bookmark>();
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(ApplicationModel.class);
        String srecent = prefs.get("recent", "");
        if (srecent.equals("") || !srecent.startsWith("<")) {
            String srecenturl = AutoplotUtil.getProperty("autoplot.default.recent", "");
            if (srecenturl.equals("")) return new ArrayList<Bookmark>();
            try {
                URL url = new URL(srecenturl);
                this.recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(url.openStream()).getDocumentElement());
                prefs.put("recent", Bookmark.formatBooks(this.recent));
                try {
                    prefs.flush();
                }
                catch (BackingStoreException ex) {
                    ex.printStackTrace();
                }
            }
            catch (MalformedURLException e) {
                return new ArrayList<Bookmark>();
            }
            catch (IOException e) {
                return new ArrayList<Bookmark>();
            }
            catch (SAXException e) {
                return new ArrayList<Bookmark>();
            }
            catch (ParserConfigurationException e) {
                return new ArrayList<Bookmark>();
            }
        } else {
            try {
                this.recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new ByteArrayInputStream(srecent.getBytes())).getDocumentElement());
            }
            catch (SAXException e) {
                return new ArrayList<Bookmark>();
            }
            catch (IOException e) {
                return new ArrayList<Bookmark>();
            }
            catch (ParserConfigurationException e) {
                return new ArrayList<Bookmark>();
            }
        }
        this.addRecent("");
        return this.recent;
    }

    public List<Bookmark> getLegacyBookmarks() {
        Preferences prefs = Preferences.userNodeForPackage(ApplicationModel.class);
        String sbookmark = prefs.get(PROPERTY_BOOKMARKS, "");
        if (sbookmark.equals("") || !sbookmark.startsWith("<")) {
            String surl = AutoplotUtil.getProperty("autoplot.default.bookmarks", "http://autoplot.org/data/demos.xml");
            if (!surl.equals("")) {
                try {
                    URL url = new URL(surl);
                    this.bookmarks = Bookmark.parseBookmarks(AutoplotUtil.readDoc(url.openStream()).getDocumentElement());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ArrayList<Bookmark>();
                }
            }
        } else {
            try {
                this.bookmarks = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new ByteArrayInputStream(sbookmark.getBytes())).getDocumentElement());
            }
            catch (SAXException e) {
                System.err.println(sbookmark);
                e.printStackTrace();
                return new ArrayList<Bookmark>();
            }
            catch (Exception e) {
                System.err.println(sbookmark);
                e.printStackTrace();
                return new ArrayList<Bookmark>();
            }
        }
        return this.bookmarks;
    }

    public void addException(String surl, Exception exx) {
        block9: {
            try {
                boolean ok;
                if (!DasApplication.hasAllPermission()) {
                    return;
                }
                if (!"jbf".equals(System.getProperty("user.name"))) {
                    return;
                }
                File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
                if (!f2.exists() && !(ok = f2.mkdirs())) {
                    throw new RuntimeException("unable to create folder " + f2);
                }
                File f3 = new File(f2, "exceptions.txt");
                FileWriter out3 = null;
                try {
                    out3 = new FileWriter(f3, true);
                    TimeParser tp = TimeParser.create((String)"%Y-%m-%dT%H:%M:%S.%{milli}Z");
                    Datum now = Units.t1970.createDatum((double)System.currentTimeMillis() / 1000.0);
                    out3.append("=== " + tp.format(now, null) + " ===\n");
                    out3.append(surl + "\n");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exx.printStackTrace(pw);
                    out3.append(sw.toString());
                    out3.append("\n");
                    out3.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (out3 == null) break block9;
                    try {
                        out3.close();
                    }
                    catch (IOException ex1) {
                        Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecent(String surl) {
        ArrayList<Bookmark> newValue;
        List<Bookmark> oldValue;
        block24: {
            boolean ok;
            if (!DasApplication.hasAllPermission()) {
                return;
            }
            if (surl.contains("nohistory=true")) {
                System.err.println("Not logging URI because it contains nohistory=true");
                return;
            }
            if (this.recent == null) {
                this.recent = new ArrayList<Bookmark>();
            }
            oldValue = Collections.unmodifiableList(this.recent);
            newValue = new ArrayList<Bookmark>(this.recent);
            if (!surl.equals("")) {
                Bookmark.Item book = new Bookmark.Item(surl);
                if (newValue.contains(book)) {
                    newValue.remove(book);
                }
                newValue.add(book);
            }
            while (newValue.size() > 20) {
                newValue.remove(0);
            }
            String nodeName = "recent";
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            File f = new File(f2, nodeName + ".xml");
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(f);
                Bookmark.formatBooks(out, newValue);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            File f3 = new File(f2, "history.txt");
            FileWriter out3 = null;
            try {
                out3 = new FileWriter(f3, true);
                TimeParser tp = TimeParser.create((String)"%Y-%m-%dT%H:%M:%S.%{milli}Z");
                Datum now = Units.t1970.createDatum((double)System.currentTimeMillis() / 1000.0);
                out3.append(tp.format(now, null) + "\t" + surl + "\n");
                out3.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                if (out3 == null) break block24;
                try {
                    out3.close();
                }
                catch (IOException ex1) {
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
        }
        this.recent = newValue;
        this.propertyChangeSupport.firePropertyChange("recent", oldValue, this.recent);
    }

    public Bookmark addBookmark(String surl) {
        ArrayList<Bookmark> newValue;
        String autoTitle;
        Bookmark.Item item = new Bookmark.Item(surl);
        URISplit split = URISplit.parse((String)surl);
        String string = autoTitle = split.file == null ? surl : split.file.substring(split.path.length());
        if (autoTitle.length() == 0) {
            autoTitle = surl;
        }
        item.setTitle(autoTitle);
        List oldValue = Collections.unmodifiableList(new ArrayList());
        if (this.bookmarks == null) {
            this.bookmarks = new ArrayList<Bookmark>();
        }
        if ((newValue = new ArrayList<Bookmark>(this.bookmarks)).contains(item)) {
            Bookmark.Item old;
            item = old = (Bookmark.Item)newValue.get(newValue.indexOf(item));
            newValue.remove(old);
        }
        newValue.add(item);
        this.bookmarks = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_BOOKMARKS, oldValue, this.bookmarks);
        return item;
    }

    public void exit() {
    }

    void resetZoom() {
        this.dom.getController().getPlot().getController().resetZoom(true, true, true);
    }

    private int stepForSize(int size) {
        int step = size < 20 ? 1 : (size < 40 ? 2 : 4);
        return step;
    }

    void increaseFontSize() {
        Font f = Font.decode(this.dom.getOptions().getCanvasFont());
        int size = f.getSize();
        int step = this.stepForSize(size);
        f = f.deriveFont((float)size + (float)step);
        this.dom.getOptions().setCanvasFont(DomUtil.encodeFont(f));
    }

    void decreaseFontSize() {
        Font f = Font.decode(this.dom.getOptions().getCanvasFont());
        int size = f.getSize();
        int step = this.stepForSize(size);
        f = f.deriveFont((float)size - (float)step);
        this.dom.getOptions().setCanvasFont(DomUtil.encodeFont(f));
    }

    public Application createState(boolean deep) {
        Application state = (Application)this.dom.copy();
        return state;
    }

    public static BufferedImage resizeImageTo(BufferedImage im, int hf) {
        int h0 = im.getHeight();
        double aspect = 1.0 * (double)h0 / (double)im.getWidth();
        int h = h0 / 2;
        BufferedImage thumb = null;
        h = hf * (int)Math.pow(2.0, (int)Math.ceil(Math.log10(1.0 * (double)h0 / (double)hf) / Math.log10(2.0)));
        if (h == h0) {
            h = h0 / 2;
        }
        while (h >= hf) {
            thumb = new BufferedImage((int)((double)h / aspect), h, 2);
            Graphics2D g = (Graphics2D)thumb.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform tx = new AffineTransform();
            double scale = 1.0 * (double)h / (double)h0;
            tx.scale(scale, scale);
            g.drawImage(im, tx, null);
            if (h == hf) break;
            h0 = h;
            h = hf < h0 / 2 ? h0 / 2 : hf;
            im = thumb;
        }
        return thumb;
    }

    public void thickenLines(BufferedImage im) {
        int bc = im.getRGB(0, 0);
        for (int i = 0; i < im.getWidth() - 4; ++i) {
            for (int j = 0; j < im.getHeight() - 4; ++j) {
                int c0 = im.getRGB(i, j);
                if (c0 != bc) continue;
                int c = im.getRGB(i + 1, j);
                if (c != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i + 2, j)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i + 3, j)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i + 4, j)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 1)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 2)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 3)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 4)) == bc) continue;
                im.setRGB(i, j, c);
            }
        }
    }

    public BufferedImage getThumbnail(int height) {
        BufferedImage im = (BufferedImage)this.getCanvas().getImage(this.getCanvas().getWidth(), this.getCanvas().getHeight());
        if (im.getHeight() / height > 3) {
            this.thickenLines(im);
        }
        BufferedImage thumb = ApplicationModel.resizeImageTo(im, height);
        return thumb;
    }

    public void restoreState(Application state) {
        boolean resetFocus = DomUtil.structureChanges(state, this.dom);
        this.dom.syncTo(state);
        if (resetFocus) {
            this.dom.getController().setPlot(this.dom.getPlots(0));
        }
    }

    void doSave(File f) throws IOException {
        StatePersistence.saveState(f, (Object)this.createState(true), "");
        this.setUseEmbeddedDataSet(false);
        this.setVapFile(f.toString());
        this.addRecent(f.toString());
    }

    void doSave(File f, String scheme) throws IOException {
        StatePersistence.saveState(f, (Object)this.createState(true), scheme);
        this.setUseEmbeddedDataSet(false);
        this.setVapFile(f.toString());
        this.addRecent(f.toString());
    }

    private void makeValid(Application state) {
        if (state.getController() != null) {
            throw new IllegalArgumentException("state must not have controller");
        }
        Canvas c = state.getCanvases(0);
        if (c.getMarginRow().getId().equals("")) {
            c.getMarginRow().setId("marginRow_0");
        }
        if (c.getMarginColumn().getId().equals("")) {
            c.getMarginColumn().setId("marginColumn_0");
        }
        if (state.getPlots(0).getRowId().equals("")) {
            int n = state.getPlots().length;
            Row[] rows = new Row[n];
            for (int i = 0; i < n; ++i) {
                Row r = new Row();
                r.setBottom("" + (double)((i + 1) * 10000) / 100.0 / (double)n + "%-2.0em");
                r.setTop("" + (double)(i * 10000) / 100.0 / (double)n + "%+2.0em");
                r.setParent(c.getMarginRow().getId());
                r.setId("row_" + i);
                state.getPlots(i).setRowId(r.getId());
                state.getPlots(i).setColumnId(c.getMarginColumn().getId());
                rows[i] = r;
            }
            c.setRows(rows);
        }
        for (BindingModel m : state.getBindings()) {
            DomNode src = DomUtil.getElementById(state, m.getSrcId());
            DomNode dst = DomUtil.getElementById(state, m.getDstId());
            if (src == null || dst == null) {
                System.err.println("invalid binding:" + m);
                continue;
            }
            BeanProperty srcProp = BeanProperty.create((String)m.getSrcProperty());
            BeanProperty dstProp = BeanProperty.create((String)m.getDstProperty());
            Object srcVal = srcProp.getValue((Object)src);
            Object dstVal = dstProp.getValue((Object)dst);
            if (srcVal == null && dstVal == null || srcVal == null || dstVal == null || srcVal.equals(dstVal)) continue;
            System.err.println("fixing inconsistent vap where bound values were not equal: " + m.getSrcId() + "." + m.getSrcProperty() + "!=" + m.getDstId() + "." + m.getDstProperty());
            BeanProperty.create((String)m.getDstProperty()).setValue((Object)dst, srcVal);
        }
    }

    private void doBindings(Application state) {
        for (BindingModel m : state.getBindings()) {
            DomNode src = DomUtil.getElementById(state, m.getSrcId());
            DomNode dst = DomUtil.getElementById(state, m.getDstId());
            AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)BeanProperty.create((String)m.getSrcProperty()), (Object)dst, (Property)BeanProperty.create((String)m.getDstProperty()));
            binding.bind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOpen(File f, LinkedHashMap<String, String> deltas) throws IOException {
        if (!f.exists()) {
            throw new IllegalArgumentException("no such file: " + f);
        }
        if (f.length() == 0L) {
            throw new IllegalArgumentException("zero-length file: " + f);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            this.doOpen(in, deltas);
            this.setVapFile(f.toString());
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    void doOpen(InputStream in, LinkedHashMap<String, String> deltas) throws IOException {
        Application state = (Application)StatePersistence.restoreState(in);
        this.makeValid(state);
        if (deltas != null) {
            this.doBindings(state);
            for (Map.Entry<String, String> e : deltas.entrySet()) {
                Class c;
                logger.log(Level.FINEST, "applying to vap {0}={1}", new Object[]{e.getKey(), e.getValue()});
                String node = e.getKey();
                String sval = e.getValue();
                try {
                    c = DomUtil.getPropertyType(state, node);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                SerializeDelegate sd = SerializeRegistry.getDelegate((Class)c);
                if (sd == null) {
                    System.err.println("unable to find serialize delegate for " + c.getCanonicalName());
                    continue;
                }
                try {
                    if (c == String.class && sval.length() > 1 && sval.startsWith("'") && sval.endsWith("'")) {
                        sval = sval.substring(1, sval.length() - 1);
                    }
                    Object val = sd.parse(sd.typeId(c), sval);
                    DomUtil.setPropertyValue(state, node, val);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (DomUtil.structureChanges(this.dom, state)) {
            this.dom.getController().reset();
        }
        this.restoreState(state);
        this.setUseEmbeddedDataSet(false);
    }

    void doOpen(File f) throws IOException {
        this.doOpen(f, null);
    }

    public String getVapFile() {
        return this.vapFile;
    }

    public void setVapFile(String vapFile) {
        String old = this.vapFile;
        this.vapFile = vapFile;
        if (vapFile == null) {
            this.propertyChangeSupport.firePropertyChange(PROP_VAPFILE, old, null);
        } else {
            this.propertyChangeSupport.firePropertyChange(PROP_VAPFILE, null, vapFile);
        }
    }

    public void doAutoLayout() {
        ApplicationModel model = this;
        ApplicationController applicationController = this.getDocumentModel().getController();
        model.dom.getController().getCanvas().getController().performingChange(this, "autolayout");
        LayoutUtil.autolayout(applicationController.getDasCanvas(), applicationController.getRow(), applicationController.getColumn());
        model.dom.getController().getCanvas().getController().changePerformed(this, "autolayout");
    }

    public boolean isAutoRangeSuppress() {
        return this.autoRangeSuppress;
    }

    public void setAutoRangeSuppress(boolean autoRangeSuppress) {
        this.autoRangeSuppress = autoRangeSuppress;
    }

    public boolean isRestoringState() {
        return this.restoringState;
    }

    public void setRestoringState(boolean b) {
        this.restoringState = b;
    }

    public String getEmbeddedDataSet() {
        if (this.isUseEmbeddedDataSet() && this.embedDsDirty) {
            this.packEmbeddedDataSet();
        }
        return this.embedDs;
    }

    private void packEmbeddedDataSet() {
        try {
            ByteArrayOutputStream out;
            if (this.dom.getController().getDataSourceFilter().getController().getDataSet() == null) {
                this.embedDs = "";
                return;
            }
            ByteArrayOutputStream dos = out = new ByteArrayOutputStream(10000);
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            format.format(this.dom.getController().getDataSourceFilter().getController().getDataSet(), (OutputStream)dos, false);
            ((OutputStream)dos).close();
            byte[] data = Base64.encodeBytes((byte[])out.toByteArray()).getBytes();
            this.embedDs = new String(data);
            this.embedDsDirty = false;
        }
        catch (StreamException ex) {
            Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setEmbeddedDataSet(String dataset) {
        this.embedDs = dataset;
        if (this.useEmbeddedDataSet && !this.embedDsDirty) {
            this.unpackEmbeddedDataSet();
        }
    }

    private void unpackEmbeddedDataSet() {
        if (this.embedDs == null || this.embedDs.equals("")) {
            return;
        }
        byte[] data = Base64.decode((String)this.embedDs);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ReadableByteChannel ich = Channels.newChannel(in);
        QDataSetStreamHandler handler = new QDataSetStreamHandler();
        try {
            StreamTool.readStream((ReadableByteChannel)ich, (StreamHandler)handler);
            this.getDataSourceFilterController().setDataSetInternal(handler.getDataSet());
        }
        catch (StreamException ex) {
            Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isUseEmbeddedDataSet() {
        return this.useEmbeddedDataSet;
    }

    public void setUseEmbeddedDataSet(boolean use) {
        this.useEmbeddedDataSet = use;
        if (use && !this.embedDsDirty) {
            this.unpackEmbeddedDataSet();
        }
    }

    boolean clearCache() throws IllegalArgumentException {
        File local = new File(AutoplotSettings.settings().resolveProperty("fscache"));
        if (local != null) {
            boolean okay = true;
            okay = okay && Util.deleteFileTree(new File(local, "http"));
            okay = okay && Util.deleteFileTree(new File(local, "https"));
            okay = okay && Util.deleteFileTree(new File(local, "ftp"));
            okay = okay && Util.deleteFileTree(new File(local, "zip"));
            okay = okay && Util.deleteFileTree(new File(local, "vfsCache"));
            okay = okay && Util.deleteFileTree(new File(local, "fscache"));
            return okay;
        }
        return true;
    }

    boolean moveCache(File n) {
        File local = new File(AutoplotSettings.settings().resolveProperty("fscache"));
        boolean y = Util.copyFileTree(local, n);
        if (y) {
            JOptionPane.showMessageDialog((Component)this.getCanvas(), "<html>File cache moved to<br>" + n + ".<br>The old cache (" + local + ") still contains data<br>and should manually be deleted.</html>", "Files moved", -1);
            AutoplotSettings.settings().setFscache(n.toString());
        }
        return y;
    }

    public void waitUntilIdle(boolean runtimeException) throws InterruptedException {
        logger.log(Level.FINE, "enter waitUntilIdle, pendingChanges={0}", this.dom.getController().isPendingChanges());
        while (this.dom.getController().isPendingChanges()) {
            this.dom.getController().waitUntilIdle();
            logger.fine("waiting for canvas");
            this.canvas.waitUntilIdle();
        }
        this.canvas.waitUntilIdle();
        logger.fine("done waiting");
    }

    public Application getDocumentModel() {
        return this.dom;
    }

    public DataSourceController getDataSourceFilterController() {
        return this.dom.getController().getDataSourceFilter().getController();
    }
}

