/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.EventsRenderer;
import org.das2.graph.ImageVectorDataSetRenderer;
import org.das2.graph.PitchAngleDistributionRenderer;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.RenderTypeUtil;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.dom.Options;
import org.virbo.autoplot.dom.OptionsPrefsController;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoplotUtil {
    private static final Logger log = Logger.getLogger("virbo.autoplot.AutoRangeDescriptor.autoRange");
    public static final int DS_LENGTH_LIMIT = 10000000;
    private static final Logger logger = Logger.getLogger("virbo.autoplot.AutoplotUtil");

    static DasPlot createPlot(DasCanvas c, QDataSet ds, DasPlot recyclable, DasColorBar cb) {
        DasRow row = DasRow.create((DasCanvas)c);
        DasColumn col = DasColumn.create((DasCanvas)c);
        DasPlot result = recyclable != null ? recyclable : DasPlot.createDummyPlot();
        List<Renderer> recycleRends = Arrays.asList(result.getRenderers());
        RenderType type = AutoplotUtil.guessRenderType(ds);
        Renderer rend1 = AutoplotUtil.maybeCreateRenderer(type, recycleRends.get(0), cb, false);
        if (cb != null && RenderTypeUtil.needsColorbar(type)) {
            cb.setVisible(true);
        }
        result.addRenderer(rend1);
        c.add((DasCanvasComponent)result, row, col);
        c.revalidate();
        c.validate();
        System.err.println(c.getBounds());
        System.err.println(row);
        result.resize();
        System.err.println(result.getBounds());
        return result;
    }

    public static ImageIcon scaleIcon(ImageIcon icon, int w, int h) {
        double aspect = (double)icon.getIconHeight() / (double)icon.getIconWidth();
        if (h == -1) {
            h = (int)((double)w * aspect);
        } else if (w == -1) {
            w = (int)((double)h / aspect);
        }
        BufferedImage image = (BufferedImage)icon.getImage();
        return new ImageIcon(AutoplotUtil.scaleImage(image, w, h));
    }

    public static BufferedImage scaleImage(BufferedImage image, int w, int h) {
        BufferedImage result = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setTransform(AffineTransform.getScaleInstance((double)w / (double)image.getWidth(), (double)h / (double)image.getHeight()));
        g2.drawImage((Image)image, 0, 0, null);
        return result;
    }

    public static List<String> getUrls(List<Bookmark> recent) {
        ArrayList<String> urls = new ArrayList<String>(recent.size());
        for (Bookmark b : recent) {
            if (!(b instanceof Bookmark.Item)) continue;
            urls.add(((Bookmark.Item)b).getUri());
        }
        return urls;
    }

    private static DatumRange getRange(Number min, Number max, Units units) {
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            if (min == null) {
                min = Units.mj1958.convertDoubleTo(units, -100000.0);
            }
            if (max == null) {
                max = Units.mj1958.convertDoubleTo(units, 100000.0);
            }
        } else {
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            if (units == null) {
                units = Units.dimensionless;
            }
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            TimeLocationUnits tu = (TimeLocationUnits)units;
            if (!tu.isValid(min.doubleValue())) {
                min = tu.validMin();
            }
            if (!tu.isValid(max.doubleValue())) {
                max = tu.validMax();
            }
            return new DatumRange(min.doubleValue(), max.doubleValue(), units);
        }
        try {
            return new DatumRange(min.doubleValue(), max.doubleValue(), units);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("here here");
            throw ex;
        }
    }

    private static DatumRange makeDimensionless(DatumRange dr) {
        Units u = dr.getUnits();
        return new DatumRange(dr.min().doubleValue(u), dr.max().doubleValue(u), Units.dimensionless);
    }

    public static AutoRangeDescriptor autoRange(QDataSet hist, QDataSet ds, Map properties) {
        double[] dd;
        log.fine("enter autoRange " + ds);
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        AutoRangeDescriptor result = new AutoRangeDescriptor();
        boolean mono = Boolean.TRUE.equals(ds.property("MONOTONIC")) || null != ds.property("CADENCE");
        long total = (Long)((Map)hist.property("USER_PROPERTIES")).get("total");
        double median = Double.NaN;
        if (mono) {
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)ds, null);
            if (cadence == null || cadence.value() > 1.7976931348623156E306) {
                cadence = DRank0DataSet.create((double)0.0);
            }
            if (ds.length() > 1) {
                double min = Math.min(ds.value(0), ds.value(ds.length() - 1));
                double max = Math.max(ds.value(0), ds.value(ds.length() - 1));
                double dcadence = Math.abs(cadence.value());
                if ("log".equals(cadence.property("SCALE_TYPE"))) {
                    Units cu = (Units)cadence.property("UNITS");
                    double factor = (cu.convertDoubleTo(Units.percentIncrease, dcadence) + 100.0) / 100.0;
                    dd = new double[]{min / factor, max * factor};
                } else {
                    dd = new double[]{min - dcadence, max + dcadence};
                }
            } else {
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
            median = (dd[0] + dd[1]) / 2.0;
        } else {
            dd = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
            QDataSet dep0 = (QDataSet)hist.property("DEPEND_0");
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)dep0, null);
            int tot = 0;
            for (int i = 0; i < hist.length(); ++i) {
                tot = (int)((double)tot + hist.value(i));
                if (dd[0] == Double.NEGATIVE_INFINITY && hist.value(i) > 0.0) {
                    dd[0] = dep0.value(i);
                }
                if (hist.value(i) > 0.0) {
                    dd[1] = dep0.value(i) + cadence.value();
                }
                if ((long)tot < total / 2L) continue;
                median = dep0.value(i);
            }
        }
        if (total < 3L) {
            result.median = median;
            result.range = DatumRange.newDatumRange((double)dd[0], (double)dd[1], (Units)u);
            result.robustMin = dd[0];
            result.robustMax = dd[1];
        } else {
            double clog;
            double nomMax;
            double nomMin;
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (mono) {
                nomMin = ds.value(0);
                nomMax = ds.value(ds.length() - 1);
            } else {
                nomMin = dd[0];
                nomMax = dd[1];
            }
            double clin = (nomMax - result.median) / (result.median - nomMin);
            if (clin > 1.0) {
                clin = 1.0 / clin;
            }
            if ((clog = nomMax / result.median / Math.abs(result.median / nomMin)) > 1.0) {
                clog = 1.0 / clog;
            }
            if (clog > clin && nomMax / nomMin > 100.0) {
                result.log = true;
            }
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        if ("log".equals(ds.property("SCALE_TYPE"))) {
            result.log = true;
        }
        if (properties != null) {
            String log1 = (String)properties.get("SCALE_TYPE");
            if (log1 != null) {
                result.log = log1.equals("log");
            }
            Number tmin = (Number)properties.get("TYPICAL_MIN");
            Number tmax = (Number)properties.get("TYPICAL_MAX");
            DatumRange range = AutoplotUtil.getRange((Number)properties.get("TYPICAL_MIN"), (Number)properties.get("TYPICAL_MAX"), (Units)properties.get("UNITS"));
            if (tmin != null || tmax != null) {
                double d2;
                double d1;
                if (result.log) {
                    try {
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                        d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoplotUtil.makeDimensionless(range);
                        result.range = AutoplotUtil.makeDimensionless(result.range);
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                        d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                    }
                } else {
                    try {
                        d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                        d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoplotUtil.makeDimensionless(range);
                        result.range = AutoplotUtil.makeDimensionless(result.range);
                        d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                        d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                    }
                }
                if (d2 - d1 > 0.1 && d2 > 0.0 && d1 < 1.0) {
                    result.range = range;
                    return result;
                }
            }
        }
        if (UnitsUtil.isRatioMeasurement((Units)u) || UnitsUtil.isIntervalMeasurement((Units)u)) {
            if (result.log) {
                if (result.robustMin <= 0.0) {
                    result.robustMin = result.robustMax / 1000.0;
                }
                result.range = DatumRange.newDatumRange((double)Math.pow(10.0, Math.floor(Math.log10(result.robustMin))), (double)Math.pow(10.0, Math.ceil(Math.log10(result.robustMax))), (Units)u);
            } else {
                result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
                if (result.robustMin < result.robustMax) {
                    result.range = DatumRangeUtil.rescale((DatumRange)result.range, (double)-0.05, (double)1.05);
                }
                if (result.robustMin == 0.0 && result.robustMax == 0.0) {
                    result.range = DatumRange.newDatumRange((double)-0.1, (double)1.0, (Units)u);
                }
            }
        } else {
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        log.fine("exit autoRange");
        return result;
    }

    public static QDataSet toDataSet(AutoRangeDescriptor ard) {
        DDataSet result = DDataSet.createRank1((int)2);
        Units u = ard.range.getUnits();
        if (u == null) {
            u = Units.dimensionless;
        }
        result.putValue(0, ard.range.min().doubleValue(u));
        result.putValue(1, ard.range.max().doubleValue(u));
        result.putProperty("BINS_0", (Object)"min,max");
        if (ard.log) {
            result.putProperty("SCALE_TYPE", (Object)"log");
        }
        if (u != Units.dimensionless) {
            result.putProperty("UNITS", (Object)u);
        }
        return result;
    }

    public static AutoRangeDescriptor autoRange(QDataSet ds, Map properties) {
        int total;
        double positiveMin;
        double median;
        double[] dd;
        log.fine("enter autoRange " + ds);
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            if (ds.property("JOIN_0") != null) {
                if (ds.length() == 0) {
                    throw new IllegalArgumentException("dataset is empty");
                }
                u = (Units)ds.property("UNITS", 0);
            }
            if (u == null) {
                u = Units.dimensionless;
            }
        }
        AutoRangeDescriptor result = new AutoRangeDescriptor();
        if (UnitsUtil.isOrdinalMeasurement((Units)u) || UnitsUtil.isNominalMeasurement((Units)u)) {
            QDataSet ext = Ops.extent((QDataSet)ds);
            result.range = DataSetUtil.asDatumRange((QDataSet)ext, (boolean)true);
            result.robustMin = result.range.min().doubleValue(u);
            result.robustMax = result.range.max().doubleValue(u);
            return result;
        }
        boolean mono = Boolean.TRUE.equals(ds.property("MONOTONIC"));
        if (null != ds.property("CADENCE") && DataSetUtil.isMonotonic((QDataSet)ds)) {
            mono = true;
        }
        AutoRangeDescriptor typical = null;
        boolean isLog = "log".equals(ds.property("SCALE_TYPE")) && !UnitsUtil.isTimeLocation((Units)u);
        Number typicalMin = (Number)ds.property("TYPICAL_MIN");
        Number typicalMax = (Number)ds.property("TYPICAL_MAX");
        if (typicalMin != null) {
            typical = new AutoRangeDescriptor();
            typical.range = new DatumRange(typicalMin.doubleValue(), typicalMax.doubleValue(), u);
            typical.log = isLog;
        }
        if (properties != null && "log".equals(properties.get("SCALE_TYPE"))) {
            isLog = true;
        }
        if (typical == null && SemanticOps.isJoin((QDataSet)ds)) {
            result.range = null;
            result.robustMax = -1.7976931348623157E308;
            result.robustMin = Double.MAX_VALUE;
            Units units = null;
            UnitsConverter uc = UnitsConverter.IDENTITY;
            for (int i = 0; i < ds.length(); ++i) {
                AutoRangeDescriptor r1 = AutoplotUtil.autoRange(ds.slice(i), properties);
                if (units == null) {
                    units = r1.range.getUnits();
                } else {
                    uc = r1.range.getUnits().getConverter(units);
                }
                DatumRange datumRange = result.range = result.range == null ? r1.range : DatumRangeUtil.union((DatumRange)result.range, (DatumRange)r1.range);
                if (!r1.log) continue;
                result.log = true;
            }
            result.robustMin = result.range.min().doubleValue(result.range.getUnits());
            result.robustMax = result.range.max().doubleValue(result.range.getUnits());
            return result;
        }
        if (mono) {
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)ds, null);
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds);
            if (cadence == null || cadence.value() > 1.7976931348623156E306) {
                cadence = DRank0DataSet.create((double)0.0);
            }
            if (ds.length() > 1) {
                int lastValid;
                int firstValid;
                for (firstValid = 0; firstValid < wds.length() && wds.value(firstValid) == 0.0; ++firstValid) {
                }
                if (firstValid == wds.length()) {
                    throw new IllegalArgumentException("data contains no valid measurements");
                }
                for (lastValid = wds.length() - 1; lastValid >= 0 && wds.value(lastValid) == 0.0; --lastValid) {
                }
                if (lastValid - firstValid + 1 == 0) {
                    System.err.println("special case where monotonic dataset contains no valid data");
                    dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
                } else {
                    double min = Math.min(ds.value(firstValid), ds.value(lastValid));
                    double max = Math.max(ds.value(firstValid), ds.value(lastValid));
                    double dcadence = Math.abs(cadence.value());
                    if (isLog) {
                        Units cu = (Units)cadence.property("UNITS");
                        if (cu == null) {
                            cu = Units.dimensionless;
                        }
                        if (UnitsUtil.isRatiometric((Units)cu)) {
                            double factor = (cu.convertDoubleTo(Units.percentIncrease, dcadence) + 100.0) / 100.0;
                            dd = new double[]{min / factor, max * factor};
                        } else if (cu.isConvertableTo(u.getOffsetUnits())) {
                            dcadence = cu.convertDoubleTo(u.getOffsetUnits(), dcadence);
                            double[] dArray = new double[]{min - dcadence, max + dcadence};
                            dd = dArray;
                            if (dd[0] < 0.0) {
                                dd[0] = min / 2.0;
                            }
                        } else {
                            dd = new double[]{min, max};
                        }
                    } else {
                        dd = new double[]{min - dcadence, max + dcadence};
                    }
                }
            } else {
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
        } else {
            try {
                dd = AutoplotUtil.simpleRange(ds);
                if (Units.dimensionless.isFill(dd[0])) {
                    dd[0] = dd[0] / 100.0;
                }
                if (Units.dimensionless.isFill(dd[1])) {
                    dd[1] = dd[1] / 100.0;
                }
            }
            catch (IllegalArgumentException ex) {
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
        }
        if (UnitsUtil.isTimeLocation((Units)u) && dd[0] == dd[1]) {
            Units du = u.getOffsetUnits();
            double d = Units.days.convertDoubleTo(du, 1.0);
            dd[0] = Math.floor(dd[0] / d) * d;
            dd[1] = dd[0] + d;
        }
        boolean isHist = false;
        if (dd[0] == dd[1]) {
            if (dd[0] == 0.0) {
                dd[0] = -1.0;
                dd[1] = 1.0;
            } else if (dd[0] > 0.0) {
                dd[0] = 0.0;
            } else {
                dd[1] = 0.0;
            }
            median = (dd[0] + dd[1]) / 2.0;
            positiveMin = dd[0] + (dd[1] - dd[0]) * 0.1;
            total = ds.length();
        } else {
            isHist = "stairSteps".equals(ds.property("RENDER_TYPE"));
            QDataSet hist = DataSetOps.histogram((QDataSet)ds, (double)dd[0], (double)(dd[1] + (dd[1] - dd[0]) * 0.01), (double)((dd[1] - dd[0]) / 100.0));
            positiveMin = (Double)hist.property("positiveMin");
            total = 0;
            for (int i = 0; i < hist.length(); ++i) {
                total = (int)((double)total + hist.value(i));
            }
            median = u.getFillDouble();
            int total50 = 0;
            for (int i = 0; i < hist.length(); ++i) {
                if ((total50 = (int)((double)total50 + hist.value(i))) < total / 2) continue;
                median = ((QDataSet)hist.property("DEPEND_0")).value(i);
                break;
            }
        }
        if (total < 3) {
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (UnitsUtil.isTimeLocation((Units)u)) {
                double dmin = TimeUtil.createTimeDatum((int)1000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                double dmax = TimeUtil.createTimeDatum((int)9000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                if (result.robustMin > dmax) {
                    result.robustMin = dmax;
                }
                if (result.robustMin < dmin) {
                    result.robustMin = dmin;
                }
                if (result.robustMax > dmax) {
                    result.robustMax = dmax;
                }
                if (result.robustMax < dmin) {
                    result.robustMax = dmin;
                }
            }
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        } else {
            double nomMax;
            double nomMin;
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (mono) {
                nomMin = ds.value(0);
                nomMax = ds.value(ds.length() - 1);
            } else {
                nomMin = dd[0];
                nomMax = dd[1];
            }
            double clin = (nomMax - result.median) / (result.median - nomMin);
            if (clin > 1.0) {
                clin = 1.0 / clin;
            }
            if (result.median > 0.0 && !UnitsUtil.isTimeLocation((Units)u)) {
                double clog = nomMax / result.median / Math.abs(result.median / nomMin);
                if (clog > 1.0) {
                    clog = 1.0 / clog;
                }
                if (clog > clin && nomMax / nomMin > 100.0) {
                    isLog = true;
                }
            }
            if (!isHist && result.median == 0.0 && nomMin == 0.0 && nomMax / positiveMin > 1000.0) {
                isLog = true;
                result.robustMin = positiveMin / 10.0;
            }
            if (UnitsUtil.isTimeLocation((Units)u)) {
                double dmin = TimeUtil.createTimeDatum((int)1000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                double dmax = TimeUtil.createTimeDatum((int)9000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                if (result.robustMin > dmax) {
                    result.robustMin = dmax;
                }
                if (result.robustMin < dmin) {
                    result.robustMin = dmin;
                }
                if (result.robustMax > dmax) {
                    result.robustMax = dmax;
                }
                if (result.robustMax < dmin) {
                    result.robustMax = dmin;
                }
            }
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        result.log = isLog;
        if (properties != null) {
            Number tmin = (Number)properties.get("TYPICAL_MIN");
            Number tmax = (Number)properties.get("TYPICAL_MAX");
            Units uu = (Units)properties.get("UNITS");
            if (uu == null) {
                uu = Units.dimensionless;
            }
            DatumRange range = AutoplotUtil.getRange((Number)properties.get("TYPICAL_MIN"), (Number)properties.get("TYPICAL_MAX"), (Units)properties.get("UNITS"));
            if (tmin != null || tmax != null) {
                double d2;
                double d1;
                if (result.log) {
                    try {
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                        d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoplotUtil.makeDimensionless(range);
                        result.range = AutoplotUtil.makeDimensionless(result.range);
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                        d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                    }
                    if (d2 > 1.2 && d2 < 2.0) {
                        range = DatumRangeUtil.rescaleLog((DatumRange)range, (double)0.0, (double)2.0);
                        d2 /= 2.0;
                        d1 /= 2.0;
                        logger.fine("adjusting TYPICAL_MAX from metadata, multiply by 2.0");
                    }
                } else {
                    try {
                        d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                        d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoplotUtil.makeDimensionless(range);
                        result.range = AutoplotUtil.makeDimensionless(result.range);
                        d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                        d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                    }
                    if (d2 > 1.2 && d2 < 2.0) {
                        range = DatumRangeUtil.rescale((DatumRange)range, (double)0.0, (double)2.0);
                        d2 /= 2.0;
                        d1 /= 2.0;
                        logger.fine("adjusting TYPICAL_MAX from metadata, multiply by 2.0");
                    }
                }
                if (d2 - d1 > 0.1 && d2 > 0.0 && d2 < 1.1 && d1 > -0.1 && d1 < 1.0 && uu.isConvertableTo(u)) {
                    result.range = range;
                    logger.fine("using TYPICAL_MIN, TYPICAL_MAX from metadata");
                    return result;
                }
                logger.fine("TYPICAL_MIN, TYPICAL_MAX from metadata rejected because it clipped or squished the data.");
            }
        }
        if (UnitsUtil.isRatioMeasurement((Units)u) || UnitsUtil.isIntervalMeasurement((Units)u)) {
            if (result.log) {
                if (result.robustMax <= 0.0) {
                    result.robustMax = 1000.0;
                }
                if (result.robustMin <= 0.0) {
                    result.robustMin = result.robustMax / 1000.0;
                }
                Datum min = u.createDatum(result.robustMin);
                Datum max = u.createDatum(result.robustMax);
                DomainDivider div = DomainDividerUtil.getDomainDivider((Datum)min, (Datum)max, (boolean)true);
                while (div.boundaryCount(min, max) > 40L) {
                    div = div.coarserDivider(false);
                }
                while (div.boundaryCount(min, max) < 20L) {
                    div = div.finerDivider(true);
                }
                result.range = new DatumRange(div.rangeContaining(min).min(), div.rangeContaining(max).max());
            } else if (UnitsUtil.isTimeLocation((Units)u)) {
                if (result.range.min().doubleValue((Units)Units.us2000) > -6.311348E15) {
                    DomainDivider div = DomainDividerUtil.getDomainDivider((Datum)result.range.min(), (Datum)result.range.max());
                    while (div.boundaryCount(result.range.min(), result.range.max()) > 40L) {
                        div = div.coarserDivider(false);
                    }
                    while (div.boundaryCount(result.range.min(), result.range.max()) < 20L) {
                        div = div.finerDivider(true);
                    }
                    result.range = new DatumRange(div.rangeContaining(result.range.min()).min(), div.rangeContaining(result.range.max()).max());
                }
            } else {
                result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
                if (result.robustMin < result.robustMax) {
                    result.range = DatumRangeUtil.rescale((DatumRange)result.range, (double)-0.05, (double)1.05);
                }
                if (result.robustMin == 0.0 && result.robustMax == 0.0) {
                    result.range = DatumRange.newDatumRange((double)-0.1, (double)1.0, (Units)u);
                }
            }
        } else {
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        log.fine("exit autoRange");
        if (typical != null) {
            double overlap;
            if (result.log && typical.log) {
                double overlap2;
                if (typical.range.min().doubleValue(typical.range.getUnits()) <= 0.0) {
                    typical.range = new DatumRange(result.range.min(), typical.range.max());
                }
                if (result.range.intersects(typical.range) && (overlap2 = DatumRangeUtil.normalizeLog((DatumRange)result.range, (Datum)typical.range.max()) - DatumRangeUtil.normalizeLog((DatumRange)result.range, (Datum)typical.range.min())) > 0.01 && overlap2 < 100.0) {
                    return typical;
                }
            } else if (!typical.log && result.range.intersects(typical.range) && (overlap = DatumRangeUtil.normalize((DatumRange)result.range, (Datum)typical.range.max()) - DatumRangeUtil.normalize((DatumRange)result.range, (Datum)typical.range.min())) > 0.01 && overlap < 100.0) {
                return typical;
            }
        }
        return result;
    }

    public static void openBrowser(String url) {
        String errMsg = "Error attempting to launch web browser";
        String osName = AutoplotUtil.getProperty("os.name", "applet");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                if (osName.equals("applet")) {
                    throw new RuntimeException("applets can't start browser yet");
                }
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static Document readDoc(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource source = new InputSource(new InputStreamReader(is));
        Document document = builder.parse(source);
        return document;
    }

    private static double[] simpleRange(QDataSet ds) {
        QDataSet delta;
        QDataSet max = ds;
        QDataSet min = ds;
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((delta = (QDataSet)ds.property("DELTA_PLUS")) != null) {
            max = Ops.add((QDataSet)ds, (QDataSet)delta);
        }
        if ((delta = (QDataSet)ds.property("DELTA_MINUS")) != null) {
            min = Ops.subtract((QDataSet)ds, (QDataSet)delta);
        }
        QDataSet wmin = DataSetUtil.weightsDataSet((QDataSet)min);
        QDataSet wmax = DataSetUtil.weightsDataSet((QDataSet)max);
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds);
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        double[] result = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int i = 0;
        while (i < 10000000 && it.hasNext()) {
            double maxv;
            it.next();
            ++i;
            if (it.getValue(wds) == 0.0 || Double.isInfinite(maxv = it.getValue(max))) continue;
            if (it.getValue(wmin) > 0.0) {
                result[0] = Math.min(result[0], it.getValue(min));
            }
            if (!(it.getValue(wmax) > 0.0)) continue;
            result[1] = Math.max(result[1], maxv);
        }
        if (result[0] == Double.POSITIVE_INFINITY) {
            if (UnitsUtil.isTimeLocation((Units)u)) {
                result[0] = Units.t2000.convertDoubleTo(u, 0.0);
                result[1] = Units.t2000.convertDoubleTo(u, 86400.0);
            } else {
                result[0] = 0.0;
                result[1] = 1.0;
            }
        }
        return result;
    }

    public static void applyFillValidRange(MutablePropertyDataSet ds, double vmin, double vmax, double fill) {
        Number oldFill;
        Number ovmin = (Number)ds.property("VALID_MIN");
        Number ovmax = (Number)ds.property("VALID_MAX");
        boolean needToCopy = false;
        if (ovmax != null && ovmax.doubleValue() < vmax) {
            needToCopy = true;
        }
        if (ovmin != null && ovmin.doubleValue() > vmin) {
            needToCopy = true;
        }
        if ((oldFill = (Number)ds.property("FILL_VALUE")) != null && !Double.isNaN(fill) && oldFill.doubleValue() != fill) {
            needToCopy = true;
        }
        if (!(needToCopy = false)) {
            if (vmin > -1.7976931348623157E308) {
                ds.putProperty("VALID_MIN", (Object)vmin);
            }
            if (vmax < Double.MAX_VALUE) {
                ds.putProperty("VALID_MAX", (Object)vmax);
            }
            if (!Double.isNaN(fill)) {
                ds.putProperty("FILL_VALUE", (Object)fill);
            }
        }
    }

    public static Map<String, Object> extractProperties(QDataSet ds) {
        QDataSet j1;
        Object v;
        String key;
        int i;
        Map result = DataSetUtil.getProperties((QDataSet)ds);
        for (i = 0; i < 4; ++i) {
            key = "DEPEND_" + i;
            v = ds.property(key);
            if (v == null) continue;
            result.put(key, AutoplotUtil.extractProperties((QDataSet)v));
        }
        for (i = 0; i < 50 && (v = ds.property(key = "PLANE_" + i)) != null; ++i) {
            result.put(key, AutoplotUtil.extractProperties((QDataSet)v));
        }
        if (SemanticOps.isJoin((QDataSet)ds) && ds.length() > 0 && ds.rank() == 3 && (j1 = (QDataSet)ds.slice(0).property("DEPEND_1")) != null) {
            Object v1;
            HashMap<String, Object> h1 = (HashMap<String, Object>)result.get("DEPEND_1");
            if (h1 == null) {
                h1 = new HashMap<String, Object>();
            }
            if ((v1 = j1.property("LABEL")) != null) {
                h1.put("LABEL", v1);
            }
            if ((v1 = j1.property("UNITS")) != null) {
                h1.put("UNITS", v1);
            }
            result.put("DEPEND_1", h1);
        }
        return result;
    }

    public static Map<String, Object> mergeProperties(Map<String, Object> properties, Map<String, Object> deflt) {
        if (deflt == null) {
            return properties;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(deflt);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object val = entry.getValue();
            String key = entry.getKey();
            if (val instanceof Map) {
                result.put(key, AutoplotUtil.mergeProperties((Map)val, (Map)deflt.get(key)));
                continue;
            }
            result.put(key, val);
        }
        return result;
    }

    public static String getProperty(String name, String deft) {
        try {
            return System.getProperty(name, deft);
        }
        catch (SecurityException ex) {
            return deft;
        }
    }

    public static void setDevicePosition(DasDevicePosition row, String spec) throws ParseException {
        int i = spec.indexOf(",");
        if (i == -1) {
            throw new IllegalArgumentException("spec must contain one comma");
        }
        double[] ddmin = DasDevicePosition.parseFormatStr((String)spec.substring(0, i));
        double[] ddmax = DasDevicePosition.parseFormatStr((String)spec.substring(i + 1));
        row.setMinimum(ddmin[0]);
        row.setEmMinimum(ddmin[1]);
        row.setPtMinimum((int)ddmin[2]);
        row.setMaximum(ddmax[0]);
        row.setEmMaximum(ddmax[1]);
        row.setPtMaximum((int)ddmax[2]);
    }

    public static String formatDevicePosition(DasDevicePosition pos) {
        return DasDevicePosition.formatLayoutStr((DasDevicePosition)pos, (boolean)true) + ", " + DasDevicePosition.formatLayoutStr((DasDevicePosition)pos, (boolean)false);
    }

    private static boolean isVectorOrBundleIndex(QDataSet dep1) {
        boolean result = false;
        Units dep1Units = (Units)dep1.property("UNITS");
        if (dep1Units != null && dep1Units instanceof EnumerationUnits) {
            result = true;
        }
        if (dep1.property("COORDINATE_FRAME") != null) {
            result = true;
        }
        return result;
    }

    public static RenderType guessRenderType(QDataSet fillds) {
        RenderType spec;
        RenderType specPref;
        block25: {
            String srenderType;
            specPref = RenderType.spectrogram;
            Options o = new Options();
            new OptionsPrefsController(o).loadPreferences();
            if (o.isNearestNeighbor()) {
                specPref = RenderType.nnSpectrogram;
            }
            if ((srenderType = (String)fillds.property("RENDER_TYPE")) != null) {
                if (srenderType.equals("time_series")) {
                    RenderType spec2 = fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
                    return spec2;
                }
                try {
                    RenderType spec3 = RenderType.valueOf(srenderType);
                    return spec3;
                }
                catch (IllegalArgumentException e) {
                    int i = srenderType.indexOf(">");
                    if (i <= -1) break block25;
                    try {
                        srenderType = srenderType.substring(0, i);
                        RenderType spec3 = srenderType.equals("spectrogram") ? specPref : RenderType.valueOf(srenderType.substring(0, i));
                        return spec3;
                    }
                    catch (IllegalArgumentException e2) {
                        System.err.println("unable to resolve render type for: " + srenderType + " in " + fillds);
                    }
                }
            }
        }
        QDataSet dep1 = (QDataSet)fillds.property("DEPEND_1");
        QDataSet plane0 = (QDataSet)fillds.property("PLANE_0");
        QDataSet bundle1 = (QDataSet)fillds.property("BUNDLE_1");
        if (fillds.property("JOIN_0") != null) {
            if (fillds.length() == 0) {
                return RenderType.series;
            }
            dep1 = (QDataSet)fillds.property("DEPEND_1", 0);
            plane0 = (QDataSet)fillds.property("PLANE_0", 0);
            bundle1 = (QDataSet)fillds.property("BUNDLE_1", 0);
        }
        if (fillds.rank() >= 2) {
            if (bundle1 != null || dep1 != null && AutoplotUtil.isVectorOrBundleIndex(dep1)) {
                spec = fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
                if (bundle1 != null) {
                    if (bundle1.length() == 3 && bundle1.property("DEPEND_0", 2) != null) {
                        spec = RenderType.colorScatter;
                    } else if (bundle1.length() == 3 || bundle1.length() == 4) {
                        Units u3;
                        Units u1;
                        Units u0 = (Units)bundle1.property("UNITS", 0);
                        if (u0 == null) {
                            u0 = Units.dimensionless;
                        }
                        if ((u1 = (Units)bundle1.property("UNITS", 1)) == null) {
                            u1 = Units.dimensionless;
                        }
                        if ((u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1)) != null && UnitsUtil.isOrdinalMeasurement((Units)u3) && u0.getOffsetUnits().isConvertableTo(u1)) {
                            spec = RenderType.eventsBar;
                        }
                    }
                }
            } else {
                spec = dep1 == null && fillds.rank() == 2 && fillds.length() > 3 && fillds.length(0) < 4 ? RenderType.series : specPref;
            }
        } else if (fillds.rank() == 0 || fillds.rank() == 1 && SemanticOps.isBundle((QDataSet)fillds)) {
            spec = RenderType.digital;
        } else {
            spec = fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
            if (plane0 != null) {
                Units u = (Units)plane0.property("UNITS");
                if (u == null) {
                    u = Units.dimensionless;
                }
                if (u != null && (UnitsUtil.isRatioMeasurement((Units)u) || UnitsUtil.isIntervalMeasurement((Units)u))) {
                    spec = RenderType.colorScatter;
                }
            }
        }
        return spec;
    }

    public static Renderer maybeCreateRenderer(RenderType renderType, Renderer recyclable, DasColorBar colorbar, boolean justRenderType) {
        SeriesRenderer result;
        boolean conf;
        boolean bl = conf = !justRenderType;
        if (renderType == RenderType.spectrogram) {
            SpectrogramRenderer result2;
            if (recyclable != null && recyclable instanceof SpectrogramRenderer) {
                result2 = (SpectrogramRenderer)recyclable;
                if (conf) {
                    result2.setRebinner(SpectrogramRenderer.RebinnerEnum.binAverage);
                }
            } else {
                result2 = new SpectrogramRenderer(null, colorbar);
                result2.setDataSetLoader(null);
            }
            if (conf) {
                result2.setRebinner(SpectrogramRenderer.RebinnerEnum.binAverage);
            }
            return result2;
        }
        if (renderType == RenderType.nnSpectrogram) {
            SpectrogramRenderer result3;
            if (recyclable != null && recyclable instanceof SpectrogramRenderer) {
                result3 = (SpectrogramRenderer)recyclable;
                if (conf) {
                    result3.setRebinner(SpectrogramRenderer.RebinnerEnum.nearestNeighbor);
                }
            } else {
                SpectrogramRenderer result4 = new SpectrogramRenderer(null, colorbar);
                result4.setDataSetLoader(null);
                if (conf) {
                    result4.setRebinner(SpectrogramRenderer.RebinnerEnum.nearestNeighbor);
                }
                return result4;
            }
            result3.setRebinner(SpectrogramRenderer.RebinnerEnum.nearestNeighbor);
            return result3;
        }
        if (renderType == RenderType.hugeScatter) {
            if (recyclable != null && recyclable instanceof ImageVectorDataSetRenderer) {
                return recyclable;
            }
            ImageVectorDataSetRenderer result5 = new ImageVectorDataSetRenderer(null);
            result5.setEnvelope(1);
            result5.setDataSetLoader(null);
            return result5;
        }
        if (renderType == RenderType.digital) {
            if (recyclable != null && recyclable instanceof DigitalRenderer) {
                return recyclable;
            }
            DigitalRenderer result6 = new DigitalRenderer();
            result6.setDataSetLoader(null);
            return result6;
        }
        if (renderType == RenderType.image) {
            if (recyclable != null && recyclable instanceof RGBImageRenderer) {
                return recyclable;
            }
            RGBImageRenderer result7 = new RGBImageRenderer();
            result7.setDataSetLoader(null);
            return result7;
        }
        if (renderType == RenderType.eventsBar) {
            if (recyclable != null && recyclable instanceof EventsRenderer) {
                return recyclable;
            }
            EventsRenderer result8 = new EventsRenderer();
            result8.setDataSetLoader(null);
            return result8;
        }
        if (renderType == RenderType.pitchAngleDistribution) {
            if (recyclable != null && recyclable instanceof PitchAngleDistributionRenderer) {
                return recyclable;
            }
            PitchAngleDistributionRenderer result9 = new PitchAngleDistributionRenderer(colorbar);
            result9.setDataSetLoader(null);
            return result9;
        }
        if (recyclable != null && recyclable instanceof SeriesRenderer) {
            result = (SeriesRenderer)recyclable;
        } else {
            result = new SeriesRenderer();
            result.setDataSetLoader(null);
        }
        if (justRenderType) {
            return result;
        }
        if (renderType == RenderType.colorScatter) {
            result.setColorBar(colorbar);
            result.setColorByDataSetId("PLANE_0");
        } else {
            result.setColorByDataSetId("");
        }
        if (renderType == RenderType.series) {
            result.setPsymConnector(PsymConnector.SOLID);
            result.setHistogram(false);
            result.setFillToReference(false);
        } else if (renderType == RenderType.scatter) {
            result.setPsymConnector(PsymConnector.NONE);
            result.setPsym((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            result.setFillToReference(false);
        } else if (renderType == RenderType.colorScatter) {
            result.setPsymConnector(PsymConnector.NONE);
            result.setPsym((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            result.setSymSize(3.0);
            result.setFillToReference(false);
        } else if (renderType == RenderType.stairSteps) {
            result.setPsymConnector(PsymConnector.SOLID);
            result.setFillToReference(true);
            result.setHistogram(true);
        } else if (renderType == RenderType.fillToZero) {
            result.setPsymConnector(PsymConnector.SOLID);
            result.setFillToReference(true);
            result.setHistogram(false);
        }
        return result;
    }

    public static Image getAutoplotIcon() {
        return new ImageIcon(AutoplotUtil.class.getResource("logoA16x16.png")).getImage();
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private JDialog createDialog(Component parentComponent, String title, int style) throws HeadlessException {
        return null;
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, null, null, null);
    }

    public static class AutoRangeDescriptor {
        public DatumRange range;
        public boolean log;
        private double robustMin;
        private double robustMax;
        private double median;

        public String toString() {
            return "" + this.range + " " + (this.log ? "log" : "");
        }
    }
}

