/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;

public class ColumnColumnConnectorMouseModule
extends MouseModule {
    DasPlot topPlot;
    DasPlot bottomPlot;
    Point p0;
    DasAxis panAxis = null;
    DatumRange panAxisRange0;
    DasAxis oppositeAxis = null;
    DasAxis.Lock panAxisLock;
    DasAxis panAxisV = null;
    DatumRange panAxisRange0V;
    DasAxis oppositeAxisV = null;
    DasAxis.Lock panAxisLockV;

    public ColumnColumnConnectorMouseModule(DasPlot topPlot, DasPlot bottomPlot) {
        this.topPlot = topPlot;
        this.bottomPlot = bottomPlot;
        super.setLabel("Connector Zoom Pan");
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        DatumRange dr;
        double nmax;
        double nmin;
        if (e.getWheelRotation() < 0) {
            nmin = 0.2;
            nmax = 0.8;
        } else {
            nmin = -0.25;
            nmax = 1.25;
        }
        if (this.panAxis != null) {
            dr = this.panAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)this.panAxis.getDatumRange(), (double)nmin, (double)nmax) : DatumRangeUtil.rescale((DatumRange)this.panAxis.getDatumRange(), (double)nmin, (double)nmax);
            this.panAxis.setDatumRange(dr);
        }
        if (this.panAxisV != null) {
            dr = this.panAxisV.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)this.panAxisV.getDatumRange(), (double)nmin, (double)nmax) : DatumRangeUtil.rescale((DatumRange)this.panAxisV.getDatumRange(), (double)nmin, (double)nmax);
            this.panAxisV.setDatumRange(dr);
        }
        super.mouseWheelMoved(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.panAxis != null) {
            this.panAxisLock.unlock();
            this.panAxisLock = null;
            this.panAxis = null;
        }
        if (this.panAxisV != null) {
            this.panAxisLockV.unlock();
            this.panAxisLockV = null;
            this.panAxisV = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
        DatumRange dr;
        Datum delta;
        super.mouseDragged(e);
        Point p2 = e.getPoint();
        if (this.panAxis != null) {
            if (!this.panAxis.getUnits().isConvertableTo(this.oppositeAxis.getUnits())) {
                return;
            }
            if (this.panAxis.isLog()) {
                delta = this.oppositeAxis.invTransform(this.p0.getX()).divide(this.oppositeAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.panAxisRange0.min().divide(delta), this.panAxisRange0.max().divide(delta));
            } else {
                delta = this.oppositeAxis.invTransform(this.p0.getX()).subtract(this.oppositeAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.panAxisRange0.min().subtract(delta), this.panAxisRange0.max().subtract(delta));
            }
            this.panAxis.setDatumRange(dr);
        }
        if (this.panAxisV != null) {
            if (!this.panAxisV.getUnits().isConvertableTo(this.oppositeAxisV.getUnits())) {
                return;
            }
            if (this.panAxisV.isLog()) {
                if (UnitsUtil.isTimeLocation((Units)this.panAxisV.getUnits())) {
                    System.err.println("log of time axis--shouldn't happen");
                    return;
                }
                delta = this.oppositeAxisV.invTransform(this.p0.getY()).divide(this.oppositeAxisV.invTransform(p2.getY()));
                dr = new DatumRange(this.panAxisRange0V.min().divide(delta), this.panAxisRange0V.max().divide(delta));
            } else {
                delta = this.oppositeAxisV.invTransform(this.p0.getY()).subtract(this.oppositeAxisV.invTransform(p2.getY()));
                dr = new DatumRange(this.panAxisRange0V.min().subtract(delta), this.panAxisRange0V.max().subtract(delta));
            }
            this.panAxisV.setDatumRange(dr);
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.p0 = e.getPoint();
        if (this.p0.getY() < 20.0) {
            this.panAxis = this.bottomPlot.getXAxis();
            this.oppositeAxis = this.topPlot.getXAxis();
        } else {
            boolean doVert;
            Point p = e.getPoint();
            p = SwingUtilities.convertPoint(e.getComponent(), p, (Component)this.bottomPlot.getCanvas());
            boolean doHoriz = this.topPlot.getXAxis().getUnits().isConvertableTo(this.bottomPlot.getXAxis().getUnits()) && this.topPlot.getXAxis().getDatumRange().contains(this.bottomPlot.getXAxis().invTransform(p.getX()));
            boolean bl = doVert = this.topPlot.getYAxis().getUnits().isConvertableTo(this.bottomPlot.getYAxis().getUnits()) && this.topPlot.getYAxis().getDatumRange().contains(this.bottomPlot.getYAxis().invTransform(p.getY()));
            if (doHoriz) {
                this.panAxis = this.topPlot.getXAxis();
                this.oppositeAxis = this.bottomPlot.getXAxis();
            }
            if (doVert) {
                this.panAxisV = this.topPlot.getYAxis();
                this.oppositeAxisV = this.bottomPlot.getYAxis();
            }
        }
        if (this.panAxis != null) {
            this.panAxisRange0 = this.panAxis.getDatumRange();
            this.panAxisLock = this.panAxis.mutatorLock();
            this.panAxisLock.lock();
        }
        if (this.panAxisV != null) {
            this.panAxisRange0V = this.panAxisV.getDatumRange();
            this.panAxisLockV = this.panAxisV.mutatorLock();
            this.panAxisLockV.lock();
        }
    }
}

