/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.das2.graph.DasCanvas;
import org.das2.graph.GraphUtil;
import org.das2.util.Entities;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.PlotElement;

public class FontAndColorsDialog
extends JDialog {
    ApplicationModel app;
    Color[] fores;
    Color[] backs;
    private static final int ICON_SIZE = 16;
    private JButton backgroundColorButton;
    private JButton dismissButton;
    private JLabel fontLabel;
    private JButton foregroundColorButton;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    public FontAndColorsDialog(Frame parent, boolean modal, ApplicationModel app) {
        super(parent, modal);
        this.initComponents();
        this.app = app;
        DasCanvas c = app.getCanvas();
        this.fores = new Color[]{Color.BLACK, Color.WHITE, Color.WHITE};
        this.backs = new Color[]{Color.WHITE, Color.BLACK, Color.BLUE.darker()};
        String[] names = new String[]{"black on white", "white on black", "white on blue", "custom"};
        Font f = app.getCanvas().getFont();
        this.fontLabel.setText(DomUtil.encodeFont(f));
        int index = 3;
        for (int i = 0; i < this.fores.length; ++i) {
            if (!this.fores[i].equals(c.getForeground()) || !this.backs[i].equals(c.getBackground())) continue;
            index = i;
        }
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(names));
        if (index != -1) {
            this.jComboBox1.setSelectedIndex(index);
        }
        this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)c.getForeground(), (int)16, (int)16));
        this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)c.getBackground(), (int)16, (int)16));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.foregroundColorButton = new JButton();
        this.backgroundColorButton = new JButton();
        this.jLabel4 = new JLabel();
        this.jButton1 = new JButton();
        this.dismissButton = new JButton();
        this.fontLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Fore/Back Colors:");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Foreground:");
        this.jLabel3.setText("Background:");
        this.foregroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.foregroundColorButtonActionPerformed(evt);
            }
        });
        this.backgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.backgroundColorButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Font:");
        this.jButton1.setText("Pick");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.dismissButton.setText("OK");
        this.dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.dismissButtonActionPerformed(evt);
            }
        });
        this.fontLabel.setText("jLabel5");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.foregroundColorButton, -2, 20, -2)).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.backgroundColorButton, -2, 18, -2)).add((Component)this.jComboBox1, -2, 173, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.fontLabel, -1, 232, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1)).add(2, (Component)this.dismissButton)).addContainerGap()));
        layout.linkSize(new Component[]{this.backgroundColorButton, this.foregroundColorButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBox1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.backgroundColorButton).add((Component)this.foregroundColorButton, -2, 17, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jButton1).add((Component)this.fontLabel)).addPreferredGap(0, 130, Short.MAX_VALUE).add((Component)this.dismissButton).addContainerGap()));
        layout.linkSize(new Component[]{this.backgroundColorButton, this.foregroundColorButton}, 2);
        this.pack();
    }

    private void dismissButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFontChooser chooser = new JFontChooser((Frame)((JFrame)this.getOwner()));
        String sci = Entities.decodeEntities((String)"2 &times; 10E7  &aacute;");
        String greek = Entities.decodeEntities((String)"Greek Symbols: &Alpha; &Beta; &Delta; &alpha; &beta; &delta; &pi; &rho; &omega;");
        String math = Entities.decodeEntities((String)"Math Symbols: &sum; &plusmn;");
        chooser.setExampleText("Electron Differential Energy Flux\n2001-01-10 12:00\nExtended ASCII: " + sci + "\n" + greek + "\n" + math);
        chooser.setFont(this.app.getCanvas().getBaseFont());
        if (chooser.showDialog() == JFontChooser.OK_OPTION) {
            this.app.getCanvas().setBaseFont(chooser.getFont());
            Font f = this.app.getCanvas().getFont();
            this.fontLabel.setText(DomUtil.encodeFont(f));
            this.app.getDocumentModel().getOptions().setCanvasFont(DomUtil.encodeFont(f));
        }
    }

    private void backgroundColorButtonActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "background color", this.backgroundColorButton.getBackground());
        this.jComboBox1.setSelectedIndex(this.fores.length);
        this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)c, (int)16, (int)16));
        this.app.getCanvas().setBackground(c);
        this.app.getDocumentModel().getOptions().setBackground(c);
    }

    private void foregroundColorButtonActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "foreground color", this.foregroundColorButton.getBackground());
        this.jComboBox1.setSelectedIndex(this.fores.length);
        List<PlotElement> pe = Arrays.asList(this.app.dom.getPlotElements());
        for (PlotElement p : pe) {
            if (!p.getStyle().getColor().equals(this.app.getCanvas().getForeground())) continue;
            p.getStyle().setColor(c);
        }
        this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)c, (int)16, (int)16));
        this.app.getCanvas().setForeground(c);
        this.app.getDocumentModel().getOptions().setForeground(c);
        this.app.getDocumentModel().getOptions().setColor(c);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        int i = this.jComboBox1.getSelectedIndex();
        if (i < this.fores.length) {
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)this.fores[i], (int)16, (int)16));
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)this.backs[i], (int)16, (int)16));
            List<PlotElement> pe = Arrays.asList(this.app.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.app.getCanvas().getForeground())) continue;
                p.getStyle().setColor(this.fores[i]);
            }
            this.app.getDocumentModel().getOptions().setForeground(this.fores[i]);
            this.app.getDocumentModel().getOptions().setColor(this.fores[i]);
            this.app.getDocumentModel().getOptions().setBackground(this.backs[i]);
        }
    }
}

