/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComponentInputMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.DragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.PointSlopeDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.system.RequestProcessor;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.autoplot.AddPlotElementDialog;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUI;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.ExportDataPanel;
import org.virbo.autoplot.ImportBookmarksGui;
import org.virbo.autoplot.ImportVapDialog;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.TcaElementDialog;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.OptionsPrefsController;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotController;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.layout.LayoutConstants;
import org.virbo.autoplot.state.StatePersistence;
import org.virbo.autoplot.transferrable.ImageSelection;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.DataSourceFormatEditorPanel;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.URISplit;
import org.xml.sax.SAXException;

public class GuiSupport {
    AutoplotUI parent;
    private static File currentFile;

    public GuiSupport(AutoplotUI parent) {
        this.parent = parent;
    }

    public void doPasteDataSetURL() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        String result = null;
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
        if (result != null) {
            this.parent.dataSetSelector.setValue(result);
        }
    }

    public void doCopyDataSetURL() {
        StringSelection stringSelection = new StringSelection(DataSetURI.toUri((String)this.parent.dataSetSelector.getValue()).toASCIIString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public void doCopyDataSetImage() {
        Runnable run = new Runnable(){

            public void run() {
                ImageSelection imageSelection = new ImageSelection();
                DasCanvas c = GuiSupport.this.parent.applicationModel.canvas;
                Image i = c.getImage(c.getWidth(), c.getHeight());
                imageSelection.setImage(i);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(imageSelection, new ClipboardOwner(){

                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                });
            }
        };
        new Thread(run, "CopyDataSetToClipboardThread").start();
    }

    public static Frame getFrameForComponent(Component parent) {
        if (!(parent instanceof Frame)) {
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return null;
    }

    public static void editPlotElement(ApplicationModel applicationModel, Component parent) {
        Application dom = applicationModel.dom;
        AddPlotElementDialog dia = new AddPlotElementDialog(GuiSupport.getFrameForComponent(parent), true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String suri = dom.getController().getFocusUri();
        GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, suri);
        dia.setTitle("Editing Plot Element");
        dia.setVisible(true);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    private static void setAddPlotElementUris(ApplicationModel applicationModel, Application dom, AddPlotElementDialog dia, String suri) {
        Pattern hasKidsPattern = Pattern.compile("vap\\+internal\\:(data_\\d+)(,(data_\\d+))?+(,(data_\\d+))?+");
        Matcher m = hasKidsPattern.matcher(suri);
        dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        if (m.matches()) {
            int depCount = m.group(5) != null ? 2 : (m.group(3) != null ? 1 : (m.group(1) != null ? 0 : -1));
            dia.setDepCount(depCount);
            DataSetSelector[] selectors = new DataSetSelector[]{dia.getPrimaryDataSetSelector(), dia.getSecondaryDataSetSelector(), dia.getTertiaryDataSetSelector()};
            int[] groups = depCount == 2 ? new int[]{5, 1, 3} : (depCount == 1 ? new int[]{3, 1} : new int[]{1});
            for (int i = 0; i < groups.length; ++i) {
                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, m.group(groups[i]));
                if (dsf == null) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                if (dsf.getUri() == null) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                if (dsf.getUri().startsWith("vap+internal:")) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                selectors[i].setValue(dsf.getUri());
            }
        } else {
            dia.getPrimaryDataSetSelector().setValue(suri);
        }
    }

    void addPlotElement() {
        ApplicationModel applicationModel = this.parent.applicationModel;
        DataSetSelector dataSetSelector = this.parent.dataSetSelector;
        Application dom = applicationModel.dom;
        AddPlotElementDialog dia = new AddPlotElementDialog((Frame)this.parent, true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String val = dataSetSelector.getValue();
        if (val.startsWith("vap+internal:")) {
            GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, val);
        } else {
            dia.getPrimaryDataSetSelector().setValue(val);
            dia.getSecondaryDataSetSelector().setValue(val);
            dia.getTertiaryDataSetSelector().setValue(val);
            dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        }
        dia.setTitle("Adding Plot Element");
        dia.setVisible(true);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    private void doDumpData(QDataSet fds, DataSourceFilter dsf, PlotElement pe, DataSourceFormat format, String uriOut, String dscontrol) throws IOException {
        DasProgressPanel mon = null;
        try {
            QDataSet ds = fds;
            if (dsf.getController().getTsb() != null) {
                dsf.getController().getTsb().setTimeResolution(null);
                mon = DasProgressPanel.createFramed((Window)this.parent, (String)"reloading timeseries at native resolution");
                ds = dsf.getController().getDataSource().getDataSet((ProgressMonitor)mon);
                if (mon.isCancelled()) {
                    this.parent.setStatus("export data cancelled");
                    return;
                }
                mon.finished();
            }
            mon = DasProgressPanel.createFramed((Window)this.parent, (String)"formatting data");
            if (dscontrol.equals("plotElementTrim")) {
                DasPlot p = pe.getController().getDasPlot();
                DatumRange xbounds = p.getXAxis().getDatumRange();
                QDataSet dsout = pe.getController().getDataSet();
                if (dsf.getController().getTsb() != null) {
                    dsout = DataSetOps.sprocess((String)pe.getComponent(), (QDataSet)dsout, (ProgressMonitor)DasProgressPanel.createFramed((Window)this.parent, (String)"process TSB timeseries at native resolution"));
                    dsout = SemanticOps.trim((QDataSet)dsout, (DatumRange)xbounds, null);
                    format.formatData(uriOut, dsout, (ProgressMonitor)mon);
                } else {
                    dsout = SemanticOps.trim((QDataSet)dsout, (DatumRange)xbounds, null);
                    format.formatData(uriOut, dsout, (ProgressMonitor)mon);
                }
            } else if (dscontrol.equals("plotElement")) {
                QDataSet dsout = pe.getController().getDataSet();
                if (dsf.getController().getTsb() != null) {
                    dsout = DataSetOps.sprocess((String)pe.getComponent(), (QDataSet)dsout, (ProgressMonitor)DasProgressPanel.createFramed((Window)this.parent, (String)"process TSB timeseries at native resolution"));
                    format.formatData(uriOut, dsout, (ProgressMonitor)mon);
                } else {
                    format.formatData(uriOut, dsout, (ProgressMonitor)mon);
                }
            } else {
                format.formatData(uriOut, ds, (ProgressMonitor)mon);
            }
            this.parent.setStatus("Wrote " + DataSourceUtil.unescape((String)uriOut));
        }
        catch (IllegalArgumentException ex) {
            this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
        }
        catch (RuntimeException ex) {
            this.parent.applicationModel.getExceptionHandler().handleUncaught((Throwable)ex);
        }
        catch (Exception ex) {
            this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
        }
        if (mon != null) {
            mon.finished();
        }
    }

    Action getDumpDataAction2(final Application dom) {
        return new AbstractAction("Export Data..."){

            public void actionPerformed(ActionEvent e) {
                final ExportDataPanel edp = new ExportDataPanel();
                edp.setDataSet(dom);
                final PlotElement pe = dom.getController().getPlotElement();
                final DataSourceFilter dsf = dom.getController().getDataSourceFilterFor(pe);
                QDataSet ds = dsf.getController().getDataSet();
                if (ds == null) {
                    JOptionPane.showMessageDialog(GuiSupport.this.parent, "No Data to Export.");
                    return;
                }
                List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
                edp.getFormatDL().setModel(new DefaultComboBoxModel<Object>(exts.toArray()));
                Preferences prefs = Preferences.userNodeForPackage(AutoplotUI.class);
                String currentFileString = prefs.get("ExportDataCurrentFile", "");
                String currentExtString = prefs.get("ExportDataCurrentExt", ".txt");
                if (!currentExtString.equals("")) {
                    edp.getFormatDL().setSelectedItem(currentExtString);
                }
                if (!currentFileString.equals("")) {
                    URISplit split = URISplit.parse((String)currentFileString);
                    edp.getFilenameTF().setText(split.file);
                    edp.getFormatDL().setSelectedItem("." + split.ext);
                    if (currentFileString.contains("/")) {
                        edp.setFile(currentFileString);
                        if (split.params != null && edp.getDataSourceFormatEditorPanel() != null) {
                            edp.getDataSourceFormatEditorPanel().setURI(currentFileString);
                        }
                    }
                }
                if (dsf.getController().getTsb() != null) {
                    edp.setTsb(true);
                }
                if (JOptionPane.showConfirmDialog(GuiSupport.this.parent, edp, "Export Data", 2) == 0) {
                    try {
                        DataSourceFormat format;
                        String name = edp.getFilenameTF().getText();
                        String ext = (String)edp.getFormatDL().getSelectedItem();
                        if (name.startsWith("file:")) {
                            name = name.substring(5);
                        }
                        File ff = new File(name);
                        name = ff.getAbsolutePath();
                        String s = name;
                        if (!s.endsWith(ext)) {
                            boolean addExt = true;
                            for (int i = 0; i < exts.size(); ++i) {
                                if (!s.endsWith((String)exts.get(i))) continue;
                                addExt = false;
                                ext = (String)exts.get(i);
                            }
                            if (addExt) {
                                s = s + ext;
                            }
                        }
                        if (ext == null) {
                            ext = "";
                        }
                        if ((format = DataSourceRegistry.getInstance().getFormatByExt(ext)) == null) {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, "No formatter for extension: " + ext);
                            return;
                        }
                        DataSourceFormatEditorPanel opts = edp.getDataSourceFormatEditorPanel();
                        if (opts != null) {
                            URISplit splitopts = URISplit.parse((String)opts.getURI());
                            URISplit splits = URISplit.parse((String)s);
                            splitopts.file = splits.file;
                            s = URISplit.format((URISplit)splitopts);
                            name = DataSourceUtil.unescape((String)s);
                        }
                        prefs.put("ExportDataCurrentFile", name);
                        prefs.put("ExportDataCurrentExt", ext);
                        final QDataSet fds = ds;
                        final String uriOut = s;
                        Runnable run = new Runnable(){

                            public void run() {
                                try {
                                    String formatControl = edp.isFormatPlotElement() ? "plotElement" : (edp.isFormatPlotElementAndTrim() ? "plotElementTrim" : "dataSourceFilter");
                                    GuiSupport.this.doDumpData(fds, dsf, pe, format, uriOut, formatControl);
                                }
                                catch (IOException ex) {
                                    GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                                }
                            }
                        };
                        new Thread(run).start();
                    }
                    catch (IllegalArgumentException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handleUncaught((Throwable)ex);
                    }
                    catch (Exception ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                    }
                }
            }
        };
    }

    Action getDumpDataAction() {
        return new AbstractAction("Export Data..."){

            public void actionPerformed(ActionEvent e) {
                int r;
                String name;
                QDataSet dataSet = GuiSupport.this.parent.applicationModel.dom.getController().getPlotElement().getController().getDataSet();
                if (dataSet == null) {
                    JOptionPane.showMessageDialog(GuiSupport.this.parent, "No Data to Export.");
                    return;
                }
                JFileChooser chooser = new JFileChooser();
                List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
                FileFilter deflt = null;
                Iterator i$ = exts.iterator();
                while (i$.hasNext()) {
                    String ext;
                    final String ex = ext = (String)i$.next();
                    String desc = "";
                    FileFilter ff = new FileFilter(){

                        public boolean accept(File f) {
                            if (f.toString() == null) {
                                return false;
                            }
                            return f.toString().endsWith(ex) || f.isDirectory();
                        }

                        public String getDescription() {
                            return "*" + ex;
                        }
                    };
                    if (ext.equals(".qds")) {
                        deflt = ff;
                    }
                    chooser.addChoosableFileFilter(ff);
                }
                chooser.setFileFilter(deflt);
                Preferences prefs = Preferences.userNodeForPackage(AutoplotUI.class);
                String currentFileString = prefs.get("DumpDataCurrentFile", "");
                if (dataSet != null && (name = (String)dataSet.property("NAME")) != null) {
                    chooser.setSelectedFile(new File(name.toLowerCase()));
                }
                if (!currentFileString.equals("") && new File(currentFileString).exists()) {
                    File folder = new File(currentFileString).getParentFile();
                    chooser.setCurrentDirectory(folder);
                }
                if ((r = chooser.showSaveDialog(GuiSupport.this.parent)) == 0) {
                    try {
                        DataSourceFormat format;
                        prefs.put("DumpDataCurrentFile", chooser.getSelectedFile().toString());
                        prefs.flush();
                        String s = chooser.getSelectedFile().toURI().toString();
                        String ext = DataSetURI.getExt((String)s);
                        if (ext == null) {
                            ext = "";
                        }
                        if ((format = DataSourceRegistry.getInstance().getFormatByExt(ext)) == null) {
                            if (chooser.getFileFilter().getDescription().startsWith("*.")) {
                                ext = chooser.getFileFilter().getDescription().substring(1);
                                format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                                if (format == null) {
                                    JOptionPane.showMessageDialog(GuiSupport.this.parent, "No formatter for extension: " + ext);
                                    return;
                                }
                                s = s + ext;
                            } else {
                                JOptionPane.showMessageDialog(GuiSupport.this.parent, "No formatter for extension: " + ext);
                                return;
                            }
                        }
                        format.formatData(s, dataSet, (ProgressMonitor)new DasProgressPanel("formatting data"));
                        GuiSupport.this.parent.setStatus("Wrote " + DataSourceUtil.unescape((String)s));
                    }
                    catch (IOException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handleUncaught((Throwable)ex);
                    }
                    catch (Exception ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                    }
                }
            }
        };
    }

    public Action createNewDOMAction() {
        return new AbstractAction("Reset Window..."){

            public void actionPerformed(ActionEvent e) {
                String msg;
                int result;
                if (GuiSupport.this.parent.stateSupport.isDirty() && ((result = JOptionPane.showConfirmDialog(GuiSupport.this.parent, msg = "The application has been modified.  Do you want to save your changes?")) == 0 ? (result = GuiSupport.this.parent.stateSupport.saveAs()) == 1 : result == 2 || result == -1)) {
                    return;
                }
                Runnable run = new Runnable(){

                    public void run() {
                        GuiSupport.this.parent.dom.getController().reset();
                        GuiSupport.this.parent.undoRedoSupport.resetHistory();
                        GuiSupport.this.parent.applicationModel.setVapFile(null);
                        GuiSupport.this.parent.stateSupport.close();
                        GuiSupport.this.parent.tickleTimer.tickle();
                    }
                };
                RequestProcessor.invokeLater((Runnable)run);
            }
        };
    }

    ApplicationModel newApplication() {
        ApplicationModel model = new ApplicationModel();
        model.setExceptionHandler(this.parent.applicationModel.getExceptionHandler());
        model.addDasPeersToApp();
        AutoplotUI view = new AutoplotUI(model);
        view.setDefaultCloseOperation(2);
        view.setVisible(true);
        OptionsPrefsController opc = new OptionsPrefsController(model.dom.getOptions());
        opc.loadPreferencesWithEvents();
        return model;
    }

    ApplicationModel cloneApplication() {
        ApplicationModel model = new ApplicationModel();
        model.setExceptionHandler(this.parent.applicationModel.getExceptionHandler());
        model.addDasPeersToApp();
        AutoplotUI view = new AutoplotUI(model);
        view.setDefaultCloseOperation(2);
        view.setVisible(true);
        model.dom.syncTo(this.parent.applicationModel.dom);
        OptionsPrefsController opc = new OptionsPrefsController(model.dom.getOptions());
        opc.loadPreferencesWithEvents();
        return model;
    }

    public Action createNewApplicationAction() {
        return new AbstractAction("New Window"){

            public void actionPerformed(ActionEvent e) {
                GuiSupport.this.newApplication();
            }
        };
    }

    public Action createCloneApplicationAction() {
        return new AbstractAction("Clone to New Window"){

            public void actionPerformed(ActionEvent e) {
                GuiSupport.this.cloneApplication();
            }
        };
    }

    public static JMenu createEZAccessMenu(final Plot plot) {
        JMenu result = new JMenu("Plot Style");
        result.add(new JMenuItem(new AbstractAction("Scatter"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.scatter);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Color Scatter"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.colorScatter);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Series"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.series);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Stair Steps"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.stairSteps);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Fill To Zero"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.fillToZero);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Huge Scatter"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.hugeScatter);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Spectrogram"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.spectrogram);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Nearest Neighbor Spectrogram"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.nnSpectrogram);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Digital"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.digital);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Events Bar"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.eventsBar);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Image"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.image);
            }
        }));
        result.add(new JMenuItem(new AbstractAction("Pitch Angle Distribution"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                pe.setRenderType(RenderType.pitchAngleDistribution);
            }
        }));
        return result;
    }

    protected void addKeyBindings(JPanel thisPanel) {
        thisPanel.getActionMap().put("UNDO", this.parent.undoRedoSupport.getUndoAction());
        thisPanel.getActionMap().put("REDO", this.parent.undoRedoSupport.getRedoAction());
        thisPanel.getActionMap().put("RESET_ZOOM", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GuiSupport.this.parent.applicationModel.resetZoom();
            }
        });
        thisPanel.getActionMap().put("INCREASE_FONT_SIZE", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GuiSupport.this.parent.applicationModel.increaseFontSize();
            }
        });
        thisPanel.getActionMap().put("DECREASE_FONT_SIZE", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GuiSupport.this.parent.applicationModel.decreaseFontSize();
            }
        });
        thisPanel.getActionMap().put("NEXT_PLOT_ELEMENT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Application dom = GuiSupport.this.parent.dom;
                PlotElement p = dom.getController().getPlotElement();
                int idx = Arrays.asList(dom.getPlotElements()).indexOf(p);
                if (idx == -1) {
                    idx = 0;
                }
                if (++idx == dom.getPlotElements().length) {
                    idx = 0;
                }
                dom.getController().setPlotElement(dom.getPlotElements(idx));
            }
        });
        thisPanel.getActionMap().put("PREV_PLOT_ELEMENT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Application dom = GuiSupport.this.parent.dom;
                PlotElement p = dom.getController().getPlotElement();
                int idx = Arrays.asList(dom.getPlotElements()).indexOf(p);
                if (idx == -1) {
                    idx = 0;
                }
                if (--idx == -1) {
                    idx = dom.getPlotElements().length - 1;
                }
                dom.getController().setPlotElement(dom.getPlotElements(idx));
            }
        });
        ComponentInputMap map = new ComponentInputMap(thisPanel);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((InputMap)map).put(KeyStroke.getKeyStroke(90, tk.getMenuShortcutKeyMask()), "UNDO");
        ((InputMap)map).put(KeyStroke.getKeyStroke(89, tk.getMenuShortcutKeyMask()), "REDO");
        ((InputMap)map).put(KeyStroke.getKeyStroke(82, tk.getMenuShortcutKeyMask()), "RESET_ZOOM");
        ((InputMap)map).put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "DECREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(521, tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(61, 0x40 | tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(9, 128), "NEXT_PLOT_ELEMENT");
        ((InputMap)map).put(KeyStroke.getKeyStroke(9, 192), "PREV_PLOT_ELEMENT");
        thisPanel.setInputMap(2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportRecent(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "bookmarks files (*.xml)";
            }
        });
        int r = chooser.showSaveDialog(c);
        if (r == 0) {
            try {
                File f = chooser.getSelectedFile();
                if (!f.toString().endsWith(".xml")) {
                    f = new File(f.toString() + ".xml");
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(f);
                    Bookmark.formatBooks(out, this.parent.applicationModel.getRecent());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static FileFilter getFileNameExtensionFilter(final String description, final String ext) {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.toString().endsWith(ext);
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public static Action getPrintAction(final Application app, final String ext) {
        return new AbstractAction("Print as " + ext.toUpperCase()){

            public void actionPerformed(ActionEvent e) {
                int choice;
                final DasCanvas canvas = DasCanvas.getFocusCanvas();
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Print to " + ext.toUpperCase());
                fileChooser.setFileFilter(GuiSupport.getFileNameExtensionFilter(ext + " files", ext));
                Preferences prefs = Preferences.userNodeForPackage(DasCanvas.class);
                String savedir = prefs.get("savedir", null);
                if (savedir != null) {
                    fileChooser.setCurrentDirectory(new File(savedir));
                }
                if (currentFile != null) {
                    fileChooser.setSelectedFile(currentFile);
                }
                if ((choice = fileChooser.showSaveDialog((Component)canvas)) == 0) {
                    String fname = fileChooser.getSelectedFile().toString();
                    if (!fname.toLowerCase().endsWith("." + ext)) {
                        fname = fname + "." + ext;
                    }
                    final String ffname = fname;
                    prefs.put("savedir", new File(ffname).getParent());
                    currentFile = new File(ffname.substring(0, ffname.length() - 4));
                    Runnable run = new Runnable(){

                        public void run() {
                            try {
                                if (ext.equals("png")) {
                                    canvas.writeToPng(ffname);
                                } else if (ext.equals("pdf")) {
                                    canvas.writeToPDF(ffname);
                                } else if (ext.equals("svg")) {
                                    canvas.writeToSVG(ffname);
                                }
                                app.getController().setStatus("wrote to " + ffname);
                            }
                            catch (IOException ioe) {
                                DasExceptionHandler.handle((Throwable)ioe);
                            }
                        }
                    };
                    new Thread(run, "writePrint").start();
                }
            }
        };
    }

    private static void mergeVap(Application dom, Plot plot, PlotElement pelement, String vap) {
        try {
            ImportVapDialog d = new ImportVapDialog();
            if (vap.indexOf("?") != -1) {
                int i = vap.indexOf("?");
                vap = vap.substring(0, i);
            }
            d.setVap(vap);
            if (d.showDialog(SwingUtilities.getWindowAncestor((Component)dom.getController().getDasCanvas())) == 0) {
                String lock = "merging vaps";
                dom.getController().registerPendingChange(d, lock);
                dom.getController().performingChange(d, lock);
                List<String> uris = d.getSelectedURIs();
                for (String uri : uris) {
                    dom.getController().doplot(plot, pelement, uri);
                    pelement = null;
                }
                dom.getController().changePerformed(d, lock);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBookmarks(String bookmarksFile) {
        ImportBookmarksGui gui = new ImportBookmarksGui();
        gui.getBookmarksFilename().setText(bookmarksFile + " ?");
        gui.getRemote().setSelected(true);
        int r = JOptionPane.showConfirmDialog(this.parent, gui, "Import bookmarks file", 2);
        if (r == 0) {
            InputStream in = null;
            try {
                DasProgressPanel mon = DasProgressPanel.createFramed((String)"importing bookmarks");
                if (gui.getRemote().isSelected()) {
                    this.parent.getBookmarksManager().getModel().addRemoteBookmarks(bookmarksFile);
                } else {
                    in = DataSetURI.getInputStream((URI)DataSetURI.getURIValid((String)bookmarksFile), (ProgressMonitor)mon);
                    ByteArrayOutputStream boas = new ByteArrayOutputStream();
                    WritableByteChannel dest = Channels.newChannel(boas);
                    ReadableByteChannel src = Channels.newChannel(in);
                    DataSourceUtil.transfer((ReadableByteChannel)src, (WritableByteChannel)dest);
                    String sin = new String(boas.toByteArray());
                    List<Bookmark> books = Bookmark.parseBookmarks(sin);
                    this.parent.getBookmarksManager().getModel().importList(books);
                }
                this.parent.setMessage("imported bookmarks file " + bookmarksFile);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                this.parent.applicationModel.showMessage("Error parsing " + bookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (SAXException ex) {
                Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                this.parent.applicationModel.showMessage("Error parsing " + bookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FileNotFoundException ex) {
                this.parent.applicationModel.showMessage("File not found: " + bookmarksFile, "Error in import bookmarks", 2);
            }
            catch (IOException ex) {
                Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                this.parent.applicationModel.showMessage("I/O Error with " + bookmarksFile, "Error in import bookmarks", 2);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static void handleAddElementDialog(AddPlotElementDialog dia, Application dom, ApplicationModel applicationModel) {
        Plot plot = null;
        PlotElement pelement = null;
        int modifiers = dia.getModifiers();
        if ((modifiers & 2) == 2 && (modifiers & 1) == 1) {
            plot = null;
            pelement = null;
        } else if ((modifiers & 2) == 2) {
            plot = null;
            pelement = null;
        } else if ((modifiers & 1) == 1) {
            plot = dom.getController().getPlot();
        } else {
            pelement = dom.getController().getPlotElement();
        }
        if (dia.getDepCount() == 0) {
            String val = dia.getPrimaryDataSetSelector().getValue();
            if (val.endsWith(".vap")) {
                GuiSupport.mergeVap(dom, plot, pelement, val);
            } else {
                dom.getController().doplot(plot, pelement, val);
            }
        } else if (dia.getDepCount() == 1) {
            applicationModel.addRecent(dia.getPrimaryDataSetSelector().getValue());
            applicationModel.addRecent(dia.getSecondaryDataSetSelector().getValue());
            dom.getController().doplot(plot, pelement, dia.getSecondaryDataSetSelector().getValue(), dia.getPrimaryDataSetSelector().getValue());
        } else if (dia.getDepCount() == 2) {
            applicationModel.addRecent(dia.getPrimaryDataSetSelector().getValue());
            applicationModel.addRecent(dia.getSecondaryDataSetSelector().getValue());
            applicationModel.addRecent(dia.getTertiaryDataSetSelector().getValue());
            dom.getController().doplot(plot, pelement, dia.getSecondaryDataSetSelector().getValue(), dia.getTertiaryDataSetSelector().getValue(), dia.getPrimaryDataSetSelector().getValue());
        } else if (dia.getDepCount() == -1 && pelement == null) {
            pelement = dom.getController().addPlotElement(plot, null);
        }
    }

    private static void bindToPlotPeer(ApplicationController controller, Plot dstPlot, Plot plot, Axis axis) throws IllegalArgumentException {
        Axis targetAxis;
        if (plot.getXaxis() == axis) {
            targetAxis = dstPlot.getXaxis();
        } else if (plot.getYaxis() == axis) {
            targetAxis = dstPlot.getYaxis();
        } else if (plot.getZaxis() == axis) {
            targetAxis = dstPlot.getZaxis();
        } else {
            throw new IllegalArgumentException("this axis and plot don't go together");
        }
        axis.setLog(targetAxis.isLog());
        axis.setRange(targetAxis.getRange());
        controller.bind(targetAxis, "log", axis, "log");
        controller.bind(targetAxis, "range", axis, "range");
    }

    protected static void addAxisContextMenuItems(final ApplicationController controller, DasPlot dasPlot, PlotController plotController, final Plot plot, final Axis axis) {
        final DasAxis dasAxis = axis.getController().getDasAxis();
        DasMouseInputAdapter mouseAdapter = dasAxis.getDasMouseInputAdapter();
        ArrayList<JMenuItem> expertMenuItems = new ArrayList<JMenuItem>();
        mouseAdapter.removeMenuItem("Properties");
        JMenuItem item = new JMenuItem(new AbstractAction("Axis Properties"){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor pp = new PropertyEditor((Object)axis);
                pp.showDialog((Component)dasAxis.getCanvas());
            }
        });
        mouseAdapter.addMenuItem((Component)item);
        expertMenuItems.add(item);
        mouseAdapter.addMenuItem((Component)new JSeparator());
        if (axis == plot.getXaxis()) {
            JMenu addPlotMenu = new JMenu("Add Plot");
            mouseAdapter.addMenuItem((Component)addPlotMenu);
            item = new JMenuItem(new AbstractAction("Bound Plot Below"){

                public void actionPerformed(ActionEvent e) {
                    controller.copyPlot(plot, true, false, true);
                }
            });
            item.setToolTipText("add a new plot below.  The plot's x axis will be bound to this plot's x axis");
            addPlotMenu.add(item);
            expertMenuItems.add(addPlotMenu);
        }
        item = new JMenuItem(new AbstractAction("Remove Bindings"){

            public void actionPerformed(ActionEvent e) {
                BindingModel[] bms = controller.getBindingsFor(axis);
                controller.unbind(axis);
                controller.setStatus("removed " + bms.length + " bindings");
            }
        });
        item.setToolTipText("remove any plot and panel property bindings");
        mouseAdapter.addMenuItem((Component)item);
        expertMenuItems.add(item);
        JMenu bindingMenu = new JMenu("Add Binding");
        mouseAdapter.addMenuItem((Component)bindingMenu);
        if (axis == plot.getXaxis()) {
            item = new JMenuItem(new AbstractAction("Bind to Application Time Range"){

                public void actionPerformed(ActionEvent e) {
                    controller.bind(controller.getApplication(), "timeRange", axis, "range");
                }
            });
            bindingMenu.add(item);
        }
        item = new JMenuItem(new AbstractAction("Bind to Plot Above"){

            public void actionPerformed(ActionEvent e) {
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind to Plot Below"){

            public void actionPerformed(ActionEvent e) {
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind to Plot to the Right"){

            public void actionPerformed(ActionEvent e) {
                Plot dstPlot = controller.getNextPlotHoriz(plot, LayoutConstants.RIGHT);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot to the right");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind to Plot to the Left"){

            public void actionPerformed(ActionEvent e) {
                Plot dstPlot = controller.getNextPlotHoriz(plot, LayoutConstants.LEFT);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot to the left");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis);
                }
            }
        });
        bindingMenu.add(item);
        expertMenuItems.add(bindingMenu);
        JMenu connectorMenu = new JMenu("Add Connector");
        mouseAdapter.addMenuItem((Component)connectorMenu);
        item = new JMenuItem(new AbstractAction("Connector to Plot Above"){

            public void actionPerformed(ActionEvent e) {
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    controller.addConnector(dstPlot, plot);
                }
            }
        });
        connectorMenu.add(item);
        expertMenuItems.add(connectorMenu);
        if (axis.getController().getDasAxis().isHorizontal()) {
            item = new JMenuItem(new AbstractAction("Add Additional Ticks from..."){

                public void actionPerformed(ActionEvent e) {
                    String uri = plot.getTicksURI();
                    if (uri.startsWith("class:org.autoplot.tca.UriTcaSource:")) {
                        uri = uri.substring("class:org.autoplot.tca.UriTcaSource:".length());
                    }
                    TcaElementDialog dia = new TcaElementDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(controller.getDasCanvas().getParent())), true);
                    dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(controller.getApplicationModel().getRecent()));
                    dia.getPrimaryDataSetSelector().setValue(uri);
                    dia.setTitle("Add additional ticks");
                    dia.setVisible(true);
                    if (dia.isCancelled()) {
                        return;
                    }
                    uri = dia.getPrimaryDataSetSelector().getValue();
                    if (uri.length() == 0) {
                        plot.setTicksURI("");
                    } else {
                        plot.setTicksURI(uri);
                    }
                }
            });
            mouseAdapter.addMenuItem((Component)item);
            expertMenuItems.add(item);
        }
        ArrayList<JMenuItem> expertMenuItemsList = new ArrayList<JMenuItem>(Arrays.asList(plotController.getExpertMenuItems()));
        expertMenuItemsList.addAll(expertMenuItems);
        plotController.setExpertMenuItems(expertMenuItemsList.toArray(new JMenuItem[expertMenuItemsList.size()]));
    }

    static void addPlotContextMenuItems(final ApplicationController controller, final DasPlot plot, final PlotController plotController, final Plot domPlot) {
        plot.getDasMouseInputAdapter().addMouseModule(new MouseModule((DasCanvasComponent)plot, (DragRenderer)new PointSlopeDragRenderer((DasCanvasComponent)plot, plot.getXAxis(), plot.getYAxis()), "Slope"));
        plot.getDasMouseInputAdapter().removeMenuItem("Dump Data");
        plot.getDasMouseInputAdapter().removeMenuItem("Properties");
        ArrayList<JMenuItem> expertMenuItems = new ArrayList<JMenuItem>();
        JMenuItem mi = new JMenuItem(new AbstractAction("Plot Properties"){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor pp = new PropertyEditor((Object)domPlot);
                pp.showDialog((Component)plot.getCanvas());
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem((Component)mi);
        expertMenuItems.add(mi);
        mi = new JMenuItem(new AbstractAction("Plot Element Properties"){

            public void actionPerformed(ActionEvent e) {
                PlotElement p = controller.getPlotElement();
                PropertyEditor pp = new PropertyEditor((Object)p);
                pp.showDialog((Component)plot.getCanvas());
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem((Component)mi);
        expertMenuItems.add(mi);
        JMenuItem panelPropsMenuItem = new JMenuItem(new AbstractAction("Plot Element Style Properties"){

            public void actionPerformed(ActionEvent e) {
                PlotElement p = controller.getPlotElement();
                PropertyEditor pp = new PropertyEditor((Object)p.getStyle());
                pp.showDialog((Component)plot.getCanvas());
            }
        });
        plotController.setPlotElementPropsMenuItem(panelPropsMenuItem);
        plot.getDasMouseInputAdapter().addMenuItem((Component)panelPropsMenuItem);
        expertMenuItems.add(panelPropsMenuItem);
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JSeparator());
        JMenu addPlotMenu = new JMenu("Add Plot");
        plot.getDasMouseInputAdapter().addMenuItem((Component)addPlotMenu);
        JMenuItem item = new JMenuItem(new AbstractAction("Copy Plot Elements Down"){

            public void actionPerformed(ActionEvent e) {
                Runnable run = new Runnable(){

                    public void run() {
                        Plot newPlot = controller.copyPlotAndPlotElements(domPlot, null, false, false);
                        Application dom = domPlot.getController().getApplication();
                        List<BindingModel> bms = dom.getController().findBindings(dom, "timeRange", domPlot.getXaxis(), "range");
                        if (bms.size() > 0 && UnitsUtil.isTimeLocation((Units)newPlot.getXaxis().getRange().getUnits())) {
                            controller.bind(controller.getApplication(), "timeRange", newPlot.getXaxis(), "range");
                        }
                    }
                };
                RequestProcessor.invokeLater((Runnable)run);
            }
        });
        item.setToolTipText("make a new plot below, and copy the plot elements into it.  New plot is bound by the x axis.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Context Overview"){

            public void actionPerformed(ActionEvent e) {
                Runnable run = new Runnable(){

                    public void run() {
                        domPlot.getController().contextOverview();
                    }
                };
                RequestProcessor.invokeLater((Runnable)run);
            }
        });
        item.setToolTipText("make a new plot, and copy the plot elements into it.  The plot is not bound,\nand a connector is drawn between the two.  The panel uris are bound as well.");
        addPlotMenu.add(item);
        expertMenuItems.add(addPlotMenu);
        JMenu editPlotMenu = new JMenu("Edit Plot");
        plot.getDasMouseInputAdapter().addMenuItem((Component)editPlotMenu);
        controller.fillEditPlotMenu(editPlotMenu, domPlot);
        expertMenuItems.add(editPlotMenu);
        JMenu panelMenu = new JMenu("Edit Plot Element");
        plot.getDasMouseInputAdapter().addMenuItem((Component)panelMenu);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Move to Plot Above"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pelement = controller.getPlotElement();
                Plot plot = controller.getPlotFor(pelement);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    dstPlot = controller.addPlot(LayoutConstants.ABOVE);
                    pelement.setPlotId(dstPlot.getId());
                } else {
                    pelement.setPlotId(dstPlot.getId());
                }
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Move to Plot Below"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pelement = controller.getPlotElement();
                Plot plot = controller.getPlotFor(pelement);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    dstPlot = controller.addPlot(LayoutConstants.BELOW);
                    pelement.setPlotId(dstPlot.getId());
                    controller.bind(plot.getXaxis(), "range", dstPlot.getXaxis(), "range");
                } else {
                    pelement.setPlotId(dstPlot.getId());
                }
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot Element"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pelement = controller.getPlotElement();
                if (controller.getApplication().getPlotElements().length < 2) {
                    DataSourceFilter dsf = controller.getDataSourceFilterFor(controller.getApplication().getPlotElements(0));
                    dsf.setUri(null);
                    pelement.setLegendLabelAutomatically("");
                    pelement.setActive(true);
                    return;
                }
                controller.deletePlotElement(pelement);
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        item = new JMenuItem(new AbstractAction("Move Plot Element Below Others"){

            public void actionPerformed(ActionEvent e) {
                PlotElement pelement = controller.getPlotElement();
                Plot p = pelement.getController().getApplication().getController().getPlotFor(pelement);
                p.getController().toBottom(pelement);
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        JMenuItem editDataMenu = new JMenuItem(new AbstractAction("Edit Data Source"){

            public void actionPerformed(ActionEvent e) {
                GuiSupport.editPlotElement(controller.getApplicationModel(), (Component)plot);
            }
        });
        expertMenuItems.add(editDataMenu);
        plot.getDasMouseInputAdapter().addMenuItem((Component)editDataMenu);
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JSeparator());
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JMenuItem(new AbstractAction("Reset Zoom"){

            public void actionPerformed(ActionEvent e) {
                plotController.resetZoom(true, true, true);
            }
        }));
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JSeparator());
        JMenu ezMenu = GuiSupport.createEZAccessMenu(domPlot);
        plot.getDasMouseInputAdapter().addMenuItem((Component)ezMenu);
        expertMenuItems.add(ezMenu);
        plotController.setExpertMenuItems(expertMenuItems.toArray(new JMenuItem[expertMenuItems.size()]));
    }

    protected void doInspectVap() {
        JFileChooser chooser = new JFileChooser();
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.toString().endsWith(".vap") || f.isDirectory();
            }

            public String getDescription() {
                return "*.vap";
            }
        };
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        chooser.setCurrentDirectory(new File(this.parent.stateSupport.getDirectory()));
        if (0 == chooser.showOpenDialog(this.parent)) {
            try {
                Application vap = (Application)StatePersistence.restoreState(chooser.getSelectedFile());
                PropertyEditor edit = new PropertyEditor((Object)vap);
                edit.showDialog((Component)this.parent);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.parent, "File does not appear to well-formatted .vap file");
            }
        }
    }
}

