/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.layout.LayoutUtil;

public class LayoutListener
implements PropertyChangeListener {
    ApplicationModel model;
    Timer t;
    static Logger logger = Logger.getLogger("virbo.autoplot.autolayout");
    public static final String PENDING_CHANGE_AUTOLAYOUT = "autolayout";

    public LayoutListener(ApplicationModel model) {
        this.model = model;
    }

    public void listenTo(DasPlot plot) {
        plot.addPropertyChangeListener("title", (PropertyChangeListener)this);
        plot.getXAxis().addPropertyChangeListener("bounds", (PropertyChangeListener)this);
        plot.getYAxis().addPropertyChangeListener("bounds", (PropertyChangeListener)this);
        plot.addPropertyChangeListener("legendPosition", (PropertyChangeListener)this);
    }

    public void listenTo(DasAxis colorbar) {
        colorbar.addPropertyChangeListener("visible", (PropertyChangeListener)this);
        colorbar.addPropertyChangeListener("bounds", (PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.model.dom.getOptions().isAutolayout()) {
            logger.fine("property change: " + evt.getPropertyName());
            if (evt.getSource() instanceof Component && ((Component)evt.getSource()).isVisible()) {
                if (this.t == null) {
                    logger.fine("create timer ");
                    this.t = new Timer(100, new ActionListener(){

                        public synchronized void actionPerformed(ActionEvent e) {
                            if (LayoutListener.this.model.dom.getOptions().isAutolayout()) {
                                logger.fine("do autolayout");
                                ApplicationController applicationController = LayoutListener.this.model.getDocumentModel().getController();
                                LayoutListener.this.model.dom.getController().getCanvas().getController().performingChange(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                LayoutListener.this.model.canvas.performingChange((Object)LayoutListener.this, (Object)LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                LayoutUtil.autolayout(applicationController.getDasCanvas(), applicationController.getRow(), applicationController.getColumn());
                                LayoutListener.this.model.canvas.changePerformed((Object)LayoutListener.this, (Object)LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                LayoutListener.this.model.dom.getController().getCanvas().getController().changePerformed(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                            } else {
                                LayoutListener.this.model.canvas.performingChange((Object)LayoutListener.this, (Object)LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                LayoutListener.this.model.canvas.changePerformed((Object)LayoutListener.this, (Object)LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                            }
                        }
                    });
                    this.t.setRepeats(false);
                }
                this.model.canvas.registerPendingChange((Object)this, (Object)PENDING_CHANGE_AUTOLAYOUT);
                this.t.restart();
            }
        }
    }
}

