/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.RecentUrisGUI;

public class RecentUrisDialog
extends JDialog {
    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";
    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";
    private JButton cancelButton;
    private JButton editUriButton;
    private JTextField filterTextField;
    private JLabel jLabel1;
    private JButton overplotButton;
    private JButton plotBelowButton;
    private JButton plotButton;
    private RecentUrisGUI recentUrisGUI1;
    private JButton updateButton;

    public RecentUrisDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.recentUrisGUI1.getTree().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Object o = null;
                o = RecentUrisDialog.this.recentUrisGUI1.getTree().getSelectionPath();
                if (o == null) {
                    return;
                }
                o = RecentUrisDialog.this.recentUrisGUI1.getTree().getSelectionPath().getLastPathComponent();
                if (!(o instanceof String[])) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    RecentUrisDialog.this.cancelled = false;
                    RecentUrisDialog.this.setModifiers(e.getModifiers());
                    RecentUrisDialog.this.setVisible(false);
                }
            }
        });
    }

    public void setFilter(String filter) {
        this.recentUrisGUI1.setFilter(filter);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }

    public String getSelectedURI() {
        return this.recentUrisGUI1.getSelectedURI();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.filterTextField = new JTextField();
        this.updateButton = new JButton();
        this.recentUrisGUI1 = new RecentUrisGUI();
        this.cancelButton = new JButton();
        this.overplotButton = new JButton();
        this.plotBelowButton = new JButton();
        this.plotButton = new JButton();
        this.editUriButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Recent History");
        this.jLabel1.setText("Filter:");
        this.jLabel1.setToolTipText("Filter URIs with free text, as in 'vap+cdf:'");
        this.filterTextField.setToolTipText("Filter URIs with free text, as in 'vap+cdf:'");
        this.filterTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.filterTextFieldActionPerformed(evt);
            }
        });
        this.updateButton.setText("Update");
        this.updateButton.setToolTipText("Apply filter to list of URIs");
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.updateButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.overplotButton.setText("Overplot");
        this.overplotButton.setToolTipText("Add this to the current plot as an overplot");
        this.overplotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.overplotButtonActionPerformed(evt);
            }
        });
        this.plotBelowButton.setText("Plot Below");
        this.plotBelowButton.setToolTipText("Plot below the current plot, possibly inserting a plot.");
        this.plotBelowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.plotBelowButtonActionPerformed(evt);
            }
        });
        this.plotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/go.png")));
        this.plotButton.setText("Plot");
        this.plotButton.setToolTipText("Replace the current plot with this");
        this.plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.plotButtonActionPerformed(evt);
            }
        });
        this.editUriButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/autoplot/fileMag.png")));
        this.editUriButton.setText("Edit");
        this.editUriButton.setToolTipText("Inspect this resource.  If an editor panel is available, this will enter the editor panel before plotting.  Otherwise the\nURI is copied to the address bar for editing with completions.");
        this.editUriButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentUrisDialog.this.editUriButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(322, Short.MAX_VALUE).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.overplotButton).addPreferredGap(0).add((Component)this.editUriButton, -2, 70, -2).addPreferredGap(0).add((Component)this.plotBelowButton).addPreferredGap(0).add((Component)this.plotButton, -2, 65, -2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.filterTextField, -2, 191, -2).addPreferredGap(0).add((Component)this.updateButton).addContainerGap(427, Short.MAX_VALUE)).add(2, (Component)this.recentUrisGUI1, -1, 781, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.editUriButton, this.plotButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1, -1, 25, Short.MAX_VALUE).add((Component)this.filterTextField, -2, -1, -2).add((Component)this.updateButton)).addPreferredGap(0).add((Component)this.recentUrisGUI1, -1, 388, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.plotButton).add((Component)this.plotBelowButton).add((Component)this.cancelButton).add((Component)this.overplotButton).add((Component)this.editUriButton)).addContainerGap()));
        this.pack();
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.setFilter(this.filterTextField.getText());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void overplotButtonActionPerformed(ActionEvent evt) {
        this.setModifiers(1);
        this.cancelled = false;
        this.setVisible(false);
    }

    private void plotBelowButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(2);
        this.setVisible(false);
    }

    private void plotButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(evt.getModifiers());
        this.setVisible(false);
    }

    private void filterTextFieldActionPerformed(ActionEvent evt) {
        this.setFilter(this.filterTextField.getText());
    }

    private void editUriButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(8);
        this.setVisible(false);
    }

    public void setExpertMode(boolean expert) {
        this.editUriButton.setVisible(expert);
        this.overplotButton.setVisible(expert);
        this.plotBelowButton.setVisible(expert);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RecentUrisDialog dialog = new RecentUrisDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

