/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.python.util.InteractiveInterpreter;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.JythonUtil;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.jythonsupport.ui.EditorTextPane;

public class RunScriptPanel
extends JPanel {
    EditorTextPane textArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel scriptFilename;
    private JPanel scriptPanel;
    private JCheckBox toolsCB;

    public RunScriptPanel() {
        this.initComponents();
        this.textArea = new EditorTextPane();
        this.scriptPanel.add((Component)this.textArea);
        this.textArea.setEditable(false);
    }

    public EditorTextPane getTextArea() {
        return this.textArea;
    }

    public static void runScript(ApplicationModel model, File ff, ProgressMonitor mon) {
        try {
            FileInputStream in = new FileInputStream(ff);
            StringBuilder buf = new StringBuilder();
            BufferedReader read = new BufferedReader(new InputStreamReader(in));
            String line = read.readLine();
            while (line != null) {
                buf.append(line).append("\n");
                line = read.readLine();
            }
            read.close();
            if (buf.length() <= 0) {
                throw new IllegalArgumentException("file was empty: " + ff);
            }
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
            interp.set("dom", (Object)model.getDocumentModel());
            interp.set("monitor", (Object)mon);
            interp.exec(buf.toString());
            mon.finished();
        }
        catch (IOException ex) {
            Logger.getLogger(RunScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JCheckBox getToolsCB() {
        return this.toolsCB;
    }

    void loadFile(File ff) throws IOException {
        this.getTextArea().loadFile(ff);
        if (ff.getCanonicalPath().startsWith(new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools").getCanonicalPath())) {
            this.toolsCB.setEnabled(false);
        }
        this.scriptFilename.setText(ff.toString());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.toolsCB = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.scriptPanel = new JPanel();
        this.scriptFilename = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1.setText("Run the script:");
        this.toolsCB.setText("Install in tools folder and menu");
        this.scriptPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.scriptPanel);
        this.scriptFilename.setText("<html><em>script filename\n");
        this.jLabel2.setText("Make sure the script does not contain malicious code.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 409, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.scriptFilename, -1, 409, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.toolsCB)).add((Component)this.jLabel2, -1, 409, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(3, 3, 3).add((Component)this.scriptFilename, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 283, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.toolsCB).add(11, 11, 11).add((Component)this.jLabel2).addContainerGap()));
    }
}

