/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.bookmarks;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.GuiSupport;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.bookmarks.BookmarksManagerModel;
import org.virbo.autoplot.bookmarks.BookmarksManagerTransferrable;
import org.virbo.autoplot.scriptconsole.GuiExceptionHandler;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.URISplit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksManager
extends JDialog {
    BookmarksManagerModel model;
    Bookmark dirtyBookmark;
    JPopupMenu contextMenu = this.createContextMenu();
    private JButton ExportButton;
    private JTextField URLTextField;
    private JMenuItem addItemMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem deleteMenuItem;
    private JTextField descriptionTextField;
    private JButton dismissButton;
    private JMenu editMenu;
    private JMenuItem exportMenuItem;
    private JButton importButton;
    private JButton importFromWebButton;
    private JMenuItem importMenuItem;
    private JMenuItem importUrlMenuItem;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JTree jTree1;
    private JMenuItem mergeInDefaultMenuItem;
    private JMenuItem newFolderMenuItem;
    private JMenuItem resetToDefaultMenuItem;
    private JTextField titleTextField;
    String prefNode = null;
    File bookmarksFile = null;

    public BookmarksManager(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.model = new BookmarksManagerModel();
        this.jTree1.setModel(this.model.getTreeModel());
        this.jTree1.addMouseListener(this.createContextMenuMouseListener());
        this.model.addPropertyChangeListener("list", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TreeModel mod = BookmarksManager.this.model.getTreeModel();
                BookmarksManager.this.jTree1.setModel(mod);
            }
        });
        BookmarksManagerTransferrable trans = new BookmarksManagerTransferrable(this.model, this.jTree1);
        DragSource dragSource = DragSource.getDefaultDragSource();
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(trans.createDropTargetListener());
        }
        catch (TooManyListenersException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.jTree1.setDropTarget(dropTarget);
        dragSource.createDefaultDragGestureRecognizer(this.jTree1, 3, trans.createDragGestureListener());
    }

    public BookmarksManagerModel getModel() {
        return this.model;
    }

    private void showMessage(String message, String title, int messageType) {
        if (!"true".equals(AutoplotUtil.getProperty("java.awt.headless", "false"))) {
            Component p = SwingUtilities.getRoot(this);
            if (p == null) {
                if (messageType == 2) {
                    System.err.println("WARNING: " + title + ": " + message);
                } else if (messageType == 1) {
                    System.err.println("INFO: " + title + ": " + message);
                } else {
                    System.err.println(title + ": " + message);
                }
            } else {
                JOptionPane.showMessageDialog(p, message, title, messageType);
            }
        } else if (messageType == 2) {
            System.err.println("WARNING: " + title + ": " + message);
        } else if (messageType == 1) {
            System.err.println("INFO: " + title + ": " + message);
        } else {
            System.err.println(title + ": " + message);
        }
    }

    public void setAddBookmark(Bookmark b) {
        TreePath tp = this.model.getPathFor(b, this.jTree1.getModel(), new TreePath(this.jTree1.getModel().getRoot()));
        this.jTree1.setSelectionPath(tp);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BookmarksManager.this.titleTextField.requestFocusInWindow();
                BookmarksManager.this.titleTextField.selectAll();
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.importButton = new JButton();
        this.importFromWebButton = new JButton();
        this.ExportButton = new JButton();
        this.dismissButton = new JButton();
        this.jLabel3 = new JLabel();
        this.URLTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.titleTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.importMenuItem = new JMenuItem();
        this.importUrlMenuItem = new JMenuItem();
        this.resetToDefaultMenuItem = new JMenuItem();
        this.mergeInDefaultMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.newFolderMenuItem = new JMenuItem();
        this.addItemMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                BookmarksManager.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.importButton.setText("Import...");
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.importButtonActionPerformed(evt);
            }
        });
        this.importFromWebButton.setText("Import From Web...");
        this.importFromWebButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.importFromWebButtonActionPerformed(evt);
            }
        });
        this.ExportButton.setText("Export...");
        this.ExportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.ExportButtonActionPerformed(evt);
            }
        });
        this.dismissButton.setText("OK");
        this.dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.dismissButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("URI:");
        this.jLabel3.setToolTipText("Location of the data (often the URL)");
        this.URLTextField.setToolTipText("Location of the data (often the URL)");
        this.URLTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                BookmarksManager.this.URLTextFieldFocusLost(evt);
            }
        });
        this.URLTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                BookmarksManager.this.URLTextFieldKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Title:");
        this.jLabel2.setToolTipText("Title for the URI");
        this.titleTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.titleTextFieldActionPerformed(evt);
            }
        });
        this.titleTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                BookmarksManager.this.titleTextFieldFocusLost(evt);
            }
        });
        this.titleTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BookmarksManager.this.titleTextFieldPropertyChange(evt);
            }
        });
        this.titleTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                BookmarksManager.this.titleTextFieldKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Bookmarks Manager");
        this.jLabel4.setText("Description:");
        this.descriptionTextField.setToolTipText("Up to a short paragraph describing the data");
        this.descriptionTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                BookmarksManager.this.descriptionTextFieldFocusLost(evt);
            }
        });
        this.descriptionTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                BookmarksManager.this.descriptionTextFieldKeyTyped(evt);
            }
        });
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.jButton1ActionPerformed(evt);
            }
        });
        this.jMenu1.setText("File");
        this.importMenuItem.setText("Import...");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.importMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.importMenuItem);
        this.importUrlMenuItem.setText("Import From Web...");
        this.importUrlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.importUrlMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.importUrlMenuItem);
        this.resetToDefaultMenuItem.setText("Reset to Default");
        this.resetToDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.resetToDefaultMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.resetToDefaultMenuItem);
        this.mergeInDefaultMenuItem.setText("Merge in Default");
        this.mergeInDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.mergeInDefaultMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mergeInDefaultMenuItem);
        this.exportMenuItem.setText("Export...");
        this.exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportMenuItem);
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.closeMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.editMenu.setText("Edit");
        this.newFolderMenuItem.setText("New Folder");
        this.newFolderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.newFolderMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.newFolderMenuItem);
        this.addItemMenuItem.setText("New Bookmark");
        this.addItemMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.addItemMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.addItemMenuItem);
        this.deleteMenuItem.setText("Delete Bookmark");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 681, Short.MAX_VALUE).add(1, (Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.importButton).addPreferredGap(0).add((Component)this.importFromWebButton).addPreferredGap(0).add((Component)this.ExportButton).addPreferredGap(0, 374, Short.MAX_VALUE).add((Component)this.dismissButton)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.URLTextField, -1, 644, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.titleTextField, -1, 639, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.descriptionTextField, -1, 563, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 250, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.titleTextField, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.descriptionTextField, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.URLTextField, -2, -1, -2)).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dismissButton).add((Component)this.importButton).add((Component)this.importFromWebButton).add((Component)this.ExportButton)).addContainerGap()));
        layout.linkSize(new Component[]{this.URLTextField, this.titleTextField}, 2);
        this.pack();
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.model.doImport(this);
    }

    private void importFromWebButtonActionPerformed(ActionEvent evt) {
        this.model.doImportUrl(this);
    }

    private void ExportButtonActionPerformed(ActionEvent evt) {
        this.model.doExport(this);
    }

    private void dismissButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void URLTextFieldFocusLost(FocusEvent evt) {
        Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        if (b != null && b instanceof Bookmark.Item) {
            ((Bookmark.Item)b).setUri(this.URLTextField.getText());
            this.jTree1.repaint();
            this.model.fireBookmarkChange(b);
        }
    }

    private void titleTextFieldFocusLost(FocusEvent evt) {
        Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        if (b != null) {
            b.setTitle(this.titleTextField.getText());
            this.jTree1.repaint();
            this.model.fireBookmarkChange(b);
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        Bookmark b;
        if (this.dirtyBookmark != null) {
            this.dirtyBookmark.setTitle(this.titleTextField.getText());
            if (this.dirtyBookmark instanceof Bookmark.Item) {
                ((Bookmark.Item)this.dirtyBookmark).setUri(this.URLTextField.getText());
            }
            this.dirtyBookmark.setDescription(this.descriptionTextField.getText());
            this.model.fireBookmarkChange(this.dirtyBookmark);
            this.dirtyBookmark = null;
        }
        if ((b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath())) != null) {
            this.titleTextField.setText(b.getTitle());
            this.descriptionTextField.setText(b.getDescription());
            this.URLTextField.setEditable(b instanceof Bookmark.Item);
            if (b instanceof Bookmark.Item) {
                this.URLTextField.setText(((Bookmark.Item)b).getUri());
            } else if (b instanceof Bookmark.Folder && ((Bookmark.Folder)b).getRemoteUrl() != null) {
                String url = ((Bookmark.Folder)b).getRemoteUrl();
                this.URLTextField.setText(url);
            } else {
                this.URLTextField.setText("");
            }
        } else {
            this.titleTextField.setText("");
            this.descriptionTextField.setText("");
            this.URLTextField.setText("");
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        this.model.doImport(this);
    }

    private void importUrlMenuItemActionPerformed(ActionEvent evt) {
        this.model.doImportUrl(this);
    }

    private void resetToDefaultMenuItemActionPerformed(ActionEvent evt) {
        String surl = AutoplotUtil.getProperty("autoplot.default.bookmarks", "http://www.autoplot.org/data/demos.xml");
        int r = JOptionPane.showConfirmDialog(this, "Reset your bookmarks to " + surl + "?", "Reset Bookmarks", 2);
        if (r == 0) {
            try {
                URL url = new URL(surl);
                Document doc = AutoplotUtil.readDoc(url.openStream());
                List<Bookmark> book = Bookmark.parseBookmarks(doc.getDocumentElement());
                this.model.setList(book);
            }
            catch (SAXException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FileNotFoundException ex) {
                new GuiExceptionHandler().handle(ex);
            }
            catch (IOException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        this.model.doExport(this);
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void newFolderMenuItemActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this, (Object)"New Folder Name:");
        if (s != null && !s.equals("")) {
            if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
                try {
                    this.model.addRemoteBookmarks(s, this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath()));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
                    this.showMessage("Error parsing " + s, "Malformed URL error " + ex.getMessage(), 2);
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
                    this.showMessage("Error parsing " + s, "Error in import bookmarks", 2);
                }
                catch (SAXException ex) {
                    Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                    this.showMessage("Error parsing " + s, "Error in import bookmarks", 2);
                }
                catch (FileNotFoundException ex) {
                    this.showMessage("File not found: " + s, "Error in import bookmarks", 2);
                }
                catch (HtmlResponseIOException ex) {
                    Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                    this.showMessage("HTML response (not XML) from " + s, "Error in import bookmarks", 2);
                }
                catch (IOException ex) {
                    Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                    this.showMessage("I/O Error adding " + s, "Error in import bookmarks", 2);
                }
                catch (IllegalArgumentException ex) {
                    this.showMessage("Error in format of " + s + "\n" + ex.toString(), "Error in import bookmarks", 2);
                }
            } else {
                this.model.addBookmark(new Bookmark.Folder(s), this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath()));
            }
        }
    }

    private void addItemMenuItemActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog("Bookmark URL:");
        if (s != null && !s.equals("")) {
            this.model.addBookmark(new Bookmark.Item(s), this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath()));
        }
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        boolean confirm = false;
        List<Bookmark> bs = this.model.getSelectedBookmarks(this.jTree1.getModel(), this.jTree1.getSelectionPaths());
        if (bs.size() > 1 && JOptionPane.showConfirmDialog(this, "Delete " + bs.size() + " bookmarks?", "Delete Bookmarks", 2) == 0) {
            confirm = true;
        }
        for (Bookmark b : bs) {
            if (b instanceof Bookmark.Folder) {
                if (!confirm && JOptionPane.showConfirmDialog(this, "Delete all bookmarks and folder?", "Delete Bookmarks Folder", 2) != 0) continue;
                this.model.removeBookmark(b);
                continue;
            }
            this.model.removeBookmark(b);
        }
    }

    private void titleTextFieldActionPerformed(ActionEvent evt) {
        Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        b.setTitle(this.titleTextField.getText());
        this.jTree1.repaint();
        this.model.fireBookmarkChange(b);
    }

    private void titleTextFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void titleTextFieldKeyTyped(KeyEvent evt) {
        this.dirtyBookmark = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private void URLTextFieldKeyTyped(KeyEvent evt) {
        this.dirtyBookmark = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private void mergeInDefaultMenuItemActionPerformed(ActionEvent evt) {
        try {
            String surl = AutoplotUtil.getProperty("autoplot.default.bookmarks", "http://www.autoplot.org/data/demos.xml");
            URL url = new URL(surl);
            Document doc = AutoplotUtil.readDoc(url.openStream());
            List<Bookmark> importBook = Bookmark.parseBookmarks(doc.getDocumentElement());
            ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.model.list.size());
            for (int i = 0; i < this.model.list.size(); ++i) {
                newList.add(i, this.model.list.get(i).copy());
            }
            this.model.mergeList(importBook, newList);
            this.model.setList(newList);
        }
        catch (SAXException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void descriptionTextFieldFocusLost(FocusEvent evt) {
        Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        if (b != null) {
            b.setDescription(this.descriptionTextField.getText());
            this.jTree1.repaint();
            this.model.fireBookmarkChange(b);
        }
    }

    private void descriptionTextFieldKeyTyped(KeyEvent evt) {
        this.dirtyBookmark = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Bookmark b;
        String txt = this.descriptionTextField.getText();
        if (txt.contains("<br>")) {
            txt = txt.replaceAll("<br>", "\n");
        }
        JTextArea edit = new JTextArea(txt);
        edit.setRows(5);
        edit.setColumns(80);
        JScrollPane jScrollPane2 = new JScrollPane(edit);
        int ok = JOptionPane.showConfirmDialog(this, jScrollPane2, this.titleTextField.getText(), 2);
        if (ok == 0) {
            txt = edit.getText();
            txt = txt.replaceAll("\n", "<br>");
            this.descriptionTextField.setText(txt);
        }
        if ((b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath())) != null) {
            b.setDescription(this.descriptionTextField.getText());
            this.jTree1.repaint();
            this.model.fireBookmarkChange(b);
        }
    }

    private MouseListener createContextMenuMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BookmarksManager.this.contextMenu.show(BookmarksManager.this.jTree1, e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                TreePath path = BookmarksManager.this.jTree1.getPathForLocation(e.getX(), e.getY());
                if (!BookmarksManager.this.jTree1.getSelectionModel().isPathSelected(path)) {
                    BookmarksManager.this.jTree1.getSelectionModel().setSelectionPath(path);
                }
                if (e.isPopupTrigger()) {
                    BookmarksManager.this.contextMenu.show(BookmarksManager.this.jTree1, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BookmarksManager.this.contextMenu.show(BookmarksManager.this.jTree1, e.getX(), e.getY());
                }
            }
        };
    }

    private JPopupMenu createContextMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.createExportFolderAction());
        menu.add(this.createDeleteAction());
        return menu;
    }

    Action createDeleteAction() {
        return new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                boolean confirm = false;
                List<Bookmark> bs = BookmarksManager.this.model.getSelectedBookmarks(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPaths());
                if (bs.size() > 1 && JOptionPane.showConfirmDialog(BookmarksManager.this, "Delete " + bs.size() + " bookmarks?", "Delete Bookmarks", 2) == 0) {
                    confirm = true;
                }
                for (Bookmark b : bs) {
                    if (b instanceof Bookmark.Folder) {
                        if (!confirm && JOptionPane.showConfirmDialog(BookmarksManager.this, "Delete all bookmarks and folder?", "Delete Bookmarks Folder", 2) != 0) continue;
                        BookmarksManager.this.model.removeBookmark(b);
                        continue;
                    }
                    BookmarksManager.this.model.removeBookmark(b);
                }
            }
        };
    }

    Action createExportFolderAction() {
        return new AbstractAction("Export Items..."){

            public void actionPerformed(ActionEvent e) {
                List<Bookmark> bs = BookmarksManager.this.model.getSelectedBookmarks(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPaths());
                BookmarksManager.this.model.doExport(BookmarksManager.this, bs);
            }
        };
    }

    public boolean hasPrefNode(String nodeName) {
        File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/" + nodeName + ".xml");
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefNode(String nodeName) {
        this.prefNode = nodeName;
        BufferedReader read = null;
        try {
            boolean ok;
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            File f = new File(f2, nodeName + ".xml");
            if (!f.exists()) {
                this.model.setList(new ArrayList<Bookmark>());
            } else {
                read = new BufferedReader(new FileReader(f));
                StringBuilder buff = new StringBuilder();
                String s = null;
                do {
                    if (s == null) continue;
                    buff.append(s).append("\n");
                } while ((s = read.readLine()) != null);
                List<Bookmark> book = Bookmark.parseBookmarks(buff.toString());
                this.model.setList(book);
            }
            this.bookmarksFile = f;
            this.model.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BookmarksManager.this.formatToFile(BookmarksManager.this.bookmarksFile);
                }
            });
        }
        catch (SAXException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            this.showMessage("XML error while parsing. " + ex.getMessage(), "Error while parsing", 2);
        }
        catch (IOException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            this.showMessage("IO Error while parsing. " + ex.getMessage(), "Error while parsing", 2);
        }
        finally {
            try {
                if (read != null) {
                    read.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void resetPrefNode(String nodeName) {
        boolean ok;
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        File f = new File(f2, nodeName + ".xml");
        if (f.exists()) {
            throw new IllegalArgumentException("bookmarks pref node already exists: " + f);
        }
        this.formatToFile(f);
        this.bookmarksFile = f;
        this.prefNode = nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatToFile(File f) {
        System.err.println("formatting " + f);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            Bookmark.formatBooks(out, this.model.getList());
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateBookmarks(JMenu bookmarksMenu, final DataSetSelector dataSetSelector) {
        List<Bookmark> bookmarks = this.model.getList();
        bookmarksMenu.removeAll();
        bookmarksMenu.add(new AbstractAction("Add Bookmark..."){

            public void actionPerformed(ActionEvent e) {
                Bookmark bookmark = BookmarksManager.this.addBookmark(dataSetSelector.getEditor().getText());
                BookmarksManager.this.setAddBookmark(bookmark);
                BookmarksManager.this.setVisible(true);
            }
        });
        bookmarksMenu.add(new AbstractAction("Manage Bookmarks"){

            public void actionPerformed(ActionEvent e) {
                Container parent = BookmarksManager.this.getParent();
                BookmarksManager.this.setLocationRelativeTo(parent);
                BookmarksManager.this.setVisible(true);
            }
        });
        bookmarksMenu.add(new JSeparator());
        if (bookmarks == null) {
            bookmarks = Collections.emptyList();
        }
        this.addBookmarks(bookmarksMenu, bookmarks, dataSetSelector);
    }

    private void addBookmarks(JMenu bookmarksMenu, List<Bookmark> bookmarks, final DataSetSelector sel) {
        for (int i = 0; i < bookmarks.size(); ++i) {
            final Bookmark book = bookmarks.get(i);
            if (book instanceof Bookmark.Item) {
                JMenuItem mi = new JMenuItem(new AbstractAction(book.getTitle()){

                    public void actionPerformed(ActionEvent e) {
                        sel.setValue(((Bookmark.Item)book).getUri());
                        sel.maybePlot(e.getModifiers());
                    }
                });
                if (book.getDescription() != null && book.getDescription().length() > 0) {
                    String ttext = "<html><em>" + book.getDescription() + "</em></html>";
                    mi.setToolTipText(ttext);
                }
                if (book.getIcon() != null) {
                    mi.setIcon(AutoplotUtil.scaleIcon(book.getIcon(), -1, 16));
                }
                bookmarksMenu.add(mi);
                continue;
            }
            Bookmark.Folder folder = (Bookmark.Folder)book;
            String title = book.getTitle();
            if (folder.getRemoteUrl() != null) {
                title = folder.getRemoteStatus() == 0 ? title + " " + "(remote)" : (folder.getRemoteStatus() == -1 ? title + " " + "(remote not loaded)" : title + " " + "(remote not available)");
            }
            JMenu subMenu = new JMenu(title);
            if (book.getDescription() != null && book.getDescription().length() > 0) {
                String ttext = "<html><em>" + book.getDescription() + "</em></html>";
                subMenu.setToolTipText(ttext);
            }
            this.addBookmarks(subMenu, folder.getBookmarks(), sel);
            bookmarksMenu.add(subMenu);
        }
    }

    public Bookmark addBookmark(String surl) {
        ArrayList<Bookmark> newValue;
        String autoTitle;
        Bookmark.Item item = new Bookmark.Item(surl);
        URISplit split = URISplit.parse((String)surl);
        String string = autoTitle = split.file == null ? surl : split.file.substring(split.path.length());
        if (autoTitle.length() == 0) {
            autoTitle = surl;
        }
        item.setTitle(autoTitle);
        List<Bookmark> bookmarks = this.model.getList();
        if (bookmarks == null) {
            bookmarks = new ArrayList<Bookmark>();
        }
        if ((newValue = new ArrayList<Bookmark>(bookmarks)).contains(item)) {
            Bookmark.Item old;
            item = old = (Bookmark.Item)newValue.get(newValue.indexOf(item));
            newValue.remove(old);
        }
        newValue.add(item);
        if (this.prefNode == null) {
            Preferences prefs = Preferences.userNodeForPackage(ApplicationModel.class);
            prefs.put("bookmarks", Bookmark.formatBooks(newValue));
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace();
            }
        }
        this.model.setList(newValue);
        return item;
    }
}

