/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.bookmarks;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.bookmarks.BookmarksManager;
import org.virbo.autoplot.bookmarks.BookmarksManagerModel;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksManagerTransferrable {
    private BookmarksManagerModel model;
    private JTree jTree1;
    DataFlavor BOOKMARK_FLAVOR = new DataFlavor(Bookmark.class, "Bookmark");
    DataFlavor BOOKMARK_LIST_FLAVOR = new DataFlavor(List.class, "BookmarkList");

    BookmarksManagerTransferrable(BookmarksManagerModel model, JTree jTree1) {
        this.model = model;
        this.jTree1 = jTree1;
    }

    DropTargetListener createDropTargetListener() {
        return new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR)) {
                    dtde.acceptDrag(3);
                } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrag(1);
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void drop(DropTargetDropEvent dtde) {
                try {
                    Bookmark item = null;
                    List<Bookmark> items = null;
                    if (dtde.isDataFlavorSupported(BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR)) {
                        item = (Bookmark)dtde.getTransferable().getTransferData(BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR);
                    } else if (dtde.isDataFlavorSupported(BookmarksManagerTransferrable.this.BOOKMARK_LIST_FLAVOR)) {
                        items = (List<Bookmark>)dtde.getTransferable().getTransferData(BookmarksManagerTransferrable.this.BOOKMARK_LIST_FLAVOR);
                    } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                        if (data.length() > 19 && data.startsWith("<bookmark-list")) {
                            items = Bookmark.parseBookmarks(data);
                        } else {
                            item = data.length() > 14 && data.startsWith("<bookmark") ? Bookmark.parseBookmark(data) : new Bookmark.Item(data);
                        }
                    }
                    TreePath tp = BookmarksManagerTransferrable.this.jTree1.getPathForLocation((int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                    Bookmark context = BookmarksManagerTransferrable.this.model.getSelectedBookmark(BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                    if (item != null) {
                        if (item == context) {
                            return;
                        }
                        BookmarksManagerTransferrable.this.model.removeBookmark(item);
                        BookmarksManagerTransferrable.this.model.insertBookmark(item, context);
                    } else if (items != null) {
                        BookmarksManagerTransferrable.this.model.removeBookmarks(items);
                        BookmarksManagerTransferrable.this.model.addBookmarks(items, context, true);
                    }
                }
                catch (UnsupportedFlavorException ex) {
                    Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SAXException ex) {
                    Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
    }

    DragGestureListener createDragGestureListener() {
        return new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                if (BookmarksManagerTransferrable.this.jTree1.getSelectionCount() == 1) {
                    Bookmark b = BookmarksManagerTransferrable.this.model.getSelectedBookmark(BookmarksManagerTransferrable.this.jTree1.getModel(), BookmarksManagerTransferrable.this.jTree1.getSelectionPath());
                    if (b instanceof Bookmark.Item) {
                        dge.startDrag(null, BookmarksManagerTransferrable.this.createBookmarkTransferrable((Bookmark.Item)b));
                    } else if (b instanceof Bookmark.Folder) {
                        dge.startDrag(null, BookmarksManagerTransferrable.this.createBookmarkTransferrable((Bookmark.Folder)b));
                    }
                } else {
                    ArrayList<Bookmark> books = new ArrayList<Bookmark>();
                    TreePath[] tps = BookmarksManagerTransferrable.this.jTree1.getSelectionPaths();
                    if (tps == null) {
                        return;
                    }
                    for (TreePath tp : tps) {
                        Bookmark b = BookmarksManagerTransferrable.this.model.getSelectedBookmark(BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                        books.add(b);
                    }
                    dge.startDrag(null, BookmarksManagerTransferrable.this.createBookmarkListTransferrable(books));
                }
            }
        };
    }

    Transferable createBookmarkTransferrable(final Bookmark.Item bookmark) {
        return new Transferable(){

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor == DataFlavor.stringFlavor || flavor == BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor == DataFlavor.stringFlavor) {
                    return bookmark.getUri();
                }
                if (flavor == BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR) {
                    return bookmark;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    Transferable createBookmarkTransferrable(final Bookmark.Folder bookmark) {
        return new Transferable(){

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor == DataFlavor.stringFlavor || flavor == BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor == BookmarksManagerTransferrable.this.BOOKMARK_FLAVOR) {
                    return bookmark;
                }
                if (flavor == DataFlavor.stringFlavor) {
                    return Bookmark.formatBookmark(bookmark);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    Transferable createBookmarkListTransferrable(final List<Bookmark> bookmarks) {
        return new Transferable(){

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, BookmarksManagerTransferrable.this.BOOKMARK_LIST_FLAVOR};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor == BookmarksManagerTransferrable.this.BOOKMARK_LIST_FLAVOR || flavor == DataFlavor.stringFlavor;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor == BookmarksManagerTransferrable.this.BOOKMARK_LIST_FLAVOR) {
                    return bookmarks;
                }
                if (flavor == DataFlavor.stringFlavor) {
                    return Bookmark.formatBooks(bookmarks);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }
}

