/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.das2.DasApplication;
import org.das2.event.MouseModule;
import org.das2.graph.ColumnColumnConnector;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.system.MonitorFactory;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.ColumnColumnConnectorMouseModule;
import org.virbo.autoplot.LayoutListener;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationControllerSupport;
import org.virbo.autoplot.dom.ApplicationControllerSyncSupport;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.BindingSupport;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.CanvasController;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.ColumnController;
import org.virbo.autoplot.dom.Connector;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DebugPropertyChangeSupport;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotController;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PlotElementController;
import org.virbo.autoplot.dom.Row;
import org.virbo.autoplot.dom.RowController;
import org.virbo.autoplot.dom.TimeSeriesBrowseController;
import org.virbo.autoplot.layout.LayoutConstants;
import org.virbo.autoplot.util.RunLaterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationController
extends DomNodeController
implements RunLaterListener.PropertyChange {
    Application application;
    ApplicationModel model;
    DasRow outerRow;
    DasColumn outerColumn;
    LayoutListener layoutListener;
    boolean headless;
    final Map<Object, BindingGroup> bindingContexts;
    protected BindingSupport bindingSupport = new BindingSupport();
    final Map<BindingModel, Binding> bindingImpls;
    final Map<Connector, ColumnColumnConnector> connectorImpls;
    private static final Logger logger = Logger.getLogger("virbo.controller");
    private static AtomicInteger canvasIdNum = new AtomicInteger(0);
    private static AtomicInteger plotIdNum = new AtomicInteger(0);
    private static AtomicInteger plotElementIdNum = new AtomicInteger(0);
    private static AtomicInteger dsfIdNum = new AtomicInteger(0);
    private static AtomicInteger rowIdNum = new AtomicInteger(0);
    private static AtomicInteger columnIdNum = new AtomicInteger(0);
    private static AtomicInteger appIdNum = new AtomicInteger(0);
    ApplicationControllerSyncSupport syncSupport;
    ApplicationControllerSupport support;
    ActionListener eventListener;
    PropertyChangeSupport das2PeerListenerSupport = new DebugPropertyChangeSupport(this);
    AtomicInteger eventId = new AtomicInteger();
    PropertyChangeListener controllerListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            logger.log(Level.FINEST, "controller change: {0}.{1} ({2}->{3})", new Object[]{evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
        }
    };
    PropertyChangeListener domListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            block16: {
                Object newValue;
                DomNodeController c;
                block17: {
                    DomNode d;
                    Object oldValue;
                    logger.log(Level.FINEST, "dom change: {0}.{1} ({2}->{3})", new Object[]{evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
                    Object src = evt.getSource();
                    if (src instanceof DomNode) {
                        c = DomNodeController.getController((DomNode)src);
                    }
                    if (!ApplicationController.this.isValueAdjusting()) {
                        ApplicationController.this.fireActionEvent(new ActionEvent(evt.getSource(), ApplicationController.this.eventId.incrementAndGet(), evt.getPropertyName()));
                    }
                    if ((oldValue = evt.getOldValue()) != null) {
                        if (oldValue instanceof DomNode) {
                            DomNode d2 = (DomNode)oldValue;
                            d2.removePropertyChangeListener(ApplicationController.this.domListener);
                            c = DomNodeController.getController(d2);
                            if (c != null) {
                                c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                            }
                            for (DomNode k : d2.childNodes()) {
                                k.removePropertyChangeListener(ApplicationController.this.domListener);
                                c = DomNodeController.getController(k);
                                if (c == null) continue;
                                c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                            }
                        } else if (oldValue.getClass().isArray() && DomNode.class.isAssignableFrom(oldValue.getClass().getComponentType())) {
                            for (int i = 0; i < Array.getLength(oldValue); ++i) {
                                d = (DomNode)Array.get(oldValue, i);
                                d.removePropertyChangeListener(ApplicationController.this.domListener);
                                c = DomNodeController.getController(d);
                                if (c != null) {
                                    c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                                }
                                for (DomNode k : d.childNodes()) {
                                    k.removePropertyChangeListener(ApplicationController.this.domListener);
                                    c = DomNodeController.getController(k);
                                    if (c == null) continue;
                                    c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                                }
                            }
                        }
                    }
                    if ((newValue = evt.getNewValue()) == null) break block16;
                    if (!(newValue instanceof DomNode)) break block17;
                    d = (DomNode)newValue;
                    d.addPropertyChangeListener(ApplicationController.this.domListener);
                    c = DomNodeController.getController(d);
                    if (c != null) {
                        c.addPropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                    for (DomNode k : d.childNodes()) {
                        k.addPropertyChangeListener(ApplicationController.this.domListener);
                        c = DomNodeController.getController(k);
                        if (c == null) continue;
                        c.addPropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                    break block16;
                }
                if (!newValue.getClass().isArray() || !DomNode.class.isAssignableFrom(newValue.getClass().getComponentType())) break block16;
                for (int i = 0; i < Array.getLength(newValue); ++i) {
                    DomNode d = (DomNode)Array.get(newValue, i);
                    d.addPropertyChangeListener(ApplicationController.this.domListener);
                    c = DomNodeController.getController(d);
                    if (c != null) {
                        c.addPropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                    for (DomNode k : d.childNodes()) {
                        k.addPropertyChangeListener(ApplicationController.this.domListener);
                        c = DomNodeController.getController(k);
                        if (c == null) continue;
                        c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                }
            }
        }
    };
    FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            Plot domPlot;
            super.focusGained(e);
            if (e.getComponent() instanceof ColumnColumnConnector) {
                // empty if block
            }
            if ((domPlot = ApplicationController.this.getPlotFor(e.getComponent())) == null) {
                return;
            }
            DasPlot dasPlot = domPlot.controller.getDasPlot();
            PlotElement p = null;
            Renderer r = dasPlot.getFocusRenderer();
            if (r != null) {
                p = ApplicationController.this.findPlotElement(r);
                ApplicationController.this.setPlotElement(p);
            }
            List<PlotElement> ps = ApplicationController.this.getPlotElementsFor(domPlot);
            if (p == null && ps.size() == 1) {
                ApplicationController.this.setFocusUri(ApplicationController.getFocusUriFor(ps.get(0)));
            }
            ApplicationController.this.setPlot(domPlot);
            if (p != null) {
                logger.log(Level.FINE, "focus due to plot getting focus: {0}", p);
                ApplicationController.this.setFocusUri(ApplicationController.getFocusUriFor(p));
                ApplicationController.this.setPlotElement(p);
                ApplicationController.this.setStatus("" + domPlot + ", " + p + " selected");
                if (ApplicationController.this.getApplication().getPlotElements().length > 1) {
                    ApplicationController.this.canvas.controller.indicateSelection(Arrays.asList(domPlot, p));
                }
            } else {
                ApplicationController.this.setStatus("" + domPlot + " selected");
            }
        }
    };
    PropertyChangeListener plotIdListener = new PropertyChangeListener(){

        public String toString() {
            return "" + ApplicationController.this;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Plot dst;
            PlotElement p = (PlotElement)evt.getSource();
            String srcid = (String)evt.getOldValue();
            String dstid = (String)evt.getNewValue();
            if (srcid == null) {
                srcid = "";
            }
            if (dstid == null) {
                dstid = "";
            }
            Plot src = srcid.length() == 0 ? null : (Plot)DomUtil.getElementById(ApplicationController.this.application, srcid);
            Plot plot = dst = dstid.length() == 0 ? null : (Plot)DomUtil.getElementById(ApplicationController.this.application, dstid);
            if (src == null) {
                if (dst != null) {
                    dst.getController().addPlotElement(p, false);
                } else {
                    return;
                }
            }
            if (dst == null) {
                src.getController().removePlotElement(p);
                return;
            }
            if (src != null && dst != null) {
                ApplicationController.this.movePlotElement(p, src, dst);
                if (ApplicationController.this.getPlotElementsFor(dst).size() == 1) {
                    dst.syncTo(p.plotDefaults, Arrays.asList("id", "rowId", "columnId"));
                }
            }
        }
    };
    PropertyChangeListener rendererFocusListener = new PropertyChangeListener(){

        public String toString() {
            return "" + ApplicationController.this;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DasPlot dasPlot = (DasPlot)evt.getSource();
            Renderer r = dasPlot.getFocusRenderer();
            if (r == null) {
                return;
            }
            PlotElement p = ApplicationController.this.findPlotElement(r);
            if (ApplicationController.this.getPlotElement() != p) {
                ApplicationController.this.setPlotElement(p);
            }
        }
    };
    protected String status = "";
    public static final String PROP_STATUS = "status";
    protected String focusUri = "";
    public static final String PROP_FOCUSURI = "focusUri";
    protected PlotElement plotElement;
    public static final String PROP_PLOT_ELEMENT = "plotElement";
    protected Plot plot;
    public static final String PROP_PLOT = "plot";
    protected Canvas canvas;
    public static final String PROP_CANVAS = "canvas";
    protected DataSourceFilter dataSourceFilter;
    public static final String PROP_DATASOURCEFILTER = "dataSourceFilter";

    public ApplicationController(ApplicationModel model, Application application) {
        super(application);
        this.changesSupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(ApplicationController.PROP_STATUS) && "ready".equals(evt.getNewValue())) {
                    ApplicationController.this.fireActionEvent(new ActionEvent(this, 0, "ready"));
                }
                if (evt.getPropertyName().equals("valueAdjusting") && evt.getNewValue() == null) {
                    String description = (String)evt.getOldValue();
                    if (description.length() > 0) {
                        ApplicationController.this.fireActionEvent(new ActionEvent(this, 0, "label: " + description));
                    } else {
                        ApplicationController.this.fireActionEvent(new ActionEvent(this, 0, "ready"));
                    }
                }
            }
        });
        this.application = application;
        this.syncSupport = new ApplicationControllerSyncSupport(this);
        this.support = new ApplicationControllerSupport(this);
        int i = appIdNum.getAndIncrement();
        application.setId("app_" + i);
        application.getOptions().setId("options_" + i);
        application.addPropertyChangeListener(this.domListener);
        for (DomNode n : application.childNodes()) {
            n.addPropertyChangeListener(this.domListener);
        }
        this.model = model;
        application.controller = this;
        this.bindingContexts = new HashMap<Object, BindingGroup>();
        this.bindingImpls = new HashMap<BindingModel, Binding>();
        this.connectorImpls = new HashMap<Connector, ColumnColumnConnector>();
        this.addListeners();
    }

    public void addActionListener(ActionListener list) {
        this.eventListener = AWTEventMulticaster.add(this.eventListener, list);
    }

    public Application getApplication() {
        return this.application;
    }

    public ApplicationModel getApplicationModel() {
        return this.model;
    }

    public void removeActionListener(ActionListener list) {
        AWTEventMulticaster.remove(this.eventListener, list);
    }

    public synchronized void addDas2PeerChangeListener(PropertyChangeListener listener) {
        this.das2PeerListenerSupport.addPropertyChangeListener(listener);
        if (this.application.getPlots(0).getController() != null) {
            this.das2PeerListenerSupport.firePropertyChange("das2peer", null, this.application.getPlots(0).getController());
        }
    }

    void maybeAddContextMenus(PlotController aThis) {
        this.das2PeerListenerSupport.firePropertyChange("das2peer", null, aThis);
    }

    private void fireActionEvent(ActionEvent e) {
        ActionListener listener = this.eventListener;
        if (listener != null) {
            listener.actionPerformed(e);
        }
    }

    private static String getFocusUriFor(PlotElement p) {
        DataSourceFilter dsf = p.controller.getDataSourceFilter();
        if (dsf != null) {
            return dsf.getUri();
        }
        return "";
    }

    public void fillEditPlotMenu(JMenu editPlotMenu, final Plot domPlot) {
        JMenuItem item = new JMenuItem(new AbstractAction("Remove Bindings"){

            public void actionPerformed(ActionEvent e) {
                ArrayList<BindingModel> bms = new ArrayList<BindingModel>();
                List<PlotElement> peles = ApplicationController.this.getPlotElementsFor(domPlot);
                for (PlotElement pele : peles) {
                    bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(pele)));
                    ApplicationController.this.unbind(pele);
                }
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot)));
                ApplicationController.this.unbind(domPlot);
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot.xaxis)));
                ApplicationController.this.unbind(domPlot.xaxis);
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot.yaxis)));
                ApplicationController.this.unbind(domPlot.yaxis);
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot.zaxis)));
                ApplicationController.this.unbind(domPlot.zaxis);
                ApplicationController.this.setStatus("removed " + bms.size() + " bindings");
            }
        });
        item.setToolTipText("remove any plot and plot element property bindings");
        editPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationController.this.application.getPlots().length > 1) {
                    List<PlotElement> plotElements = ApplicationController.this.getPlotElementsFor(domPlot);
                    for (PlotElement pele : plotElements) {
                        if (ApplicationController.this.application.getPlotElements().length > 1) {
                            ApplicationController.this.deletePlotElement(pele);
                            continue;
                        }
                        ApplicationController.this.setStatus("warning: the last plot element may not be deleted");
                    }
                    ApplicationController.this.deletePlot(domPlot);
                } else {
                    ArrayList<PlotElement> pes = new ArrayList<PlotElement>(ApplicationController.this.getPlotElementsFor(domPlot));
                    Collections.reverse(pes);
                    for (PlotElement pe : pes) {
                        ApplicationController.this.deletePlotElement(pe);
                    }
                    domPlot.syncTo(new Plot(), Arrays.asList("id", "rowId", "columnId"));
                }
            }
        });
        editPlotMenu.add(item);
    }

    public Plot getPlotFor(Component c) {
        Plot plot1 = null;
        for (Plot p : this.application.getPlots()) {
            DasPlot p1 = p.controller.getDasPlot();
            if (p1 == c || p1.getXAxis() == c || p1.getYAxis() == c) {
                plot1 = p;
                break;
            }
            if (p.controller.getDasColorBar() != c) continue;
            plot1 = p;
            break;
        }
        return plot1;
    }

    public void doplot(Plot plot, PlotElement pele, String secondaryUri, String teriaryUri, String primaryUri) {
        this.support.plot(plot, pele, secondaryUri, teriaryUri, primaryUri);
    }

    public void doplot(Plot plot, PlotElement pele, String secondaryUri, String primaryUri) {
        this.support.plot(plot, pele, secondaryUri, primaryUri);
    }

    public void doplot(Plot plot, PlotElement pele, String primaryUri) {
        this.support.plot(plot, pele, primaryUri);
    }

    public void waitUntilIdle() {
        while (this.isPendingChanges()) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ApplicationController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected synchronized DataSourceFilter addDataSourceFilter() {
        DataSourceController dsfc;
        DataSourceFilter dsf = new DataSourceFilter();
        dsf.controller = dsfc = new DataSourceController(this.model, dsf);
        this.assignId(dsf);
        ArrayList<DataSourceFilter> dataSourceFilters = new ArrayList<DataSourceFilter>(Arrays.asList(this.application.getDataSourceFilters()));
        dataSourceFilters.add(dsf);
        this.application.setDataSourceFilters(dataSourceFilters.toArray(new DataSourceFilter[dataSourceFilters.size()]));
        dsf.addPropertyChangeListener(this.domListener);
        return dsf;
    }

    private void addListeners() {
        this.addPropertyChangeListener(PROP_PLOT_ELEMENT, new PropertyChangeListener(){

            public String toString() {
                return "" + ApplicationController.this;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (!ApplicationController.this.isValueAdjusting()) {
                    PlotElement p = ApplicationController.this.getPlotElement();
                    if (p != null) {
                        ApplicationController.this.setDataSourceFilter(ApplicationController.this.getDataSourceFilterFor(p));
                        ApplicationController.this.setPlot(ApplicationController.this.getPlotFor(p));
                    } else {
                        ApplicationController.this.setDataSourceFilter(null);
                    }
                }
            }
        });
        this.application.addPropertyChangeListener("plotElements", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (ApplicationController.this.application.getPlotElements().length > 1) {
                    ApplicationController.this.application.options.setLayoutVisible(true);
                }
            }
        });
    }

    public synchronized DasCanvas addCanvas() {
        logger.fine("enter addCanvas");
        DasCanvas.setDisableActions((boolean)true);
        Canvas lcanvas = new Canvas();
        DasCanvas dasCanvas = new DasCanvas(lcanvas.getWidth(), lcanvas.getHeight());
        dasCanvas.setScaleFonts(false);
        this.assignId(lcanvas);
        new CanvasController(this.application, lcanvas).setDasCanvas(dasCanvas);
        new RowController(lcanvas.getMarginRow()).createDasPeer(lcanvas, null);
        new ColumnController(lcanvas.getMarginColumn()).createDasPeer(lcanvas, null);
        this.layoutListener = new LayoutListener(this.model);
        this.application.setCanvases(new Canvas[]{lcanvas});
        this.setCanvas(lcanvas);
        this.bindTo(dasCanvas);
        lcanvas.addPropertyChangeListener(this.domListener);
        dasCanvas.setPrintingTag("");
        return dasCanvas;
    }

    public void deletePlotElement(PlotElement pelement) {
        List<PlotElement> dsfElements;
        logger.log(Level.FINE, "deletePlotElement({0})", pelement);
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Plot Element");
        int currentIdx = this.application.plotElements.indexOf(pelement);
        if (currentIdx == -1) {
            throw new IllegalArgumentException("deletePlotElement but plot element isn't part of application");
        }
        String id = pelement.getId();
        if (this.application.plotElements.size() > 1) {
            Renderer r;
            DasPlot p = pelement.controller.getDasPlot();
            if (p != null && (r = pelement.controller.getRenderer()) != null) {
                p.removeRenderer(r);
            }
            pelement.removePropertyChangeListener(this.domListener);
            pelement.getStyle().removePropertyChangeListener(this.domListener);
            this.unbind(pelement);
            pelement.controller.unbindDsf();
            pelement.removePropertyChangeListener(this.plotIdListener);
        }
        DataSourceFilter dsf = this.getDataSourceFilterFor(pelement);
        ArrayList<PlotElement> elements = new ArrayList<PlotElement>(Arrays.asList(this.application.getPlotElements()));
        elements.remove(pelement);
        if (elements.size() > 0) {
            if (!elements.contains(this.getPlotElement())) {
                if (elements.size() == 0) {
                    this.setPlotElement(null);
                } else {
                    this.setPlotElement(elements.get(0));
                }
            }
            this.application.setPlotElements(elements.toArray(new PlotElement[elements.size()]));
        } else {
            dsf.setUri(null);
            pelement.setLegendLabelAutomatically("");
            pelement.setActive(true);
        }
        if (dsf != null && (dsfElements = this.getPlotElementsFor(dsf)).size() == 0 && this.application.getDataSourceFilters().length > 1) {
            this.deleteDataSourceFilter(dsf);
        }
        for (PlotElement p : this.application.plotElements) {
            if (!p.getParent().equals(id)) continue;
            p.setParent("");
        }
        lock.unlock();
    }

    public void addConnector(Plot domPlot, Plot that) {
        logger.log(Level.FINE, "addConnector({0},{1})", new Object[]{domPlot, that});
        ArrayList<Connector> connectors = new ArrayList<Connector>(Arrays.asList(this.application.getConnectors()));
        Connector connector = new Connector(domPlot.getId(), that.getId());
        connectors.add(connector);
        this.application.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        DasCanvas lcanvas = this.getDasCanvas();
        DasPlot upper = domPlot.controller.getDasPlot();
        DasPlot lower = that.controller.getDasPlot();
        ColumnColumnConnector overviewPlotConnector = new ColumnColumnConnector(lcanvas, upper, DasRow.create(null, (DasRow)upper.getRow(), (String)"0%", (String)"100%+2em"), lower);
        this.connectorImpls.put(connector, overviewPlotConnector);
        overviewPlotConnector.setBottomCurtain(true);
        overviewPlotConnector.setCurtainOpacityPercent(80);
        ColumnColumnConnectorMouseModule mm = new ColumnColumnConnectorMouseModule(upper, lower);
        overviewPlotConnector.getDasMouseInputAdapter().setSecondaryModule((MouseModule)mm);
        overviewPlotConnector.getDasMouseInputAdapter().setPrimaryModule((MouseModule)mm);
        lcanvas.add((Component)overviewPlotConnector);
        lcanvas.revalidate();
    }

    public void deleteConnector(Connector connector) {
        logger.log(Level.FINE, "deleteConnector({0})", connector);
        ColumnColumnConnector impl = this.connectorImpls.get(connector);
        if (impl != null) {
            this.getDasCanvas().remove((Component)impl);
        }
        ArrayList<Connector> connectors = DomUtil.asArrayList(this.application.getConnectors());
        connectors.remove(connector);
        this.connectorImpls.remove(connector);
        this.application.setConnectors(connectors.toArray(new Connector[connectors.size()]));
    }

    private void movePlotElement(PlotElement p, Plot src, Plot dst) {
        assert (src == null || p.getPlotId().equals(src.getId()) || p.getPlotId().equals(dst.getId()));
        if (src == dst) {
            return;
        }
        if (src != null) {
            src.getController().removePlotElement(p);
        }
        dst.getController().addPlotElement(p, false);
        p.setPlotId(dst.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotElement addPlotElement(Plot domPlot, DataSourceFilter dsf) {
        PlotElementController pec;
        logger.log(Level.FINE, "enter addPlotElement({0},{1})", new Object[]{domPlot, dsf});
        PlotElement pele1 = new PlotElement();
        if (dsf == null) {
            dsf = this.addDataSourceFilter();
        }
        pele1.controller = pec = new PlotElementController(this.model, this.application, pele1);
        if (domPlot == null) {
            domPlot = this.addPlot(LayoutConstants.BELOW);
        }
        this.assignId(pele1);
        pele1.getStyle().setColor(this.application.getOptions().getColor());
        pele1.getStyle().setFillColor(this.application.getOptions().getFillColor());
        pele1.getStyle().setAntiAliased(this.application.getOptions().isDrawAntiAlias());
        pele1.addPropertyChangeListener("plotId", this.plotIdListener);
        pele1.setPlotId(domPlot.getId());
        pele1.setDataSourceFilterId(dsf.getId());
        pele1.setAutoLabel(true);
        ApplicationController applicationController = this;
        synchronized (applicationController) {
            PlotElement[] p = this.application.getPlotElements();
            PlotElement[] temp = new PlotElement[p.length + 1];
            System.arraycopy(p, 0, temp, 0, p.length);
            temp[p.length] = pele1;
            this.application.setPlotElements(temp);
            pele1.addPropertyChangeListener(this.domListener);
            pele1.getStyle().addPropertyChangeListener(this.domListener);
            if (this.plotElement == null) {
                this.setPlotElement(pele1);
            }
        }
        if (domPlot.getController() != null) {
            domPlot.controller.addPlotElement(pele1);
        }
        return pele1;
    }

    public synchronized Plot addPlot(Object direction) {
        Plot focus = this.getPlot();
        return this.addPlot(focus, direction);
    }

    public synchronized Plot addPlot(Plot focus, Object direction) {
        Row domRow;
        logger.fine("enter addPlot");
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Plot");
        Plot domPlot = new Plot();
        CanvasController ccontroller = this.canvas.controller;
        if (focus != null && ccontroller.getRowFor(focus) == this.canvas.marginRow) {
            String srcRow;
            if (this.canvas.getRows().length > 0) {
                srcRow = this.canvas.getRows(0).getId();
            } else {
                ccontroller.addRows(2);
                srcRow = this.canvas.getRows(0).getId();
            }
            domRow = this.canvas.getRows().length > 1 ? this.canvas.getRows(1) : ccontroller.addInsertRow(ccontroller.getRowFor(focus), direction);
            focus.setRowId(srcRow);
        } else {
            domRow = this.canvas.getRows().length == 0 && (direction == LayoutConstants.BELOW || direction == LayoutConstants.ABOVE) ? ccontroller.addRow() : (direction == null || direction == LayoutConstants.LEFT || direction == LayoutConstants.RIGHT ? ccontroller.getRowFor(focus) : ccontroller.addInsertRow(ccontroller.getRowFor(focus), direction));
        }
        Column domColumn = this.canvas.getMarginColumn();
        if (direction == null || direction == LayoutConstants.ABOVE || direction == LayoutConstants.BELOW) {
            domColumn = this.canvas.marginColumn;
        } else if (ccontroller.getColumnFor(focus) == this.canvas.marginColumn) {
            String srcColumn;
            if (this.canvas.getColumns().length > 0) {
                srcColumn = this.canvas.getColumns(0).getId();
            } else {
                ccontroller.addColumns(2);
                srcColumn = this.canvas.getColumns(0).getId();
            }
            domColumn = this.canvas.getColumns().length > 1 ? this.canvas.getColumns(1) : ccontroller.addInsertColumn(ccontroller.getColumnFor(focus), direction);
            focus.setColumnId(srcColumn);
        } else {
            domColumn = ccontroller.addInsertColumn(ccontroller.getColumnFor(focus), direction);
        }
        this.assignId(domPlot);
        new PlotController(this.application, domPlot).createDasPeer(this.canvas, domRow, domColumn);
        domPlot.getXaxis().setAutoRange(true);
        domPlot.getYaxis().setAutoRange(true);
        domPlot.getZaxis().setAutoRange(true);
        domPlot.getXaxis().setAutoLabel(true);
        domPlot.getYaxis().setAutoLabel(true);
        domPlot.getZaxis().setAutoLabel(true);
        domPlot.setAutoLabel(true);
        domPlot.setAutoBinding(true);
        domPlot.getZaxis().setVisible(false);
        domPlot.setRowId(domRow.getId());
        domPlot.setColumnId(domColumn.getId());
        ArrayList<Plot> plots = new ArrayList<Plot>(Arrays.asList(this.application.getPlots()));
        if (focus != null) {
            int idx = plots.indexOf(focus);
            if (direction == null || direction == LayoutConstants.BELOW) {
                ++idx;
            }
            plots.add(idx, domPlot);
        } else {
            plots.add(domPlot);
        }
        this.application.setPlots(plots.toArray(new Plot[plots.size()]));
        if (this.getPlot() == null) {
            this.setPlot(domPlot);
        }
        domPlot.addPropertyChangeListener(this.domListener);
        lock.unlock();
        return domPlot;
    }

    public Plot addPlot(Row get, Column get0) {
        Plot p = this.addPlot(null);
        p.setRowId(get.getId());
        p.setColumnId(get0.getId());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Plot> addPlots(int nrow, int ncol, Object dir) {
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock(String.format("addPlots(%d,%d,%s)", nrow, ncol, dir));
        try {
            ArrayList<Plot> result = new ArrayList<Plot>(nrow * ncol);
            CanvasController ccontroller = this.getCanvas().getController();
            List<Column> cols = ncol > 1 ? ccontroller.addColumns(ncol) : Collections.singletonList(this.getCanvas().getMarginColumn());
            List<Row> rows = dir == null && nrow == 1 ? Collections.singletonList(ccontroller.getRowFor(this.plot)) : ccontroller.addRows(nrow, dir);
            for (int i = 0; i < nrow; ++i) {
                for (int j = 0; j < ncol; ++j) {
                    Plot p = this.addPlot(rows.get(i), cols.get(j));
                    result.add(p);
                    this.addPlotElement(p, null);
                }
            }
            ArrayList<Plot> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    protected PlotElement findPlotElement(Renderer rend) {
        for (PlotElement p : this.application.getPlotElements()) {
            PlotElementController pc = p.controller;
            if (pc.getRenderer() != rend) continue;
            return p;
        }
        throw new IllegalArgumentException("unable to find plot element for das renderer");
    }

    private Plot findPlot(DasPlot plot) {
        for (Plot p : this.application.getPlots()) {
            PlotController pc = p.controller;
            if (pc.getDasPlot() != plot) continue;
            return p;
        }
        throw new IllegalArgumentException("unable to find plot for das plot");
    }

    public Plot copyPlotAndPanels(Plot domPlot, DataSourceFilter dsf, boolean bindx, boolean bindy) {
        return this.copyPlotAndPlotElements(domPlot, dsf, bindx, bindy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot copyPlotAndPlotElements(Plot domPlot, DataSourceFilter dsf, boolean bindx, boolean bindy) {
        ArrayList<PlotElement> newElements;
        Plot newPlot;
        List<PlotElement> srcElements = this.getPlotElementsFor(domPlot);
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("Copy Plot and Plot Elements");
        try {
            newPlot = this.copyPlot(domPlot, bindx, bindy, false);
            if (srcElements.size() == 0) {
                Plot plot = newPlot;
                return plot;
            }
            newElements = new ArrayList<PlotElement>();
            for (PlotElement srcElement : srcElements) {
                PlotElement newp;
                if (!srcElement.getComponent().equals("")) {
                    if (srcElement.getController().getParentPlotElement() != null) continue;
                    newp = this.copyPlotElement(srcElement, newPlot, dsf);
                    newElements.add(newp);
                    continue;
                }
                newp = this.copyPlotElement(srcElement, newPlot, dsf);
                newElements.add(newp);
                List<PlotElement> srcKids = srcElement.controller.getChildPlotElements();
                ArrayList<PlotElement> newKids = new ArrayList<PlotElement>();
                DataSourceFilter dsf1 = this.getDataSourceFilterFor(newp);
                for (PlotElement k : srcKids) {
                    if (!srcElements.contains(k)) continue;
                    PlotElement kidp = this.copyPlotElement(k, newPlot, dsf1);
                    kidp.getController().setParentPlotElement(newp);
                    newElements.add(kidp);
                    newKids.add(kidp);
                }
            }
        }
        finally {
            lock.unlock();
        }
        for (PlotElement newp : newElements) {
            newp.getController().setResetRanges(false);
            newp.getController().setResetComponent(false);
            newp.getController().setResetPlotElement(false);
            newp.getController().setResetRenderType(false);
            newp.getController().setDsfReset(true);
        }
        return newPlot;
    }

    protected PlotElement copyPanel(PlotElement srcElement, Plot domPlot, DataSourceFilter dsf) {
        return this.copyPlotElement(srcElement, domPlot, dsf);
    }

    protected PlotElement copyPlotElement(PlotElement srcElement, Plot domPlot, DataSourceFilter dsf) {
        logger.log(Level.FINER, "copyPlotElement({0},{1},{2})", new Object[]{srcElement, domPlot, dsf});
        PlotElement newp = this.addPlotElement(domPlot, dsf);
        newp.getController().setResetPlotElement(false);
        newp.getController().setDsfReset(false);
        newp.syncTo(srcElement, Arrays.asList("id", "plotId", "dataSourceFilterId"));
        if (dsf == null) {
            DataSourceFilter dsfnew = newp.controller.getDataSourceFilter();
            DataSourceFilter dsfsrc = srcElement.controller.getDataSourceFilter();
            this.copyDataSourceFilter(dsfsrc, dsfnew);
        }
        return newp;
    }

    public Plot copyPlot(Plot srcPlot, boolean bindx, boolean bindy, boolean addPlotElement) {
        Plot that = this.addPlot(LayoutConstants.BELOW);
        that.setAutoBinding(false);
        that.getController().setAutoBinding(false);
        if (addPlotElement) {
            this.addPlotElement(that, null);
        }
        that.syncTo(srcPlot, Arrays.asList("id", "rowId", "columnId"));
        if (bindx) {
            BindingModel bb = this.findBinding(this.application, "timeRange", srcPlot.getXaxis(), "range");
            if (bb == null) {
                this.bind(srcPlot.getXaxis(), "range", that.getXaxis(), "range");
            } else {
                this.bind(this.application, "timeRange", that.getXaxis(), "range");
            }
        }
        if (bindy) {
            this.bind(srcPlot.getYaxis(), "range", that.getYaxis(), "range");
        }
        return that;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDataSourceFilter(DataSourceFilter dsfsrc, DataSourceFilter dsfnew) {
        ChangesSupport.DomLock lock = dsfnew.getController().mutatorLock();
        lock.lock("Copy Data Source Filter");
        try {
            boolean dataSetNeedsLoading = dsfsrc.controller.isDataSetNeedsLoading();
            dsfnew.controller.setResetDimensions(false);
            if (dsfsrc.getUri() != null) {
                dsfnew.setUri(dsfsrc.getUri());
            }
            if (!dataSetNeedsLoading) {
                dsfnew.controller.setUriNeedsResolution(false);
                dsfnew.controller.resetDataSource(false, dsfsrc.controller.getDataSource());
                dsfnew.controller.setDataSetNeedsLoading(false);
                dsfnew.controller.setResetDimensions(false);
                dsfnew.controller.setDataSetInternal(dsfsrc.controller.getDataSet(), dsfsrc.controller.getRawProperties(), this.isValueAdjusting());
                dsfnew.controller.setProperties(dsfsrc.controller.getProperties());
                dsfnew.setFilters(dsfsrc.getFilters());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlot(Plot domPlot) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Plot");
        if (!this.application.plots.contains(domPlot)) {
            throw new IllegalArgumentException("plot is not in this application");
        }
        if (this.application.plots.size() < 2) {
            throw new IllegalArgumentException("last plot cannot be deleted");
        }
        List<PlotElement> elements = this.getPlotElementsFor(domPlot);
        if (elements.size() > 0) {
            for (PlotElement p : elements) {
                if (this.application.plotElements.size() <= 1) continue;
                this.deletePlotElement(p);
            }
        }
        for (Connector c : DomUtil.asArrayList(this.application.getConnectors())) {
            if (!c.getPlotA().equals(domPlot.getId()) && !c.getPlotB().equals(domPlot.getId())) continue;
            this.deleteConnector(c);
        }
        Row deleteRow = null;
        Row row = (Row)DomUtil.getElementById(this.application, domPlot.getRowId());
        List<DomNode> plotsUsingRow = DomUtil.rowUsages(this.application, row.getId());
        plotsUsingRow.remove(domPlot);
        if (plotsUsingRow.size() == 0) {
            deleteRow = row;
        }
        domPlot.removePropertyChangeListener(this.domListener);
        this.unbind(domPlot);
        this.unbind(domPlot.getXaxis());
        this.unbind(domPlot.getYaxis());
        this.unbind(domPlot.getZaxis());
        DasPlot p = domPlot.controller.getDasPlot();
        this.getDasCanvas().remove((Component)p);
        DasColorBar cb = domPlot.controller.getDasColorBar();
        this.getDasCanvas().remove((Component)cb);
        ApplicationController applicationController = this;
        synchronized (applicationController) {
            ArrayList<Plot> plots = new ArrayList<Plot>(Arrays.asList(this.application.getPlots()));
            plots.remove(domPlot);
            if (!plots.contains(this.getPlot())) {
                if (plots.size() == 0) {
                    this.setPlot(null);
                } else {
                    this.setPlot((Plot)plots.get(0));
                }
            }
            this.application.setPlots(plots.toArray(new Plot[plots.size()]));
            if (deleteRow != null) {
                CanvasController cc = row.controller.getCanvas().controller;
                cc.deleteRow(deleteRow);
                cc.removeGaps();
            }
        }
        lock.unlock();
    }

    protected synchronized void deleteParentsOfDataSourceFilter(DataSourceFilter dsf) {
        DataSourceFilter[] parents = dsf.controller.getParentSources();
        ArrayList<DataSourceFilter> alsoRemove = new ArrayList<DataSourceFilter>();
        for (DataSourceFilter pdf : parents) {
            if (pdf == null) continue;
            String dsfId = pdf.getId();
            List<DomNode> usages = DomUtil.dataSourceUsages(this.application, dsfId);
            usages.remove(dsf);
            if (usages.size() != 0) continue;
            alsoRemove.add(pdf);
        }
        if (alsoRemove.size() > 0) {
            ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>(Arrays.asList(this.application.getDataSourceFilters()));
            dsfs.removeAll(alsoRemove);
            this.application.setDataSourceFilters(dsfs.toArray(new DataSourceFilter[dsfs.size()]));
            for (int i = 0; i < alsoRemove.size(); ++i) {
                TimeSeriesBrowseController tsbc = ((DataSourceFilter)alsoRemove.get((int)i)).controller.getTimeSeriesBrowseController();
                if (tsbc == null) continue;
                tsbc.release();
            }
        }
    }

    public synchronized void deleteDataSourceFilter(DataSourceFilter dsf) {
        if (!this.application.dataSourceFilters.contains(dsf)) {
            logger.fine("dsf wasn't part of the application");
            return;
        }
        if (this.application.dataSourceFilters.size() < 2) {
            throw new IllegalArgumentException("last plot cannot be deleted");
        }
        List<PlotElement> plotElements = this.getPlotElementsFor(dsf);
        if (plotElements.size() > 0) {
            throw new IllegalArgumentException("dsf must not have plot elements before deleting");
        }
        dsf.removePropertyChangeListener(this.domListener);
        this.unbind(dsf);
        dsf.controller.unbind();
        DataSourceFilter[] parents = dsf.controller.getParentSources();
        ArrayList<DataSourceFilter> alsoRemove = new ArrayList<DataSourceFilter>();
        for (DataSourceFilter pdf : parents) {
            if (pdf == null) continue;
            String dsfId = pdf.getId();
            List<DomNode> usages = DomUtil.dataSourceUsages(this.application, dsfId);
            usages.remove(dsf);
            if (usages.size() != 0) continue;
            alsoRemove.add(pdf);
        }
        ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>(Arrays.asList(this.application.getDataSourceFilters()));
        dsfs.remove(dsf);
        dsfs.removeAll(alsoRemove);
        if (!dsfs.contains(this.getDataSourceFilter())) {
            if (dsfs.size() == 0) {
                this.setDataSourceFilter(null);
            } else {
                this.setDataSourceFilter((DataSourceFilter)dsfs.get(0));
            }
        }
        this.application.setDataSourceFilters(dsfs.toArray(new DataSourceFilter[dsfs.size()]));
        TimeSeriesBrowseController tsbc = dsf.getController().getTimeSeriesBrowseController();
        if (tsbc != null) {
            tsbc.release();
        }
        for (int i = 0; i < alsoRemove.size(); ++i) {
            tsbc = ((DataSourceFilter)alsoRemove.get((int)i)).controller.getTimeSeriesBrowseController();
            if (tsbc == null) continue;
            tsbc.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("Reset");
        Lock canvasLock = this.canvas.controller.getDasCanvas().mutatorLock();
        canvasLock.lock();
        try {
            int i;
            int i2;
            Plot p0 = this.getPlotFor(this.application.getPlotElements(0));
            for (int i22 = this.application.getPlots().length - 1; i22 > 0; --i22) {
                this.deletePlot(this.application.getPlots(i22));
            }
            for (i2 = this.application.getPlotElements().length - 1; i2 > 0; --i2) {
                this.deletePlotElement(this.application.getPlotElements(i2));
            }
            this.application.getDataSourceFilters(0).setId("data_0");
            this.application.getPlotElements(0).setDataSourceFilterId("data_0");
            if (p0 != this.application.getPlots(0)) {
                this.movePlotElement(this.application.getPlotElements(0), p0, this.application.getPlots(0));
            }
            this.application.getPlots(0).setId("plot_0");
            this.application.getPlotElements(0).setPlotId("plot_0");
            for (i2 = this.application.getDataSourceFilters().length - 1; i2 > 0; --i2) {
                this.deleteDataSourceFilter(this.application.getDataSourceFilters(i2));
            }
            this.application.getPlotElements(0).setId("plotElement_0");
            this.application.getPlots(0).getXaxis().setLog(false);
            this.application.getPlots(0).getYaxis().setLog(false);
            this.application.getPlots(0).getZaxis().setLog(false);
            this.application.getPlots(0).syncTo(new Plot(), Arrays.asList("id", "rowId", "columnId"));
            this.application.getPlots(0).getXaxis().setAutoRange(true);
            this.application.getPlots(0).getYaxis().setAutoRange(true);
            this.application.getPlots(0).getZaxis().setAutoRange(true);
            for (i2 = this.application.getBindings().length - 1; i2 >= 0; --i2) {
                this.deleteBinding(this.application.getBindings(i2));
            }
            Canvas c = this.application.getCanvases(0);
            this.application.getPlots(0).setColumnId(c.getMarginColumn().getId());
            this.application.getPlots(0).setRowId(c.getRows(0).getId());
            for (i = c.getRows().length - 1; i >= 1; --i) {
                c.getController().deleteRow(c.getRows(i));
            }
            if (c.getRows().length > 0) {
                c.getRows(0).syncTo(new Row(), Arrays.asList("id", "top", "bottom", "parent"));
                c.getRows(0).setTop("+2em");
                c.getRows(0).setBottom("+100%-2em");
            }
            c.getMarginRow().setTop("2em");
            c.getMarginRow().setBottom("100%-3em");
            c.getMarginColumn().setLeft("+7.0em");
            c.getMarginColumn().setRight("100%-7.0em");
            for (i = c.getColumns().length - 1; i >= 0; --i) {
                c.getController().deleteColumn(c.getColumns(i));
            }
            c.setFitted(true);
            this.application.getDataSourceFilters(0).syncTo(new DataSourceFilter(), Collections.singletonList("id"));
            this.application.getDataSourceFilters(0).getController().setDataSetInternal(null, null, true);
            this.application.getPlots(0).syncTo(new Plot(), Arrays.asList("id", "columnId", "rowId"));
            this.application.getPlotElements(0).syncTo(new PlotElement(), Arrays.asList("id", "plotId", "dataSourceFilterId", "renderType"));
            this.application.getPlots(0).syncTo(new Plot(), Arrays.asList("id", "columnId", "rowId"));
            this.application.getPlots(0).setAutoLabel(true);
            this.application.getPlotElements(0).syncTo(new PlotElement(), Arrays.asList("id", "plotId", "dataSourceFilterId"));
            this.application.getPlotElements(0).setAutoLabel(true);
            this.application.getPlotElements(0).getPlotDefaults().setId("plot_defaults_0");
            this.application.getPlotElements(0).getStyle().setId("style_0");
            this.application.getPlotElements(0).getStyle().setFillColor(Color.decode("#404040"));
            this.application.getPlotElements(0).getStyle().setColor(this.application.getOptions().getColor());
            if (!this.application.getCanvases(0).getController().getDasCanvas().getBackground().equals(this.application.getOptions().getBackground())) {
                this.application.getCanvases(0).getController().getDasCanvas().setBackground(this.application.getOptions().getBackground());
            }
            this.application.getPlots(0).getXaxis().setAutoLabel(true);
            this.application.getPlots(0).getYaxis().setAutoLabel(true);
            this.application.getPlots(0).getZaxis().setAutoLabel(true);
            this.application.getPlots(0).getXaxis().setAutoRange(true);
            this.application.getPlots(0).getYaxis().setAutoRange(true);
            this.application.getPlots(0).getZaxis().setAutoRange(true);
            this.application.getPlotElements((int)0).controller.setDsfReset(true);
            this.application.getPlots(0).getZaxis().setVisible(false);
            this.application.setTimeRange(Application.DEFAULT_TIME_RANGE);
            this.application.getPlots(0).setTicksURI("");
            this.application.getPlots(0).setContext(this.application.getPlots(0).getXaxis().getRange());
            this.resetIdSequenceNumbers();
            for (PlotElement plotElement : this.application.getPlotElements()) {
                plotElement.getController().dataSet = null;
            }
            for (DomNode domNode : this.application.getDataSourceFilters()) {
                ((DataSourceFilter)domNode).getController().dataSet = null;
                ((DataSourceFilter)domNode).getController().fillDataSet = null;
                ((DataSourceFilter)domNode).getController().histogram = null;
            }
            DasCanvasComponent[] dccs = this.canvas.controller.getDasCanvas().getCanvasComponents();
            for (int i3 = 0; i3 < dccs.length; ++i3) {
                boolean bl;
                if (!(dccs[i3] instanceof DasPlot)) continue;
                DasPlot p = (DasPlot)dccs[i3];
                boolean bl2 = false;
                for (Plot pp : this.application.getPlots()) {
                    if (pp.getController().getDasPlot() != p) continue;
                    bl = true;
                }
                if (!bl) {
                    this.canvas.controller.getDasCanvas().remove((Component)p);
                    continue;
                }
                Renderer[] rr = p.getRenderers();
                for (int j = 0; j < rr.length; ++j) {
                    boolean bl3 = false;
                    for (PlotElement pes : this.application.getPlotElements()) {
                        if (pes.getController().getRenderer() != rr[j]) continue;
                        bl3 = true;
                    }
                    if (bl3) continue;
                    p.removeRenderer(rr[j]);
                }
            }
        }
        finally {
            canvasLock.unlock();
            lock.unlock();
        }
        ArrayList<String> problems = new ArrayList<String>();
        if (!DomUtil.validateDom(this.application, problems)) {
            System.err.println(problems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(DomNode src, String srcProp, Object dst, String dstProp, Converter converter) {
        BindingGroup bc;
        BindingModel bindingModel;
        logger.log(Level.FINER, "bind {0}.{1} to {2}.{3}", new Object[]{src, srcProp, dst, dstProp});
        String srcId = src.getId();
        String dstId = "???";
        if (dst instanceof DomNode) {
            dstId = ((DomNode)dst).getId();
        }
        if (dst instanceof DasCanvasComponent) {
            dstId = "das2:" + ((DasCanvasComponent)dst).getDasName();
        }
        if (this.application.bindings.contains(bindingModel = new BindingModel(srcId, srcId, srcProp, dstId, dstProp))) {
            logger.finest("binding already exists, ignoring");
            this.setStatus("binding already exists: " + bindingModel);
            return;
        }
        try {
            DomUtil.getPropertyType(src, srcProp);
            if (dst instanceof DomNode) {
                DomUtil.getPropertyType((DomNode)dst, dstProp);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
        Map<Object, BindingGroup> map = this.bindingContexts;
        synchronized (map) {
            bc = this.bindingContexts.get(src);
            if (bc == null) {
                bc = new BindingGroup();
                this.bindingContexts.put(src, bc);
            }
        }
        if (!dstId.equals("???") && !dstId.startsWith("das2:")) {
            AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)BeanProperty.create((String)srcProp), (Object)dst, (Property)BeanProperty.create((String)dstProp));
            if (converter != null) {
                binding.setConverter(converter);
            }
            ArrayList<BindingModel> bindings = new ArrayList<BindingModel>(Arrays.asList(this.application.getBindings()));
            bindings.add(bindingModel);
            this.application.setBindings(bindings.toArray(new BindingModel[bindings.size()]));
            bc.addBinding((Binding)binding);
            binding.bind();
            this.bindingImpls.put(bindingModel, (Binding)binding);
        } else {
            this.bindingSupport.bind(src, srcProp, dst, dstProp, converter);
        }
    }

    public void bind(DomNode src, String srcProp, Object dst, String dstProp) {
        this.bind(src, srcProp, dst, dstProp, null);
    }

    protected void unbind(DomNode src, String srcProp, Object dst, String dstProp) {
        this.bindingSupport.unbind(src, srcProp, dst, dstProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(DomNode src) {
        Map<Object, Object> map = this.bindingImpls;
        synchronized (map) {
            ArrayList<BindingModel> bb = new ArrayList<BindingModel>(Arrays.asList(this.application.getBindings()));
            for (BindingModel b : this.application.getBindings()) {
                if (!b.getSrcId().equals(src.getId()) && !b.getDstId().equals(src.getId())) continue;
                bb.remove(b);
                Binding bimpl = this.bindingImpls.get(b);
                if (bimpl == null) continue;
                bimpl.unbind();
                this.bindingImpls.remove(b);
            }
            this.application.setBindings(bb.toArray(new BindingModel[bb.size()]));
        }
        map = this.bindingContexts;
        synchronized (map) {
            BindingGroup bc = this.bindingContexts.get(src);
            if (bc != null) {
                bc.unbind();
                this.bindingContexts.remove(bc);
                String bcid = src.getId();
                ArrayList<BindingModel> bindings = DomUtil.asArrayList(this.application.getBindings());
                ArrayList<BindingModel> remove = new ArrayList<BindingModel>();
                for (BindingModel bb : bindings) {
                    if (!bb.getBindingContextId().equals(bcid)) continue;
                    remove.add(bb);
                }
                bindings.removeAll(remove);
                this.application.setBindings(bindings.toArray(new BindingModel[bindings.size()]));
            }
        }
    }

    protected void unbindImpl(DomNode src) {
        this.bindingSupport.unbind(src);
    }

    public void deleteBinding(BindingModel binding) {
        Binding b = this.bindingImpls.get(binding);
        if (b == null) {
            new IllegalArgumentException("didn't find the binding implementation for " + binding + ", ignoring").printStackTrace();
            return;
        }
        b.unbind();
        this.bindingImpls.remove(binding);
        ArrayList<BindingModel> bindings = DomUtil.asArrayList(this.application.getBindings());
        bindings.remove(binding);
        this.application.setBindings(bindings.toArray(new BindingModel[bindings.size()]));
    }

    public BindingModel findBinding(DomNode src, String srcProp, DomNode dst, String dstProp) {
        List<BindingModel> results = this.findBindings(src, srcProp, dst, dstProp);
        if (results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public List<BindingModel> findBindings(DomNode src, String srcProp, DomNode dst, String dstProp) {
        ArrayList<BindingModel> result = new ArrayList<BindingModel>();
        for (BindingModel b : this.application.getBindings()) {
            if (!(src != null && !b.getSrcId().equals(src.getId()) || dst != null && !b.getDstId().equals(dst.getId()) || srcProp != null && !b.getSrcProperty().equals(srcProp) || dstProp != null && !b.getDstProperty().equals(dstProp))) {
                result.add(b);
                continue;
            }
            if (dst != null && !b.getSrcId().equals(dst.getId()) || src != null && !b.getDstId().equals(src.getId()) || dstProp != null && !b.getSrcProperty().equals(dstProp) || srcProp != null && !b.getDstProperty().equals(srcProp)) continue;
            result.add(b);
        }
        return result;
    }

    public BindingModel[] getBindingsFor(DomNode node) {
        List<BindingModel> results = this.findBindings(node, null, null, null);
        return results.toArray(new BindingModel[results.size()]);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        logger.log(Level.FINE, "{0} (status message)", status);
        String oldStatus = this.status;
        this.status = status;
        this.propertyChangeSupport.firePropertyChange(PROP_STATUS, oldStatus, status);
    }

    public String getFocusUri() {
        return this.focusUri;
    }

    public void setFocusUri(String focusUri) {
        if (focusUri == null) {
            focusUri = "";
        }
        String oldFocusUri = this.focusUri;
        this.focusUri = focusUri;
        this.propertyChangeSupport.firePropertyChange(PROP_FOCUSURI, oldFocusUri, focusUri);
    }

    public Plot getPlotAbove(Plot p) {
        return this.getPlot(p, LayoutConstants.ABOVE);
    }

    public Plot getPlotBelow(Plot p) {
        return this.getPlot(p, LayoutConstants.BELOW);
    }

    public Plot getNextPlotHoriz(Plot p, Object dir) {
        Column r = this.getCanvas().getController().getColumnFor(p);
        Column left = this.getCanvas().getController().getColumn(r, dir);
        if (left == null) {
            return null;
        }
        int n = this.application.getPlots().length;
        Plot best = null;
        for (int i = 0; i < n; ++i) {
            Plot p1 = this.application.getPlots(i);
            if (!p1.getColumnId().equals(left.getId())) continue;
            if (best == null) {
                best = p1;
                continue;
            }
            if (!p1.rowId.equals(p.getRowId())) continue;
            best = p1;
        }
        return best;
    }

    public Plot getPlot(Plot p, Object dir) {
        Row r = this.getCanvas().getController().getRowFor(p);
        Row above = this.getCanvas().getController().getRow(r, dir);
        if (above == null) {
            return null;
        }
        int n = this.application.getPlots().length;
        Plot best = null;
        for (int i = 0; i < n; ++i) {
            Plot p1 = this.application.getPlots(i);
            if (!p1.getRowId().equals(above.getId())) continue;
            if (best == null) {
                best = p1;
                continue;
            }
            if (!p1.columnId.equals(p.getColumnId())) continue;
            best = p1;
        }
        return best;
    }

    public Plot getPlotFor(PlotElement element) {
        String id = element.getPlotId();
        Plot result = null;
        for (Plot p : this.application.getPlots()) {
            if (!p.getId().equals(id)) continue;
            result = p;
        }
        return result;
    }

    public List<PlotElement> getPlotElementsFor(Plot plot) {
        return DomUtil.getPlotElementsFor(this.application, plot);
    }

    public DataSourceFilter getDataSourceFilterFor(PlotElement element) {
        String id = element.getDataSourceFilterId();
        DataSourceFilter result = null;
        for (DataSourceFilter dsf : this.application.getDataSourceFilters()) {
            if (!dsf.getId().equals(id)) continue;
            result = dsf;
        }
        return result;
    }

    public List<PlotElement> getPlotElementsFor(DataSourceFilter plot) {
        String id = plot.getId();
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement p : this.application.getPlotElements()) {
            if (!p.getDataSourceFilterId().equals(id)) continue;
            result.add(p);
        }
        return result;
    }

    public Plot getFirstPlotFor(DataSourceFilter dsf) {
        String lookFor = dsf.getId();
        PlotElement f = null;
        ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>();
        dsfs.add(dsf);
        for (PlotElement pe : this.application.plotElements) {
            if (!pe.getDataSourceFilterId().equals(lookFor)) continue;
            f = pe;
        }
        Pattern p = Pattern.compile("vap\\+internal:([a-z][a-z_0-9]*)(,([a-z][a-z_0-9]*))*");
        if (f == null) {
            for (DataSourceFilter dsf1 : this.application.getDataSourceFilters()) {
                Matcher m;
                if (dsf1.getUri() == null || !(m = p.matcher(dsf1.getUri())).matches()) continue;
                int n = m.groupCount() + 1;
                for (int i = 1; i < n; i += 2) {
                    if (!m.group(i).equals(dsf.getId())) continue;
                    if (Thread.currentThread().getStackTrace().length < 100) {
                        return this.getFirstPlotFor(dsf1);
                    }
                    throw new IllegalArgumentException("circular references in dsfs");
                }
            }
            return null;
        }
        return this.getPlotFor(f);
    }

    protected void assignId(DomNode node) {
        if (node instanceof Row) {
            node.setId("row_" + rowIdNum.getAndIncrement());
        } else if (node instanceof Column) {
            node.setId("column_" + columnIdNum.getAndIncrement());
        } else if (node instanceof DataSourceFilter) {
            node.setId("data_" + dsfIdNum);
            dsfIdNum.getAndIncrement();
        } else if (node instanceof Canvas) {
            int i = canvasIdNum.getAndIncrement();
            node.setId("canvas_" + i);
            Canvas ca = (Canvas)node;
            ca.getMarginColumn().setId("marginColumn_" + i);
            ca.getMarginRow().setId("marginRow_" + i);
        } else if (node instanceof PlotElement) {
            int i = plotElementIdNum.getAndIncrement();
            node.setId("plotElement_" + i);
            ((PlotElement)node).getStyle().setId("style_" + i);
            ((PlotElement)node).getPlotDefaults().setId("plot_defaults_" + i);
        } else if (node instanceof Plot) {
            int num = plotIdNum.getAndIncrement();
            Plot domPlot = (Plot)node;
            domPlot.setId("plot_" + num);
            domPlot.getXaxis().setId("xaxis_" + num);
            domPlot.getYaxis().setId("yaxis_" + num);
            domPlot.getZaxis().setId("zaxis_" + num);
        } else {
            throw new IllegalArgumentException("unsupported type: " + node.getClass().getName());
        }
    }

    private int maxIdNum(List<DomNode> nodes, String pattern) {
        int min = -1;
        Pattern p = Pattern.compile(pattern);
        for (DomNode n : nodes) {
            int idNum;
            Matcher m = p.matcher(n.getId());
            if (!m.matches() || (idNum = Integer.parseInt(m.group(1))) <= min) continue;
            min = idNum;
        }
        return min;
    }

    private void resetIdSequenceNumbers() {
        List<DomNode> nodes = DomUtil.findElementsById(this.application, ".+_(\\d+)");
        rowIdNum.set(this.maxIdNum(nodes, "row_(\\d+)") + 1);
        columnIdNum.set(this.maxIdNum(nodes, "column_(\\d+)") + 1);
        dsfIdNum.set(this.maxIdNum(nodes, "data_(\\d+)") + 1);
        canvasIdNum.set(this.maxIdNum(nodes, "canvas_(\\d+)") + 1);
        plotElementIdNum.set(this.maxIdNum(nodes, "plotElement_(\\d+)") + 1);
        plotIdNum.set(this.maxIdNum(nodes, "plot_(\\d+)") + 1);
    }

    public PlotElement getPlotElement() {
        return this.plotElement;
    }

    public void setPlotElement(PlotElement plotElement) {
        PlotElement oldPlotElement = this.plotElement;
        if (plotElement == null) {
            this.setStatus("no plot element selected");
        } else {
            JMenuItem mi;
            Plot lplot;
            this.setStatus(plotElement + " selected");
            if (this.application.getPlotElements().length > 1 || plotElement != oldPlotElement) {
                this.getCanvas().controller.indicateSelection(Collections.singletonList(plotElement));
            }
            if (plotElement != oldPlotElement && (lplot = this.getPlotFor(plotElement)) != null && lplot.getController() != null && (mi = lplot.getController().getPlotElementPropsMenuItem()) != null && plotElement.getController() != null && plotElement.getController().getRenderer() != null) {
                mi.setIcon(plotElement.getController().getRenderer().getListIcon());
            }
        }
        this.plotElement = plotElement;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT_ELEMENT, oldPlotElement, plotElement);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        Plot oldPlot = this.plot;
        this.plot = plot;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT, oldPlot, plot);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public synchronized void setCanvas(Canvas canvas) {
        Canvas oldCanvas = this.canvas;
        this.canvas = canvas;
        this.propertyChangeSupport.firePropertyChange(PROP_CANVAS, oldCanvas, canvas);
    }

    public DataSourceFilter getDataSourceFilter() {
        return this.dataSourceFilter;
    }

    public void setDataSourceFilter(DataSourceFilter dataSourceFilter) {
        DataSourceFilter oldDataSourceFilter = this.dataSourceFilter;
        this.dataSourceFilter = dataSourceFilter;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASOURCEFILTER, oldDataSourceFilter, dataSourceFilter);
    }

    private void bindTo(DasCanvas canvas) {
        ApplicationController ac = this;
        ac.bind(this.application.options, "background", canvas, "background");
        ac.bind(this.application.options, "foreground", canvas, "foreground");
        ac.bind(this.application.options, "canvasFont", canvas, "baseFont", DomUtil.STRING_TO_FONT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void syncTo(Application that, List<String> exclude) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Sync to Application");
        Lock canvasLock = this.getCanvas().controller.getDasCanvas().mutatorLock();
        canvasLock.lock();
        try {
            if (!exclude.contains("options")) {
                this.application.getOptions().syncTo(that.getOptions(), Arrays.asList("overRendering", "logConsoleVisible", "scriptVisible", "serverEnabled"));
            }
            HashMap<String, String> nameMap = new HashMap<String, String>(){

                @Override
                public String get(Object key) {
                    String result = (String)super.get(key);
                    return result == null ? (String)key : result;
                }
            };
            if (!this.application.id.equals(that.id)) {
                nameMap.put(that.id, this.application.id);
            }
            if (!exclude.contains("canvases")) {
                this.syncSupport.syncToCanvases(that.getCanvases(), (Map<String, String>)nameMap);
            }
            if (!exclude.contains("plots")) {
                this.syncSupport.syncToPlots(that.getPlots(), (Map<String, String>)nameMap);
            }
            if (!exclude.contains("dataSourceFilters")) {
                this.syncSupport.syncToDataSourceFilters(that.getDataSourceFilters(), (Map<String, String>)nameMap);
            }
            if (!exclude.contains("plotElements")) {
                this.syncSupport.syncToPlotElements(that.getPlotElements(), (Map<String, String>)nameMap);
            }
            this.application.setTimeRange(that.getTimeRange());
            this.syncSupport.syncBindingsNew(that.getBindings(), (Map<String, String>)nameMap);
            this.syncSupport.syncConnectors(that.getConnectors());
            this.resetIdSequenceNumbers();
        }
        finally {
            canvasLock.unlock();
            lock.unlock();
        }
        for (PlotElement plotElement : this.application.getPlotElements()) {
            plotElement.controller.setResetPlotElement(false);
            plotElement.controller.setResetComponent(false);
            plotElement.controller.setResetRanges(false);
            plotElement.controller.setResetRenderType(false);
            plotElement.controller.setDsfReset(true);
        }
        for (DomNode domNode : this.application.getDataSourceFilters()) {
            ((DataSourceFilter)domNode).controller.setResetDimensions(false);
        }
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public DasCanvas getDasCanvas() {
        return this.getCanvas().controller.getDasCanvas();
    }

    public DasRow getRow() {
        return this.getCanvas().getMarginRow().getController().getDasRow();
    }

    public DasColumn getColumn() {
        return this.getCanvas().getMarginColumn().getController().getDasColumn();
    }

    public MonitorFactory getMonitorFactory() {
        return new MonitorFactory(){

            public ProgressMonitor getMonitor(DasCanvas canvas, String string, String desc) {
                return DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(canvas, string, desc);
            }

            public ProgressMonitor getMonitor(DasCanvasComponent context, String label, String description) {
                return DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(context, label, description);
            }

            public ProgressMonitor getMonitor(String label, String description) {
                return DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(ApplicationController.this.getDasCanvas(), label, description);
            }
        };
    }

    boolean isConnected(Plot plot) {
        Connector[] connectors = this.application.getConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            if (connectors[i].getPlotB().equals(plot.getId())) {
                return true;
            }
            if (!connectors[i].getPlotA().equals(plot.getId())) continue;
            return true;
        }
        return false;
    }
}

