/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;

public class ArrayNodeDiff
implements Diff {
    String propertyName;
    Object node;
    int index;
    int toIndex;
    Action action;

    protected ArrayNodeDiff(String propertyName, Action action, Object node, int index) {
        this.propertyName = propertyName;
        this.action = action;
        this.node = node;
        this.index = index;
    }

    protected ArrayNodeDiff(String propertyName, Action action, Object node, int index, int toIndex) {
        this.propertyName = propertyName;
        this.action = action;
        this.node = node;
        this.index = index;
        this.toIndex = toIndex;
    }

    static Object deleteElement(Object o, int index) {
        int i;
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            throw new IllegalArgumentException("expected an array: " + o);
        }
        int length = Array.getLength(o);
        Object result = Array.newInstance(c.getComponentType(), length - 1);
        for (i = 0; i < index; ++i) {
            Array.set(result, i, Array.get(o, i));
        }
        for (i = index; i < length - 1; ++i) {
            Array.set(result, i, Array.get(o, i + 1));
        }
        return result;
    }

    static Object insertElement(Object o, Object element, int index) {
        int i;
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            throw new IllegalArgumentException("expected an array: " + o);
        }
        int length = Array.getLength(o);
        Object result = Array.newInstance(c.getComponentType(), length + 1);
        for (i = 0; i < index; ++i) {
            Array.set(result, i, Array.get(o, i));
        }
        Array.set(result, index, element);
        for (i = index + 1; i < length + 1; ++i) {
            Array.set(result, i, Array.get(o, i - 1));
        }
        return result;
    }

    private static void doAction(DomNode node, String propertyName, Object element, Action action, int arg0, int arg1) {
        try {
            Object newArray;
            BeanInfo info = Introspector.getBeanInfo(node.getClass());
            PropertyDescriptor pd = null;
            for (PropertyDescriptor pd1 : info.getPropertyDescriptors()) {
                if (!pd1.getName().equals(propertyName)) continue;
                pd = pd1;
                break;
            }
            if (pd == null) {
                throw new IllegalArgumentException("failed to find property " + propertyName + " in " + node);
            }
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("expected indexed property");
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Object array = ipd.getReadMethod().invoke((Object)node, new Object[0]);
            if (action == Action.Delete) {
                newArray = ArrayNodeDiff.deleteElement(array, arg0);
            } else if (action == Action.Insert) {
                newArray = ArrayNodeDiff.insertElement(array, element, arg0);
            } else if (action == Action.Move) {
                newArray = ArrayNodeDiff.deleteElement(array, arg0);
                if (arg1 > arg0) {
                    --arg1;
                }
                newArray = ArrayNodeDiff.insertElement(array, element, arg1);
            } else {
                throw new IllegalArgumentException("unimplemented action: " + (Object)((Object)action));
            }
            ipd.getWriteMethod().invoke((Object)node, newArray);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ArrayNodeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ArrayNodeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(ArrayNodeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(ArrayNodeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doDiff(DomNode node) {
        ArrayNodeDiff.doAction(node, this.propertyName, this.node, this.action, this.index, this.toIndex);
    }

    public void undoDiff(DomNode node) {
        if (this.action == Action.Delete) {
            ArrayNodeDiff.doAction(node, this.propertyName, this.node, Action.Insert, this.index, this.toIndex);
        } else if (this.action == Action.Insert) {
            ArrayNodeDiff.doAction(node, this.propertyName, this.node, Action.Delete, this.index, this.toIndex);
        } else if (this.action == Action.Move) {
            ArrayNodeDiff.doAction(node, this.propertyName, this.node, Action.Move, this.toIndex, this.index);
        }
    }

    public String propertyName() {
        return this.propertyName;
    }

    public Action getAction() {
        return this.action;
    }

    public Object getNode() {
        return this.node;
    }

    public String toString() {
        if (this.action == Action.Delete) {
            return "delete " + this.node + " from " + this.propertyName + " @ " + this.index;
        }
        if (this.action == Action.Insert) {
            return "insert " + this.node + " into " + this.propertyName + " @ " + this.index;
        }
        if (this.action == Action.Move) {
            return "move " + this.node + "." + this.propertyName + " from " + this.index + " to " + this.toIndex;
        }
        return super.toString();
    }

    public String getLabel() {
        return this.toString();
    }

    public String getDescription() {
        return this.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        Insert,
        Delete,
        Move;

    }
}

